/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.util;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.ssc.enums.SscTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.workflow.engine.task.TaskInfo;

public class CirculateUtil {
    private static final Log log = LogFactory.getLog(CirculateUtil.class);
    private static final String EXT_SERVICE_NUMBER = "004";
    private static final String QUERY_TASK_FIELD = "assignid,sscid,qualitysamplelibrary";

    public static Map<String, Object> checkTaskAndCirculateParam(Long taskId, String entityName) {
        boolean isQualityCheckTask;
        log.info("\u5171\u4eab\u4efb\u52a1\u4f20\u9605\uff0c taskId = {}, entityName = {}", (Object)taskId, (Object)entityName);
        HashMap<String, Object> result = new HashMap<String, Object>();
        QFilter qFilter = new QFilter("id", "=", (Object)taskId);
        DynamicObject taskInfo = QueryServiceHelper.queryOne((String)(entityName.equals("task_task") ? "task_task" : "task_taskhistory"), (String)QUERY_TASK_FIELD, (QFilter[])new QFilter[]{qFilter});
        if (taskInfo == null) {
            result.put("canCirculate", false);
            result.put("msg", ResManager.loadKDString((String)"\u6240\u9009\u4efb\u52a1\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u4efb\u52a1\u5217\u8868\u3002", (String)"CirculateUtil_0", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return result;
        }
        boolean bl = isQualityCheckTask = taskInfo.getLong("qualitysamplelibrary") > 0L;
        if (isQualityCheckTask) {
            result.put("canCirculate", false);
            result.put("msg", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5ba1\u5355\u4efb\u52a1\u8fdb\u884c\u4f20\u9605\u3002", (String)"CirculateUtil_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return result;
        }
        Long wfTaskId = null;
        try {
            wfTaskId = Long.valueOf(taskInfo.getString("assignid"));
        }
        catch (Exception e) {
            result.put("canCirculate", false);
            result.put("msg", ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5de5\u4f5c\u6d41\u8282\u70b9\u914d\u7f6e\u4e86\u5141\u8bb8\u4f20\u9605\u7684\u975e\u8d28\u68c0\u4efb\u52a1\u8fdb\u884c\u4f20\u9605\u3002", (String)"CirculateUtil_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
            return result;
        }
        Long sscId = taskInfo.getLong("sscid");
        boolean canCirculate = CirculateUtil.getCirculateParam(sscId, wfTaskId, "task_taskhistory".equals(entityName));
        result.put("canCirculate", canCirculate);
        result.put("msg", canCirculate ? "" : ResManager.loadKDString((String)"\u5f53\u524d\u5171\u4eab\u5ba1\u6279\u8282\u70b9\u672a\u5f00\u542f\u5141\u8bb8\u4f20\u9605\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CirculateUtil_3", (String)"bos-ext-ssc", (Object[])new Object[0]));
        result.put("wfTaskId", wfTaskId);
        return result;
    }

    private static boolean getCirculateParam(Long sscId, Long wfTaskId, boolean isHistoryTask) {
        QFilter idFilter = new QFilter("sscorg", "=", (Object)sscId);
        DynamicObject sscDuty = QueryServiceHelper.queryOne((String)"ssc_dutymanage", (String)"sscbusinesstype", (QFilter[])idFilter.toArray());
        String sscType = sscDuty == null ? "1" : sscDuty.getString("sscbusinesstype");
        log.info("sscId = {}\u7684\u5171\u4eab\u4e2d\u5fc3\u7c7b\u578b\u4e3a\uff1a{}", (Object)sscId, (Object)sscType);
        if (!sscType.equals(SscTypeEnum.HR.getType())) {
            return CirculateUtil.getWfSscTaskNodeCirculateParam(wfTaskId, isHistoryTask);
        }
        return CirculateUtil.getCirculateParamByMicroService(sscType, wfTaskId);
    }

    public static boolean getWfSscTaskNodeCirculateParam(Long wfTaskId, boolean isHistoryTask) {
        TaskInfo taskInfo = WorkflowServiceHelper.findTaskById((Long)wfTaskId);
        if (taskInfo != null && StringUtils.isNotBlank((CharSequence)taskInfo.getControl())) {
            Map map = (Map)SerializationUtils.fromJsonString((String)taskInfo.getControl(), Map.class);
            String circulate = (String)map.get("circulate");
            return Boolean.parseBoolean(circulate);
        }
        if (taskInfo == null && isHistoryTask) {
            DynamicObject[] control = BusinessDataServiceHelper.load((String)"wf_hitaskinst", (String)"control", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)wfTaskId)});
            String circulate = null;
            for (DynamicObject controlValue : control) {
                circulate = (String)controlValue.get("control");
            }
            if (!kd.bos.util.StringUtils.isEmpty(circulate)) {
                String circulateResult = "false";
                String regex = "\"circulate\":\"(.*?)\"";
                Pattern pattern = Pattern.compile(regex);
                Matcher matcher = pattern.matcher(circulate);
                if (matcher.find()) {
                    circulateResult = matcher.group(1);
                }
                return !"false".equals(circulateResult);
            }
        }
        return false;
    }

    public static boolean getCirculateParamByMicroService(String sscType, Long wfTaskId) {
        QFilter filter1 = new QFilter("bizextcase.number", "=", (Object)EXT_SERVICE_NUMBER);
        QFilter filter2 = new QFilter("sscbusinesstype", "=", (Object)sscType);
        QFilter filter3 = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject bizExtServiceDo = QueryServiceHelper.queryOne((String)"ssc_bizextservice", (String)"id,servicename,methodname,cloudid.number,appid.number", (QFilter[])new QFilter[]{filter1, filter2, filter3});
        if (bizExtServiceDo == null) {
            log.info("\u672a\u627e\u5230\u76f8\u5173\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\uff0c\u53c2\u6570\u503c\u9ed8\u8ba4\u4e3afalse\u3002 sscType = {}\uff0ccaseNumber = 004", (Object)sscType);
            return false;
        }
        String serviceName = bizExtServiceDo.getString("servicename");
        String methodName = bizExtServiceDo.getString("methodname");
        String cloudId = bizExtServiceDo.getString("cloudid.number");
        String appId = bizExtServiceDo.getString("appid.number");
        log.info("\u4e1a\u52a1\u6269\u5c55\u5fae\u670d\u52a1\u6570\u636e\uff1aserviceName = {}, methodName = {}, cloudId = {}, appId = {}", new Object[]{serviceName, methodName, cloudId, appId});
        if (kd.bos.util.StringUtils.isEmpty((String)serviceName) || kd.bos.util.StringUtils.isEmpty((String)methodName) || kd.bos.util.StringUtils.isEmpty((String)cloudId) || kd.bos.util.StringUtils.isEmpty((String)appId)) {
            return false;
        }
        cloudId = cloudId.toLowerCase();
        boolean canCirculate = false;
        try {
            Object result = DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)methodName, (Object[])new Object[]{String.valueOf(wfTaskId)});
            log.info("\u5fae\u670d\u52a1\u8c03\u7528\u7ed3\u679c\uff1a" + result);
            if (result != null) {
                canCirculate = (Boolean)result;
            }
        }
        catch (Exception e) {
            log.error("\u8c03\u7528\u5fae\u670d\u52a1\u63a5\u53e3\u5f02\u5e38", (Throwable)e);
        }
        return canCirculate;
    }
}

