/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.ssc.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.impl.ORMUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import org.apache.commons.lang3.math.NumberUtils;

public class TaskQueryServiceHelper {
    private static final Log log = LogFactory.getLog(TaskQueryServiceHelper.class);

    public static String getGeneralFiler(List<QFilter> filterList, boolean isAdmin) {
        QFilter generalFilter = new QFilter("1", "=", (Object)1);
        for (QFilter f : filterList) {
            generalFilter = generalFilter.and(f);
        }
        if (!isAdmin) {
            QFilter filter = new QFilter("personid", "=", (Object)Long.valueOf(RequestContext.get().getUserId()));
            generalFilter = generalFilter.and(filter);
        }
        return generalFilter.toSerializedString();
    }

    public static DynamicObjectCollection getDataMyTasklist(Long pkid, boolean isHistory) {
        String entityName = "task_task";
        String selector = "id,billtype,billtype.isembed,billtype.bindbill.number,billtype.isstoredindb,billtype.externalerp.number,billtype.isuseimage,oprt,billid,pooltype,state,subject,tasktypeid,tasktypeid.qualityjudge,bizdata_tag,qualitystate,apprevalmessage,qualitysamplelibrary,imagenumber,billnumber,innermsg,personid,decisionitem,unpassreasondesc,billlongid";
        if (isHistory) {
            selector = selector + ",sourcetaskid";
            entityName = "task_taskhistory";
        } else {
            selector = selector + ",approveop,pendingopinion,rescanopinion,unpassreasondata";
        }
        ORM orm = ORM.create();
        QFilter filter = new QFilter("id", "=", (Object)pkid);
        QFilter[] filters = new QFilter[]{filter};
        try (DataSet dataset = orm.queryDataSet("tasklist", entityName, selector, filters);){
            DynamicObjectCollection dynamicObjectCollection = ORMUtil.toDynamicObjectCollection((DataSet)dataset, (String)entityName);
            return dynamicObjectCollection;
        }
    }

    public static List<Map<String, Object>> getMyTaskListInfoByPkIds(Set<Long> pkids) {
        String sql = "select a.*,c.fpriorityid, bc.fdownadjust from (select aa.fid,aa.ftasktypeid,aa.fbilltypeid,aa.fsubject,aa.ftasklevelid,bb.fpriority,aa.fqualitysamplelibraryid,aa.fstate from t_tk_task aa left join t_tk_tasklevel bb on aa.ftasklevelid = bb.fid where aa.fid in (%s))a left join t_tk_taskrulebill b on a.fbilltypeid = b.fid and a.ftasktypeid = b.ftasktype left join t_tk_levelentry c on b.fchildpkid = c.fid  left join T_tk_taskbillchild bc on b.fchildpkid = bc.fid";
        String params = StringUtils.join((Object[])pkids.toArray(), (String)",");
        try (DataSet ds = DB.queryDataSet((String)"kd.ssc.getMyTaskListInfoByPkIds", (DBRoute)DBRoute.of((String)"ssc"), (String)String.format(sql, params));){
            ArrayList<Map<String, Object>> resultList = new ArrayList<Map<String, Object>>(10);
            while (ds.hasNext()) {
                Row row = ds.next();
                HashMap<String, Object> result = new HashMap<String, Object>(8);
                result.put("qualitySampleLibrary", row.getLong("fqualitysamplelibraryid"));
                result.put("id", row.getLong("fid"));
                result.put("state", row.getString("fstate"));
                result.put("priority", row.getLong("fpriorityid"));
                result.put("taskId", row.getLong("fid"));
                result.put("subject", row.getString("fsubject"));
                result.put("taskLevelId", row.getLong("ftasklevelid"));
                result.put("level", row.getInteger("fpriority"));
                result.put("billTypeId", row.getLong("fbilltypeid"));
                result.put("taskTypeId", row.getLong("ftasktypeid"));
                result.put("downAdjust", row.getString("fdownadjust"));
                resultList.add(result);
            }
            ArrayList<Map<String, Object>> arrayList = resultList;
            return arrayList;
        }
    }

    public static String getErpNumber(long billtypeid) {
        ORM orm = ORM.create();
        DynamicObject billType = orm.queryOne("task_taskbill", "id,externalerp.id,externalerp.number", new QFilter[]{new QFilter("id", "=", (Object)billtypeid)});
        if (billType == null) {
            return null;
        }
        String erpNumber = (String)billType.get("externalerp.number");
        return erpNumber == null ? null : erpNumber.toLowerCase();
    }

    public static boolean isTaskforcurrentperson(long id) {
        long personid;
        QFilter filter;
        RequestContext requestContext = RequestContext.get();
        long currentUserId = NumberUtils.toLong((String)requestContext.getUserId());
        ORM orm = ORM.create();
        DynamicObject obj = orm.queryOne("task_task", "id,personid", (filter = new QFilter("id", "=", (Object)id)).toArray());
        return obj == null || (personid = ((Long)obj.get("personid")).longValue()) != currentUserId;
    }

    public static String findParentBillId(long billid, boolean processingTask) {
        log.info(String.format("request queryTaskRealBillId,param is %1s and %2s", billid, processingTask));
        Object data = DispatchServiceHelper.invokeBizService((String)"ssc", (String)"hstc", (String)"ITaskService", (String)"queryTaskRealBillId", (Object[])new Object[]{billid, processingTask});
        log.info(String.format("request queryTaskRealBillId,return is %s ", data.toString()));
        if (data instanceof Map) {
            Map map = (Map)data;
            String success = (String)map.get("success");
            if ("true".equals(success)) {
                Map realBillId = (Map)map.get("data");
                return (String)realBillId.get("realBillId");
            }
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u8be5\u4efb\u52a1\u7684\u76eeID\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s", (String)"TaskQueryServiceHelper_0", (String)"bos-ext-ssc", (Object[])new Object[0]), map.get("msg")));
        }
        throw new KDBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u8be5\u4efb\u52a1\u7684\u76eeID\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"TaskQueryServiceHelper_1", (String)"bos-ext-ssc", (Object[])new Object[0]));
    }
}

