/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workflow.listener;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.CommitListener;
import kd.bos.db.tx.TX;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.ComboProp;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import kd.bos.workflow.engine.dynprocess.freeflow.WFFlowElement;

public class CreateTaskTestListener
implements ExecutionListener {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog(CreateTaskTestListener.class);
    private static final String LOG_PRE_TAG = "--CreateTaskTestListener--";
    private static final String EXCEPTION_ERROR_CODE = "workFlowCreateSSCTaskException";
    private static final String SSCNODE_WFKEY = "SSCApprove";
    private static final String QUERY_TASKTYPE_SQL = "select ftasktypeid,ftaskoriginal from t_tk_taskbillchild where fid in(select fchildpkid from t_tk_taskrulebill where fid = ?) and ftaskoriginal<'9'";
    private static final String REPLACE_PREFIX = "\"fieldName\":\"";

    public void notify(AgentExecution arg0) {
        boolean isParTask;
        HashSet taskTypeIds;
        String createTaskModel;
        long billTypeId;
        Long processDefinitionId = arg0.getProcessDefinitionId();
        String billId = this.getBillTypeKey(arg0);
        long workFlowId = arg0.getCurrentTaskId();
        String entityNumber = this.getEntityNumber(arg0);
        String taskLevelStr = this.getTaskLevel(arg0);
        boolean isMultiNodePattern = StringUtils.isNotEmpty((String)taskLevelStr);
        int taskLevel = this.getTaskLevel(isMultiNodePattern, taskLevelStr);
        DynamicObject billType = this.matchTaskBillType(entityNumber, billId, isMultiNodePattern, processDefinitionId);
        if (billType != null) {
            billTypeId = billType.getLong("id");
            createTaskModel = billType.getString("createtaskmodel");
            Map<String, Object> objectMap = this.getTaskTypeIds(billTypeId);
            taskTypeIds = (HashSet)objectMap.get("taskTypeIds");
            isParTask = (Boolean)objectMap.get("isParTask");
            if (taskTypeIds.size() < 1) {
                ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636e\u672a\u914d\u7f6e\u5355\u636e\u4efb\u52a1\uff0c\u8bf7\u68c0\u67e5\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eid\u4e3a\uff1a%1s, \u5355\u636e\u5b9e\u4f53\u4e3a\uff1a%2s\uff0c\u5339\u914d\u5230\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%3s\u3002", (String)"CreateTaskTestListener_10", (String)"bos-ext-ssc", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[]{billId, entityNumber, billTypeId});
            }
        } else {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6d41\u7a0b\u91c7\u7528\u4e86\u5355\u5171\u4eab\u8282\u70b9\u6a21\u5f0f\uff0c\u4f46\u4e0d\u5b58\u5728\u751f\u6548\u6216\u5728\u9014\u7684\u5171\u4eab\u521b\u5efa\u4efb\u52a1\u6a21\u5f0f\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_9", (String)"bos-ext-ssc", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        TX.addCommitListener((CommitListener)new /* Unavailable Anonymous Inner Class!! */);
    }

    private void createTaskOfWF(String billId, Long billTypeId, HashSet<Long> taskTypeIds, long workFlowId) {
        ArrayList<Long> createFailTaskTypeIds = new ArrayList<Long>();
        for (Long taskTypeId : taskTypeIds) {
            long taskID = (Long)DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"createTaskByWf", (Object[])new Object[]{taskTypeId, billTypeId, billId, 0, "", "", 0, Long.toString(workFlowId)});
            if (taskID != 0L) continue;
            createFailTaskTypeIds.add(taskTypeId);
        }
        if (createFailTaskTypeIds.size() > 0) {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u8c03\u7528\u5171\u4eabssc\u5fae\u670d\u52a1\u65b9\u6cd5createParTaskByWf\u521b\u5efa\u6765\u6e90\u4e3a\u5de5\u4f5c\u6d41\u7684\u5171\u4eab\u4efb\u52a1\u5931\u8d25\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eId\u4e3a\uff1a%1s\uff0c\u4f7f\u7528\u7684\u4e1a\u52a1\u5355\u636eid\u4e3a\uff1a%2s\uff0c\u521b\u5efa\u5931\u8d25\u7684\u4efb\u52a1\u7c7b\u578bid\u96c6\u4e3a\uff1a%3s\u3002", (String)"CreateTaskTestListener_12", (String)"bos-ext-ssc", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{billId, billTypeId, createFailTaskTypeIds});
        }
    }

    private String getBillTypeKey(AgentExecution arg0) {
        if (StringUtils.isEmpty((String)arg0.getBusinessKey())) {
            LOG.error("\u521b\u5efa\u4efb\u52a1\u62a5\u9519:\u5355\u636eID\u4e3a\u7a7a,\u4efb\u52a1ID:" + arg0.getCurrentTaskId());
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u5355\u636eID\u4e3a\u7a7a", (String)"CreateTaskTestListener_2", (String)"bos-ext-ssc", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        return arg0.getBusinessKey();
    }

    private String getEntityNumber(AgentExecution arg0) {
        if (StringUtils.isEmpty((String)arg0.getEntityNumber())) {
            LOG.error("\u521b\u5efa\u4efb\u52a1\u62a5\u9519:\u5355\u636e\u5143\u6570\u636e\u7f16\u7801\u4e3a\u7a7a,\u4efb\u52a1ID:" + arg0.getCurrentTaskId());
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u5355\u636e\u5143\u6570\u636e\u7f16\u7801\u4e3a\u7a7a", (String)"CreateTaskTestListener_4", (String)"bos-ext-ssc", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        return arg0.getEntityNumber();
    }

    private int getTaskLevel(boolean isMultiNodePattern, String taskLevelStr) {
        int taskLevel = -1;
        if (isMultiNodePattern) {
            try {
                taskLevel = Integer.parseInt(taskLevelStr);
            }
            catch (Exception ex) {
                ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u5171\u4eab\u8282\u70b9\u914d\u7f6e\u7684\u4efb\u52a1\u7ea7\u6b21\u53c2\u6570\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u586b\u5199\u6b63\u6574\u6570\u3002", (String)"CreateTaskTestListener_6", (String)"bos-ext-ssc", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[0]);
            }
        }
        return taskLevel;
    }

    private DynamicObject matchTaskBillType(String entityNumber, String billId, boolean isMultiNodePattern, Long processDefinitionId) {
        DynamicObject billData = BusinessDataServiceHelper.loadHead((Object)Long.valueOf(billId), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        long effectiveBillTypeId = this.getFitTaskBillType(entityNumber, billData, "1");
        DynamicObject billTypeDyo = QueryServiceHelper.queryOne((String)"task_taskbill", (String)"id,createtaskmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)effectiveBillTypeId)});
        if (billTypeDyo == null) {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u672a\u5728\u4efb\u4e00\u5171\u4eab\u4e2d\u5fc3\u4e0b\uff0c\u627e\u5230\u751f\u6548\u7684\u4e1a\u52a1\u5355\u636e\u3002\u8fdb\u5165\u5171\u4eab\u5931\u8d25\u7684\u5355\u636eId\u4e3a\uff1a%1s, \u5355\u636e\u5b9e\u4f53\u4e3a\uff1a%2s", (String)"CreateTaskTestListener_5", (String)"bos-ext-ssc", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[]{billId, entityNumber});
        }
        String createTaskModel = billTypeDyo.getString("createtaskmodel");
        if ("0".equals(createTaskModel)) {
            if (isMultiNodePattern) {
                ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u8be5\u5171\u4eab\u8282\u70b9\u914d\u7f6e\u4e86\u4efb\u52a1\u7ea7\u6b21\u53c2\u6570\u4f46\u672a\u5728\u4efb\u4e00\u5171\u4eab\u4e2d\u5fc3\u4e0b\u627e\u5230\u9002\u914d\u7684\u5de5\u4f5c\u6d41\u6a21\u5f0f\u5171\u4eab\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_7", (String)"bos-ext-ssc", (Object[])new Object[0]));
                throw new KDException(errorCode, new Object[0]);
            }
            return billTypeDyo;
        }
        if (isMultiNodePattern) {
            return billTypeDyo;
        }
        int sscNodeCount = this.getCountOfSSCNodeInDef(processDefinitionId);
        if (sscNodeCount > 1) {
            ErrorCode errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, ResManager.loadKDString((String)"\u5de5\u4f5c\u6d41\u8bbe\u8ba1\u591a\u5171\u4eab\u8282\u70b9\u65f6\uff0c\u9700\u8981\u5171\u4eab\u8282\u70b9\u8bbe\u7f6e\u4efb\u52a1\u7ea7\u6b21\u53c2\u6570\u3002", (String)"CreateTaskTestListener_8", (String)"bos-ext-ssc", (Object[])new Object[0]));
            throw new KDException(errorCode, new Object[0]);
        }
        long onWayBIllTypeId = this.getFitTaskBillType(entityNumber, billData, "2");
        return QueryServiceHelper.queryOne((String)"task_taskbill", (String)"id,createtaskmodel", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)onWayBIllTypeId)});
    }

    private long getFitTaskBillType(String entityNumber, DynamicObject billData, String effectiveStatus) {
        ErrorCode errorCode;
        String errorMsg;
        DynamicObjectCollection taskBillTypes = QueryServiceHelper.query((String)"task_taskbill", (String)"id,entryentityfield.sourcefieldnumber sourcefieldnumber", (QFilter[])new QFilter[]{new QFilter("bindbill.number", "=", (Object)entityNumber), new QFilter("entryentityfield.fieldconfiguration", "=", (Object)"10"), new QFilter("effective", "=", (Object)effectiveStatus)});
        if (taskBillTypes.size() < 1) {
            String errorMsg2 = "2".equals(effectiveStatus) ? String.format(ResManager.loadKDString((String)"\u8be5\u5355\u636e\u7684\u5de5\u4f5c\u6d41\u5171\u4eab\u5ba1\u6838\u8282\u70b9\u672a\u914d\u7f6e\u4efb\u52a1\u7ea7\u6b21\uff08tasklevel\uff09\u503c\uff0c\u521b\u5efa\u4efb\u52a1\u65f6\u5339\u914d\u5230\u201c\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u201d\u4e3a\u201c\u5de5\u4f5c\u6d41\u521b\u5efa\u201d\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u9700\u5728\u5de5\u4f5c\u6d41\u5171\u4eab\u5ba1\u6279\u8282\u70b9\u8bbe\u7f6e\u4efb\u52a1\u7ea7\u6b21\u503c\uff0c\u6216\u8005\u8bbe\u7f6e\u4e00\u6761\u201c\u4efb\u52a1\u521b\u5efa\u6a21\u5f0f\u201d\u4e3a\u201c\u5171\u4eab\u4e2d\u5fc3\u521b\u5efa\u4efb\u52a1\u201d\uff0c\u201c\u6765\u6e90\u5355\u636e\u201d\u4e3a%s\uff0c\u4e14\u751f\u6548\u72b6\u6001\u4e3a\u201c\u5728\u9014\u751f\u6548\u201d\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_15", (String)"bos-ext-ssc", (Object[])new Object[0]), entityNumber) : String.format(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u4e00\u6761\u6765\u6e90\u5355\u636e\u4e3a%1s\uff0c\u751f\u6548\u72b6\u6001\u4e3a%2s\u4e14\u542b\u6709\u7ec4\u7ec7\u6620\u5c04\u5b57\u6bb5\u7684\u4e1a\u52a1\u5355\u636e\u3002", (String)"CreateTaskTestListener_14", (String)"bos-ext-ssc", (Object[])new Object[0]), entityNumber, this.getNameOfComboByValue(effectiveStatus));
            ErrorCode errorCode2 = new ErrorCode(EXCEPTION_ERROR_CODE, errorMsg2);
            throw new KDException(errorCode2, new Object[0]);
        }
        Map<Long, String> orgFiledMap = taskBillTypes.stream().collect(Collectors.toMap(dyn -> dyn.getLong("id"), dyn -> dyn.getString("sourcefieldnumber"), (v1, v2) -> v1));
        DynamicObjectCollection applyOrgCollection = QueryServiceHelper.query((String)"task_taskbill", (String)"id,applycond.id,sscbillorgpar.fbasedataid sscbillorgpar", (QFilter[])new QFilter[]{new QFilter("id", "in", orgFiledMap.keySet())});
        HashMap<Long, Long> applyCondIdMap = new HashMap<Long, Long>(16);
        HashMap<Long, Set<Long>> billTypeApplyOrgMap = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject applyOrg : applyOrgCollection) {
            Long billTypeId = applyOrg.getLong("id");
            Long applyCondId = applyOrg.getLong("applycond.id");
            Long applyOrgId = applyOrg.getLong("sscbillorgpar");
            if (applyCondId > 0L) {
                applyCondIdMap.putIfAbsent(billTypeId, applyCondId);
            }
            billTypeApplyOrgMap.computeIfAbsent(billTypeId, k -> new HashSet(16)).add(applyOrgId);
        }
        LOG.info("start execute matchApplyOrg(). billId = {}, orgFiledMap.size = {}, billTypeApplyOrgMap.size = {}, applyCondIdMap.size = {}", new Object[]{billData.getPkValue(), orgFiledMap.size(), billTypeApplyOrgMap.size(), applyCondIdMap.size()});
        this.matchApplyOrg(billData, orgFiledMap, billTypeApplyOrgMap, applyCondIdMap);
        LOG.info("matchApplyOrg() end. billId = {}, orgFiledMap.size = {}, billTypeApplyOrgMap.size = {}, applyCondIdMap.size = {}", new Object[]{billData.getPkValue(), orgFiledMap.size(), billTypeApplyOrgMap.size(), applyCondIdMap.size()});
        Set matchedOrgIds = billTypeApplyOrgMap.keySet();
        matchedOrgIds.removeAll(applyCondIdMap.keySet());
        this.matchApplyCond(billData, applyCondIdMap);
        LOG.info("matchApplyOrg() end. billId = {}, applyCondIdMap.size = {}", billData.getPkValue(), (Object)applyCondIdMap.size());
        if (applyCondIdMap.size() == 1) {
            return (Long)applyCondIdMap.keySet().iterator().next();
        }
        if (applyCondIdMap.size() > 1) {
            errorMsg = String.format(ResManager.loadKDString((String)"\u4e0d\u6ee1\u8db3\u552f\u4e00\u6027\u7ea6\u675f\uff1a\u5b58\u5728\u591a\u4e2a\u4e1a\u52a1\u5355\u636e\u540c\u65f6\u6ee1\u8db3\u9002\u7528\u7ec4\u7ec7\u53ca\u9002\u7528\u6761\u4ef6\u3002\u4e1a\u52a1\u5355\u636eid\uff1a%1s", (String)"CreateTaskTestListener_18", (String)"bos-ext-ssc", (Object[])new Object[0]), applyCondIdMap.keySet().toString());
            errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, errorMsg);
            throw new KDException(errorCode, new Object[]{entityNumber});
        }
        if (matchedOrgIds.size() > 0) {
            return (Long)matchedOrgIds.iterator().next();
        }
        errorMsg = "2".equals(effectiveStatus) ? ResManager.loadKDString((String)"\u8be5\u5355\u636e\u6d41\u7a0b\u914d\u7f6e\u4e86\u5355\u5171\u4eab\u5ba1\u6838\u8282\u70b9\uff0c\u4f46\u662f\u672a\u914d\u7f6e\u4efb\u52a1\u7ea7\u6b21\uff0c\u6839\u636e\u4efb\u52a1\u521b\u5efa\u903b\u8f91\u5339\u914d\u5728\u9014\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\uff0c\u627e\u5230\u4e86\u6765\u6e90\u5355\u636e\u4e3a%s\u7684\u4e1a\u52a1\u5355\u636e\u4e3a\u5728\u9014\u751f\u6548\u72b6\u6001\uff0c\u4f46\u662f\u65e0\u5339\u914d\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u5728\u9014\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\u4e2d\u7ec4\u7ec7\u5b57\u6bb5\u914d\u7f6e\u5bf9\u5e94\u7684\u503c\uff0c\u662f\u5426\u5305\u542b\u5728\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e2d\u3002", (String)"CreateTaskTestListener_16", (String)"bos-ext-ssc", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u627e\u5230\u4e86\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\u6765\u6e90\u5355\u636e\u4e3a%s\uff0c\u4f46\u662f\u65e0\u5339\u914d\u7684\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\uff0c\u8bf7\u68c0\u67e5\u751f\u6548\u72b6\u6001\u7684\u4e1a\u52a1\u5355\u636e\u4e2d\u7ec4\u7ec7\u5b57\u6bb5\u914d\u7f6e\u5bf9\u5e94\u7684\u503c\uff0c\u662f\u5426\u5305\u542b\u5728\u9002\u7528\u7ec4\u7ec7\u8303\u56f4\u4e2d\u3002", (String)"CreateTaskTestListener_17", (String)"bos-ext-ssc", (Object[])new Object[0]);
        errorCode = new ErrorCode(EXCEPTION_ERROR_CODE, errorMsg);
        throw new KDException(errorCode, new Object[]{entityNumber});
    }

    private long getMainOrgId(DynamicObject billData, String orgFieldKey) {
        DynamicObject orgRel;
        if (StringUtils.isEmpty((String)orgFieldKey)) {
            return 0L;
        }
        Object orgObj = billData.get(orgFieldKey);
        if (orgObj == null) {
            return 0L;
        }
        if (orgObj instanceof DynamicObject) {
            return ((DynamicObject)orgObj).getLong("id");
        }
        if (orgObj instanceof String && (orgRel = ORM.create().queryOne("bos_org", "id", new QFilter[]{new QFilter("name", "=", (Object)orgObj.toString())})) != null) {
            return orgRel.getLong("id");
        }
        return 0L;
    }

    private int getCountOfSSCNodeInDef(Long processDefinitionId) {
        List elements = WorkflowServiceHelper.getProcElementsByProcDefId((Long)processDefinitionId);
        int result = 0;
        for (WFFlowElement element : elements) {
            if (!SSCNODE_WFKEY.equals(element.getType())) continue;
            ++result;
        }
        return result;
    }

    private Map<String, Object> getTaskTypeIds(Long billTypeId) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        boolean isParTask = false;
        HashSet<Long> taskTypeIds = new HashSet<Long>();
        Object[] params = new SqlParameter[]{new SqlParameter("fid", -5, (Object)billTypeId)};
        String algoKey = this.getClass() + ".getTaskTypeByBillTypeId()";
        try (DataSet taskTypeDataSet = DB.queryDataSet((String)algoKey, (DBRoute)DBRoute.of((String)"ssc"), (String)QUERY_TASKTYPE_SQL, (Object[])params);){
            if (taskTypeDataSet.hasNext()) {
                for (Row row : taskTypeDataSet) {
                    Long taskTypeId;
                    String taskOriginal = row.getString("ftaskoriginal");
                    if ("2".equals(taskOriginal)) {
                        isParTask = true;
                    }
                    if ((taskTypeId = row.getLong("ftasktypeid")).equals(0L)) continue;
                    taskTypeIds.add(taskTypeId);
                }
            }
        }
        result.put("isParTask", isParTask);
        result.put("taskTypeIds", taskTypeIds);
        return result;
    }

    private HashSet<Long> matchTaskTypeByTaskLevel(HashSet<Long> allTaskTypes, int taskLevel) {
        HashSet<Long> result = new HashSet<Long>();
        String taskLevelStr = String.valueOf(taskLevel);
        QFilter idFilter = new QFilter("id", "in", allTaskTypes);
        DynamicObjectCollection taskTypes = QueryServiceHelper.query((String)"task_tasktype", (String)"id,tasklevel", (QFilter[])idFilter.toArray());
        for (DynamicObject taskType : taskTypes) {
            if (!taskLevelStr.equals(taskType.getString("tasklevel"))) continue;
            result.add(taskType.getLong("id"));
        }
        return result;
    }

    private String getNameOfComboByValue(String value) {
        ComboProp comboProp = (ComboProp)EntityMetadataCache.getDataEntityType((String)"task_taskbill").getProperty("effective");
        if (comboProp != null) {
            return comboProp.getItemByName(value);
        }
        return value;
    }

    private String getTaskLevel(AgentExecution agentExecution) {
        String extTaskLevel = (String)agentExecution.getVariable("extTaskLevel");
        if (extTaskLevel != null) {
            agentExecution.setVariable("extTaskLevel", null);
            return extTaskLevel;
        }
        return (String)agentExecution.getCurrentFlowElement().getCustomPropValue("tasklevel");
    }

    public void notifyByWithdraw(AgentExecution execution) {
        if (execution == null) {
            LOG.error("\u5171\u4eab\u64a4\u56de\u5165\u53c2\u4e3a\u7a7a\uff0c\u76f4\u63a5\u8fd4\u56de");
            return;
        }
        String billKey = execution.getBusinessKey();
        LOG.info("\u5355\u636e\u64a4\u56de\u6267\u884c\u5f00\u59cb" + billKey);
        try {
            String billId = billKey + "";
            String wfTaskId = execution.getCurrentTaskId() + "";
            DispatchServiceHelper.invokeBizService((String)"ssc", (String)"task", (String)"ITaskService", (String)"taskWithdrawFromSSC", (Object[])new Object[]{billId, wfTaskId});
        }
        catch (Exception e) {
            LOG.error("\u5355\u636e\u64a4\u56de\u6267\u884c\u5931\u8d25\uff1a" + billKey, (Throwable)e);
        }
        LOG.info("\u5355\u636e\u64a4\u56de\u6267\u884c\u5b8c\u6210" + billKey);
    }

    private void matchApplyOrg(DynamicObject billData, Map<Long, String> orgFiledMap, Map<Long, Set<Long>> billTypeApplyOrgMap, Map<Long, Long> applyCondIdMap) {
        for (Map.Entry<Long, String> item : orgFiledMap.entrySet()) {
            Long billTypeId = item.getKey();
            String orgFieldKey = item.getValue();
            long mainOrgId = this.getMainOrgId(billData, orgFieldKey);
            if (mainOrgId == 0L) {
                LOG.info(LOG_PRE_TAG + String.format("\u83b7\u53d6\u5355\u636e\u4e3b\u4e1a\u52a1\u7ec4\u7ec7\u9519\u8bef\uff1a\u4f9d\u636eid\u4e3a%s\u7684\u4e1a\u52a1\u5355\u636e\u914d\u7f6e\u7684\u7ec4\u7ec7\u6620\u5c04\u5b57\u6bb5\u4ece\u5b9e\u4f53%s\u7684\u5355\u636e%s\u83b7\u53d6\u7ec4\u7ec7\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", billTypeId, billData.getDataEntityType().getName(), billData.getPkValue()));
            }
            if (billTypeApplyOrgMap.get(billTypeId).contains(mainOrgId)) continue;
            billTypeApplyOrgMap.remove(billTypeId);
            applyCondIdMap.remove(billTypeId);
        }
    }

    private void matchApplyCond(DynamicObject billData, Map<Long, Long> applyCondIdMap) {
        if (applyCondIdMap == null || applyCondIdMap.isEmpty()) {
            return;
        }
        String entityNumber = billData.getDataEntityType().getName();
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        QFilter idFilter = new QFilter("id", "in", applyCondIdMap.values());
        DynamicObjectCollection applyCondDyos = QueryServiceHelper.query((String)"ssc_apply_condition", (String)"id,conditionjson_tag", (QFilter[])idFilter.toArray());
        Map<Long, String> applyCondMap = applyCondDyos.stream().collect(Collectors.toMap(p -> p.getLong("id"), p -> p.getString("conditionjson_tag")));
        QFilter srcBillFilter = new QFilter("sourcebill", "=", (Object)entityNumber);
        DynamicObjectCollection condFiledMappingColl = QueryServiceHelper.query((String)"ssc_confield_mapping", (String)"id,confield.number confieldnum,billfieldnumber,billfield", (QFilter[])srcBillFilter.toArray());
        Map<String, DynamicObject> condFiledMapping = condFiledMappingColl.stream().collect(Collectors.toMap(p -> p.getString("confieldnum"), p -> p));
        if (mainEntityType == null) {
            return;
        }
        applyCondIdMap.entrySet().removeIf(p -> {
            String condJson = (String)applyCondMap.get(p.getValue());
            if (StringUtils.isNotEmpty((String)condJson)) {
                for (Map.Entry entry : condFiledMapping.entrySet()) {
                    condJson = condJson.replaceAll(REPLACE_PREFIX + (String)entry.getKey(), REPLACE_PREFIX + ((DynamicObject)entry.getValue()).getString("billfieldnumber"));
                }
                FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)condJson, FilterCondition.class);
                for (SimpleFilterRow row : filterCondition.getFilterRow()) {
                    row.setEntityNumber(entityNumber);
                }
                FilterBuilder filterBuilder = new FilterBuilder(mainEntityType, filterCondition, true);
                filterBuilder.buildFilter(true);
                QFilter qFilter = filterBuilder.getQFilter().and("id", "=", billData.getPkValue());
                LOG.info("execute matchApplyCond(). billId = {}, qFilter = {}", billData.getPkValue(), (Object)qFilter);
                return !QueryServiceHelper.exists((String)entityNumber, (QFilter[])qFilter.toArray());
            }
            return true;
        });
    }

    static /* synthetic */ Log access$000() {
        return LOG;
    }

    static /* synthetic */ void access$100(CreateTaskTestListener x0, String x1, Long x2, HashSet x3, long x4) {
        x0.createTaskOfWF(x1, x2, x3, x4);
    }

    static /* synthetic */ HashSet access$200(CreateTaskTestListener x0, HashSet x1, int x2) {
        return x0.matchTaskTypeByTaskLevel(x1, x2);
    }
}

