/*
 * Decompiled with CFR 0.152.
 */
package kd.ssc.task.workflow.listener;

import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.param.AppParam;
import kd.bos.ext.ssc.enums.ImageScannerShowTypeEnum;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.image.ImageServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.bos.servicehelper.workflow.WorkflowServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.workflow.api.AgentExecution;
import kd.bos.workflow.api.ExecutionListener;
import org.apache.commons.lang3.ObjectUtils;

public class ImageUploadListener
implements ExecutionListener {
    private static final String ENTITY = "task_billimagemap";
    private static final String SELECFIELD = "billid,billtype,imagestate,wfprocessingid,imagenumber,scanuserid,enternodetime";
    private static final long serialVersionUID = -2805474979956979956L;
    private static final String SYS_APP_ID = "18XSXYEL8//U";
    private static Log log = LogFactory.getLog(ImageUploadListener.class);
    private static final String LOCK_PREFIX = "/bos/image/imageReady/";

    public void notify(AgentExecution execution) {
        block24: {
            String billkeyid = execution.getBusinessKey();
            Long workFlowId = execution.getCurrentTaskId();
            log.info("\u5f53\u524d\u5de5\u4f5c\u6d41\u4efb\u52a1id:" + workFlowId + " \u5355\u636eid:" + billkeyid);
            if (workFlowId == null) {
                log.info("\u672a\u83b7\u53d6\u5230\u5de5\u4f5c\u6d41\u4efb\u52a1Id");
                return;
            }
            try (DLock dLock = DLock.create((String)("/bos/image/imageReady//" + billkeyid)).fastMode();){
                if (!dLock.tryLock(5000L)) break block24;
                QFilter qFilter = new QFilter("billid", "=", (Object)billkeyid);
                DynamicObject result = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)SELECFIELD, (QFilter[])new QFilter[]{qFilter});
                if (result == null) {
                    log.info("\u672a\u627e\u5230\u5f71\u50cf\u8bb0\u5f55");
                    return;
                }
                DynamicObject historyTask = BusinessDataServiceHelper.loadSingle((String)"wf_hitaskinst", (String)"id,endtime", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)workFlowId)});
                boolean historyTaskNotEnd = historyTask == null || historyTask.getDate("endtime") == null;
                boolean taskNotExecute = QueryServiceHelper.exists((String)"wf_task", (Object)workFlowId);
                log.info("\u4efb\u52a1\u8868\u5b58\u5728\u6570\u636e\uff1a" + taskNotExecute + "  \u5386\u53f2\u4efb\u52a1\u8868\u5b58\u5728\u6570\u636e" + (historyTask == null) + " \u5386\u53f2\u4efb\u52a1\u662f\u5426\u5b8c\u6210\uff1a" + historyTaskNotEnd);
                if (taskNotExecute || historyTaskNotEnd) {
                    String imageState = result.getString("imagestate");
                    log.info("\u5f53\u524d\u5355\u636e\u5f71\u50cf\u72b6\u6001\u4e3a\uff1a" + imageState);
                    if ("2".equals(imageState) || "4".equals(imageState)) {
                        Long creator;
                        String param = this.getScannerShowControlParam();
                        Long userId = -1L;
                        if (ImageScannerShowTypeEnum.SCANNER.getShowType().equals(param)) {
                            String scanUserId = result.getString("scanuserid");
                            userId = StringUtils.isNumberString((String)scanUserId) ? Long.valueOf(Long.parseLong(scanUserId)) : Long.valueOf(RequestContext.get().getCurrUserId());
                        } else if (ImageScannerShowTypeEnum.SUBMITTER.getShowType().equals(param) && (creator = this.queryCreatorId(new QFilter[]{qFilter})) > 0L) {
                            userId = creator;
                        }
                        try {
                            WorkflowServiceHelper.completeTask((Long)workFlowId, (Long)userId, (String)"Consent", (String)ResManager.loadKDString((String)"\u4e0a\u4f20\u5f71\u50cf\u6210\u529f", (String)"ImageUploadListener_0", (String)"bos-ext-ssc", (Object[])new Object[0]));
                        }
                        catch (Exception e) {
                            log.error("\u63a8\u5de5\u4f5c\u6d41\u5f02\u5e38\uff1a" + e);
                        }
                    }
                }
                result.set("wfprocessingid", (Object)String.valueOf(workFlowId));
                result.set("enternodetime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{result});
            }
        }
    }

    public void notifyByWithdraw(AgentExecution execution) {
        Long currentTaskId = execution.getCurrentTaskId();
        String businessKey = execution.getBusinessKey();
        log.info("\u4efb\u52a1id\uff1a" + currentTaskId + ",\u5355\u636eid\uff1a" + businessKey);
        QFilter qFilter = new QFilter("billid", "=", (Object)businessKey);
        DynamicObject image = BusinessDataServiceHelper.loadSingle((String)ENTITY, (String)SELECFIELD, (QFilter[])new QFilter[]{qFilter});
        if (image == null) {
            log.info("\u672a\u627e\u5230\u5f71\u50cf\u8bb0\u5f55");
            return;
        }
        String imageNumber = image.getString("imagenumber");
        String imageState = image.getString("imagestate");
        log.info("imagenumber\uff1a" + imageNumber + ",imagestate\uff1a" + imageState);
        if ("2".equals(imageState) || "4".equals(imageState)) {
            try {
                ImageServiceHelper.imageRscan((String)imageNumber, (String)ResManager.loadKDString((String)"\u626b\u63cf\u5458\u9000\u56de\u91cd\u626b", (String)"ImageUploadListener_1", (String)"bos-ext-ssc", (Object[])new Object[0]), (String)RequestContext.get().getUserId());
                image.set("imageState", (Object)"3");
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{image});
                log.info(imageNumber + "\u626b\u63cf\u5458\u9000\u626b\u6210\u529f");
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private String getScannerShowControlParam() {
        long rootOrgId = OrgUnitServiceHelper.getRootOrgId();
        AppParam param = new AppParam(SYS_APP_ID, Long.valueOf(rootOrgId));
        Object paramValue = SystemParamServiceHelper.loadAppParameterFromCache((AppParam)param, (String)"scannershowcontrol");
        return ObjectUtils.isEmpty((Object)paramValue) ? ImageScannerShowTypeEnum.SCANNER.getShowType() : paramValue.toString();
    }

    private Long queryCreatorId(QFilter[] filters) {
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"queryCreatorId", (String)ENTITY, (String)"creator.id", (QFilter[])filters, null);){
            if (dataSet.hasNext()) {
                Long l = dataSet.next().getLong("creator.id");
                return l;
            }
        }
        return 0L;
    }
}

