/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hrwtc.thread;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import kd.bos.context.OperationContext;
import kd.bos.context.RequestContext;
import kd.bos.ext.hrwtc.thread.IWTCUnifiedTaskType;
import kd.bos.unifiedthreadpool.api.PoolRejectedExecutionHandler;
import kd.bos.unifiedthreadpool.api.ThreadExecutorService;
import kd.bos.unifiedthreadpool.api.ThreadPoolFactory;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategy;
import kd.bos.unifiedthreadpool.api.ThreadPoolStrategyFactory;
import kd.bos.unifiedthreadpool.policy.AbortPolicy;
import kd.bos.unifiedthreadpool.tasktype.Priority;
import kd.bos.unifiedthreadpool.tasktype.TaskType;

public class WTCThreadExecutorService {
    private static final ThreadExecutorService SERVICE = ThreadPoolFactory.create((String)"wtc", (String)"wtc-threadpool", (ThreadPoolStrategy)WTCThreadExecutorService.getDefaultThreadPoolStrategy());

    private static ThreadPoolStrategy getDefaultThreadPoolStrategy() {
        ThreadPoolStrategy strategy = ThreadPoolStrategyFactory.create();
        strategy.setMinThreadNum(2).setMaxThreadNum(20).setOverflowThreadNum(4).setThreadIdeMinutes(1L);
        strategy.setRejectedExecutionHandler((PoolRejectedExecutionHandler)new AbortPolicy());
        strategy.register(new TaskType("wtc.commontask", Priority.FIVE));
        return strategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ThreadExecutorService get(IWTCUnifiedTaskType taskTypeEnum) {
        TaskType taskType = WTCThreadExecutorService.getTaskType(taskTypeEnum);
        if (taskType == null) {
            IWTCUnifiedTaskType iWTCUnifiedTaskType = taskTypeEnum;
            synchronized (iWTCUnifiedTaskType) {
                taskType = WTCThreadExecutorService.getTaskType(taskTypeEnum);
                if (taskType == null) {
                    taskType = new TaskType(taskTypeEnum.getName(), taskTypeEnum.getPriority(), taskTypeEnum.getThreadLimitedModel(), (Object)taskTypeEnum.getThreadLimitedValue(), taskTypeEnum.getTaskQueueMaxSize());
                    SERVICE.addTaskType(taskType);
                }
            }
        }
        return SERVICE;
    }

    private static TaskType getTaskType(IWTCUnifiedTaskType taskTypeEnum) {
        TaskType taskType = null;
        try {
            taskType = SERVICE.getTaskType(taskTypeEnum.getName());
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return taskType;
    }

    public static void execute(Runnable runnable, IWTCUnifiedTaskType taskTypeEnum, RequestContext requestContext, OperationContext operationContext) {
        WTCThreadExecutorService.get(taskTypeEnum).execute(runnable, taskTypeEnum.getName(), requestContext, operationContext);
    }

    public static <T> Future<T> submit(Callable<T> callAble, IWTCUnifiedTaskType taskTypeEnum, RequestContext requestContext, OperationContext operationContext) {
        return WTCThreadExecutorService.get(taskTypeEnum).submit(callAble, taskTypeEnum.getName(), requestContext, operationContext);
    }
}

