/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.filter;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.ext.hr.filter.AdminOrgHisF7FastFilter;
import kd.bos.filter.CommonBaseDataFilterColumn;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Control;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BaseDataCustomControllerEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class AdminOrgF7FastFilter
extends AdminOrgHisF7FastFilter {
    private static final String FAST_FILTER_STRUCT_PROJECT_ID = "fastFilterStructProjectId";

    @Override
    public void buildBaseDataCoreFilter(BaseDataCustomControllerEvent event) {
        super.buildBaseDataCoreFilter(event);
        Object source = event.getSource();
        ListShowParameter listShowParameter = event.getListShowParameter();
        QFilter versionFilter = this.getVersionFilter(listShowParameter);
        List<Long> structProjectIds = this.getStructProjectId(source);
        QFilter filter = this.buildStructFilter(versionFilter, structProjectIds);
        if (filter != null) {
            event.addQFilter(filter);
        }
    }

    private List<Long> getStructProjectId(Object source) {
        IPageCache pageCache = ((Control)source).getView().getPageCache();
        String structProjectIdStr = pageCache.get(FAST_FILTER_STRUCT_PROJECT_ID);
        if (!StringUtils.isEmpty((CharSequence)structProjectIdStr)) {
            return Collections.singletonList(Long.parseLong(structProjectIdStr));
        }
        String entityName = "";
        String propKey = "";
        if (source instanceof BasedataEdit) {
            BasedataEdit column = (BasedataEdit)source;
            entityName = column.getView().getEntityId();
            propKey = column.getFieldKey();
        } else if (source instanceof CommonBaseDataFilterColumn) {
            CommonBaseDataFilterColumn column = (CommonBaseDataFilterColumn)source;
            entityName = column.getEntityType().getName();
            propKey = column.getFieldName();
        }
        return this.getStructProConfig(entityName, propKey);
    }

    private QFilter buildStructFilter(QFilter versionFilter, List<Long> structProjectIds) {
        if (!CollectionUtils.isEmpty(structProjectIds)) {
            QFilter structProjectFilter = new QFilter("structproject", "in", structProjectIds);
            if (versionFilter == null) {
                structProjectFilter.and("iscurrentversion", "=", (Object)"1");
            } else {
                structProjectFilter.and(versionFilter);
            }
            structProjectFilter.and("enable", "=", (Object)"1");
            DynamicObjectCollection structInfos = QueryServiceHelper.query((String)"haos_adminorgstruct", (String)"structproject, adminorg", (QFilter[])new QFilter[]{structProjectFilter});
            Map<Long, List<DynamicObject>> structProjectIdMap = structInfos.stream().collect(Collectors.groupingBy(structInfo -> structInfo.getLong("structproject")));
            QFilter filter = null;
            for (Map.Entry<Long, List<DynamicObject>> entry : structProjectIdMap.entrySet()) {
                Long structProjectId = entry.getKey();
                if (structProjectId == 1010L) {
                    if (filter == null) {
                        filter = new QFilter("isvirtualorg", "=", (Object)"0");
                        continue;
                    }
                    filter.or("isvirtualorg", "=", (Object)"0");
                    continue;
                }
                List<DynamicObject> structInfoGroup = entry.getValue();
                Set adminOrgIds = structInfoGroup.stream().map(structInfo -> structInfo.getLong("adminorg")).collect(Collectors.toSet());
                if (filter == null) {
                    filter = new QFilter("boid", "in", adminOrgIds);
                    continue;
                }
                filter.or("boid", "in", adminOrgIds);
            }
            return filter;
        }
        return null;
    }

    private List<Long> getStructProConfig(String entityType, String propKey) {
        QFilter filter;
        String selectField;
        DynamicObject[] structConfigs;
        if (StringUtils.isEmpty((CharSequence)entityType) || StringUtils.isEmpty((CharSequence)propKey)) {
            return null;
        }
        if (propKey.contains(".")) {
            propKey = propKey.split("\\.")[0];
        }
        if ((structConfigs = BusinessDataServiceHelper.load((String)"haos_structproconfig", (String)(selectField = "entitytype, entryentity, entryentity.propkey, subentryentity.structproject"), (QFilter[])new QFilter[]{filter = new QFilter("entitytype", "=", (Object)entityType)})) != null && structConfigs.length != 0) {
            for (DynamicObject structConfig : structConfigs) {
                Map<String, DynamicObject> propKeyEntryMap;
                DynamicObjectCollection entryEntity = structConfig.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryEntity) || !(propKeyEntryMap = entryEntity.stream().collect(Collectors.toMap(entry -> entry.getString("propkey"), entry -> entry))).containsKey(propKey)) continue;
                DynamicObject entry2 = propKeyEntryMap.get(propKey);
                DynamicObjectCollection subEntryEntity = entry2.getDynamicObjectCollection("subentryentity");
                if (CollectionUtils.isEmpty((Collection)subEntryEntity)) {
                    return null;
                }
                return subEntryEntity.stream().map(subEntry -> subEntry.getLong("structproject.id")).collect(Collectors.toList());
            }
        }
        return null;
    }
}

