/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.hr.menu;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.AppMenuInfo;
import kd.bos.entity.AppMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.portal.service.IPortalAppMenuExtService;
import kd.bos.servicehelper.QueryServiceHelper;

public class HPFSMenuPlugin
implements IPortalAppMenuExtService {
    private static final Log LOG = LogFactory.getLog(HPFSMenuPlugin.class);
    private static final String HPFS_APP_ID = "1XL6VIDTDRXN";
    private static final String HPFS_SWITCH_MENU_CONFIG = "hpfs_switch_menu_config";
    private static final Set<String> OLD_MENU_SET = new HashSet<String>();
    private static final Set<String> NEW_MENU_SET = new HashSet<String>();

    public Map<String, Set<String>> getHideMenuIdsByBizAppIds(Long userId, Map<String, Set<String>> appIdAndMenuIdMap) {
        try {
            Set<String> menuIdSet = appIdAndMenuIdMap.get(HPFS_APP_ID);
            if (CollectionUtils.isEmpty(menuIdSet)) {
                return null;
            }
            HashMap<String, Set<String>> result = new HashMap<String, Set<String>>(16);
            result.put(HPFS_APP_ID, this.getHideMenu());
            return result;
        }
        catch (Exception ex) {
            LOG.error((Throwable)ex);
            return null;
        }
    }

    private Set<String> getHideMenu() {
        DynamicObject configParam = QueryServiceHelper.queryOne((String)"hpfs_devconfig", (String)"businesskey,businessvalue", (QFilter[])new QFilter[]{new QFilter("businesskey", "=", (Object)HPFS_SWITCH_MENU_CONFIG)});
        HashSet<String> needHideSet = new HashSet<String>();
        if (configParam != null) {
            String businessvalue = configParam.getString("businessvalue");
            if ("0".equals(businessvalue)) {
                needHideSet.addAll(NEW_MENU_SET);
            } else if ("1".equals(businessvalue)) {
                needHideSet.addAll(OLD_MENU_SET);
            }
        }
        List appMenusInfoByAppId = AppMetadataCache.getAppMenusInfoByAppId((String)HPFS_APP_ID);
        return appMenusInfoByAppId.stream().filter(appMenusInfo -> needHideSet.contains(appMenusInfo.getFormId())).map(AppMenuInfo::getId).collect(Collectors.toSet());
    }

    static {
        OLD_MENU_SET.add("hpfs_chgguidebase");
        OLD_MENU_SET.add("hpfs_chgtactic");
        OLD_MENU_SET.add("hpfs_chgplugin");
        NEW_MENU_SET.add("hpfs_chgaction");
        NEW_MENU_SET.add("hpfs_filemapmanager");
    }
}

