/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.ai.operation.DapOperationResultHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ReverseVoucherUtil {
    private static final String SQL = "id,sourcebillno,fsourcebillid,buildstate,entryentity.message,entryentity.errlevel,entryentity.seq,errorresult,isexceptionreport";

    public static void buildOperateResult(OperationResult result, Set<Long> idSet, Date time) {
        QFilter qFilter = ReverseVoucherUtil.createQFilter(idSet, time);
        ReverseVoucherUtil.processDataSet(result, idSet, qFilter);
    }

    private static QFilter createQFilter(Set<Long> idSet, Date time) {
        QFilter qFilter = new QFilter("fsourcebillid", "in", idSet).and(new QFilter("createtime", ">=", (Object)time));
        qFilter.and(new QFilter("buildvouchertype", "=", (Object)"9"));
        return qFilter;
    }

    private static void processDataSet(OperationResult result, Set<Long> idSet, QFilter qFilter) {
        HashSet<Long> addMessageBillIds = new HashSet<Long>(idSet);
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)DapOperationResultHelper.class.getName(), (String)"ai_buildreport", (String)SQL, (QFilter[])qFilter.toArray(), (String)"buildstate asc,createtime desc");){
            for (Row row : ds) {
                Long billId = row.getLong("fsourcebillid");
                if (!addMessageBillIds.contains(billId)) continue;
                String buildState = row.getString("buildstate");
                if ("0".equals(buildState)) {
                    result.getSuccessPkIds().add(billId);
                    addMessageBillIds.remove(billId);
                    continue;
                }
                String message = ReverseVoucherUtil.getMessageFromRow(row);
                if (message == null) continue;
                addMessageBillIds.remove(billId);
                OperateErrorInfo errorInfo = ReverseVoucherUtil.createErrorInfo(billId, message);
                result.setSuccess(false);
                result.addErrorInfo(errorInfo);
            }
        }
    }

    private static String getMessageFromRow(Row row) {
        if (Boolean.TRUE.equals(row.getBoolean("isexceptionreport"))) {
            String error = row.getString("errorresult");
            return error.isEmpty() || error.length() > 50 ? ResManager.loadKDString((String)"\u201c\u51b2\u9500\u51ed\u8bc1\u201d\u5f02\u5e38\uff0c\u8bf7\u67e5\u770b\u51ed\u8bc1\u751f\u6210\u62a5\u544a\u201c\u5f02\u5e38\u5806\u6808\u4fe1\u606f\u201d\u6216\u8005\u8054\u7cfb\u5bf9\u5e94\u5f00\u53d1\u5904\u7406\u3002", (String)"ReverseVoucherUtil_1", (String)"bos-ext-fi", (Object[])new Object[0]) : error;
        }
        if ("2".equalsIgnoreCase(row.getString("entryentity.errlevel").trim())) {
            return row.getString("entryentity.message");
        }
        return null;
    }

    private static OperateErrorInfo createErrorInfo(Long billId, String message) {
        OperateErrorInfo errorInfo = new OperateErrorInfo();
        errorInfo.setLevel(ErrorLevel.Error);
        errorInfo.setMessage(message);
        errorInfo.setPkValue((Object)billId);
        errorInfo.setTitle(ResManager.loadKDString((String)"\u51b2\u9500\u51ed\u8bc1", (String)"ReverseVoucherUtil_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        return errorInfo;
    }
}

