/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.dap.customfilter;

import kd.bos.cache.CacheConfigInfo;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.LocalMemoryCache;
import kd.bos.dataentity.resource.cache.CacheKeyUtil;
import kd.bos.ext.fi.ai.dap.customfilter.IRelationBillCustomFilter;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RelationBillCustomFilterImpl
implements IRelationBillCustomFilter {
    @Override
    public QFilter getRelationBillCustomFilter(String billtype) {
        if (StringUtils.isEmpty(billtype) || "fah_e_".equals(billtype) || !billtype.startsWith("fah_e_")) {
            return null;
        }
        CacheConfigInfo localConfig = new CacheConfigInfo();
        localConfig.setMaxItemSize(5000);
        localConfig.setTimeout(600);
        LocalMemoryCache localcache = CacheFactory.getCommonCacheFactory().$getOrCreateLocalMemoryCache(CacheKeyUtil.getAcctId(), "ai", localConfig);
        if (localcache.get(billtype) != null) {
            return this.getFilter();
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        if (cache.get(billtype) != null) {
            return this.getFilter();
        }
        if (this.isExistExtDataModel(billtype = billtype.toLowerCase())) {
            cache.put(billtype, (Object)"C");
            localcache.put(billtype, (Object)"C");
            return this.getFilter();
        }
        return null;
    }

    private QFilter getFilter() {
        return new QFilter("billstatus", "=", (Object)"C");
    }

    private boolean isExistExtDataModel(String billtype) {
        return QueryServiceHelper.exists((String)"fah_ext_datamodel", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)billtype.substring(6)).and(new QFilter("status", "=", (Object)"C"))});
    }
}

