/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.dap.cache.CacheHelper;
import kd.bos.ext.fi.ai.dap.cache.CacheModule;
import kd.bos.ext.fi.ai.dap.cache.DistributeCache;
import kd.bos.ext.fi.ai.operate.FahOperateUtil;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.operation.OperationServiceHelper;

public class FahOperateTask
implements Callable<OperationResult> {
    private static final Log logger = LogFactory.getLog(FahOperateTask.class);
    public static final String CURRTASKKEY = "currProgress";
    public String operateClassName;
    RequestContext rc;
    Set<Long> idSet;
    String entityId;
    String taskId;
    String operateKey;
    String optionStr;
    boolean isReverse;
    String requestId;

    public FahOperateTask() {
    }

    public FahOperateTask(RequestContext rc, Set<Long> idSet, String entityId, String taskId, String operateKey, String optionStr, boolean isReverse, String requestId) {
        this.rc = rc;
        this.idSet = idSet;
        this.entityId = entityId;
        this.taskId = taskId;
        this.operateKey = operateKey;
        this.optionStr = optionStr;
        this.isReverse = isReverse;
        this.requestId = requestId;
    }

    @Override
    public OperationResult call() {
        RequestContext.copyAndSet((RequestContext)this.rc);
        return this.doTask();
    }

    private OperationResult doTask() {
        List opts = EntityMetadataCache.getDataEntityOperate((String)this.entityId);
        String voucherOpt = this.operateKey;
        if (StringUtils.isEmpty((CharSequence)voucherOpt)) {
            String keyName = this.isReverse ? "reverseglandacctje" : "generatevoucher";
            for (Map opt : opts) {
                String optKey = (String)opt.get("type");
                if (!optKey.equalsIgnoreCase(keyName)) continue;
                voucherOpt = (String)opt.get("key");
                break;
            }
        }
        OperateOption create = OperateOption.create();
        if (null != this.optionStr) {
            Map optionMap = FahSerializeHelper.getInstance().parse(this.optionStr, Map.class);
            for (Map.Entry entrySet : optionMap.entrySet()) {
                create.setVariableValue((String)entrySet.getKey(), (String)entrySet.getValue());
            }
        }
        create.setVariableValue("GenerateProcessKey", this.taskId);
        create.setVariableValue("build_mode", "true");
        create.setVariableValue("entityId", this.entityId);
        create.setVariableValue("requestId", this.requestId);
        if (null == this.idSet) {
            throw new RuntimeException("idSet is null");
        }
        try {
            long start = System.currentTimeMillis();
            OperationResult operationResult = OperationServiceHelper.executeOperate((String)voucherOpt, (String)this.entityId, (Object[])this.idSet.toArray(), (OperateOption)create);
            FahOperateUtil.checkAndCacheOperationResult(this.taskId, operationResult);
            long end = System.currentTimeMillis();
            logger.info("{}_cost, {} ms, requestId: {}", new Object[]{voucherOpt, end - start, this.requestId});
            return operationResult;
        }
        catch (Exception e) {
            logger.error("{}_error\uff1a{}", (Object)voucherOpt, (Object)e.getMessage());
            return this.buildErrorResult(e);
        }
    }

    OperationResult buildErrorResult(Exception e) {
        String message = e.getMessage();
        String progressTag = this.taskId;
        DistributeCache distributeCache = CacheHelper.getDistributeCache(CacheModule.GenerateVoucherTaskProcess);
        HashMap<String, Object> cacheDataMap = new HashMap<String, Object>(8);
        cacheDataMap.put(CURRTASKKEY, 100);
        cacheDataMap.put("currProgress_error", message);
        distributeCache.put(progressTag, SerializationUtils.toJsonString(cacheDataMap));
        OperationResult operationResult = new OperationResult();
        operationResult.setSuccess(false);
        operationResult.setMessage(message);
        return operationResult;
    }
}

