/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.operate.FahOperateUtil;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahSerializeHelper;
import kd.bos.ext.fi.ai.v2.fah.constant.CreateXlaMode;
import kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PreviewVoucherOp
extends DefaultEntityOperate
implements IConfirmCallBack,
ICloseCallBack {
    private static final Log logger = LogFactory.getLog(PreviewVoucherOp.class);
    public static final String CURRTASKKEY = "currProgress";

    protected int getBatchSize() {
        return Integer.MAX_VALUE;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        logger.info("PreviewVoucherOp_beforeInvokeOperation");
        Set<Long> billIds = this.getSelectedBillIds();
        if (billIds.size() > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc71000\u5f20\u5355\u4e0d\u53ef\u4ee5\u9884\u89c8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PreviewVoucherOp_9", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        String mode = BuildXLAAndGLUtils.createXlaMode();
        if (CreateXlaMode.DAP_NEW_CUS.getCode().equals(mode) || CreateXlaMode.DAP_REG_NEW.getCode().equals(mode) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getEntityId(), this.getSelectedBillIds())) {
            return this.buildXlaAndGLForm(result);
        }
        if (CreateXlaMode.DAP_REG_OPTION.getCode().equals(mode) && BuildXLAAndGLUtils.checkHasRegBillWithData(this.getEntityId(), this.getSelectedBillIds())) {
            String createMode = this.getOption().getVariableValue("create_mode", null);
            if (null == createMode) {
                FormShowParameter parameters = new FormShowParameter();
                parameters.getOpenStyle().setShowType(ShowType.Modal);
                parameters.setFormId("fah_preview_mode");
                parameters.setCustomParam("pageId", (Object)this.getView().getPageId());
                parameters.setCustomParam("operateKey", (Object)this.getOperateKey());
                parameters.setCustomParam("entityId", (Object)this.getEntityId());
                parameters.setCustomParam("operatorName", (Object)this.getOperateName().getLocaleValue());
                parameters.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_preview_mode"));
                this.getView().showForm(parameters);
                return false;
            }
            if ("2".equals(createMode)) {
                return this.buildXlaAndGLForm(result);
            }
        } else if (CreateXlaMode.DAP_ORG_NEW.getCode().equals(mode)) {
            Boolean hasRegOrg = BuildXLAAndGLUtils.checkHasRegOrgBillWithData(this.getEntityId(), this.getSelectedBillIds());
            if (null == hasRegOrg) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f53\u524d\u9009\u62e9\u7684\u5355\u636e\u4ec5\u90e8\u5206\u6ee1\u8db3\u65b0\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u542f\u7528\u8303\u56f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"BuildVoucher_18", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            if (Boolean.TRUE.equals(hasRegOrg)) {
                return this.buildXlaAndGLForm(result);
            }
        }
        return this.previewDapVoucher(result);
    }

    boolean previewDapVoucher(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        return this.checkPreviewValid();
    }

    boolean checkPreviewValid() {
        Set<Long> billIds;
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58%s\u3002", (String)"PreviewVoucherOp_3", (String)"bos-ext-fi", (Object[])new Object[]{this.getView().getFormShowParameter().getCaption()}));
                return false;
            }
        }
        if ((billIds = this.getSelectedBillIds()).size() > 1000) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8d85\u8fc71000\u5f20\u5355\u4e0d\u53ef\u4ee5\u9884\u89c8\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"PreviewVoucherOp_9", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        HashMap<String, List<Long>> billTypeGroup = new HashMap<String, List<Long>>(1);
        boolean isAiEvent = "ai_event".equals(this.getEntityId());
        if (isAiEvent) {
            Set<Long> selectedBillIds = this.getSelectedBillIds();
            billTypeGroup.putAll(ExtDataQueryHelper.groupByBillType(selectedBillIds));
            if (billTypeGroup.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u4e0d\u540c\u6a21\u578b\u4e0b\u7684\u5916\u90e8\u6570\u636e\u751f\u6210\u51ed\u8bc1\u3002", (String)"BuildVoucher_12", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            String billType = (String)billTypeGroup.keySet().iterator().next();
            if ("ai_event".equals(billType)) {
                DynamicObject event = QueryServiceHelper.queryOne((String)"ai_event", (String)"eventclass.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billIds.iterator().next())});
                qFilters.add(new QFilter("eventclass.id", "=", (Object)event.getLong("eventclass.id")));
                qFilters.add(new QFilter("billentity", "=", (Object)"ai_eventclass"));
            } else {
                qFilters.add(new QFilter("billentity", "=", (Object)billType));
            }
        } else {
            qFilters.add(new QFilter("billentity", "=", (Object)this.getEntityId()));
        }
        DynamicObject config = QueryServiceHelper.queryOne((String)"ai_dapconfig", (String)"id,isdap,billentity,oper,isselecttemp", (QFilter[])qFilters.toArray(new QFilter[0]));
        if (config != null) {
            boolean isdap = config.getBoolean("isdap");
            if (!isdap) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5f00\u542f\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3002", (String)"PreviewVoucherOp_5", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
        } else {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u5bf9\u8be5\u5355\u636e\u5f00\u542f\u53c2\u4e0e\u751f\u6210\u51ed\u8bc1\u3002", (String)"PreviewVoucherOp_6", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        boolean isselecttemp = config.getBoolean("isselecttemp");
        this.getView().getPageCache().put("cacheName", this.getEntityId());
        HashSet<Long> vids = new HashSet<Long>(billIds.size());
        ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>(2);
        if (isAiEvent) {
            QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (Map.Entry entry : billTypeGroup.entrySet()) {
                qFilter.or(new QFilter("sourcebillid", "in", entry.getValue()).and("billType", "=", entry.getKey()));
            }
            qFilters1.add(qFilter);
        } else {
            qFilters1.add(new QFilter("sourcebillid", "in", billIds));
            qFilters1.add(new QFilter("billtype", "=", (Object)this.getEntityId()));
        }
        HashSet<Long> notBuildVouIds = new HashSet<Long>(billIds);
        Throwable throwable = null;
        try (DataSet queryDataSet = QueryServiceHelper.queryDataSet((String)"previewVoucher", (String)"ai_daptracker", (String)"sourcebillid,voucherid", (QFilter[])qFilters1.toArray(new QFilter[0]), null);){
            for (Row row : queryDataSet) {
                vids.add(row.getLong("voucherid"));
                notBuildVouIds.remove(row.getLong("sourcebillid"));
            }
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        if (!vids.isEmpty()) {
            if (!notBuildVouIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u548c\u672a\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u652f\u6301\u9884\u89c8\u3002", (String)"PreviewVoucherOp_7", (String)"bos-ext-fi", (Object[])new Object[0]));
            } else {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u603b\u8d26\u51ed\u8bc1\uff0c\u662f\u5426\u8054\u67e5\uff1f", (String)"PreviewVoucherOp_1", (String)"bos-ext-fi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("preview", (AbstractOperate)this));
            }
            return false;
        }
        Object tempIds = DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"SelectTemplteService", (String)"getSelectSource", (Object[])new Object[]{this.getEntityId(), billIds, true});
        Map map = (Map)tempIds;
        if (map.get("useTemp") != null && isselecttemp) {
            FormShowParameter formShow = new FormShowParameter();
            formShow.setFormId("ai_selecttemplate");
            formShow.setCustomParam("tempId", (Object)SerializationUtils.toJsonString((Object)map));
            formShow.setCustomParam("sourceId", (Object)SerializationUtils.toJsonString(billIds));
            formShow.setCustomParam("entityname", (Object)this.getEntityId());
            formShow.setCustomParam("pageId", (Object)this.getView().getPageId());
            formShow.getOpenStyle().setShowType(ShowType.Modal);
            formShow.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "selecttmp"));
            this.getView().showForm(formShow);
            return false;
        }
        return true;
    }

    boolean buildXlaAndGLForm(OperationResult result) {
        if (!LicenseServiceHelper.getLicenseModules().contains("2FMS=8GUFGGN")) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u201c\u8d22\u52a1+\u4f9b\u5e94\u94fe+\u5236\u9020\u5206\u7ec4\u201d\u4e2d\u201c\u4f1a\u8ba1\u4e8b\u4ef6\u5e93\u201d\u5e94\u7528\u8bb8\u53ef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PreviewVoucherOp_14", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        return this.checkBuildXlaAndGlFormValid();
    }

    boolean checkBuildXlaAndGlFormValid() {
        long start = System.currentTimeMillis();
        Set<Long> selectedBillIds = this.getSelectedBillIds();
        Map<Object, Object> billTypeGroups = new HashMap(0);
        String realEntity = this.getEntityId();
        boolean isAiEvent = "ai_event".equals(this.getEntityId());
        if (isAiEvent) {
            if (selectedBillIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\uff0c\u5916\u90e8\u6570\u636e\u4ec5\u652f\u6301\u5217\u8868\u9009\u62e9\u5355\u636e\u751f\u6210\u603b\u8d26\u51ed\u8bc1\u3002", (String)"BuildVoucher_13", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            billTypeGroups = ExtDataQueryHelper.groupByBillType(selectedBillIds);
            if (billTypeGroups.containsKey("ai_event")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e7\u6a21\u578b\u7684\u5916\u90e8\u6570\u636e\u9884\u89c8\u4e8b\u4ef6\u548c\u5b50\u5206\u7c7b\u8d26\u3002", (String)"PreviewVoucherOp_16", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            if (billTypeGroups.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u9009\u62e9\u591a\u4e2a\u4e0d\u540c\u6a21\u578b\u5bf9\u5e94\u7684\u5916\u90e8\u6570\u636e\u9884\u89c8\u603b\u8d26\u51ed\u8bc1\u3002", (String)"PreviewVoucherOp_15", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            LinkedList<String> notRegExtData = new LinkedList<String>();
            for (String string : billTypeGroups.keySet()) {
                boolean hasReg = BuildXLAAndGLUtils.checkHasRegBill(string);
                if (hasReg) continue;
                notRegExtData.add(string);
            }
            if (!notRegExtData.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5916\u90e8\u6570\u636e\u6a21\u578b\uff08\u6a21\u578b\u7f16\u7801\uff1a%1$s\uff09\u672a\u8fdb\u884c\u5355\u636e\u63a5\u5165\u6ce8\u518c\u3002", (String)"PreviewVoucherOp_17", (String)"bos-ext-fi", (Object[])new Object[0]), String.join((CharSequence)",", notRegExtData)));
                return false;
            }
        } else {
            boolean hasReg = BuildXLAAndGLUtils.checkHasRegBill(realEntity);
            if (!hasReg) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)realEntity);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\u201c%1$s\uff08%2$s\uff09\u201d\u672a\u8fdb\u884c\u5355\u636e\u63a5\u5165\u6ce8\u518c\u3002", (String)"PreviewVoucherOp_18", (String)"bos-ext-fi", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), realEntity));
                return false;
            }
        }
        if (FahVoucherDao.existGLVoucher(isAiEvent, this.getEntityId(), selectedBillIds, billTypeGroups)) {
            this.getView().getPageCache().put("cacheName", this.getEntityId());
            this.getView().showConfirm(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u603b\u8d26\u51ed\u8bc1\uff0c\u662f\u5426\u8054\u67e5\uff1f", (String)"PreviewVoucherOp_1", (String)"bos-ext-fi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("preview", (AbstractOperate)this));
            return false;
        }
        OperateOption option = this.getOption();
        option = option == null ? OperateOption.create() : option;
        Map optionMap = option.getVariables();
        long l = System.currentTimeMillis();
        logger.info("--XLA--EventAndXla, cost:{}ms, optionMap:{}", (Object)(l - start), (Object)optionMap);
        return FahOperateUtil.invokeBuildXlaAndGlTipTask((AbstractOperate)this, optionMap);
    }

    void showResult(IFormView currentView, long requestId, Map<String, String> cacheDataMap) {
        String error = cacheDataMap.get("currProgress_error");
        String operationResult = cacheDataMap.get("operationResult");
        String or = operationResult == null ? null : operationResult.toString();
        String msg = ResManager.loadKDString((String)"\u9884\u89c8\u51ed\u8bc1\u6210\u529f\u3002", (String)"PreviewVoucherOp_12", (String)"bos-ext-fi", (Object[])new Object[0]);
        if (or != null) {
            List<Long> voucherIfPks = FahVoucherDao.queryIfVoucherByRequestId(requestId);
            OperationResult opResult = (OperationResult)DataEntitySerializer.deSerializerFromString((String)or, (IDataEntityType)OrmUtils.getDataEntityType(OperationResult.class));
            if (opResult.isSuccess()) {
                currentView.showSuccessNotification(msg, Integer.valueOf(15000));
                if (voucherIfPks.size() == 1) {
                    this.showVoucherIf(currentView, voucherIfPks.get(0));
                } else if (voucherIfPks.size() > 1) {
                    this.showVoucherIfList(currentView, voucherIfPks, requestId, true);
                }
            } else {
                this.showVoucherIfList(currentView, voucherIfPks, requestId, false);
            }
            this.refreshData(currentView);
        } else if (StringUtils.isNotBlank((Object)error)) {
            currentView.showTipNotification(error.toString());
        } else {
            currentView.showSuccessNotification(msg);
            this.refreshData(currentView);
        }
    }

    public OperateOption getOption() {
        OperateOption option = super.getOption();
        option.setVariableValue("previewpageid", this.getView().getPageId());
        return option;
    }

    private static String getString() {
        return ResManager.loadKDString((String)"\u5355\u636e\u5728\u6240\u6709\u59d4\u6258\u6838\u7b97\u8d26\u7c3f\u4e0b\u90fd\u5df2\u751f\u6210\u51ed\u8bc1\u3002", (String)"PreviewVoucherOp_0", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        super.afterInvokeOperation(opResult);
        this.doDisposeResult(this.getView(), opResult);
    }

    protected void afterOperationClose(OperationResult result) {
        List errors = result.getAllErrorInfo();
        List averrors = result.getAllErrorOrValidateInfo();
        if ((errors == null || errors.size() <= 0 || averrors == null || averrors.size() != 1) && result.isSuccess()) {
            this.showSuccessMessage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result = evt.getResult();
        String billType = SessionManager.getCurrent().getView(this.getView().getPageId()).getPageCache().get("cacheName");
        if (MessageBoxResult.Yes.equals((Object)result)) {
            HashSet<Long> sourceBillIds = new HashSet<Long>();
            if (this.getView() instanceof IListView) {
                IListView listView = (IListView)this.getView();
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (!selectedRows.isEmpty()) {
                    selectedRows.forEach(o -> sourceBillIds.add((Long)o.getPrimaryKeyValue()));
                }
            } else if (this.getView() instanceof BillView) {
                sourceBillIds.add((Long)this.getView().getModel().getDataEntity().getPkValue());
            }
            boolean isAiEvent = "ai_event".equals(billType);
            if (!sourceBillIds.isEmpty()) {
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(new QFilter("sourcebillid", "in", sourceBillIds));
                Map<Object, Object> billTypeGroup = new HashMap(0);
                if (isAiEvent && (billTypeGroup = ExtDataQueryHelper.groupByBillType(sourceBillIds)).size() > 0) {
                    billType = (String)billTypeGroup.keySet().iterator().next();
                }
                DapVoucherUtil.addBillTypeFilter(billType, filterList);
                DynamicObjectCollection dapTrackers = QueryServiceHelper.query((String)"ai_daptracker", (String)"voucherid", (QFilter[])filterList.toArray(new QFilter[0]));
                if (dapTrackers != null && !dapTrackers.isEmpty()) {
                    if (dapTrackers.size() == 1) {
                        long singleVchId = ((DynamicObject)dapTrackers.iterator().next()).getLong("voucherid");
                        this.showVoucher(singleVchId);
                    } else {
                        Set<Long> voucherIds = dapTrackers.stream().map(k -> k.getLong("voucherid")).collect(Collectors.toSet());
                        this.showVoucherList(voucherIds);
                    }
                } else {
                    Set<Long> voucherPks = FahVoucherDao.queryEvtTrackerInfo(isAiEvent, billType, sourceBillIds, billTypeGroup);
                    if (voucherPks.size() == 1) {
                        this.showVoucher(voucherPks.iterator().next());
                    } else {
                        this.showVoucherList(voucherPks);
                    }
                }
            }
        }
    }

    private void showVoucher(long billId) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long orgId = 0L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)"gl_voucher", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, null);){
            for (Row row : ds) {
                orgId = row.getLong("org");
            }
        }
        String entity = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"getVoucherEntity", (Object[])new Object[]{billId});
        showParameter.setFormId(entity);
        long userId = RequestContext.get().getCurrUserId();
        int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)entity, (String)"4715a0df000000ac");
        Boolean isbizvoucher = DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam(orgId);
        if (!(i != 1 || isbizvoucher.booleanValue() && "gl_voucher".equals(entity))) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.setHasRight(true);
        showParameter.setCustomParam("checkRightAppId", (Object)"gl");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void showVoucherList(Set<Long> voucherPks) {
        ListShowParameter showParameter = new ListShowParameter();
        long singleVchId = voucherPks.iterator().next();
        String entity = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"getVoucherEntity", (Object[])new Object[]{singleVchId});
        showParameter.setBillFormId(entity);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setShowFilter(false);
        showParameter.setShowQuickFilter(false);
        for (Long pkid : voucherPks) {
            showParameter.addLinkQueryPkId((Object)pkid);
        }
        showParameter.getCustomParams().put("org", "");
        showParameter.getCustomParams().put("booktype", "");
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected Set<Long> getSelectedBillIds() {
        return FahOperateUtil.getSelectedBillIds(this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String key;
        switch (key = evt.getActionId()) {
            case "selecttmp": {
                String returnData = evt.getReturnData() + "";
                Map map = (Map)SerializationUtils.fromJsonString((String)returnData, Map.class);
                if (map == null) break;
                String pageid = (String)map.get("pageId");
                OperateOption create = OperateOption.create();
                create.setVariableValue("tempId", (String)map.get("souandtemp"));
                create.setVariableValue("previewpageid", pageid);
                create.setVariableValue("build_mode", "false");
                Set ids = (Set)SerializationUtils.fromJsonString((String)((String)map.get("sourceid")), Set.class);
                String preKey = this.getPreVoucherKey((String)map.get("entityname"));
                OperationResult opResult = OperationServiceHelper.executeOperate((String)preKey, (String)((String)map.get("entityname")), (Object[])ids.toArray(), (OperateOption)create);
                this.doDisposeResult(SessionManager.getCurrent().getView(pageid), opResult);
                break;
            }
            case "fah_preview_mode": {
                String returnData = (String)evt.getReturnData();
                Map map = FahSerializeHelper.fromJsonString(returnData, Map.class);
                if (map == null) break;
                String pageId = (String)map.get("pageId");
                OperateOption create = OperateOption.create();
                create.setVariableValue("create_mode", (String)map.get("create_mode"));
                String genKey = (String)map.get("operateKey");
                genKey = genKey == null ? this.getPreVoucherKey((String)map.get("entityId")) : genKey;
                IFormView view = SessionManager.getCurrent().getView(pageId);
                view.invokeOperation(genKey, create);
                break;
            }
            case "fah_build_xla_gl_tip": {
                String returnData = (String)evt.getReturnData();
                Map map = FahSerializeHelper.fromJsonString(returnData, Map.class);
                if (map == null) break;
                Long requestId = Long.valueOf((String)map.get("requestId"));
                IFormView currentView = SessionManager.getCurrent().getView((String)map.get("pageId"));
                this.showResult(currentView, requestId, map);
                break;
            }
        }
    }

    private void showVoucherIf(IFormView currentView, Long pk) {
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId("fah_unrecord_voucher");
        showParameter.setPkId((Object)pk);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.setHasRight(true);
        currentView.showForm((FormShowParameter)showParameter);
    }

    private void showVoucherIfList(IFormView currentView, List<Long> voucherIfPks, Long requestId, boolean isSuccess) {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setBillFormId("fah_unrecord_voucher");
        listShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        listShowParameter.setShowFilter(false);
        listShowParameter.setShowQuickFilter(false);
        listShowParameter.getListFilterParameter().setFilter(new QFilter("id", "in", voucherIfPks));
        listShowParameter.setCustomParam("isSuccess", (Object)isSuccess);
        listShowParameter.setCustomParam("requestId", (Object)requestId);
        currentView.showForm((FormShowParameter)listShowParameter);
    }

    private void showPreVoucher(IFormView view) {
        IAppCache cache = AppCache.get((String)"gl");
        String string = (String)cache.get("accSys_" + view.getPageId() + "_perviewvouchernew", String.class);
        if (StringUtils.isBlank((CharSequence)string)) {
            string = (String)cache.get("accSys_" + view.getPageId() + "_perviewvoucher", String.class);
            String entityName = (String)cache.get("accSys_" + view.getPageId() + "_entityname", String.class);
            String billId = (String)cache.get("accSys_" + view.getPageId() + "_billid", String.class);
            String isevent = (String)cache.get("accSys_" + view.getPageId() + "_isevent", String.class);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                String tempId = (String)cache.get("accSys_" + view.getPageId() + "_vchtemplateid", String.class);
                FormShowParameter form = new FormShowParameter();
                form.setFormId("ai_previewvoucher");
                form.setCustomParam("voucher", (Object)string);
                form.setCustomParam("entityname", (Object)entityName);
                form.setCustomParam("isevent", (Object)isevent);
                form.setCustomParam("billId", (Object)billId);
                form.setCustomParam("tempId", (Object)tempId);
                form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                form.setStatus(OperationStatus.VIEW);
                view.showForm(form);
            }
        } else {
            String entityName = (String)cache.get("accSys_" + view.getPageId() + "_entityname", String.class);
            String billId = (String)cache.get("accSys_" + view.getPageId() + "_billid", String.class);
            String isevent = (String)cache.get("accSys_" + view.getPageId() + "_isevent", String.class);
            if (StringUtils.isNotBlank((CharSequence)string)) {
                Map map = (Map)SerializationUtils.fromJsonString((String)string, Map.class);
                String tempId = (String)cache.get("accSys_" + view.getPageId() + "_vchtemplateid", String.class);
                if (map.size() > 1) {
                    FormShowParameter showParameter = new FormShowParameter();
                    showParameter.setFormId("ai_previewvoucherlist");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    showParameter.setCustomParam("voucher", (Object)string);
                    showParameter.setCustomParam("entityname", (Object)entityName);
                    showParameter.setCustomParam("isevent", (Object)isevent);
                    showParameter.setCustomParam("billId", (Object)billId);
                    showParameter.setCustomParam("tempId", (Object)tempId);
                    showParameter.setStatus(OperationStatus.VIEW);
                    view.showForm(showParameter);
                } else {
                    FormShowParameter form = new FormShowParameter();
                    form.setFormId("ai_previewvoucher");
                    form.setCustomParam("voucher", map.get("preview1"));
                    form.setCustomParam("entityname", (Object)entityName);
                    form.setCustomParam("isevent", (Object)isevent);
                    form.setCustomParam("billId", (Object)billId);
                    form.setCustomParam("tempId", (Object)tempId);
                    form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    form.setStatus(OperationStatus.VIEW);
                    view.showForm(form);
                }
            }
        }
    }

    private String getPreVoucherKey(String entityname) {
        List opts = EntityMetadataCache.getDataEntityOperate((String)entityname);
        String genVoucherOptName = "previewvoucher";
        for (Map opt : opts) {
            String optKey = (String)opt.get("type");
            if (!optKey.equalsIgnoreCase("previewvoucher")) continue;
            genVoucherOptName = (String)opt.get("key");
        }
        return genVoucherOptName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDisposeResult(IFormView view, OperationResult opResult) {
        try {
            if (!opResult.isSuccess()) {
                String message = opResult.getMessage();
                if (PreviewVoucherOp.getString().equals(message)) {
                    this.setOption(OperateOption.create());
                    this.setView(view);
                    this.setOperateKey("previewvoucher");
                    boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
                    if (!isConfirm) {
                        view.showConfirm(ResManager.loadKDString((String)"\u5df2\u751f\u6210\u603b\u8d26\u51ed\u8bc1\uff0c\u662f\u5426\u8054\u67e5\uff1f", (String)"PreviewVoucherOp_1", (String)"bos-ext-fi", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("contentChange1", (AbstractOperate)this));
                    }
                    opResult.getAllErrorOrValidateInfo().clear();
                    opResult.getAllErrorInfo().clear();
                    return;
                }
                if (opResult.getAllErrorOrValidateInfo().size() > 0) {
                    message = ((IOperateInfo)opResult.getAllErrorOrValidateInfo().get(0)).getMessage();
                }
                view.showTipNotification(message);
                opResult.setShowMessage(true);
                return;
            }
            this.showPreVoucher(view);
        }
        finally {
            IAppCache cache = AppCache.get((String)"gl");
            cache.remove("accSys_" + view.getPageId() + "_perviewvoucher");
            cache.remove("accSys_" + view.getPageId() + "_perviewvouchernew");
        }
    }

    private void refreshData(IFormView view) {
    }
}

