/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.operation;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.NewVoucherUtils;
import kd.bos.ext.fi.ai.operate.FahOperateUtil;
import kd.bos.ext.fi.ai.operation.DeleteVoucherValidator;
import kd.bos.ext.fi.ai.v2.fah.FahDeleteVoucherRequestTask;
import kd.bos.ext.fi.ai.v2.fah.FahDeleteVoucherValidator;
import kd.bos.ext.fi.ai.v2.fah.FahVoucherWriteBackSqlExecutor;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.util.StringUtils;

public class DeleteVoucherService
extends EntityOperateService {
    private static final Log logger = LogFactory.getLog(DeleteVoucherService.class);

    protected void preparePropertys(List<String> fieldKeys) {
        if ("ai_event".equals(this.getBillEntityType().getName())) {
            fieldKeys.add("number");
        }
        super.preparePropertys(fieldKeys);
    }

    public OperationResult excute(Object[] ids) throws Exception {
        OperationResult sr = super.excute(ids);
        return this.execute_0(sr);
    }

    protected OperationResult execute_0(OperationResult sr) {
        if (sr.getSuccessPkIds().isEmpty()) {
            logger.info("--getSuccessPkIds()--isEmpty");
            return sr;
        }
        boolean batchDelete = Boolean.parseBoolean(SysParamConfig.get("fi.ai.fah.voucher.delete.batch.enable", "false"));
        OperationResult operationResult = batchDelete ? this.deleteVoucherV2_20250310(sr) : this.deleteVoucherV1_20240808(sr);
        FahOperateUtil.updateProcessInfo(this.getOption(), operationResult);
        return operationResult;
    }

    private OperationResult deleteVoucherV2_20250310(OperationResult sr) {
        String billType = this.getBillEntityType().getName();
        List successPkIds = sr.getSuccessPkIds();
        Set successPkIdSet = successPkIds.stream().map(m -> Long.parseLong(m.toString())).collect(Collectors.toSet());
        HashMap paramMap = new HashMap(2);
        String paramJsonStr = JSON.toJSONString(paramMap);
        String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IDeleteVoucherService", (String)"deleteVoucher", (Object[])new Object[]{billType, successPkIdSet, paramJsonStr});
        if (StringUtils.isNotEmpty((String)errorMsg)) {
            try {
                List errorInfoList = JSON.parseArray((String)errorMsg, OperateErrorInfo.class);
                if (!errorInfoList.isEmpty()) {
                    for (OperateErrorInfo operateErrorInfo : errorInfoList) {
                        sr.addErrorInfo(operateErrorInfo);
                    }
                    sr.setSuccess(false);
                }
            }
            catch (Exception e) {
                sr.setMessage(errorMsg);
                sr.setSuccess(false);
            }
        }
        return sr;
    }

    private OperationResult deleteVoucherV1_20240808(OperationResult sr) {
        FahDeleteVoucherRequestTask requestTask = new FahDeleteVoucherRequestTask(this.getBillEntityType().getName(), sr.getSuccessPkIds().stream().map(m -> Long.parseLong(m.toString())).collect(Collectors.toList()));
        requestTask.genRequestTask();
        requestTask.genRequestTaskBatch();
        List<OperateErrorInfo> operationResult = FahDeleteVoucherValidator.newFahVoucherValidate(requestTask);
        FahVoucherWriteBackSqlExecutor fahVoucherWriteBackSqlExecutor = new FahVoucherWriteBackSqlExecutor(requestTask.getBillType());
        fahVoucherWriteBackSqlExecutor.execute("deleteVoucherService", FahVoucherWriteBackSqlExecutor.FahBillEvtStatusBaseDataEnum.PROCESS, requestTask.removeErrorBillIds_event(operationResult));
        NewVoucherUtils.voucherDeleteDataCollect(requestTask);
        if (!requestTask.getVoucherAndBillIdMap_event().isEmpty()) {
            requestTask.getVoucherAndBillIdMap_event().keySet().forEach(id -> requestTask.getVoucherAndBillIdMap_dap().remove(id));
        }
        List<OperateErrorInfo> operateErrorInfos = NewVoucherUtils.deleteVoucherOperation(requestTask.getVoucherAndBillIdMap_dap(), requestTask.getVoucherAndBillIdMap_event(), requestTask.getNot_pushVoucher());
        operationResult.addAll(operateErrorInfos);
        fahVoucherWriteBackSqlExecutor.execute("deleteVoucherService", FahVoucherWriteBackSqlExecutor.FahBillEvtStatusBaseDataEnum.NEW, requestTask.removeErrorBillIds_event(operationResult));
        fahVoucherWriteBackSqlExecutor.execute("deleteVoucherService", FahVoucherWriteBackSqlExecutor.FahBillEvtStatusBaseDataEnum.VOUCHER, operateErrorInfos.stream().map(m -> Long.parseLong(m.getPkValue().toString())).collect(Collectors.toList()));
        operationResult.forEach(f -> sr.addErrorInfo(f));
        requestTask.genErrorTaskInfo(operationResult);
        return sr;
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        String entityKey = this.billEntityType.getName();
        String operateName = this.getOpName();
        String operateType = (String)this.operateMetaMap.get("type");
        DeleteVoucherValidator vd = new DeleteVoucherValidator();
        vd.setEntityKey(entityKey);
        vd.setOperateKey(this.operationKey);
        vd.setOperationName(operateName);
        vd.setOperateType(operateType);
        validators.add(vd);
    }

    protected void executeOperate(DynamicObject[] arg0) {
    }
}

