/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;

@Deprecated
public class FahDeleteVoucherRequestTask {
    private static final Log logger = LogFactory.getLog(FahDeleteVoucherRequestTask.class);
    private Long requestId;
    private String billType;
    private List<Long> billIds;
    private Map<Long, List<Long>> voucherAndBillIdMap_dap = new HashMap<Long, List<Long>>();
    private Map<Long, List<Long>> voucherAndBillIdMap_event = new HashMap<Long, List<Long>>();
    private List<Long> not_pushVoucher = new ArrayList<Long>();
    private List<Long> billIds_event = new ArrayList<Long>();
    private Map<Long, String> billIdAndNumberMap = new HashMap<Long, String>();
    private static final String sql_t_fah_request_task = "insert into t_fah_request_task(fid, fTaskNo, fTaskType, fQueryStartDate, fQueryEndDate, fRequestBillCnt, fCreateTime, fCreatorid) values(?,?,?,?,?,?,?,?)";
    private static final String sql_t_fah_request_task_bill = "insert into t_fah_request_task_bill (fpkid,fid,fbasedataid) values(?,?,?)";
    private static final String sql_t_fah_task_batch = "insert into t_fah_task_batch(fid,frequestid,fseqno,fbilltype,freccnt,fstatus) values(?,?,?,?,?,?)";
    private static final String sql_t_fah_task_batch_en = "insert into t_fah_task_batch_en(fid,fentryid,fseqno,fsrcbillid) values(?,?,?,?)";
    public static final String FAH_REQUEST_TASK = "fah_request_task";
    public static final String T_FAH_REQUEST_TASK = "t_fah_request_task";
    private static final DynamicObject dummy_request_task_object = BusinessDataServiceHelper.newDynamicObject((String)"fah_request_task");
    private static final DBRoute dbRoute = DBRoute.of((String)"ai");

    public FahDeleteVoucherRequestTask(String billType, List<Long> billIds) {
        this.billType = billType;
        this.billIds = billIds;
        if (billIds == null) {
            this.billIds = new ArrayList<Long>(8);
        }
        if (CollectionUtils.isEmpty(this.billIds)) {
            return;
        }
        if ("ai_event".equals(billType)) {
            for (Map.Entry<String, List<Long>> billTypeGroup : ExtDataQueryHelper.groupByBillType(this.billIds).entrySet()) {
                List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(billTypeGroup.getValue(), 2000);
                for (List<Long> spIds : splitbatch) {
                    FahVoucherDao.queryHasVoucherBillId(billTypeGroup.getKey(), spIds, this.billIds_event);
                }
            }
        } else {
            List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(this.billIds, 2000);
            for (List<Long> spIds : splitbatch) {
                FahVoucherDao.queryHasVoucherBillId(billType, spIds, this.billIds_event);
            }
        }
        FahVoucherDao.queryBillNumber(billType, this.billIds_event, this.billIdAndNumberMap);
    }

    public Long genRequestTask() {
        if (this.requestId != null) {
            return this.requestId;
        }
        this.requestId = DB.genLongId((String)T_FAH_REQUEST_TASK);
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)sql_t_fah_request_task, (Object[])new Object[]{this.requestId, CodeRuleServiceHelper.getNumber((CodeRuleInfo)CodeRuleServiceHelper.getCodeRule((String)FAH_REQUEST_TASK, (DynamicObject)dummy_request_task_object, null), (DynamicObject)dummy_request_task_object), "8", new Date(), new Date(), this.billIds.size(), new Date(), UserServiceHelper.getCurrentUserId()});
            DB.execute((DBRoute)dbRoute, (String)sql_t_fah_request_task_bill, (Object[])new Object[]{DB.genLongId((String)"t_fah_request_task_bill"), this.requestId, this.billType});
        }
        return this.requestId;
    }

    public void genRequestTaskBatch() {
        if (CollectionUtils.isEmpty(this.billIds)) {
            return;
        }
        if ("ai_event".equals(this.billType)) {
            for (Map.Entry<String, List<Long>> billTypeGroup : ExtDataQueryHelper.groupByBillType(this.billIds).entrySet()) {
                String billType_extData = billTypeGroup.getKey();
                List<Long> billIds_extData = billTypeGroup.getValue();
                this.genRequestTaskBatch2(billType_extData, billIds_extData);
            }
        } else {
            this.genRequestTaskBatch2(this.billType, this.billIds);
        }
    }

    private void genRequestTaskBatch2(String billType, List<Long> billIds) {
        long[] taskBatchEnIds = DB.genLongIds((String)"t_fah_task_batch_en", (int)billIds.size());
        long taskBatchId = DB.genLongId((String)"t_fah_task_batch");
        ArrayList<Object[]> taskBatchEnParamsList = new ArrayList<Object[]>(billIds.size());
        int index = 0;
        for (Long billId : billIds) {
            taskBatchEnParamsList.add(new Object[]{taskBatchId, taskBatchEnIds[index], ++index, billId});
        }
        try (TXHandle h = TX.required();){
            DB.execute((DBRoute)dbRoute, (String)sql_t_fah_task_batch, (Object[])new Object[]{taskBatchId, this.requestId, 1, billType, billIds.size(), Character.valueOf('0')});
            DB.executeBatch((DBRoute)dbRoute, (String)sql_t_fah_task_batch_en, taskBatchEnParamsList);
        }
    }

    public void genErrorTaskInfo(List<OperateErrorInfo> operationResult) {
        String sql = "update t_fah_request_task set fexcuteendtime = ?,ffailbillcnt = ? where fid = ?";
        DB.execute((DBRoute)dbRoute, (String)sql, (Object[])new Object[]{new Date(), operationResult.size(), this.requestId});
        if (operationResult.isEmpty()) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>(operationResult.size());
        long[] newIds = DB.genLongIds((String)"t_fah_task_fail_bills", (int)operationResult.size());
        int i = 0;
        for (OperateErrorInfo errorInfo : operationResult) {
            Long billId = Long.parseLong(errorInfo.getPkValue().toString());
            String billNo = this.billIdAndNumberMap.get(billId);
            billNo = billNo == null ? "" : billNo;
            params.add(new Object[]{newIds[i++], this.requestId, this.billType, billId, errorInfo.getMessage(), "90", billNo});
        }
        FahVoucherDao.insertErrorInfo(params);
    }

    public List<Long> removeErrorBillIds_event(List<OperateErrorInfo> operationResult) {
        if (!operationResult.isEmpty()) {
            List ids = operationResult.stream().map(m -> Long.parseLong(m.getPkValue().toString())).collect(Collectors.toList());
            this.billIds_event.removeAll(ids);
            this.billIds.removeAll(ids);
        }
        return this.billIds_event;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public List<Long> getBillIds() {
        return this.billIds;
    }

    public void setBillIds(List<Long> billIds) {
        this.billIds = billIds;
    }

    public Long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(Long requestId) {
        this.requestId = requestId;
    }

    public Map<Long, List<Long>> getVoucherAndBillIdMap_dap() {
        return this.voucherAndBillIdMap_dap;
    }

    public void setVoucherAndBillIdMap_dap(Map<Long, List<Long>> voucherAndBillIdMap_dap) {
        this.voucherAndBillIdMap_dap = voucherAndBillIdMap_dap;
    }

    public Map<Long, List<Long>> getVoucherAndBillIdMap_event() {
        return this.voucherAndBillIdMap_event;
    }

    public void setVoucherAndBillIdMap_event(Map<Long, List<Long>> voucherAndBillIdMap_event) {
        this.voucherAndBillIdMap_event = voucherAndBillIdMap_event;
    }

    public Map<Long, String> getBillIdAndNumberMap() {
        return this.billIdAndNumberMap;
    }

    public void setBillIdAndNumberMap(Map<Long, String> billIdAndNumberMap) {
        this.billIdAndNumberMap = billIdAndNumberMap;
    }

    public List<Long> getBillIds_event() {
        return this.billIds_event;
    }

    public void setBillIds_event(List<Long> billIds_event) {
        this.billIds_event = billIds_event;
    }

    public List<Long> getNot_pushVoucher() {
        return this.not_pushVoucher;
    }

    public void setNot_pushVoucher(List<Long> not_pushVoucher) {
        this.not_pushVoucher = not_pushVoucher;
    }
}

