/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.util.CollectionUtils;

public class FahVoucherWriteBackSqlExecutor {
    private String tableName;
    private String evtStatusFieldNumAlias;
    private String pkFiled;
    private final String dbRouteKey;
    private boolean isAiEvent;

    public FahVoucherWriteBackSqlExecutor(String billType) {
        this(billType, false);
    }

    private FahVoucherWriteBackSqlExecutor(String billType, boolean checkedAiEvent) {
        String tableGroup;
        if (!checkedAiEvent && "ai_event".equals(billType)) {
            this.isAiEvent = true;
            this.dbRouteKey = "ai";
            return;
        }
        MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)billType);
        this.dbRouteKey = mainEntityType.getDBRouteKey();
        String tableNameTmp = mainEntityType.getAlias();
        String evtStatusFieldNum = this.getBillEvtStatusFieldNum(billType);
        DynamicProperty property = mainEntityType.getProperty(evtStatusFieldNum);
        if (null == property) {
            return;
        }
        boolean supportTableGroup = Boolean.parseBoolean(SysParamConfig.get("fah.evt.writeBack.supportTableGroup", "true"));
        if (supportTableGroup && StringUtils.isNotBlank((CharSequence)(tableGroup = property.getTableGroup()))) {
            tableNameTmp = tableNameTmp + "_" + tableGroup;
        }
        this.tableName = tableNameTmp;
        this.evtStatusFieldNumAlias = property.getAlias();
        this.pkFiled = mainEntityType.getPrimaryKey().getAlias();
    }

    private String getBillEvtStatusFieldNum(String billType) {
        String result = "";
        DynamicObject[] dataCol = BusinessDataServiceHelper.load((String)"fah_regbill", (String)"keyfieldentry,keyfieldentry.id,keyfieldentry.evtstatusfieldnum", (QFilter[])new QFilter("srcbilltype", "=", (Object)billType).toArray());
        if (dataCol == null || dataCol.length <= 0) {
            return result;
        }
        DynamicObjectCollection keyfieldentry = dataCol[0].getDynamicObjectCollection("keyfieldentry");
        if (keyfieldentry.isEmpty()) {
            return result;
        }
        result = ((DynamicObject)keyfieldentry.get(0)).getString("evtstatusfieldnum");
        return result;
    }

    private SqlBuilder createSqlBuilder(FahBillEvtStatusBaseDataEnum billEvtStatusEnum, Collection<Long> billIds) {
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update ", new Object[0]).append(this.tableName, new Object[0]).append(" set ", new Object[0]).append(this.evtStatusFieldNumAlias, new Object[0]).append(" = ? ", new Object[]{billEvtStatusEnum.getId()});
        sqlBuilder.append("where ", new Object[0]).appendIn(this.pkFiled, billIds.toArray());
        return sqlBuilder;
    }

    public void execute(String txTag, FahBillEvtStatusBaseDataEnum billEvtStatusEnum, Collection<Long> billIds) {
        if (this.isAiEvent) {
            this.execute_for_AiEvent(txTag, billEvtStatusEnum, billIds);
            return;
        }
        if (CollectionUtils.isEmpty(billIds) || this.tableName == null) {
            return;
        }
        List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(new ArrayList<Long>(billIds), 1000);
        try (TXHandle h = TX.requiresNew((String)txTag);){
            try {
                for (List<Long> ids : splitbatch) {
                    SqlBuilder sqlBuilder = this.createSqlBuilder(billEvtStatusEnum, ids);
                    DB.execute((DBRoute)DBRoute.of((String)this.dbRouteKey), (SqlBuilder)sqlBuilder);
                }
            }
            catch (Exception e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void execute_for_AiEvent(String txTag, FahBillEvtStatusBaseDataEnum billEvtStatusEnum, Collection<Long> billIds) {
        for (Map.Entry<String, List<Long>> billTypeGroup : ExtDataQueryHelper.groupByBillType(billIds).entrySet()) {
            List<Long> subIdList = billTypeGroup.getValue();
            String billType = billTypeGroup.getKey();
            FahVoucherWriteBackSqlExecutor fahVoucherWriteBackSqlExecutor = new FahVoucherWriteBackSqlExecutor(billType, true);
            fahVoucherWriteBackSqlExecutor.execute(txTag, billEvtStatusEnum, subIdList);
        }
    }

    public String toString() {
        return "FahWriteBackSqlExecutor{tableName='" + this.tableName + '\'' + ", evtStatusFieldNumAlias='" + this.evtStatusFieldNumAlias + '\'' + ", pkFiled='" + this.pkFiled + '\'' + ", dbRouteKey='" + this.dbRouteKey + '\'' + '}';
    }

    public static enum FahBillEvtStatusBaseDataEnum {
        NEW(1000L),
        PROCESS(1001L),
        REVERSED(1005L),
        REVERSED_EVENT(1006L),
        VOUCHER(1003L);

        private Long id;

        private FahBillEvtStatusBaseDataEnum(Long id) {
            this.id = id;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }
}

