/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.dao;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;

public class FahVoucherDao {
    private static Log logger = LogFactory.getLog(FahVoucherDao.class);

    public static List<Long> queryVoucherId(String billType, Set<Long> deleteIds) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (StringUtils.isBlank(billType) || deleteIds.isEmpty()) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sql.append("select distinct fgl_header_id from t_fah_evt_tracker where fstatus = '4' and fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsrc_billid", deleteIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long fglHeaderId = ((Row)iterator.next()).getLong("fgl_header_id");
                result.add(fglHeaderId);
            }
        }
        return result;
    }

    public static void queryHasVoucherBillId(String billType, List<Long> deleteIds, List<Long> hasVoucherBillIds) {
        if (StringUtils.isBlank(billType) || deleteIds.isEmpty()) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sql.append("select distinct fsrc_billid from t_fah_evt_tracker where fstatus = '4' and fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsrc_billid", deleteIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                Long fsrcBillid = ((Row)iterator.next()).getLong("fsrc_billid");
                hasVoucherBillIds.add(fsrcBillid);
            }
        }
    }

    public static void queryBillNumber(String billType, List<Long> billIds, Map<Long, String> billIdAndNumberMap) {
        if (StringUtils.isBlank(billType) || billIds.isEmpty()) {
            return;
        }
        String billNumber = null;
        if ("ai_event".equals(billType)) {
            billNumber = "number";
        } else {
            MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billType);
            if (dataEntityType != null) {
                BillEntityType bnt = (BillEntityType)dataEntityType;
                billNumber = bnt.getBillNo();
            }
        }
        if (StringUtils.isBlank(billNumber)) {
            return;
        }
        List<List<Long>> splitbatch = DapBuildVoucherCommonUtil.splitbatch(billIds, 2000);
        for (List<Long> spIds : splitbatch) {
            DynamicObjectCollection dataCol = QueryServiceHelper.query((String)billType, (String)(billNumber + ",id"), (QFilter[])new QFilter("id", "in", spIds).toArray());
            for (DynamicObject data : dataCol) {
                billIdAndNumberMap.put(data.getLong("id"), data.getString(billNumber));
            }
        }
    }

    public static Map<String, List<Long>> queryBillIds(List<Long> voucherIds) {
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        if (voucherIds.isEmpty()) {
            return result;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select distinct fsrc_billid,fsrc_billtype from t_fah_evt_tracker where ", new Object[0]).appendIn("fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                String fsrcBilltype = row.getString("fsrc_billtype");
                Long fsrcBillid = row.getLong("fsrc_billid");
                result.computeIfAbsent(fsrcBilltype, v -> new ArrayList()).add(fsrcBillid);
            }
        }
        return result;
    }

    public static void queryEventData(List<Long> voucherIds, List<Long> eventIds, List<Long> xlaIds, List<Long> interfaceTableIds, List<Long> trackerId) {
        if (voucherIds.isEmpty()) {
            return;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fxla_header_id,fgl_header_id,fid from t_fah_evt_tracker where ", new Object[0]).appendIn("fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sql);){
            for (Row row : queryDataSet) {
                Long fxlaHeaderId = row.getLong("fxla_header_id");
                xlaIds.add(fxlaHeaderId);
                Long fglHeaderId = row.getLong("fgl_header_id");
                interfaceTableIds.add(fglHeaderId);
                Long id = row.getLong("fid");
                trackerId.add(id);
            }
        }
        if (xlaIds.isEmpty()) {
            return;
        }
        SqlBuilder sqlevent = new SqlBuilder();
        sqlevent.append("select fsrceventid from t_fah_ae_headers where ", new Object[0]).appendIn("fid", xlaIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.v2.fah.dao.FahVoucherDao", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlevent);){
            for (Row row : queryDataSet) {
                Long fsrceventid = row.getLong("fsrceventid");
                eventIds.add(fsrceventid);
            }
        }
    }

    public static void getVoucherInfo(String billType, List<Long> billIds, Map<Long, Set<Long>> vchIdAndBillIds, List<Long> hasReverseBills) {
        FahVoucherDao.getVoucherInfo(billType, billIds, vchIdAndBillIds, hasReverseBills, new ArrayList<Long>());
    }

    public static void getVoucherInfo(String billType, List<Long> billIds, Map<Long, Set<Long>> vchIdAndBillIds, List<Long> hasReverseBills, List<Long> not_pushVoucherId) {
        if (billIds.isEmpty()) {
            return;
        }
        HashSet<Long> voucherIds = new HashSet<Long>();
        SqlBuilder sqlbd = new SqlBuilder();
        String appenddata = "'" + billType + "'";
        sqlbd.append("select distinct fsrc_billid,fgl_header_id,freverseflag from t_fah_evt_tracker where fstatus = '4' and fsrc_billtype = ", new Object[0]).append(appenddata, new Object[0]).append(" and ", new Object[0]).appendIn("fsrc_billid", billIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlbd);){
            for (Row row : queryDataSet) {
                Long fsourcebillid = row.getLong("fsrc_billid");
                Long fvoucherid = row.getLong("fgl_header_id");
                voucherIds.add(fvoucherid);
                int freverseflag = row.getInteger("freverseflag");
                if (freverseflag == 0) continue;
                hasReverseBills.add(fsourcebillid);
            }
        }
        if (voucherIds.isEmpty()) {
            return;
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select distinct fsrc_billid,fgl_header_id from t_fah_evt_tracker where ", new Object[0]).appendIn("fgl_header_id", voucherIds.toArray());
        DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbd);
        Object iterator = null;
        try {
            for (Row row : queryDataSet) {
                Long fsourcebillid = row.getLong("fsrc_billid");
                Long fvoucherid = row.getLong("fgl_header_id");
                vchIdAndBillIds.computeIfAbsent(fvoucherid, v -> new HashSet()).add(fsourcebillid);
            }
        }
        catch (Throwable throwable) {
            iterator = throwable;
            throw throwable;
        }
        finally {
            if (queryDataSet != null) {
                if (iterator != null) {
                    try {
                        queryDataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)iterator).addSuppressed(throwable);
                    }
                } else {
                    queryDataSet.close();
                }
            }
        }
        not_pushVoucherId.addAll(voucherIds);
        SqlBuilder sbdn = new SqlBuilder();
        sbdn.append("select fid from t_gl_voucher where ", new Object[0]).appendIn("fid", voucherIds.toArray());
        try (DataSet queryDataSet2 = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbdn);){
            for (Row row : queryDataSet2) {
                not_pushVoucherId.remove(row.getLong("fid"));
            }
        }
    }

    public static void insertErrorInfo(List<Object[]> params) {
        if (params.isEmpty()) {
            return;
        }
        String sql = "insert into t_fah_task_fail_bills(fid, frequestid, fbilltype, fsrcbillid, fmsg, fmsg_code,  fsrcbillno) values (?,?,?,?,?,?,?)";
        try (TXHandle h = TX.requiresNew();){
            try {
                DB.executeBatch((DBRoute)DBRoute.of((String)"fi"), (String)sql, params);
            }
            catch (Exception e) {
                logger.error("--FAH---FahDeleteVoucherRequestTask:{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            }
        }
    }

    public static List<Long> queryCompleteBillIds(Map<String, List<Long>> missBillMap, String billType) {
        ArrayList<Long> result = new ArrayList<Long>();
        ArrayList<Long> voucherIds = new ArrayList<Long>();
        SqlBuilder sqlBuilder = new SqlBuilder();
        missBillMap.values().forEach(f -> result.addAll((Collection<Long>)f));
        sqlBuilder.append("select distinct fgl_header_id from t_fah_evt_tracker where fstatus = '4'", new Object[0]).appendIn(" and fsrc_billid", result.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sqlBuilder);){
            Iterator iterator = queryDataSet.iterator();
            while (iterator.hasNext()) {
                voucherIds.add(((Row)iterator.next()).getLong("fgl_header_id"));
            }
        }
        result.clear();
        if (voucherIds.isEmpty()) {
            return result;
        }
        SqlBuilder sbd = new SqlBuilder();
        sbd.append("select distinct fsrc_billid,fsrc_billtype from t_fah_evt_tracker where fstatus = '4'", new Object[0]).appendIn(" and fgl_header_id", voucherIds.toArray());
        try (DataSet queryDataSet = DB.queryDataSet((String)"kd.bos.ext.fi.ai.operation.DeleteVoucherValidator", (DBRoute)DBRoute.of((String)"fi"), (SqlBuilder)sbd);){
            for (Row row : queryDataSet) {
                String fsrcBilltype = row.getString("fsrc_billtype");
                Long fsrcBillid = row.getLong("fsrc_billid");
                if (!billType.equals(fsrcBilltype)) continue;
                result.add(fsrcBillid);
            }
        }
        return result;
    }

    public static List<Long> queryIfVoucherByRequestId(Long requestId) {
        LinkedList<Long> result = new LinkedList<Long>();
        String sql = "select fid from t_fah_voucher_if where fRequestId = " + requestId;
        try (DataSet dataSet = DB.queryDataSet((String)"FahVoucherDao.queryIfVoucherByRequestId", (DBRoute)DBRoute.of((String)"ai"), (String)sql);){
            while (dataSet.hasNext()) {
                result.add(dataSet.next().getLong("fid"));
            }
        }
        return result;
    }

    public static boolean existGLVoucher(boolean isAiEvent, String billType, Set<Long> selectedBillIds, Map<String, List<Long>> billTypeGroups) {
        ArrayList<QFilter> qFilters1 = new ArrayList<QFilter>(2);
        if (isAiEvent) {
            QFilter qFilter = QFilter.of((String)"1!=1", (Object[])new Object[0]);
            for (Map.Entry<String, List<Long>> billTypeEntry : billTypeGroups.entrySet()) {
                qFilter.or(new QFilter("sourcebillid", "in", billTypeEntry.getValue()).and("billType", "=", (Object)billTypeEntry.getKey()));
            }
            qFilters1.add(qFilter);
        } else {
            qFilters1.add(new QFilter("sourcebillid", "in", selectedBillIds));
            qFilters1.add(new QFilter("billtype", "=", (Object)billType));
        }
        if (QueryServiceHelper.exists((String)"ai_daptracker", (QFilter[])qFilters1.toArray(new QFilter[0]))) {
            return true;
        }
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fid from t_fah_evt_tracker where ", new Object[0]);
        if (isAiEvent) {
            int index = 1;
            sql.append("(", new Object[0]);
            for (Map.Entry<String, List<Long>> billTypeEntry : billTypeGroups.entrySet()) {
                sql.append("(fsrc_billtype = ?", new Object[]{billTypeEntry.getKey()});
                sql.appendIn("and fsrc_billid ", billTypeEntry.getValue().toArray());
                sql.append(")", new Object[0]);
                if (index < billTypeGroups.size()) {
                    sql.append(" or ", new Object[0]);
                }
                ++index;
            }
            sql.append(")", new Object[0]);
        } else {
            sql.append("fsrc_billtype = ?", new Object[]{billType});
            sql.appendIn("and fsrc_billid ", selectedBillIds.toArray());
        }
        sql.append("and fstatus != ?", new Object[]{"9"});
        DataSet dataSet = DB.queryDataSet((String)"existGLVoucher", (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sql);
        Object object = null;
        try {
            boolean bl = dataSet.hasNext();
            return bl;
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (dataSet != null) {
                if (object != null) {
                    try {
                        dataSet.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    dataSet.close();
                }
            }
        }
    }

    public static Set<Long> queryEvtTrackerInfo(boolean isAiEvent, String billType, Set<Long> selectedBillIds, Map<String, List<Long>> billTypeGroups) {
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fgl_header_id from t_fah_evt_tracker where ", new Object[0]);
        if (isAiEvent) {
            int index = 1;
            for (Map.Entry<String, List<Long>> billTypeEntry : billTypeGroups.entrySet()) {
                sql.append("(fsrc_billtype = ?", new Object[]{billTypeEntry.getKey()});
                sql.appendIn("and fsrc_billid ", billTypeEntry.getValue().toArray());
                sql.append(")", new Object[0]);
                if (index < billTypeGroups.size()) {
                    sql.append(" or ", new Object[0]);
                }
                ++index;
            }
        } else {
            sql.append("fsrc_billtype = ?", new Object[]{billType});
            sql.appendIn("and fsrc_billid ", selectedBillIds.toArray());
        }
        HashSet<Long> result = new HashSet<Long>(1);
        try (DataSet dataSet = DB.queryDataSet((String)"existGLVoucher", (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sql);){
            while (dataSet.hasNext()) {
                result.add(dataSet.next().getLong("fgl_header_id"));
            }
        }
        return result;
    }
}

