/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.operate;

import com.alibaba.fastjson.JSON;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillView;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.v2.fah.BuildXLAAndGLUtils;
import kd.bos.ext.fi.ai.v2.fah.EventGenTaskUtils;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.ext.fi.ai.v2.fah.FahRequestTaskDao;
import kd.bos.ext.fi.ai.v2.fah.SysParamConfig;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.instance.Instance;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.bos.util.ExceptionUtils;

public class BuildAcctJEAndPostToGL
extends DefaultEntityOperate
implements ICloseCallBack {
    private static final int max_batch = 100000;
    private static final String COLON = ":";
    private static final String CACHE_KEY_PREFIX = "BuildEventAndXLA";
    private static final Log logger = LogFactory.getLog(BuildAcctJEAndPostToGL.class);

    protected int getBatchSize() {
        return 100000;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        Set<Long> selectedBillIds = this.getSelectedBillIds(this.getView());
        LinkedList<String> extDataBillTypeNotHasDispatchRuleList = new LinkedList<String>();
        String realEntity = this.getEntityId();
        if ("ai_event".equals(this.getEntityId())) {
            String billType;
            if (selectedBillIds.isEmpty()) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\uff0c\u5916\u90e8\u6570\u636e\u4ec5\u652f\u6301\u5217\u8868\u9009\u62e9\u5355\u636e\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u5e76\u4f20\u603b\u8d26\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(selectedBillIds);
            if (billTypeGroups.containsKey("ai_event")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u65e7\u6a21\u578b\u5916\u90e8\u6570\u636e\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u5e76\u4f20\u603b\u8d26\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            if (billTypeGroups.size() > 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u591a\u9009\u6a21\u578b\u5916\u90e8\u6570\u636e\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u5e76\u4f20\u603b\u8d26\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]));
                return false;
            }
            LinkedList<String> notRegExtData = new LinkedList<String>();
            Iterator<String> iterator = billTypeGroups.keySet().iterator();
            while (iterator.hasNext()) {
                realEntity = billType = iterator.next();
                boolean hasReg = BuildXLAAndGLUtils.checkHasRegBill(billType);
                if (hasReg) continue;
                notRegExtData.add(billType);
            }
            if (!notRegExtData.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u5916\u90e8\u6570\u636e\u672a\u8fdb\u884c\u6ce8\u518c\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]), String.join((CharSequence)",", notRegExtData)));
                return false;
            }
            iterator = billTypeGroups.keySet().iterator();
            while (iterator.hasNext()) {
                realEntity = billType = iterator.next();
                boolean hasDispatchRule = BuildXLAAndGLUtils.checkHasDispatchRule(billType);
                if (hasDispatchRule) continue;
                extDataBillTypeNotHasDispatchRuleList.add(billType);
            }
            if (!extDataBillTypeNotHasDispatchRuleList.isEmpty()) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u6a21\u578b\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u5916\u90e8\u6570\u636e\u672a\u914d\u7f6e\u4e8b\u4ef6\u5206\u6d41\u89c4\u5219\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]), String.join((CharSequence)",", extDataBillTypeNotHasDispatchRuleList)));
                return false;
            }
        } else {
            boolean hasReg = BuildXLAAndGLUtils.checkHasRegBill(realEntity);
            if (!hasReg) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)realEntity);
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a%1$s[%2$s]\u672a\u8fdb\u884c\u6ce8\u518c\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), realEntity));
                return false;
            }
            boolean hasDispatchRule = BuildXLAAndGLUtils.checkHasDispatchRule(this.getEntityId());
            if (!hasDispatchRule) {
                MainEntityType dataEntityType = MetadataServiceHelper.getDataEntityType((String)this.getEntityId());
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b\uff1a%1$s[%2$s]\u672a\u914d\u7f6e\u4e8b\u4ef6\u5206\u6d41\u89c4\u5219\u3002", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]), dataEntityType.getDisplayName().getLocaleValue(), this.getEntityId()));
                return false;
            }
        }
        this.showParamPage(realEntity);
        return false;
    }

    private void showParamPage(String realEntity) {
        FormShowParameter parameters = new FormShowParameter();
        parameters.getOpenStyle().setShowType(ShowType.Modal);
        parameters.setFormId("fah_evt_create_param");
        parameters.setCustomParam("pageId", (Object)this.getView().getPageId());
        parameters.setCustomParam("operateKey", (Object)this.getOperateKey());
        parameters.setCustomParam("operateName", (Object)this.getOperateName().getLocaleValue());
        parameters.setCustomParam("entityId", (Object)realEntity);
        parameters.setCustomParam("isSelectNoData", (Object)"false");
        parameters.setCustomParam("hide_bill_range", (Object)"true");
        parameters.setCloseCallBack(new CloseCallBack(((Object)((Object)this)).getClass().getName(), "fah_evt_create_param"));
        this.getView().showForm(parameters);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        logger.info("buildEventData_BuildEventAndXLA,ActionId:{}, returnData: {}", (Object)closedCallBackEvent.getActionId(), returnData);
        switch (closedCallBackEvent.getActionId()) {
            case "fah_evt_create_param": {
                Collection<Object> orgPkSet;
                Set<Long> selectedBillIds;
                if (!(returnData instanceof Map)) break;
                Map returnDataMap = (Map)returnData;
                String pageId = (String)returnDataMap.get("pageId");
                IFormView view = SessionManager.getCurrent().getView(pageId);
                String entityId = (String)returnDataMap.get("entityId");
                boolean isSelectedBills = "1".equals(returnDataMap.get("radiogroup_bill"));
                Map<String, Tuple<String, String>> dateOrgFieldMap = EventGenTaskUtils.getDateOrgFiledByBillTypes(Collections.singleton(entityId));
                String dateField = (String)dateOrgFieldMap.get((Object)entityId).item1;
                String orgField = (String)dateOrgFieldMap.get((Object)entityId).item2;
                if (isSelectedBills) {
                    selectedBillIds = this.getSelectedBillIds(view);
                    orgPkSet = EventGenTaskUtils.getSelectedBillOrgPkSet(entityId, orgField, selectedBillIds);
                } else {
                    orgPkSet = JSON.parseArray((String)((String)returnDataMap.get("orgs")), Long.class);
                    Date startDate = new Date(Long.parseLong((String)returnDataMap.get("startDate")));
                    Date endDate = new Date(Long.parseLong((String)returnDataMap.get("endDate")));
                    LinkedList<QFilter> qFilters = new LinkedList<QFilter>();
                    qFilters.add(new QFilter(orgField, "in", (Object)orgPkSet));
                    qFilters.add(new QFilter(dateField, ">=", (Object)startDate));
                    qFilters.add(new QFilter(dateField, "<=", (Object)endDate));
                    qFilters.add(new QFilter("billstatus", "=", returnDataMap.get("billstatus")));
                    List pks = QueryServiceHelper.queryPrimaryKeys((String)entityId, (QFilter[])qFilters.toArray(new QFilter[0]), null, (int)1);
                    if (CollectionUtils.isEmpty((Collection)pks)) {
                        String msg = ResManager.loadKDString((String)"\u6839\u636e\u81ea\u5b9a\u4e49\u8303\u56f4\u6ca1\u6709\u67e5\u8be2\u5230\u6570\u636e", (String)"BuildEventAndXLA_11", (String)"bos-ext-fi", (Object[])new Object[0]);
                        view.showSuccessNotification(msg);
                        break;
                    }
                    selectedBillIds = Collections.singleton((Long)pks.get(0));
                }
                try {
                    this.dispatchAsync(returnDataMap, selectedBillIds, orgPkSet);
                    String msg = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4\u521b\u5efa\u4e8b\u4ef6\u53ca\u5b50\u5206\u7c7b\u8d26\u4efb\u52a1\uff0c\u8bf7\u7a0d\u540e\u67e5\u770b\u4e8b\u4ef6\u521b\u5efa\u8bb0\u5f55\u3002", (String)"BuildEventAndXLA_5", (String)"bos-ext-fi", (Object[])new Object[0]);
                    view.showSuccessNotification(msg);
                }
                catch (Exception e) {
                    logger.error("buildEventData_err, submit create event job failed,entityId:{}, ", (Object)entityId, (Object)e);
                    view.showErrorNotification(String.format(ResManager.loadKDString((String)"\u63d0\u4ea4\u521b\u5efa\u4e8b\u4ef6\u4efb\u52a1\u5931\u8d25\u3002\u8be6\u7ec6\u4fe1\u606f\uff1a%s", (String)"BuildEventAndXLA_6", (String)"bos-ext-fi", (Object[])new Object[0]), e.getMessage()));
                }
                break;
            }
        }
    }

    private void dispatchAsync(Map<String, String> returnDataMap, Collection<Long> selectedBillIds, Collection<Long> orgPkSet) {
        Collection<Long> billIds;
        Date endDate;
        Date startDate;
        String buildEventMode;
        boolean isSelectedBills = "1".equals(returnDataMap.get("radiogroup_bill"));
        boolean isCreateEvtFinal = "3".equals(returnDataMap.get("radiogroup_op"));
        String entityId = returnDataMap.get("entityId");
        String operateKey = returnDataMap.get("operateKey");
        String string = buildEventMode = isCreateEvtFinal ? "3" : "4";
        if (null == this.getOption()) {
            this.setOption(OperateOption.create());
        }
        OperateOption option = this.getOption();
        option.setVariableValue("buildeventmode", buildEventMode);
        Long taskId = DB.genLongId((String)"t_fah_request_task");
        int buildEvtBillBatchSize = Integer.parseInt(SysParamConfig.get("fah.evt.buildEvtBillBatchSize", "999"));
        if (isSelectedBills) {
            startDate = null;
            endDate = null;
            if (selectedBillIds.size() > buildEvtBillBatchSize) {
                DistributeSessionlessCache taskStatusCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("ai");
                String billIdsCacheKey = this.getBillIdsCacheKey(taskId);
                taskStatusCache.addList(billIdsCacheKey, this.transToStr(selectedBillIds));
                logger.info("buildEventData_taskStatusCache.cacheBillIds, billIdsCacheKey: {}, selectedBillIds.size: {}", (Object)billIdsCacheKey, (Object)selectedBillIds.size());
                billIds = Collections.singletonList(selectedBillIds.iterator().next());
            } else {
                billIds = selectedBillIds;
            }
        } else {
            startDate = new Date(Long.parseLong(returnDataMap.get("startDate")));
            endDate = new Date(Long.parseLong(returnDataMap.get("endDate")));
            option.setVariableValue("startdate", returnDataMap.get("startDate"));
            option.setVariableValue("enddate", returnDataMap.get("endDate"));
            billIds = selectedBillIds;
        }
        this.saveFahEventGenTask(taskId, entityId, orgPkSet, selectedBillIds, startDate, endDate, buildEventMode);
        option.setVariableValue("taskid", taskId.toString());
        option.setVariableValue("billtypes", JSON.toJSONString(Collections.singleton(entityId)));
        option.setVariableValue("orgs", JSON.toJSONString(orgPkSet));
        option.setVariableValue("iscustom", isSelectedBills ? "0" : "1");
        option.setVariableValue("idsusecache", isSelectedBills && selectedBillIds.size() > buildEvtBillBatchSize ? "1" : "0");
        try {
            ThreadPools.executeOnce((String)CACHE_KEY_PREFIX, () -> {
                try {
                    OperationResult operationResult = OperationServiceHelper.executeOperate((String)operateKey, (String)entityId, (Object[])billIds.toArray(), (OperateOption)option);
                    boolean success = operationResult.isSuccess();
                    if (!success) {
                        FahRequestTaskDao.updateFahRequestTask(taskId, operationResult.getMessage());
                    }
                }
                catch (Exception e) {
                    FahRequestTaskDao.updateFahRequestTask(taskId, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
                    throw e;
                }
            });
        }
        catch (Exception e) {
            logger.error("buildEventData_BuildEventAndXLA, submit async task failed, taskId:{}, ", (Object)taskId, (Object)e);
            FahRequestTaskDao.updateFahRequestTask(taskId, ExceptionUtils.getExceptionStackTraceMessage((Exception)e));
            throw e;
        }
    }

    private String[] transToStr(Collection<Long> selectedBillIds) {
        return (String[])selectedBillIds.stream().map(Object::toString).toArray(String[]::new);
    }

    private String getBillIdsCacheKey(Long taskId) {
        RequestContext requestContext = RequestContext.get();
        return Instance.getClusterName() + COLON + requestContext.getAccountId() + COLON + CACHE_KEY_PREFIX + COLON + taskId;
    }

    private Long saveFahEventGenTask(Long taskId, String billType, Collection<Long> orgPkSet, Collection<Long> billIds, Date startDate, Date endDate, String buildEventMode) {
        Throwable throwable = null;
        try (TXHandle h = TX.required();){
            FahRequestTaskDao.createNewRequest(taskId, Collections.singletonList(billType), orgPkSet, buildEventMode, billIds.size(), startDate, endDate);
            Long l = taskId;
            return l;
        }
        catch (Exception e) {
            try {
                h.markRollback();
                throw e;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    protected Set<Long> getSelectedBillIds(IFormView view) {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>();
        if (view instanceof IListView) {
            IListView listView = (IListView)view;
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                Long billId = (Long)row.getPrimaryKeyValue();
                billIds.add(billId);
            }
        } else if (view instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)view).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }

    public boolean needSelectData() {
        return false;
    }
}

