/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.operate;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.IBillView;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.datamodel.IBillModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ICloseCallBack;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.list.IListView;
import kd.bos.mvc.SessionManager;
import kd.bos.mvc.bill.BillView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;

public class PreviewAcctJE
extends DefaultEntityOperate
implements IConfirmCallBack,
ICloseCallBack {
    protected int getBatchSize() {
        return Integer.MAX_VALUE;
    }

    protected boolean beforeInvokeOperation(OperationResult result) {
        if (!super.beforeInvokeOperation(result)) {
            return false;
        }
        if (this.getView() instanceof IBillView) {
            String pkValue;
            IBillModel billModel = (IBillModel)this.getView().getModel();
            String string = pkValue = billModel.getPKValue() == null ? "" : billModel.getPKValue().toString();
            if (StringUtils.isBlank((CharSequence)pkValue) || pkValue.equals("0")) {
                this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58%1$s", (String)"PreviewAcctJE_0", (String)"bos-ext-fi", (Object[])new Object[0]), this.getView().getFormShowParameter().getCaption()));
                return false;
            }
        }
        this.getView().getPageCache().put("cacheName", this.getEntityId());
        return true;
    }

    public OperateOption getOption() {
        OperateOption option = super.getOption();
        option.setVariableValue("previewpageid", this.getView().getPageId());
        return option;
    }

    static String getString() {
        return ResManager.loadKDString((String)"\u5355\u636e\u5df2\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u3002", (String)"PreviewAcctJE_2", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    static String getShowInfo() {
        return ResManager.loadKDString((String)"\u5df2\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u3002", (String)"PreviewAcctJE_3", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    protected void afterInvokeOperation(OperationResult opResult) {
        super.afterInvokeOperation(opResult);
        this.doDisposeResult(this.getView(), opResult);
    }

    protected void afterOperationClose(OperationResult result) {
        List errors = result.getAllErrorInfo();
        List averrors = result.getAllErrorOrValidateInfo();
        if ((errors == null || errors.size() <= 0 || averrors == null || averrors.size() != 1) && result.isSuccess()) {
            this.showSuccessMessage();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        MessageBoxResult result = evt.getResult();
        String billType = SessionManager.getCurrent().getView(this.getView().getPageId()).getPageCache().get("cacheName");
        if (MessageBoxResult.Yes.equals((Object)result)) {
            long sourcebillId = 0L;
            if (this.getView() instanceof IListView) {
                IListView listView = (IListView)this.getView();
                ListSelectedRowCollection selectedRows = listView.getSelectedRows();
                if (!selectedRows.isEmpty()) {
                    sourcebillId = (Long)selectedRows.get(0).getPrimaryKeyValue();
                }
            } else if (this.getView() instanceof BillView) {
                sourcebillId = (Long)this.getView().getModel().getDataEntity().getPkValue();
            }
            if (sourcebillId != 0L) {
                Map<String, List<Long>> billTypeGroup;
                ArrayList<QFilter> filterList = new ArrayList<QFilter>();
                filterList.add(new QFilter("sourcebillid", "=", (Object)sourcebillId));
                if ("ai_event".equals(billType) && (billTypeGroup = ExtDataQueryHelper.groupByBillType(Collections.singleton(sourcebillId))).size() > 0) {
                    billType = billTypeGroup.keySet().iterator().next();
                }
                DapVoucherUtil.addBillTypeFilter(billType, filterList);
                DynamicObject daptrackers = QueryServiceHelper.queryOne((String)"ai_daptracker", (String)"voucherid", (QFilter[])filterList.toArray(new QFilter[0]));
                this.showVoucher(daptrackers);
            }
        }
    }

    private void showVoucher(DynamicObject daptrackers) {
        long billId = daptrackers.getLong("voucherid");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setPkId((Object)billId);
        showParameter.setFormId("gl_voucher");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        long orgId = 0L;
        try (DataSet ds = QueryServiceHelper.queryDataSet((String)"TraceVoucher_queryvoucher", (String)"gl_voucher", (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)billId)}, null);){
            for (Row row : ds) {
                orgId = row.getLong("org");
            }
        }
        String entity = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"BuildVoucherService", (String)"getVoucherEntity", (Object[])new Object[]{billId});
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int i = PermissionServiceHelper.checkPermission((long)userId, (String)"DIM_ORG", (long)orgId, (String)"83bfebc8000017ac", (String)entity, (String)"4715a0df000000ac");
        Boolean isbizvoucher = DapBuildVoucherCommonUtil.getEnableBizVoucherSystemParam(orgId);
        if (!(i != 1 || isbizvoucher.booleanValue() && "gl_voucher".equals(entity))) {
            showParameter.setStatus(OperationStatus.EDIT);
        } else {
            showParameter.setStatus(OperationStatus.VIEW);
        }
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    protected Set<Long> getSelectedBillIds() {
        IBillView billView;
        IBillModel billModel;
        HashSet<Long> billIds = new HashSet<Long>();
        if (this.getView() instanceof IListView) {
            IListView listView = (IListView)this.getView();
            for (ListSelectedRow row : listView.getSelectedRows()) {
                if (!(row.getPrimaryKeyValue() instanceof Long)) continue;
                Long billId = (Long)row.getPrimaryKeyValue();
                billIds.add(billId);
            }
        } else if (this.getView() instanceof IBillView && (billModel = (IBillModel)(billView = (IBillView)this.getView()).getModel()).getPKValue() instanceof Long) {
            Long billId = (Long)billModel.getPKValue();
            billIds.add(billId);
        }
        return billIds;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        String returnData;
        Map map;
        String key = evt.getActionId();
        if ("selecttmp".equals(key) && (map = (Map)SerializationUtils.fromJsonString((String)(returnData = evt.getReturnData() + ""), Map.class)) != null) {
            String pageid = (String)map.get("pageId");
            OperateOption create = OperateOption.create();
            create.setVariableValue("tempId", (String)map.get("souandtemp"));
            create.setVariableValue("previewpageid", pageid);
            Set ids = (Set)SerializationUtils.fromJsonString((String)((String)map.get("sourceid")), Set.class);
            String preKey = this.getPreVoucherKey((String)map.get("entityname"));
            OperationResult opResult = OperationServiceHelper.executeOperate((String)preKey, (String)((String)map.get("entityname")), (Object[])ids.toArray(), (OperateOption)create);
            this.doDisposeResult(SessionManager.getCurrent().getView(pageid), opResult);
        }
    }

    private void showPreVoucher(IFormView view) {
        IAppCache cache = AppCache.get((String)"gl");
        String string = (String)cache.get("accSys_" + view.getPageId() + "_perviewvoucher", String.class);
        String entityName = (String)cache.get("accSys_" + view.getPageId() + "_entityname", String.class);
        String billId = (String)cache.get("accSys_" + view.getPageId() + "_billid", String.class);
        String isevent = (String)cache.get("accSys_" + view.getPageId() + "_isevent", String.class);
        if (StringUtils.isNotBlank((CharSequence)string)) {
            String tempId = (String)cache.get("accSys_" + view.getPageId() + "_vchtemplateid", String.class);
            FormShowParameter form = new FormShowParameter();
            form.setFormId("fah_subledger");
            form.setCustomParam("voucher", (Object)string);
            form.setCustomParam("entityname", (Object)entityName);
            form.setCustomParam("isevent", (Object)isevent);
            form.setCustomParam("billId", (Object)billId);
            form.setCustomParam("tempId", (Object)tempId);
            form.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            form.setStatus(OperationStatus.VIEW);
            view.showForm(form);
        }
        cache.remove("accSys_" + view.getPageId() + "_perviewvoucher");
    }

    private String getPreVoucherKey(String entityname) {
        List opts = EntityMetadataCache.getDataEntityOperate((String)entityname);
        String genVoucherOptName = "previewvoucher";
        for (Map opt : opts) {
            String optKey = (String)opt.get("type");
            if (!optKey.equalsIgnoreCase("previewvoucher")) continue;
            genVoucherOptName = (String)opt.get("key");
        }
        return genVoucherOptName;
    }

    private void doDisposeResult(IFormView view, OperationResult opResult) {
        if (!opResult.isSuccess()) {
            String message = opResult.getMessage();
            if (PreviewAcctJE.getString().equals(message)) {
                this.setOption(OperateOption.create());
                this.setView(view);
                this.setOperateKey("previewvoucher");
                boolean isConfirm = "MessageCallBackType".equals(this.getParameter().get("sourceName"));
                if (!isConfirm) {
                    String messages = String.format(ResManager.loadKDString((String)"%1$s\u662f\u5426\u8054\u67e5\uff1f", (String)"PreviewAcctJE_4", (String)"bos-ext-fi", (Object[])new Object[0]), PreviewAcctJE.getShowInfo());
                    view.showConfirm(messages, MessageBoxOptions.OKCancel, new ConfirmCallBackListener("contentChange1", (AbstractOperate)this));
                }
                opResult.getAllErrorOrValidateInfo().clear();
                opResult.getAllErrorInfo().clear();
                return;
            }
            if (!opResult.getAllErrorOrValidateInfo().isEmpty()) {
                message = ((IOperateInfo)opResult.getAllErrorOrValidateInfo().get(0)).getMessage();
            }
            view.showTipNotification(message);
            opResult.setShowMessage(true);
            return;
        }
        this.showPreVoucher(view);
    }
}

