/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.ai.v2.fah.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.ext.fi.ai.v2.fah.ExtDataQueryHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.operation.BuildAcctJEAndGLOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;

public class BuildAcctJEAndPostToGLService
extends BuildAcctJEAndGLOperateService {
    private static final Log logger = LogFactory.getLog(BuildAcctJEAndPostToGLService.class);
    private Set<Long> billIds;

    @Override
    public OperationResult excute(Object[] ids) throws Exception {
        this.billIds = new HashSet<Long>(ids.length);
        for (Object id : ids) {
            this.billIds.add(Long.valueOf(id.toString()));
        }
        OperationResult sr = super.excute(ids);
        return sr;
    }

    protected void executeOperate(DynamicObject[] dynamicObjects) {
        OperationResult sr = this.getOperationResult();
        if (!sr.getAllErrorOrValidateInfo().isEmpty()) {
            this.billIds.removeAll(sr.getValidateResult().getErrorPkIds());
        }
        String paramStr = this.parseParams(this.operateMetaMap.get("parameter"), this.operationKey);
        logger.info("buildEventData_paramStr: {}", (Object)paramStr);
        OperationResult result = this.getOperationResult();
        List<String> errorList = this.dispatchBuildEvt(this.billIds, paramStr);
        HashSet<Long> allIds = new HashSet<Long>(this.billIds);
        result.setSuccessPkIds(new ArrayList<Long>(allIds));
    }

    private List<String> dispatchBuildEvt(Set<Long> ids, String paramStr) {
        LinkedList<String> errorList = new LinkedList<String>();
        if ("ai_event".equals(this.getOperationContext().getEntityTypeId())) {
            Map<String, List<Long>> billTypeGroups = ExtDataQueryHelper.groupByBillType(ids);
            for (Map.Entry<String, List<Long>> billTypeGroup : billTypeGroups.entrySet()) {
                String errorMsg = "ai_event".equals(billTypeGroup.getKey()) ? "" : this.buildEvt(billTypeGroup.getKey(), new HashSet<Long>((Collection)billTypeGroup.getValue()), paramStr);
                if (!StringUtils.isNotBlank((CharSequence)errorMsg)) continue;
                errorList.add(errorMsg);
            }
        } else {
            String errorMsg = this.buildEvt(this.getOperationContext().getEntityTypeId(), ids, paramStr);
            if (StringUtils.isNotBlank((CharSequence)errorMsg)) {
                errorList.add(errorMsg);
            }
        }
        logger.info("buildEventData_#####dispatchBuildEvt--error:" + errorList);
        return errorList;
    }

    private String buildEvt(String billType, Set<Long> ids, String paramStr) {
        String errorMsg = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"ai", (String)"IBuildXLAAndGLService", (String)"buildXLAAndGL", (Object[])new Object[]{billType, ids, paramStr});
        return errorMsg;
    }

    protected DynamicObject[] callOperation(DynamicObject[] objs) {
        DynamicObject[] sd = super.callOperation(objs);
        List succids = this.getOperationResult().getSuccessPkIds();
        DynamicObject[] rel = (DynamicObject[])Stream.of(sd).filter(d -> succids.contains(d.getPkValue())).toArray(DynamicObject[]::new);
        succids.removeAll(Stream.of(rel).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
        IDataEntityProperty billNoProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = "ai_event".equals(this.subEntityType.getName()) ? this.subEntityType.findProperty("number") : this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
        }
        List errors = this.getOperationResult().getAllErrorInfo();
        HashMap<Object, DynamicObject> dataMap = new HashMap<Object, DynamicObject>(sd.length);
        for (DynamicObject dd : sd) {
            dataMap.put(dd.getPkValue(), dd);
        }
        for (OperateErrorInfo error : errors) {
            String billNo;
            DynamicObject errorObj = (DynamicObject)dataMap.get(error.getPkValue());
            if (errorObj == null) continue;
            String string = billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)errorObj);
            if (billNo == null) {
                error.setMessage(String.format(ResManager.loadKDString((String)"\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u5e76\u4f20\u603b\u8d26\uff1a%s", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]), error.getMessage()));
                continue;
            }
            error.setMessage(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\u751f\u6210\u5b50\u5206\u7c7b\u8d26\u5e76\u4f20\u603b\u8d26\uff1a%2$s", (String)"", (String)"bos-ext-fi", (Object[])new Object[0]), billNo, error.getMessage()));
        }
        return rel;
    }

    private String parseParams(Object params, String opr) {
        String paramStr;
        Map<String, String> param = params != null ? ((paramStr = SerializationUtils.toJsonString((Object)params)) != null ? (Map)SerializationUtils.fromJsonString((String)paramStr, Map.class) : new HashMap()) : new HashMap<String, String>();
        param.put("operationKey", this.operationKey);
        if (opr != null) {
            param.put("opr", opr);
        }
        Map optionVarsMap = this.getOption().getVariables();
        param.put("option", (String)((Object)optionVarsMap));
        return SerializationUtils.toJsonString(param);
    }
}

