/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.bei.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.operate.printop.PrintTemplateMatcher;
import kd.bos.form.operate.printop.PrintTypes;
import kd.bos.form.plugin.print.ComplexSettingItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.bos.servicehelper.user.UserService;

public class PrintServiceCopy {
    private static final Log log = LogFactory.getLog(PrintServiceCopy.class);
    private static final String AUDIT = "C";
    private static final String FORMID_PRINTLOG = "bos_print_logs";
    private static final String FORMID_BILLTYPE = "bos_billtype";
    private static final String CFG_SUFFIX = "_printsetting";
    private Map<Long, DynamicObject> billTypeObjCache = new HashMap<Long, DynamicObject>();
    private Map<Object, Long> billidToBillTypeId = new HashMap<Object, Long>();
    private StringBuilder errorMsg = new StringBuilder();
    private Object dPrinter;
    private Map<String, Integer> templateStatusMap = new HashMap<String, Integer>(16);
    protected PrintTypes printTypes;
    private static final String PRINTERID = "printerid";
    private static final String TEMPLATEID = "templateid";
    private static final String BOS_FORM_BUSINESS = "bos-form-business";
    private static final String BASESETTING = "basesetting";
    private static final String COMPLEXSETTING = "complexsetting";
    private static final String TEMPLATE = "template";
    private static final String ENABLE = "enable";
    private static final String PRINTTPLIDID = "printtplid.id";
    private static final String BAS_MANAGEPRINTTPL = "bas_manageprinttpl";
    private Map<String, Object> printSetting = new HashMap<String, Object>(16);
    private String userId;
    private Object dTemplateId;
    private String formId;
    private String caption;

    public PrintServiceCopy(String formId, String userId) {
        this.formId = formId;
        this.userId = userId;
        this.caption = FormMetadataCache.getFormConfig((String)formId).getCaption().getLocaleValue();
        if (this.printSetting.isEmpty()) {
            String configKey = formId + CFG_SUFFIX;
            String settingData = UserConfigServiceHelper.getSetting((long)Long.parseLong(this.userId), (String)configKey);
            if (StringUtils.isNotBlank((CharSequence)settingData)) {
                this.printSetting = (Map)SerializationUtils.fromJsonString((String)settingData, Map.class);
            }
        }
    }

    public Object getDefaultTemplateId() {
        DynamicObject preferenceScheme;
        if (!this.printSetting.isEmpty()) {
            this.dTemplateId = this.printSetting.get(TEMPLATEID);
        }
        if (ObjectUtils.isEmpty((Object)this.dTemplateId) && (preferenceScheme = this.getEnableScheme()) != null) {
            this.dTemplateId = preferenceScheme.get("defaultprinter");
        }
        if (ObjectUtils.isEmpty((Object)this.dTemplateId)) {
            this.dTemplateId = this.getDefaulttplInManangeTool(this.formId);
        }
        return this.dTemplateId;
    }

    public Map<Object, List<Object>> getTemplateIdByPK(List<Object> pks) {
        Map<Object, List<Object>> myjobs;
        boolean isExistUserSetting = this.isExistUserSetting();
        if (isExistUserSetting) {
            myjobs = this.buildPrintJobsForPC(pks);
            if (myjobs.size() == 0) {
                this.getPCDefaultPrintJobs(myjobs, pks);
            }
        } else {
            DynamicObject scheme = this.getEnableScheme();
            myjobs = scheme != null ? this.buildJobsByScheme(pks, scheme) : this.buildJobsByDefault(pks);
        }
        return myjobs;
    }

    private boolean isExistUserSetting() {
        Object complexSetting;
        Object baseSetting;
        boolean isExistUserSetting;
        boolean bl = isExistUserSetting = this.printSetting.containsKey(TEMPLATEID) && StringUtils.isNotBlank((Object)this.printSetting.get(TEMPLATEID));
        if (!isExistUserSetting && this.printSetting.containsKey(BASESETTING) && !ObjectUtils.isEmpty((Object)(baseSetting = this.printSetting.get(BASESETTING)))) {
            isExistUserSetting = true;
        }
        if (!isExistUserSetting && this.printSetting.containsKey(COMPLEXSETTING) && !ObjectUtils.isEmpty((Object)(complexSetting = this.printSetting.get(COMPLEXSETTING)))) {
            isExistUserSetting = true;
        }
        return isExistUserSetting;
    }

    private Map<Object, List<Object>> buildPrintJobsForPC(List<Object> pkids) {
        boolean isContainBillType;
        Map<Object, List<Object>> pcJobs = new HashMap<Object, List<Object>>();
        Object complexSettingJson = this.printSetting.get(COMPLEXSETTING);
        Object baseSetting = this.printSetting.get(BASESETTING);
        boolean hasEnableComplexSetting = false;
        List objs = new ArrayList();
        if (!ObjectUtils.isEmpty((Object)complexSettingJson)) {
            objs = complexSettingJson instanceof String ? SerializationUtils.fromJsonStringToList((String)complexSettingJson.toString(), ComplexSettingItem.class) : SerializationUtils.fromJsonStringToList((String)SerializationUtils.toJsonString((Object)complexSettingJson), ComplexSettingItem.class);
            hasEnableComplexSetting = objs.stream().anyMatch(ComplexSettingItem::isEnable);
        }
        if (hasEnableComplexSetting) {
            List<ComplexSettingItem> availableFilterSetting = objs.stream().filter(p -> p.isEnable() && StringUtils.isNotBlank((CharSequence)p.getFiltertemplateid())).collect(Collectors.toList());
            if (!availableFilterSetting.isEmpty()) {
                pcJobs = this.getPrintJobByFilter(pkids = this.filterPKIds(pkids), availableFilterSetting, null);
                if (pcJobs.isEmpty() && this.errorMsg.length() == 0) {
                    Optional<ComplexSettingItem> other = objs.stream().filter(o -> o.getFiltertype() == 2).findFirst();
                    if (other.isPresent()) {
                        ComplexSettingItem item = other.get();
                        if (StringUtils.isBlank((CharSequence)item.getFiltertemplateid())) {
                            this.errorMsg.append(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c \u5e76\u4e14\u7c7b\u578b\u4e3a\u3010\u5176\u5b83\u3011\u7684\u6761\u4ef6\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\u3002\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u91cd\u65b0\u8bbe\u7f6e\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u3002", (String)"AbstractPrint_7", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        } else {
                            this.errorMsg.append(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5df2\u88ab\u8fc7\u6ee4\u3002\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u6253\u5370\u8bbe\u7f6e\u3002", (String)"AbstractPrint_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        }
                    } else {
                        this.errorMsg.append(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5df2\u88ab\u8fc7\u6ee4\u3002\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u6253\u5370\u8bbe\u7f6e\u3002", (String)"AbstractPrint_8", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                    }
                }
            } else {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5df2\u542f\u7528\u6253\u5370\u7684\u9ad8\u7ea7\u8bbe\u7f6e\uff0c\u4f46\u672a\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011-\u3010\u9ad8\u7ea7\u3011\u4e2d\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AbstractPrint_9", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
            return pcJobs;
        }
        if (!ObjectUtils.isEmpty((Object)baseSetting) && (isContainBillType = this.isContainBillType())) {
            List<Object> printenablePKIds = this.filterPKIds(pkids);
            if (this.errorMsg.length() != 0) {
                return pcJobs;
            }
            if (!printenablePKIds.isEmpty()) {
                pcJobs = this.getPrintJobByBillType(printenablePKIds);
            }
            if (!pcJobs.isEmpty()) {
                return pcJobs;
            }
        }
        this.getPCDefaultPrintJobs(pcJobs, pkids);
        return pcJobs;
    }

    private Map<Object, List<Object>> getPrintJobByFilter(List<Object> pkids, List<ComplexSettingItem> objs, Map<String, Object> wfParams) {
        ComplexSettingItem item;
        HashMap<Object, List<Object>> fJobs = new HashMap<Object, List<Object>>(16);
        String entityTypeId = this.formId;
        MainEntityType dt = EntityMetadataCache.getDataEntityType((String)entityTypeId);
        for (ComplexSettingItem item2 : objs) {
            if (!StringUtils.isNotBlank((Object)item2.getFiltercondition()) || item2.getFiltertype() != 1) continue;
            int result = 1;
            if (this.templateStatusMap.containsKey(item2.getFiltertemplateid())) {
                result = this.templateStatusMap.get(item2.getFiltertemplateid());
            } else {
                result = this.getTtplInManangeToolisenable(item2.getFiltertemplateid());
                this.templateStatusMap.put(item2.getFiltertemplateid(), result);
            }
            if (0 == result) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                continue;
            }
            if (2 == result) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                continue;
            }
            FilterCondition filterCondition = null;
            filterCondition = item2.getFiltercondition() instanceof String ? (FilterCondition)SerializationUtils.fromJsonString((String)item2.getFiltercondition().toString(), FilterCondition.class) : (FilterCondition)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)item2.getFiltercondition()), FilterCondition.class);
            FilterBuilder filterBuilder = new FilterBuilder(dt, filterCondition, true);
            filterBuilder.setUserService((IUserService)new UserService());
            filterBuilder.buildFilter(true);
            String pkName = dt.getPrimaryKey().getName();
            QFilter[] filters = new QFilter[]{filterBuilder.getQFilter(), new QFilter(pkName, "in", pkids)};
            Map filterObjs = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (QFilter[])filters);
            if (filterObjs.size() <= 0) continue;
            ArrayList pkIds = new ArrayList(filterObjs.keySet());
            fJobs.put(item2.getFiltertemplateid(), pkIds);
        }
        Optional<ComplexSettingItem> other = objs.stream().filter(o -> o.getFiltertype() == 2).findFirst();
        if (other.isPresent() && StringUtils.isNotBlank((CharSequence)(item = other.get()).getFiltertemplateid())) {
            int result = 1;
            if (this.templateStatusMap.containsKey(item.getFiltertemplateid())) {
                result = this.templateStatusMap.get(item.getFiltertemplateid());
            } else {
                result = this.getTtplInManangeToolisenable(item.getFiltertemplateid());
                this.templateStatusMap.put(item.getFiltertemplateid(), result);
            }
            if (0 == result) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_12", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else if (2 == result) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6761\u4ef6\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_13", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                ArrayList<Object> otherMatchIds = new ArrayList<Object>();
                for (Object id : pkids) {
                    boolean isMatch = fJobs.values().stream().anyMatch(p -> p.contains(id));
                    if (isMatch) continue;
                    otherMatchIds.add(id);
                }
                if (!otherMatchIds.isEmpty()) {
                    fJobs.put(item.getFiltertemplateid(), otherMatchIds);
                }
            }
        }
        return fJobs;
    }

    private Map<Object, List<Object>> getPrintJobByBillType(List<Object> pkids) {
        PrintTemplateMatcher printTemplateMatcher = new PrintTemplateMatcher(this.printSetting, this.billTypeObjCache, this.billidToBillTypeId, true);
        HashMap<Object, List<Object>> tplBillIdMap = new HashMap<Object, List<Object>>(16);
        for (Object pkid : pkids) {
            Object templateId = printTemplateMatcher.getTemplateBySetting(pkid);
            if (StringUtils.isBlank((Object)templateId)) {
                templateId = printTemplateMatcher.getTemplateByDefault(pkid);
            }
            if (StringUtils.isBlank((Object)templateId)) {
                templateId = this.getDefaultTemplateId();
            }
            if (!StringUtils.isNotBlank((Object)templateId)) continue;
            int result = 1;
            if (this.templateStatusMap.containsKey(templateId)) {
                result = this.templateStatusMap.get(templateId);
            } else {
                result = this.getTtplInManangeToolisenable((String)templateId);
                this.templateStatusMap.put((String)templateId, result);
            }
            if (0 == result) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                continue;
            }
            if (2 == result) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_15", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                continue;
            }
            if (tplBillIdMap.containsKey(templateId)) {
                ((List)tplBillIdMap.get(templateId)).add(pkid);
                continue;
            }
            ArrayList<Object> pks = new ArrayList<Object>();
            pks.add(pkid);
            tplBillIdMap.put(templateId, pks);
        }
        return tplBillIdMap;
    }

    private boolean isContainBillType() {
        BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)this.formId);
        return StringUtils.isNotBlank((CharSequence)billDT.getBillType());
    }

    private List<Object> filterPKIds(List<Object> pkids) {
        ArrayList<Object> printEnableIds = new ArrayList();
        String entityTypeId = this.formId;
        BillEntityType billDT = (BillEntityType)EntityMetadataCache.getDataEntityType((String)entityTypeId);
        String billTypeFieldKey = billDT.getBillType();
        String billStatusFieldKey = billDT.getBillStatus();
        String billNOKey = billDT.getBillNo();
        if (StringUtils.isNotBlank((CharSequence)billStatusFieldKey) && StringUtils.isNotBlank((CharSequence)billTypeFieldKey)) {
            QFilter[] qFilters = new QFilter[]{new QFilter("id", "in", pkids)};
            StringBuilder sb = new StringBuilder();
            sb.append("id").append(",");
            sb.append(billStatusFieldKey).append(", ");
            if (StringUtils.isNotBlank((CharSequence)billNOKey)) {
                sb.append(billNOKey).append(", ");
            }
            sb.append(billTypeFieldKey);
            Map cacheDatas = BusinessDataServiceHelper.loadFromCache((String)entityTypeId, (String)sb.toString(), (QFilter[])qFilters);
            for (Map.Entry cacheData : cacheDatas.entrySet()) {
                boolean isCanPt;
                Object pkId = cacheData.getKey();
                DynamicObject obj = (DynamicObject)cacheData.getValue();
                Object statusObj = obj.get(billStatusFieldKey);
                DynamicObject billTypeObj = (DynamicObject)obj.get(billTypeFieldKey);
                if (!StringUtils.isNotBlank((Object)statusObj) || ObjectUtils.isEmpty((Object)billTypeObj)) continue;
                Long billTypeId = (Long)billTypeObj.getPkValue();
                String billNO = "";
                if (StringUtils.isNotBlank((CharSequence)billNOKey)) {
                    billNO = obj.get(billNOKey).toString();
                }
                if (!(isCanPt = this.isBillPrintenable(billTypeId, statusObj.toString(), pkId, billNO)) || printEnableIds.contains(pkId)) continue;
                printEnableIds.add(pkId);
            }
        } else {
            printEnableIds = pkids;
        }
        return printEnableIds;
    }

    private boolean isBillPrintenable(Long billTypeId, String billStatus, Object pkId, String billNo) {
        String selectProperties = "id, printafteraudit, controlprintcount, maxprintcount";
        DynamicObject billTypeObj = BusinessDataServiceHelper.loadSingleFromCache((Object)billTypeId, (String)FORMID_BILLTYPE, (String)selectProperties);
        if (billTypeObj == null) {
            log.error("\u5355\u636e\u7c7b\u578b\u4e0d\u5b58\u5728\uff01 \u4e3b\u952e\uff1a" + billTypeId + " \u5bf9\u5e94\u7684\u5355\u636e\u7c7b\u578b\u5bf9\u8c61\u4e0d\u5b58\u5728");
            return true;
        }
        this.billTypeObjCache.put(billTypeId, billTypeObj);
        this.billidToBillTypeId.put(pkId, billTypeId);
        if (StringUtils.isBlank((CharSequence)billStatus)) {
            return true;
        }
        boolean printAfterAudit = billTypeObj.getBoolean("printafteraudit");
        boolean controlPrintCount = billTypeObj.getBoolean("controlprintcount");
        int maxPrintCount = billTypeObj.getInt("maxprintcount");
        if (printAfterAudit && !AUDIT.equals(billStatus)) {
            String auditErrMsg = this.errorMsg.toString().contains(ResManager.loadKDString((String)"\u672a\u5ba1\u6838", (String)"PrintServiceCopy_0", (String)"tmc-bei-business", (Object[])new Object[0])) ? this.errorMsg.toString().replace(ResManager.loadKDString((String)"\u548c", (String)"PrintServiceCopy_1", (String)"tmc-bei-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u3001", (String)"PrintServiceCopy_2", (String)"tmc-bei-business", (Object[])new Object[0])).replace(ResManager.loadKDString((String)"\u672a\u5ba1\u6838\u3002", (String)"PrintServiceCopy_3", (String)"tmc-bei-business", (Object[])new Object[0]), ResManager.loadKDString((String)"\u548c\"%1$s\"\u672a\u5ba1\u6838\u3002", (String)"PrintServiceCopy_6", (String)"tmc-bei-business", (Object[])new Object[]{billNo})) : String.format(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b:%2$s\u4e2d\u8bbe\u7f6e\u4e86\u3010\u5ba1\u6838\u540e\u6253\u5370\u3011\uff0c\u800c\u5355\u636e\uff1a\"%3$s\"\u672a\u5ba1\u6838\u3002", (String)"AbstractPrint_18", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]), billTypeObj.getLocaleString("name").getLocaleValue(), billNo);
            this.errorMsg.delete(0, this.errorMsg.length()).append(auditErrMsg);
            return false;
        }
        if (controlPrintCount && maxPrintCount <= this.currentPrintCount(pkId)) {
            this.errorMsg.append(ResManager.loadKDString((String)"\u5355\u636e\u7c7b\u578b:", (String)"AbstractPrint_17", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])).append(billTypeObj.getLocaleString("name").getLocaleValue()).append(ResManager.loadKDString((String)" \u4e2d\u8bbe\u7f6e\u4e86\u3010\u6700\u5927\u6253\u5370\u6b21\u6570\u3011", (String)"AbstractPrint_20", (String)BOS_FORM_BUSINESS, (Object[])new Object[0])).append(maxPrintCount).append(ResManager.loadKDString((String)" \u6b21\uff0c\u5f53\u524d\u5355\u636e\u5df2\u5230\u8fbe\u6700\u5927\u6253\u5370\u6b21\u6570", (String)"AbstractPrint_21", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private int currentPrintCount(Object pkid) {
        QFilter[] qFilters = new QFilter[]{new QFilter("bizobjid", "=", (Object)pkid.toString())};
        DynamicObjectCollection printCount = QueryServiceHelper.query((String)FORMID_PRINTLOG, (String)"id", (QFilter[])qFilters);
        return printCount != null ? printCount.size() : 0;
    }

    private String getDefaulttplInManangeTool(String formId) {
        String tplId = "";
        QFilter[] qFilters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("isdefault", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)PRINTTPLIDID, (QFilter[])qFilters);
        if (defaultObj != null) {
            tplId = (String)defaultObj.get(PRINTTPLIDID);
        }
        return tplId;
    }

    private int getTtplInManangeToolisenable(String tplId) {
        int result = 0;
        QFilter[] qFilters = new QFilter[]{new QFilter(PRINTTPLIDID, "=", (Object)tplId)};
        DynamicObject defaultObj = QueryServiceHelper.queryOne((String)BAS_MANAGEPRINTTPL, (String)ENABLE, (QFilter[])qFilters);
        if (defaultObj != null) {
            String enable = (String)defaultObj.get(ENABLE);
            result = enable.equals("1") || enable.equals("") ? 1 : 2;
        }
        return result;
    }

    private boolean isExistTplInManangeTool(Object tplId) {
        QFilter[] qFilters = new QFilter[]{new QFilter("printtplid", "=", tplId)};
        boolean isExist = QueryServiceHelper.exists((String)BAS_MANAGEPRINTTPL, (QFilter[])qFilters);
        return isExist;
    }

    private DynamicObject getEnableScheme() {
        DynamicObject scheme = null;
        String formId = this.formId;
        QFilter[] filters = new QFilter[]{new QFilter("billformid", "=", (Object)formId), new QFilter("ispreference", "=", (Object)Boolean.TRUE), new QFilter(ENABLE, "=", (Object)Boolean.TRUE)};
        Map schemes = BusinessDataServiceHelper.loadFromCache((String)"bos_printingscheme", (QFilter[])filters);
        if (!schemes.isEmpty()) {
            Optional firstScheme = schemes.values().stream().findFirst();
            scheme = (DynamicObject)firstScheme.get();
        }
        return scheme;
    }

    private Map<Object, List<Object>> buildJobsByScheme(List<Object> pkids, DynamicObject preferenceScheme) {
        Map<Object, List<Object>> jobs = new HashMap<Object, List<Object>>();
        Object printer = preferenceScheme.get("defaultprinter");
        Object template = preferenceScheme.get("defaulttemplate");
        HashMap<String, Object> wfParams = new HashMap<String, Object>();
        wfParams.put("approveline", preferenceScheme.get("approveline"));
        DynamicObjectCollection complexSetting = preferenceScheme.getDynamicObjectCollection(COMPLEXSETTING);
        if (complexSetting.isEmpty()) {
            if (ObjectUtils.isEmpty((Object)template)) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5df2\u914d\u7f6e\u6253\u5370\u65b9\u6848\uff0c\u4f46\u672a\u8bbe\u7f6e\u6253\u5370\u6a21\u677f\uff0c\u8bf7\u91cd\u65b0\u8bbe\u7f6e\u3002", (String)"AbstractPrint_22", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                jobs.put(template, pkids);
            }
        } else {
            boolean isExistEnableFilter = false;
            ArrayList<ComplexSettingItem> filters = new ArrayList<ComplexSettingItem>();
            for (DynamicObject o : complexSetting) {
                String filterTemplateid = o.getString("filtertemplateid");
                boolean isEnable = o.getBoolean("ischecked");
                if (isEnable && !isExistEnableFilter) {
                    isExistEnableFilter = true;
                }
                if (!isEnable || !StringUtils.isNotBlank((CharSequence)filterTemplateid)) continue;
                ComplexSettingItem item = new ComplexSettingItem();
                item.setEnable(true);
                item.setFiltercondition((Object)o.getString("filtercondition"));
                item.setFiltername(o.getString("filtername"));
                item.setFiltertemplateid(o.getString("filtertemplateid"));
                item.setFiltertype(o.getInt("filtertype"));
                filters.add(item);
            }
            if (!filters.isEmpty()) {
                jobs = this.getPrintJobByFilter(pkids, filters, wfParams);
                if (jobs.isEmpty() && this.errorMsg.length() == 0) {
                    this.errorMsg.append(ResManager.loadKDString((String)"\u6240\u9009\u5355\u636e\u4e0d\u7b26\u5408\u8fc7\u6ee4\u6761\u4ef6\uff0c\u5df2\u88ab\u8fc7\u6ee4\u3002\u8bf7\u68c0\u67e5\u5355\u636e\u6216\u6253\u5370\u65b9\u6848\u3002", (String)"AbstractPrint_23", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                }
            } else if (isExistEnableFilter) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u6253\u5370\u65b9\u6848\u4e2d\u5b58\u5728\u5df2\u542f\u7528\u4f46\u672a\u8bbe\u7f6e\u6a21\u677f\u7684\u8fc7\u6ee4\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u5e76\u8fdb\u884c\u8bbe\u7f6e\u3002", (String)"AbstractPrint_24", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            } else {
                jobs.put(template, pkids);
            }
        }
        return jobs;
    }

    private Map<Object, List<Object>> buildJobsByDefault(List<Object> pkids) {
        HashMap<Object, List<Object>> mjobs = new HashMap<Object, List<Object>>(16);
        if (this.isContainBillType()) {
            List<Object> printenablePKIds = this.filterPKIds(pkids);
            if (!printenablePKIds.isEmpty()) {
                PrintTemplateMatcher printTemplateMatcher = new PrintTemplateMatcher(null, this.billTypeObjCache, this.billidToBillTypeId, true);
                HashMap tplBillIdMap = new HashMap(16);
                for (int i = 0; i < printenablePKIds.size(); ++i) {
                    Object pkid = printenablePKIds.get(i);
                    String templateId = printTemplateMatcher.getTemplateByDefault(pkid);
                    if (!StringUtils.isNotBlank((CharSequence)templateId)) continue;
                    int result = 1;
                    if (this.templateStatusMap.containsKey(templateId)) {
                        result = this.templateStatusMap.get(templateId);
                    } else {
                        result = this.getTtplInManangeToolisenable(templateId);
                        this.templateStatusMap.put(templateId, result);
                    }
                    if (0 == result) {
                        this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_14", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        continue;
                    }
                    if (2 == result) {
                        this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u5355\u636e\u7c7b\u578b\u8bbe\u7f6e\u7684\u6253\u5370\u6a21\u677f\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_15", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                        continue;
                    }
                    if (tplBillIdMap.containsKey(templateId)) {
                        ((List)tplBillIdMap.get(templateId)).add(pkid);
                        continue;
                    }
                    ArrayList<Object> pks = new ArrayList<Object>();
                    pks.add(pkid);
                    tplBillIdMap.put(templateId, pks);
                }
                mjobs = tplBillIdMap;
            } else {
                return mjobs;
            }
        }
        if (mjobs.isEmpty()) {
            String tplId = this.getDefaulttplInManangeTool(this.formId);
            mjobs.put(tplId, pkids);
        }
        return mjobs;
    }

    private void getPCDefaultPrintJobs(Map<Object, List<Object>> pcJobs, List<Object> pkids) {
        Object defaultTemplateId = this.printSetting.get(TEMPLATEID);
        Object defaultTemplate = this.printSetting.get(TEMPLATE);
        Object selectTpl = this.printSetting.get("selecttpl");
        if (StringUtils.isBlank((Object)defaultTemplateId)) {
            if (StringUtils.isBlank((Object)defaultTemplate)) {
                defaultTemplate = selectTpl;
            }
            if (StringUtils.isNotBlank((Object)defaultTemplate)) {
                defaultTemplateId = MetadataDao.getIdByNumber((String)defaultTemplate.toString(), (MetaCategory)MetaCategory.Form);
            }
        }
        if (StringUtils.isNotBlank((Object)defaultTemplateId)) {
            int result = this.getTtplInManangeToolisenable((String)defaultTemplateId);
            if (result == 1) {
                List<Object> printenablePKIds = this.filterPKIds(pkids);
                pcJobs.put(defaultTemplateId, printenablePKIds);
            } else if (result == 0) {
                if (this.errorMsg.length() == 0) {
                    this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_10", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
                }
            } else if (this.errorMsg.length() == 0) {
                this.errorMsg.append(ResManager.loadKDString((String)"\u5f53\u524d\u6a21\u677f\u5df2\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u8bf7\u5230\u3010\u6253\u5370\u8bbe\u7f6e\u3011\u91cd\u65b0\u9009\u62e9\u6a21\u677f", (String)"AbstractPrint_11", (String)BOS_FORM_BUSINESS, (Object[])new Object[0]));
            }
        }
    }
}

