/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.convert;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.AfterCreateTargetEventArgs;
import kd.bos.ext.fi.botp.helper.BaseDataHelper;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.ext.fi.botp.helper.OrgHelper;
import kd.bos.ext.fi.botp.helper.QuotationHelper;
import kd.bos.ext.fi.botp.helper.SystemStatusCtrolHelper;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import org.apache.commons.lang3.tuple.Pair;

public class RecBilllConvertPlugin
extends AbstractConvertPlugIn {
    public void afterCreateTarget(AfterCreateTargetEventArgs e) {
        List extendedDataEntities;
        if (e.getTargetExtDataEntitySet() != null && e.getTargetExtDataEntitySet().getExtDataEntityMap() != null && e.getTargetExtDataEntitySet().getExtDataEntityMap().containsKey("cas_recbill") && (extendedDataEntities = (List)e.getTargetExtDataEntitySet().getExtDataEntityMap().get("cas_recbill")) != null) {
            extendedDataEntities.forEach(extendedDataEntity -> {
                DynamicObject targetBill = extendedDataEntity.getDataEntity();
                if (targetBill.containsProperty("exchangerate")) {
                    targetBill.set("exchangerate", null);
                }
            });
        }
        super.afterCreateTarget(e);
    }

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntity[] billDataEntitys;
        super.afterConvert(e);
        String targetEntityNumber = this.getTgtMainType().getName();
        for (ExtendedDataEntity billDataEntity : billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(targetEntityNumber)) {
            DynamicObject targetBill = billDataEntity.getDataEntity();
            DynamicObject org = targetBill.getDynamicObject("org");
            if (org != null) {
                DynamicObject baseCurrency;
                long orgId = org.getLong("id");
                DynamicObject currency = targetBill.getDynamicObject("currency");
                if (currency != null && CasHelper.isNotEmpty(currency = BusinessDataServiceHelper.loadSingleFromCache((Object)currency.getPkValue(), (String)"bd_currency"))) {
                    targetBill.set("currency", (Object)currency);
                }
                if ((baseCurrency = OrgHelper.getBaseCurrency(orgId)) != null) {
                    targetBill.set("basecurrency", (Object)baseCurrency);
                }
                this.setValueIfAbsent(targetBill, "exratetable", SystemStatusCtrolHelper.getExrateTable(orgId));
                this.setValueIfAbsent(targetBill, "exratedate", DateUtils.getCurrentDate());
                BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
                if (CasHelper.isEmpty(exchangeRate)) {
                    exchangeRate = BigDecimal.ONE;
                    String quotation = "0";
                    if (currency != null && baseCurrency != null) {
                        long destCurrencyId;
                        boolean isCurrencyDifferent;
                        long srcCurrencyId = currency.getLong("id");
                        boolean bl = isCurrencyDifferent = srcCurrencyId != (destCurrencyId = baseCurrency.getLong("id"));
                        if (isCurrencyDifferent) {
                            Date exrateDate = targetBill.getDate("exratedate");
                            DynamicObject exrateTable = targetBill.getDynamicObject("exratetable");
                            if (CasHelper.isNotEmpty(exrateTable)) {
                                Pair<String, BigDecimal> exchangeRateByTable = BaseDataHelper.getExchangeRateByTable(srcCurrencyId, destCurrencyId, orgId, exrateDate, exrateTable.getLong("id"));
                                exchangeRate = (BigDecimal)exchangeRateByTable.getRight();
                                quotation = (String)exchangeRateByTable.getLeft();
                            }
                        }
                    }
                    targetBill.set("exchangerate", (Object)exchangeRate);
                    targetBill.set("quotation", (Object)quotation);
                } else {
                    this.setValueIfAbsent(targetBill, "quotation", "0");
                }
                DynamicObject accountBank = targetBill.getDynamicObject("accountbank");
                if (accountBank != null) {
                    targetBill.set("payeebank", (Object)accountBank.getDynamicObject("bank"));
                    this.setValueIfAbsent(targetBill, "openorg", accountBank.getDynamicObject("openorg"));
                }
            }
            this.calculateAmt(targetBill);
            this.setSettleOrg(targetBill);
            this.setPayerNumber(targetBill);
            DynamicObject receivingtype = targetBill.getDynamicObject("receivingtype");
            if (receivingtype == null) continue;
            receivingtype = BusinessDataServiceHelper.loadSingleFromCache((Object)receivingtype.getPkValue(), (String)"cas_receivingbilltype", (String)"id,fundflowitem");
            this.fillFundflowItem(targetBill, receivingtype.getDynamicObject("fundflowitem"));
        }
    }

    private void setSettleOrg(DynamicObject targetBill) {
        DynamicObject receivingtype = targetBill.getDynamicObject("receivingtype");
        Object org = null;
        if (receivingtype != null && receivingtype.getBoolean("ispartreceivable")) {
            DynamicObject recOrg = targetBill.getDynamicObject("org");
            if ((recOrg = BusinessDataServiceHelper.loadSingle((Object)recOrg.getPkValue(), (String)recOrg.getDynamicObjectType().getName(), (String)"fisaccounting")).getBoolean("fisaccounting")) {
                org = recOrg;
            } else {
                DynamicObject recAccount = targetBill.getDynamicObject("accountbank");
                if (recAccount != null) {
                    org = recAccount.get("openorg");
                }
            }
        } else {
            org = targetBill.get("openorg");
        }
        for (DynamicObject entry : targetBill.getDynamicObjectCollection("entry")) {
            if (org == null || entry.getDynamicObject("e_settleorg") != null) continue;
            entry.set("e_settleorg", org);
        }
    }

    private void calculateAmt(DynamicObject targetBill) {
        DynamicObject basecurrency = targetBill.getDynamicObject("basecurrency");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        BigDecimal exchangeRate = targetBill.getBigDecimal("exchangerate");
        String quotation = targetBill.getString("quotation");
        if (exchangeRate == null) {
            return;
        }
        int round = 10;
        if (basecurrency != null) {
            round = basecurrency.getInt("amtprecision");
        }
        BigDecimal sumAmt = BigDecimal.ZERO;
        BigDecimal sumLocalAmt = BigDecimal.ZERO;
        for (DynamicObject entry : targetBill.getDynamicObjectCollection("entry")) {
            BigDecimal receivableAmt = entry.getBigDecimal("e_receivableamt");
            BigDecimal receivableLocAmt = entry.getBigDecimal("e_receivablelocamt");
            if (receivableAmt != null && CasHelper.isEmpty(receivableLocAmt)) {
                BigDecimal recLocAmt = QuotationHelper.callToCurrency(receivableAmt, exchangeRate, quotation, round);
                entry.set("e_receivablelocamt", (Object)recLocAmt);
            }
            BigDecimal discountAmt = entry.getBigDecimal("e_discountamt");
            BigDecimal discountLocAmt = entry.getBigDecimal("e_discountlocamt");
            if (discountAmt != null && CasHelper.isEmpty(discountLocAmt)) {
                BigDecimal disLocAmt = QuotationHelper.callToCurrency(discountAmt, exchangeRate, quotation, round);
                entry.set("e_discountlocamt", (Object)disLocAmt);
            }
            BigDecimal actAmt = entry.getBigDecimal("e_actamt");
            if (receivableAmt != null && discountAmt != null && CasHelper.isEmpty(actAmt)) {
                actAmt = currency != null ? receivableAmt.subtract(discountAmt).subtract(entry.getBigDecimal("e_fee")).setScale(currency.getInt("amtprecision"), 4) : receivableAmt.subtract(discountAmt).subtract(entry.getBigDecimal("e_fee"));
                entry.set("e_actamt", (Object)actAmt);
            }
            actAmt = entry.getBigDecimal("e_actamt");
            sumAmt = sumAmt.add(actAmt);
            BigDecimal actLocalAmt = entry.getBigDecimal("e_localamt");
            if (CasHelper.isNotEmpty(actAmt) && CasHelper.isEmpty(actLocalAmt)) {
                BigDecimal actLocAmt = QuotationHelper.callToCurrency(actAmt, exchangeRate, quotation, round);
                entry.set("e_localamt", (Object)actLocAmt);
            }
            actLocalAmt = CasHelper.isEmpty(actLocalAmt = entry.getBigDecimal("e_localamt")) ? BigDecimal.ZERO : actLocalAmt;
            sumLocalAmt = sumLocalAmt.add(actLocalAmt);
        }
        targetBill.set("actrecamt", (Object)sumAmt);
        BigDecimal localamt = targetBill.getBigDecimal("localamt");
        if (CasHelper.isEmpty(localamt)) {
            targetBill.set("localamt", (Object)sumLocalAmt);
        }
    }

    public void setValueIfAbsent(DynamicObject targetBill, String key, Object value) {
        if (CasHelper.isEmpty(targetBill.get(key))) {
            targetBill.set(key, value);
        }
    }

    private void setPayerNumber(DynamicObject targetBill) {
        DynamicObject[] baseBills;
        Long payer;
        String payertype = targetBill.getString("payertype");
        if (CasHelper.isNotEmpty(payertype) && !"other".equals(payertype) && CasHelper.isNotEmpty(payer = Long.valueOf(targetBill.getLong("payer"))) && CasHelper.isNotEmpty(baseBills = BusinessDataServiceHelper.load((String)payertype, (String)"id,number", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)payer)}))) {
            targetBill.set("payernumber", baseBills[0].get("number"));
        }
    }

    private void fillFundflowItem(DynamicObject targetBill, DynamicObject defaultFundsItem) {
        if (defaultFundsItem == null) {
            return;
        }
        DynamicObjectCollection entry = targetBill.getDynamicObjectCollection("entry");
        if (entry == null || entry.size() <= 0) {
            return;
        }
        for (DynamicObject row : entry) {
            this.setValueIfAbsent(row, "e_fundflowitem", defaultFundsItem);
        }
    }
}

