/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.botp.helper;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.ext.fi.botp.enums.AsstActTypeEnum;
import kd.bos.ext.fi.botp.enums.SourceBillTypeEnum;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

public class CasPayeeOrPayerHelper {
    public static Map<String, Object> getPayeeOrPayerInfo(Object payeeBankNum, Object payeeOrPayer, Object payeeOrPayerType, String billName) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        String addressPropName = "";
        if (CasPayeeOrPayerHelper.isSupplier(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        } else if (CasPayeeOrPayerHelper.isCustomer(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        }
        Object bankaccount = null;
        DynamicObject payeebank = null;
        String accountname = null;
        if (!CasHelper.isEmpty(entityNameTemp) && !CasHelper.isEmpty(payeeOrPayer)) {
            DynamicObjectCollection addressls;
            DynamicObjectCollection entry_banks;
            DynamicObject supplierCustDO = BusinessDataServiceHelper.loadSingle((Object)payeeOrPayer, (String)entityNameTemp, (String)("number,entry_bank.isdefault_bank,entry_bank.bankaccount,entry_bank.bank,entry_bank.accountname,entry_address." + addressPropName));
            if (!CasHelper.isEmpty(supplierCustDO) && !CasHelper.isEmpty((Collection)(entry_banks = supplierCustDO.getDynamicObjectCollection("entry_bank")))) {
                for (int i = 0; i < entry_banks.size(); ++i) {
                    Boolean isBank = false;
                    DynamicObject entry_bank = (DynamicObject)entry_banks.get(i);
                    if (CasHelper.isNotEmpty(payeeBankNum)) {
                        if (payeeBankNum.equals(entry_bank.get("bankaccount"))) {
                            isBank = true;
                        }
                    } else if (i == 0 || ((DynamicObject)entry_banks.get(i)).getBoolean("isdefault_bank")) {
                        isBank = true;
                    }
                    if (!isBank.booleanValue()) continue;
                    bankaccount = entry_bank.get("bankaccount");
                    payeebank = entry_bank.getDynamicObject("bank");
                    accountname = entry_bank.getLocaleString("accountname").getLocaleValue();
                }
            }
            String payeenumber = supplierCustDO.getString("number");
            String payeename = supplierCustDO.getString("name");
            resultMap.put("payeenumber", payeenumber);
            resultMap.put("payeename", payeename);
            if (!CasHelper.isEmpty(bankaccount)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("payeebanknum", bankaccount);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("payeracctbanknum", bankaccount);
                }
            }
            if (!CasHelper.isEmpty(payeebank)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("payeebank", payeebank);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("f7_payerbank", payeebank);
                }
            }
            if (!CasHelper.isEmpty(accountname)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("accountname", accountname);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("accountname", accountname);
                }
            } else {
                accountname = supplierCustDO.getLocaleString("name").getLocaleValue();
                resultMap.put("accountname", accountname);
            }
            if ((addressls = supplierCustDO.getDynamicObjectCollection("entry_address")) != null && addressls.size() > 0) {
                HashSet<Object> addressIds = new HashSet<Object>();
                for (DynamicObject a : addressls) {
                    addressIds.add(a.get(addressPropName + "_id"));
                }
                DynamicObject[] addresses = BusinessDataServiceHelper.load((String)"bd_address", (String)"default,detailaddress,addemail", (QFilter[])new QFilter[]{new QFilter("id", "in", addressIds)});
                if (addresses != null) {
                    for (DynamicObject address : addresses) {
                        if (!address.getBoolean("default")) continue;
                        resultMap.put("payeeemail", address.getString("addemail"));
                        resultMap.put("payeeaddress", address.getString("detailaddress"));
                        break;
                    }
                }
            }
        }
        return resultMap;
    }

    @SdkDeprecated
    public static Map<String, Object> getPayeeOrPayerInfo(Object payeeBankNum, Object payeeOrPayer, Object payeeOrPayerType, String billName, DynamicObject dynamicObject, Map<Long, DynamicObject> addressDynamicObject) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        String addressPropName = "";
        if (CasPayeeOrPayerHelper.isSupplier(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.SUPPLIER.getValue();
            addressPropName = "supplieraddress";
        } else if (CasPayeeOrPayerHelper.isCustomer(payeeOrPayerType)) {
            entityNameTemp = AsstActTypeEnum.CUSTOMER.getValue();
            addressPropName = "customeraddress";
        }
        Object bankaccount = null;
        DynamicObject payeebank = null;
        String accountname = null;
        if (!CasHelper.isEmpty(entityNameTemp) && !CasHelper.isEmpty(payeeOrPayer)) {
            DynamicObjectCollection addressls;
            DynamicObjectCollection entry_banks;
            DynamicObject supplierCustDO = dynamicObject;
            if (!CasHelper.isEmpty(supplierCustDO) && !CasHelper.isEmpty((Collection)(entry_banks = supplierCustDO.getDynamicObjectCollection("entry_bank")))) {
                for (int i = 0; i < entry_banks.size(); ++i) {
                    Boolean isBank = false;
                    DynamicObject entry_bank = (DynamicObject)entry_banks.get(i);
                    if (CasHelper.isNotEmpty(payeeBankNum) && payeeBankNum.equals(entry_bank.get("bankaccount"))) {
                        isBank = true;
                    }
                    if (!isBank.booleanValue()) continue;
                    bankaccount = entry_bank.get("bankaccount");
                    payeebank = entry_bank.getDynamicObject("bank");
                    accountname = entry_bank.getLocaleString("accountname").getLocaleValue();
                    break;
                }
            }
            String payeenumber = supplierCustDO.getString("number");
            String payeename = supplierCustDO.getString("name");
            resultMap.put("payeenumber", payeenumber);
            resultMap.put("payeename", payeename);
            if (!CasHelper.isEmpty(bankaccount)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("payeebanknum", bankaccount);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("payeracctbanknum", bankaccount);
                }
            }
            if (!CasHelper.isEmpty(payeebank)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("payeebank", payeebank);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("f7_payerbank", payeebank);
                }
            }
            if (!CasHelper.isEmpty(accountname)) {
                if (SourceBillTypeEnum.PAYBILL.getValue().equals(billName)) {
                    resultMap.put("accountname", accountname);
                }
                if (SourceBillTypeEnum.RECBILL.getValue().equals(billName)) {
                    resultMap.put("accountname", accountname);
                }
            } else {
                accountname = supplierCustDO.getLocaleString("name").getLocaleValue();
                resultMap.put("accountname", accountname);
            }
            if ((addressls = supplierCustDO.getDynamicObjectCollection("entry_address")) != null && addressls.size() > 0) {
                DynamicObject a;
                DynamicObject address = null;
                Iterator iterator = addressls.iterator();
                while (iterator.hasNext() && (address = addressDynamicObject.get((a = (DynamicObject)iterator.next()).get(addressPropName + "_id"))) == null) {
                }
                if (null != address && address.getBoolean("default")) {
                    resultMap.put("payeeemail", address.getString("addemail"));
                    resultMap.put("payeeaddress", address.getString("detailaddress"));
                }
            }
        }
        return resultMap;
    }

    @SdkDeprecated
    public static Map<String, Object> getUserOrOrgNumber(Object id, Object type) {
        DynamicObject userOrgDO;
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        String entityNameTemp = "";
        if (CasPayeeOrPayerHelper.isUser(type)) {
            entityNameTemp = AsstActTypeEnum.EMPLOYEE.getValue();
        }
        if (CasPayeeOrPayerHelper.isOrg(type)) {
            entityNameTemp = AsstActTypeEnum.COMPANY.getValue();
        }
        if (!(CasHelper.isEmpty(entityNameTemp) || CasHelper.isEmpty(id) || CasHelper.isEmpty(userOrgDO = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityNameTemp, (String)"number")))) {
            String payeenumber = userOrgDO.getString("number");
            resultMap.put("payeenumber", payeenumber);
        }
        return resultMap;
    }

    @SdkDeprecated
    public static boolean isSupplier(Object payeeType) {
        return CasPayeeOrPayerHelper.isAimType(AsstActTypeEnum.SUPPLIER, payeeType);
    }

    @SdkDeprecated
    public static boolean isCustomer(Object payeeType) {
        return CasPayeeOrPayerHelper.isAimType(AsstActTypeEnum.CUSTOMER, payeeType);
    }

    public static boolean isUser(Object payeeType) {
        return CasPayeeOrPayerHelper.isAimType(AsstActTypeEnum.EMPLOYEE, payeeType);
    }

    public static boolean isOrg(Object payeeType) {
        return CasPayeeOrPayerHelper.isAimType(AsstActTypeEnum.COMPANY, payeeType);
    }

    public static boolean isAimType(AsstActTypeEnum asstactType, Object payeeType) {
        return asstactType.getValue().equals(payeeType);
    }
}

