/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.function;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.LinkEntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.entity.function.BOSUDFunction;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class GetBizBillFieldValue
implements BOSUDFunction {
    private ExpressionContext expContext;

    public GetBizBillFieldValue() {
    }

    public GetBizBillFieldValue(ExpressionContext expContext) {
        this.expContext = expContext;
    }

    public BOSUDFunction getInstance(ExpressionContext expContext) {
        return new GetBizBillFieldValue(expContext);
    }

    public Object call(Object ... arg) {
        String entityobject = (String)arg[0];
        Object bizbillentryid = arg[1];
        String billfield = (String)arg[2];
        MainEntityType bizEntityType = EntityMetadataCache.getDataEntityType((String)entityobject);
        if (bizEntityType == null) {
            return null;
        }
        String entryKey = this.getEntryKey(bizEntityType);
        String selectField = this.getSelectField(bizEntityType, billfield);
        if (StringUtils.isEmpty((String)selectField)) {
            return null;
        }
        if (StringUtils.isNotEmpty((String)entryKey) && StringUtils.isNotEmpty((String)selectField)) {
            QFilter qFilter = new QFilter(entryKey + ".id", "=", bizbillentryid);
            try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)entityobject, (String)selectField, (QFilter[])qFilter.toArray(), null);){
                if (dataSet.hasNext()) {
                    Row row = dataSet.next();
                    Object object = row.get(selectField);
                    return object;
                }
            }
        }
        return null;
    }

    private String getSelectField(MainEntityType bizEntityType, String billfield) {
        if (StringUtils.isEmpty((String)billfield)) {
            return null;
        }
        IDataEntityProperty dataEntity = bizEntityType.findProperty(billfield.split("\\.")[0]);
        if (dataEntity != null && dataEntity.getParent() instanceof EntryType) {
            return dataEntity.getParent().getName() + "." + billfield;
        }
        if (dataEntity != null) {
            return billfield;
        }
        return null;
    }

    public String getName() {
        return "GetBizBillFieldValue";
    }

    private String getEntryKey(MainEntityType bizEntityType) {
        for (Map.Entry entryItem : bizEntityType.getAllEntities().entrySet()) {
            EntityType entityType = (EntityType)entryItem.getValue();
            if (!(entityType instanceof EntryType) || entityType instanceof LinkEntryType || entityType instanceof SubEntryType) continue;
            return entityType.getName();
        }
        return null;
    }
}

