/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.plugin;

import java.util.EventObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;

public class CalFunAccountPropPlugin
extends AbstractFuncParamPlugIn {
    public void afterCreateNewData(EventObject e) {
    }

    public String getSetting() {
        String costAccount = (String)this.getModel().getValue("costaccount");
        String setting = String.format("%s(%s)", this.getFuncId(), costAccount);
        return setting;
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String costAccount = (String)this.getModel().getValue("costaccount");
        if (StringUtils.isEmpty((CharSequence)costAccount)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u201c\u6210\u672c\u8d26\u7c3f\u201d\u3002", (String)"CalFunAccountPropPlugin_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"costaccount"});
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        this.doClick(source.getKey());
    }

    private void doClick(String key) {
        if ("costaccount".equals(key)) {
            MainEntityType mainType = this.getBillEntityType();
            if (mainType == null) {
                return;
            }
            PropTreeBuildOption option = new PropTreeBuildOption();
            new FormTreeBuilder();
            TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            this.showSelectFieldForm(tree, "costaccount");
        }
    }

    private MainEntityType getBillEntityType() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return null;
        }
        Object entityNumber = parentView.getFormShowParameter().getCustomParam("entitynumber");
        if (entityNumber == null) {
            return null;
        }
        return EntityMetadataCache.getDataEntityType((String)entityNumber.toString());
    }

    private void showSelectFieldForm(TreeNode srcBillNode, String sourceCtrlKey) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        String nodesJson = SerializationUtils.toJsonString((Object)srcBillNode);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String sourceFldKey = closedCallBackEvent.getActionId();
        Object returnData = closedCallBackEvent.getReturnData();
        if ("costaccount".equals(sourceFldKey) && returnData != null) {
            this.getModel().setValue("costaccount", returnData);
        }
    }
}

