/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.cal.plugin;

import java.util.ArrayList;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.treebuilder.FormTreeBuilder;
import kd.bos.metadata.treebuilder.PropTreeBuildOption;
import kd.bos.servicehelper.MetadataServiceHelper;

public class GetInventoryCategoryByMaterialPlugin
extends AbstractFuncParamPlugIn {
    private static final String MATERIAL = "material";
    private static final String ORG = "org";
    private static final String ORG1 = "org1";
    private static final String ORG2 = "org2";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{MATERIAL});
    }

    public void afterCreateNewData(EventObject e) {
        this.fillBox(ORG);
        this.fillBox(ORG1);
        this.fillBox(ORG2);
    }

    private void fillBox(String orgkey) {
        MainEntityType srcMainET = MetadataServiceHelper.getDataEntityType((String)this.getEntityNumber());
        if (srcMainET == null) {
            return;
        }
        ComboEdit fieldEditor = (ComboEdit)this.getView().getControl(orgkey);
        HashSet<String> entityIds = new HashSet<String>();
        entityIds.add("bos_org");
        entityIds.add("bos_adminorg");
        entityIds.add("bos_costcenter");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        Map allEntities = srcMainET.getAllEntities();
        for (EntityType entityType : allEntities.values()) {
            DataEntityPropertyCollection properties = entityType.getProperties();
            for (IDataEntityProperty property : properties) {
                ComboItem item;
                BasedataProp prop;
                if (!(property instanceof BasedataProp) || !entityIds.contains((prop = (BasedataProp)property).getBaseEntityId())) continue;
                IDataEntityType parent = prop.getParent();
                if (parent == null) {
                    item = new ComboItem(prop.getDisplayName(), prop.getName());
                    items.add(item);
                    continue;
                }
                item = new ComboItem(new LocaleString(parent.getDisplayName() + "." + prop.getDisplayName()), prop.getName());
                items.add(item);
            }
        }
        fieldEditor.setComboItems(items);
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)MATERIAL)) {
            MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)this.getEntityNumber());
            PropTreeBuildOption option = new PropTreeBuildOption();
            new FormTreeBuilder();
            TreeNode tree = FormTreeBuilder.buildDynamicPropertyTree((MainEntityType)mainType, (PropTreeBuildOption)option);
            FormShowParameter showParameter = new FormShowParameter();
            showParameter.setFormId("botp_selectfield");
            String nodesJson = SerializationUtils.toJsonString((Object)tree);
            showParameter.getCustomParams().put("treenodes", nodesJson);
            showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, MATERIAL));
            showParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm(showParameter);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)MATERIAL)) {
            this.getModel().setValue(MATERIAL, closedCallBackEvent.getReturnData());
        }
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String material = (String)this.getModel().getValue(MATERIAL);
        if (StringUtils.isBlank((CharSequence)material)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u7269\u6599\u3002", (String)"GetInventoryCategoryByMaterialPlugin_0", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        String org = (String)this.getModel().getValue(ORG);
        if (StringUtils.isBlank((CharSequence)org)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"GetInventoryCategoryByMaterialPlugin_1", (String)"fi-ai-common", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public String getSetting() {
        String material = (String)this.getModel().getValue(MATERIAL);
        String org = (String)this.getModel().getValue(ORG);
        String org1 = (String)this.getModel().getValue(ORG1);
        String org2 = (String)this.getModel().getValue(ORG2);
        String setting = String.format("%s(%s, %s, %s, %s)", this.getFuncId(), material, org, org1, org2);
        return setting;
    }
}

