/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.eb;

import java.util.ArrayList;
import java.util.EventObject;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.CustomEventArgs;
import kd.bos.form.plugin.FormViewPluginProxy;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.workflow.design.plugin.AbstractWorkflowPlugin;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgs;
import kd.bos.workflow.taskcenter.plugin.validate.BeforeSubmitCustomEventArgsClosedCallBack;

public class ApprovalPagePlugin
extends AbstractWorkflowPlugin {
    private static final Log log = LogFactory.getLog(ApprovalPagePlugin.class);
    private static final String EPM_CALLBACK_CACHE = "epm_callback_cache";
    private static final String EPM_CALLBACK_ID = "epm_callback_id";

    public void initialize() {
        super.initialize();
        if (this.isApproveBill()) {
            this.getPageCache().put("isNewApprovePage", "true");
        }
    }

    public void afterCreateNewData(EventObject e) {
        if (this.isApproveBill()) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{"flexpanelap6"});
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("closeApproveBill".equals(actionId)) {
            this.getView().close();
        } else if (EPM_CALLBACK_ID.equals(actionId)) {
            Object returnData = closedCallBackEvent.getReturnData();
            if (returnData == null) {
                return;
            }
            BeforeSubmitCustomEventArgsClosedCallBack args = new BeforeSubmitCustomEventArgsClosedCallBack((Object)this.getView(), null, null, null);
            args.setDoSubmitTask(true);
            this.getPageCache().put(EPM_CALLBACK_CACHE, String.valueOf(true));
            FormViewPluginProxy proxy = (FormViewPluginProxy)this.getView().getService(FormViewPluginProxy.class);
            proxy.fireCustomEvent((CustomEventArgs)args);
        }
    }

    private boolean isApproveBill() {
        String entityNumber = this.getPageCache().get("entitynumber");
        if (StringUtils.isEmpty((CharSequence)entityNumber)) {
            entityNumber = (String)this.getView().getFormShowParameter().getCustomParams().get("entityNumber");
        }
        return "eb_approvebill".equals(entityNumber);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        IFormView parentView;
        super.beforeClosed(e);
        if (this.isApproveBill() && (parentView = this.getView().getParentView()) != null) {
            parentView.setVisible(Boolean.TRUE, new String[]{"flexpanelap1"});
            this.getView().sendFormAction(parentView);
        }
    }

    public void customEvent(CustomEventArgs e) {
        if (e == null) {
            return;
        }
        if (!this.isApproveBill()) {
            return;
        }
        if (e instanceof BeforeSubmitCustomEventArgs) {
            String result = this.getPageCache().get(EPM_CALLBACK_CACHE);
            if (result != null && Boolean.parseBoolean(result)) {
                return;
            }
            BeforeSubmitCustomEventArgs args = (BeforeSubmitCustomEventArgs)e;
            args.setCancel(true);
            DynamicObject approveBill = BusinessDataServiceHelper.loadSingleFromCache((Object)this.getApproveBillId(), (String)"eb_approvebill");
            DynamicObjectCollection coll = approveBill.getDynamicObjectCollection("entryentity");
            ArrayList<String> errorMsgList = new ArrayList<String>(16);
            for (int i = 0; i < coll.size(); ++i) {
                DynamicObject entry = (DynamicObject)coll.get(i);
                String reportNumber = entry.getString("tempid.number");
                String reportName = entry.getString("tempid.name");
                errorMsgList.add(reportNumber + " " + reportName);
            }
            FormShowParameter parameters = new FormShowParameter();
            parameters.getOpenStyle().setShowType(ShowType.Modal);
            parameters.setFormId("eb_confirm");
            parameters.setShowTitle(false);
            String context = ResManager.loadKDString((String)"\u672c\u6b21\u64cd\u4f5c\u4f1a\u5ba1\u6838\u4ee5\u4e0b\u62a5\u8868\uff1a", (String)"ApprovalPagePlugin_3", (String)"bos-ext-fi", (Object[])new Object[0]);
            parameters.setCustomParam("title", (Object)context);
            parameters.setCustomParam("hasMore", (Object)(errorMsgList.size() > 1000 ? 1 : 0));
            parameters.setCustomParam("errorMsg", errorMsgList);
            parameters.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EPM_CALLBACK_ID));
            this.getView().showForm(parameters);
        }
    }

    private Long getApproveBillId() {
        String businessKey = this.getView().getPageCache().get("EPM_APPROVEBILL_KEY");
        if (StringUtils.isEmpty((CharSequence)businessKey)) {
            return 0L;
        }
        return Long.parseLong(businessKey);
    }
}

