/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.fcm;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.data.BusinessDataWriter;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityTypeUtil;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterField;
import kd.bos.entity.property.BasedataProp;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.ExecuteStatus;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.ext.fi.fcm.mservice.CheckItemQueryParam;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.thread.TaskType;
import kd.bos.ext.fi.thread.ThreadService;
import kd.bos.ext.fi.util.DateUtils;
import kd.bos.license.api.LicenseCheckResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.bos.trace.TraceSpan;
import kd.bos.trace.Tracer;
import kd.bos.trace.core.InnerFactory;
import kd.bos.util.JSONUtils;
import kd.sdk.annotation.SdkDeprecated;

public class ClosePeriodCheckExecutor {
    private static final Log LOG = LogFactory.getLog(ClosePeriodCheckExecutor.class);
    public static final String EXECUTOR_MSERVICE_CALLBACK_SERVICE = "CheckItemExecuteCallBackService";
    public static final String EXECUTOR_MSERVICE_CALLBACK_METHOD = "executeCheckItems";
    private static final String CHECK_ITEM_PROVIDER_APP = "fcm";
    private static final String APP_GL = "gl";
    private static final String CHECK_ITEM_SERVICE_NAME = "CheckItemMService";
    private static final String CURR_APP = "bos-ext-fi";
    private static final String CHECK_METHOD_STANDARD = "1";
    private static final String CHECK_METHOD_PLUGIN = "2";
    private static final Integer INT_FALSE = 0;
    private static final String PROP_ID = "id";
    private static final String ENTITY_NAME_APP = "bos_devportal_bizapp";
    private static final String FORM_ID_PERIOD = "bd_period";
    private static final String PERIOD_P_START_DATE = "begindate";
    private static final String PERIOD_P_END_DATE = "enddate";
    private static final List<String> AVAILABLE_CHECK_METHODS = Arrays.asList("1", "2");
    private static final String RES_KEY_MISSING_PARAMETER = "ClosePeriodCheckExecutorOp_1";
    private static final Map<String, WeakReference<Class<?>>> PLUGIN_CACHE = new HashMap();
    private static final String MULTIPLE_PERIOD_GL_BALANCE = "gl_balance";
    private static Function<String, ErrorCode> MISS_PARAM_ERR_GEN = paraName -> new ErrorCode(RES_KEY_MISSING_PARAMETER, ResManager.loadKDString((String)"\u53c2\u6570\u201c%1$s\u201d\u672a\u8fdb\u884c\u521d\u59cb\u8bbe\u7f6e\uff0c\u4e0d\u80fd\u6267\u884c\u201c\u7ed3\u8d26\u68c0\u67e5\u201d\u3002", (String)RES_KEY_MISSING_PARAMETER, (String)CURR_APP, (Object[])new Object[]{paraName}));
    public static ClosePeriodCheckExecutor instance = new ClosePeriodCheckExecutor();

    private ClosePeriodCheckExecutor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CheckExecutionResult execute(CheckItemExecutionParam executionParam) {
        LOG.info(String.format("executing close period check with %s", executionParam));
        if (kd.bos.util.StringUtils.isEmpty((String)executionParam.getBizAppId())) {
            throw new KDBizException(MISS_PARAM_ERR_GEN.apply("bizAppCode"), new Object[0]);
        }
        if (Objects.isNull(executionParam.getOrgId())) {
            throw new KDBizException(MISS_PARAM_ERR_GEN.apply("orgId"), new Object[0]);
        }
        if (Objects.isNull(executionParam.getPeriodStartDate()) || Objects.isNull(executionParam.getPeriodEndDate())) {
            if (Objects.isNull(executionParam.getPeriodId())) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u201cperiodId\u201d\u6216\u8005\u201cperiodStartDate/periodEndDate\u201d\u5fc5\u987b\u6307\u5b9a\u4e00\u9879\u3002", (String)"ClosePeriodCheckExecutorOp_14", (String)CURR_APP, (Object[])new Object[0]));
            }
            DynamicObject periodRecord = BusinessDataServiceHelper.loadSingle((Object)executionParam.getPeriodId(), (String)FORM_ID_PERIOD);
            executionParam.setPeriodStartDate(DateUtils.getDataFormat(periodRecord.getDate(PERIOD_P_START_DATE), true));
            executionParam.setPeriodEndDate(DateUtils.getDataFormat(periodRecord.getDate(PERIOD_P_END_DATE), false));
        }
        List<CheckItemDetail> checkItemDetails = null;
        checkItemDetails = CollectionUtils.isEmpty(executionParam.getCheckItemIds()) ? ClosePeriodCheckExecutor.queryCheckItemList(executionParam.getBizAppId(), executionParam.getSubBizAppCode(), executionParam.getOrgId(), true) : this.queryCheckItemByIds(executionParam.getCheckItemIds());
        if (CollectionUtils.isEmpty(checkItemDetails)) {
            return new CheckExecutionResult(Collections.EMPTY_LIST);
        }
        if (checkItemDetails.stream().anyMatch(x -> !AVAILABLE_CHECK_METHODS.contains(x.getMethod()))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65e0\u6cd5\u8bc6\u522b\u7684\u671f\u672b\u201c\u68c0\u67e5\u9879\u201d\u7c7b\u578b\u3002", (String)"ClosePeriodCheckExecutorOp_5", (String)CURR_APP, (Object[])new Object[0]));
        }
        if (checkItemDetails.stream().anyMatch(item -> !item.getIsSysPreset()) && !this.checkLisenceIsRight()) {
            String selfDefinedItemNameJoin = checkItemDetails.stream().filter(item -> !item.getIsSysPreset()).map(CheckItemDetail::getName).collect(Collectors.joining(ResManager.loadKDString((String)"\uff0c", (String)"ClosePeriodCheckExecutorOp_20", (String)"fi-bd-common", (Object[])new Object[0])));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u672a\u7981\u7528\u7684\u81ea\u5b9a\u4e49\u68c0\u67e5\u9879\uff0c\u8bf7\u8d2d\u4e70\u7ed3\u8d26\u76d1\u63a7\u7279\u6027\u8bb8\u53ef\uff0c\u6216\u7981\u7528\u4ee5\u4e0b\u68c0\u67e5\u9879\uff1a%s", (String)"ClosePeriodCheckExecutorOp_21", (String)"fi-bd-common", (Object[])new Object[0]), selfDefinedItemNameJoin));
        }
        try (TraceSpan span = Tracer.create((String)"executeCheckItem", (String)String.format("bizAppId: %s, subBizAppCode: %s, orgId: %s, periodId: %s, startDate: %s, endDate: %s", executionParam.getBizAppId(), executionParam.getSubBizAppCode(), executionParam.getOrgId(), executionParam.getPeriodId(), executionParam.getPeriodStartDate(), executionParam.getPeriodEndDate()));){
            HashMap taskFutureMap = new HashMap(checkItemDetails.size());
            for (CheckItemDetail checkItemDetail : checkItemDetails) {
                CheckContext checkContext = new CheckContext(executionParam.getOrgId(), executionParam.getBizAppId(), executionParam.getSubBizAppCode(), executionParam.getPeriodId(), executionParam.getPeriodStartDate(), executionParam.getPeriodEndDate());
                checkContext.setPluginDefineParams(checkItemDetail.getPluginDefineParams());
                Callable<CheckExecutionResult.CheckResultWrapper> task = CHECK_METHOD_STANDARD.equals(checkItemDetail.getMethod()) ? () -> this.executeStandardCheckItem(checkContext, checkItemDetail) : () -> this.executePluginCheckItem(checkContext, checkItemDetail);
                taskFutureMap.put(checkItemDetail, ThreadService.submit(InnerFactory.getTracer().wrap(task), TaskType.FIBD_CHECK_ITEM_EXECUTOR_TASK, RequestContext.get()));
            }
            ArrayList<CheckExecutionResult.CheckResultWrapper> resultList = new ArrayList<CheckExecutionResult.CheckResultWrapper>(checkItemDetails.size());
            for (Map.Entry checkExecutionResult2 : taskFutureMap.entrySet()) {
                CheckExecutionResult.CheckResultWrapper itemResult;
                CheckItemDetail checkItem = (CheckItemDetail)checkExecutionResult2.getKey();
                Future future = (Future)checkExecutionResult2.getValue();
                try {
                    itemResult = (CheckExecutionResult.CheckResultWrapper)future.get(this.getCheckItemTimeOut(), TimeUnit.SECONDS);
                }
                catch (InterruptedException | ExecutionException | TimeoutException ex) {
                    String errMsg = null;
                    errMsg = ex instanceof ExecutionException ? ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u6267\u884c\u5f02\u5e38\uff0c \u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u5904\u7406\u3002", (String)"ClosePeriodCheckExecutorOp_6", (String)"fi-bd-common", (Object[])new Object[0]) : (ex instanceof TimeoutException ? ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u6267\u884c\u201c\u7ebf\u7a0b\u201d\u5f02\u5e38\u6216\u8d85\u65f6\uff0c \u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u5904\u7406\u3002", (String)"ClosePeriodCheckExecutorOp_12", (String)"fi-bd-common", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u68c0\u67e5\u9879\u6267\u884c\u4e2d\u65ad\uff0c\u8bf7\u8054\u7cfb\u5f00\u53d1\u4eba\u5458\u5904\u7406\u3002", (String)"ClosePeriodCheckExecutorOp_22", (String)"fi-bd-common", (Object[])new Object[0]));
                    LOG.error(errMsg, (Throwable)ex);
                    itemResult = CheckExecutionResult.CheckResultWrapper.error(checkItem, errMsg);
                }
                resultList.add(itemResult);
            }
            CheckExecutionResult checkExecutionResult = new CheckExecutionResult(resultList);
            LOG.info("executed result as: " + checkExecutionResult.toString());
            this.writeCheckLog(executionParam, checkExecutionResult);
            CheckExecutionResult checkExecutionResult2 = checkExecutionResult;
            return checkExecutionResult2;
        }
        catch (Exception e) {
            String errMsg = String.format(ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u6267\u884c\u5931\u8d25:\u201c%1$s\u201d\u3002", (String)"ClosePeriodCheckExecutor_101", (String)"fi-bd-opplugin", (Object[])new Object[0]), e.getMessage());
            throw new KDBizException(ResManager.loadKDString((String)errMsg, (String)"ClosePeriodCheckExecutorOp_4", (String)CURR_APP, (Object[])new Object[]{e.getMessage()}));
        }
    }

    private boolean checkLisenceIsRight() {
        boolean needNoCheck;
        String version = LicenseServiceHelper.getProductVersion();
        boolean isConstellation = LicenseServiceHelper.getModeType() == 3;
        boolean bl = needNoCheck = isConstellation && ImmutableSet.of((Object)"1.0", (Object)"2.0", (Object)"3.0").contains((Object)version);
        if (!needNoCheck) {
            LicenseCheckResult result = LicenseServiceHelper.checkPerformGroup((String)"PRO_FCM");
            return result.getHasLicense();
        }
        return true;
    }

    private long getCheckItemTimeOut() {
        return Long.parseLong(System.getProperty("prop.fi.fcm.checkitem.timeout", "60"));
    }

    private CheckExecutionResult.CheckResultWrapper executeStandardCheckItem(CheckContext context, CheckItemDetail standardCheckItem) {
        if (kd.bos.util.StringUtils.isEmpty((String)standardCheckItem.getCheckCondition()) || kd.bos.util.StringUtils.isEmpty((String)standardCheckItem.getCheckBillId())) {
            return new CheckExecutionResult.CheckResultWrapper(standardCheckItem, ExecuteStatus.ERROR, ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u914d\u7f6e\u4e0d\u6b63\u786e\uff1a\u201c\u4e1a\u52a1\u5bf9\u8c61\u201d\u6216\u201c\u68c0\u67e5\u6761\u4ef6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"ClosePeriodCheckExecutorOp_13", (String)CURR_APP, (Object[])new Object[0]));
        }
        List<QFilter> filters = null;
        try {
            filters = ClosePeriodCheckExecutor.buildFiltersForStandardCheckitem(context, standardCheckItem.getCheckBillId(), standardCheckItem.getPeriodPropName(), standardCheckItem.getOrgPropValue());
        }
        catch (KDBizException ke) {
            return new CheckExecutionResult.CheckResultWrapper(standardCheckItem, ExecuteStatus.ERROR, ke.getMessage());
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)standardCheckItem.getCheckCondition()) && !standardCheckItem.isOnlineViewExternal()) {
            try {
                filters.add(QFilter.fromSerializedString((String)standardCheckItem.getCheckCondition()));
            }
            catch (Exception e) {
                ErrorCode errCode = new ErrorCode("ClosePeriodCheckExecutorOp_7", ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u68c0\u67e5\u6761\u4ef6\u89e3\u6790\u5931\u8d25\u201c[%1$s]\u201d - \u201c%2$s\u201d\u3002", (String)"ClosePeriodCheckExecutorOp_7", (String)CURR_APP, (Object[])new Object[]{standardCheckItem.getCheckCondition(), e.getMessage()}));
                throw new KDBizException(errCode, new Object[0]);
            }
        }
        boolean isExistData = false;
        try {
            isExistData = QueryServiceHelper.exists((String)standardCheckItem.getCheckBillId(), (QFilter[])filters.toArray(new QFilter[filters.size()]));
        }
        catch (Exception e) {
            StringBuilder sb = new StringBuilder();
            filters.stream().forEach(x -> sb.append(x.toString()).append("|"));
            LOG.error("possible wrong sql filter: " + sb, (Throwable)e);
            throw e;
        }
        CheckExecutionResult.CheckResultWrapper checkResult = new CheckExecutionResult.CheckResultWrapper(standardCheckItem, !isExistData ? ExecuteStatus.PASS : ExecuteStatus.FAIL);
        checkResult.setOnlineViewId(standardCheckItem.getCheckBillId());
        checkResult.setBillFilters(filters.toArray(new QFilter[0]));
        checkResult.setExecutionTraceId(RequestContext.get().getTraceId());
        LOG.info(String.format("execute_standard_check_item done[%s], bill: %s, status: %s, filter condition: %s on org: %s, period: %s", standardCheckItem.getName(), standardCheckItem.getCheckBillId(), checkResult.getExecuteStatus().name(), StringUtils.join((Object[])filters.stream().map(x -> x.toString()).toArray(), (String)"|"), context.getOrgId(), context.getPeriodId()));
        if (ExecuteStatus.FAIL == checkResult.getExecuteStatus() && kd.bos.util.StringUtils.isEmpty((String)checkResult.getErrMsg())) {
            checkResult.setErrMsg(ResManager.loadKDString((String)"\u5b58\u5728\u6ee1\u8db3\u68c0\u67e5\u9879\u914d\u7f6e\u6761\u4ef6\u7684\u6570\u636e", (String)"ClosePeriodCheckExecutorOp_10", (String)CURR_APP, (Object[])new Object[0]));
        }
        return checkResult;
    }

    @SdkDeprecated
    public static List<QFilter> buildFiltersForStandardCheckitem(CheckContext context, String billEntityNumber, String billPeriodPropName, String billOrgPropName) {
        BookRegisterInfo bookRegisterInfo;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)billEntityNumber);
        if (Date.class == ((IDataEntityProperty)mainEntityType.getProperties().get((Object)billPeriodPropName)).getPropertyType()) {
            filters.add(new QFilter(billPeriodPropName, ">=", (Object)context.getPeriodStartDate()));
            filters.add(new QFilter(billPeriodPropName, "<=", (Object)context.getPeriodEndDate()));
        } else if (mainEntityType.getProperties().get((Object)billPeriodPropName) instanceof BasedataProp && FORM_ID_PERIOD.equals(((BasedataProp)mainEntityType.getProperties().get((Object)billPeriodPropName)).getBaseEntityId())) {
            if (!kd.bos.util.StringUtils.isBlank((String)billEntityNumber) && MULTIPLE_PERIOD_GL_BALANCE.equals(billEntityNumber)) {
                filters.add(new QFilter(billPeriodPropName, "<=", (Object)context.getPeriodId()));
                filters.add(new QFilter("endperiod", ">", (Object)context.getPeriodId()));
            } else {
                filters.add(new QFilter(billPeriodPropName, "=", (Object)context.getPeriodId()));
            }
        } else {
            throw new KDBizException(ResManager.loadKDString((String)"\u201c\u68c0\u67e5\u9879\u201d\u914d\u7f6e\u7684\u671f\u95f4\u89c4\u5219\u5fc5\u987b\u4e3a\u201c\u671f\u95f4\u201d\u6216\u201c\u65e5\u671f\u201d\u7c7b\u578b\u3002", (String)"ClosePeriodCheckExecutorOp_11", (String)CURR_APP, (Object[])new Object[0]));
        }
        String bizAppNumber = AppMetadataCache.getAppNumberById((String)context.getBizAppId());
        if (!BookRegisterService.isBookOnOrg(bizAppNumber) && Objects.nonNull(bookRegisterInfo = BookRegisterService.queryByBizApp(bizAppNumber))) {
            String accountEntityName = bookRegisterInfo.getBookEntityId();
            String accountType = bookRegisterInfo.getBookTypeFieldOnBookEntity();
            String accountTypeEntityName = ((BasedataProp)EntityMetadataCache.getDataEntityType((String)accountEntityName).getProperty(accountType)).getBaseEntityId();
            Optional<QFilter> possibleQFilter = ClosePeriodCheckExecutor.tryToAddAccountTypeQFilter(mainEntityType, accountTypeEntityName, context.getSubBizAppId());
            if (!possibleQFilter.isPresent()) {
                possibleQFilter = ClosePeriodCheckExecutor.tryToAddAccountBookQFilter(mainEntityType, accountEntityName, accountType, context.getSubBizAppId());
            }
            if (possibleQFilter.isPresent()) {
                filters.add(possibleQFilter.get());
            }
        }
        filters.add(new QFilter(billOrgPropName, "=", (Object)context.getOrgId()));
        return filters;
    }

    private static Optional<QFilter> tryToAddAccountTypeQFilter(MainEntityType mainEntityType, String accountTypeEntityName, String accountTypeFilterValue) {
        List accountTypeRelativeCols = ClosePeriodCheckExecutor.buildFilterColumns(mainEntityType, null).stream().filter(x -> accountTypeEntityName.equals(x.get("entityId"))).collect(Collectors.toList());
        if (!accountTypeRelativeCols.isEmpty()) {
            Map useColItem = (Map)accountTypeRelativeCols.get(0);
            String oneFieldName = (String)useColItem.get("fieldName");
            String entryEntity = (String)useColItem.get("entryEntity");
            List<String> nameItems = Arrays.asList(oneFieldName.split("\\.")).stream().filter(x -> kd.bos.util.StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
            if (nameItems.size() > 1) {
                nameItems = nameItems.subList(0, nameItems.size() - 1);
            }
            String varPrefix = StringUtils.join((Object[])nameItems.toArray(new String[0]), (String)".");
            Optional<String> entryEntityFullName = ClosePeriodCheckExecutor.parseEntryFullName(mainEntityType, entryEntity);
            if (entryEntityFullName.isPresent()) {
                varPrefix = entryEntityFullName.get() + "." + varPrefix;
            }
            return Optional.of(new QFilter(varPrefix + ".id", "=", (Object)Long.parseLong(accountTypeFilterValue)));
        }
        return Optional.empty();
    }

    private static Optional<QFilter> tryToAddAccountBookQFilter(MainEntityType mainEntityType, String accountEntityName, String accountType, String accountTypeFilterValue) {
        List accountRelativeCols = ClosePeriodCheckExecutor.buildFilterColumns(mainEntityType, null).stream().filter(x -> accountEntityName.equals(x.get("entityId"))).collect(Collectors.toList());
        if (!accountRelativeCols.isEmpty()) {
            Map useColItem = (Map)accountRelativeCols.get(0);
            String oneFieldName = (String)useColItem.get("fieldName");
            String entryEntity = (String)useColItem.get("entryEntity");
            List<String> nameItems = Arrays.asList(oneFieldName.split("\\.")).stream().filter(x -> kd.bos.util.StringUtils.isNotEmpty((String)x)).collect(Collectors.toList());
            if (nameItems.size() > 1) {
                nameItems = nameItems.subList(0, nameItems.size() - 1);
            }
            String varPrefix = StringUtils.join((Object[])nameItems.toArray(new String[0]), (String)".");
            Optional<String> entryEntityFullName = ClosePeriodCheckExecutor.parseEntryFullName(mainEntityType, entryEntity);
            if (entryEntityFullName.isPresent()) {
                varPrefix = entryEntityFullName.get() + "." + varPrefix;
            }
            return Optional.of(new QFilter(varPrefix + "." + accountType, "=", (Object)Long.parseLong(accountTypeFilterValue)));
        }
        return Optional.empty();
    }

    private static Optional<String> parseEntryFullName(MainEntityType mainEntityType, String entityKey) {
        StringBuilder fullNameBuilder = new StringBuilder();
        Stack<String> parentStack = new Stack<String>();
        Map allEntityType = mainEntityType.getAllEntities();
        IDataEntityType curEntityType = (IDataEntityType)allEntityType.get(entityKey);
        while (!mainEntityType.getName().equals(curEntityType.getName())) {
            parentStack.push(curEntityType.getName());
            curEntityType = curEntityType.getParent();
        }
        while (!parentStack.empty()) {
            fullNameBuilder.append((String)parentStack.pop()).append(".");
        }
        if (fullNameBuilder.length() == 0) {
            return Optional.empty();
        }
        fullNameBuilder.deleteCharAt(fullNameBuilder.length() - 1);
        return Optional.of(fullNameBuilder.toString());
    }

    private CheckExecutionResult.CheckResultWrapper executePluginCheckItem(CheckContext context, CheckItemDetail pluginCheckItem) {
        try {
            Class pluginClass = Optional.ofNullable(PLUGIN_CACHE.get(pluginCheckItem.getPluginQualifiedName())).map(Reference::get).orElseGet(() -> {
                Class pluginClazz = TypesContainer.getOrRegister((String)pluginCheckItem.getPluginQualifiedName());
                PLUGIN_CACHE.put(pluginCheckItem.getPluginQualifiedName(), new WeakReference<Class>(pluginClazz));
                return pluginClazz;
            });
            if (!IClosePeriodCheckPlugin.class.isAssignableFrom(pluginClass) && !kd.sdk.fi.fcm.extpoint.checkitem.IClosePeriodCheckPlugin.class.isAssignableFrom(pluginClass)) {
                ErrorCode errCode = new ErrorCode("ClosePeriodCheckExecutorOp_2", ResManager.loadKDString((String)"\u63d2\u4ef6\u7c7b\u201c%1$s\u201d\u5728\u6307\u5b9a\u7684\u63d2\u4ef6\u63a5\u53e3\u4e2d\u4e0d\u5b58\u5728\u3002", (String)"ClosePeriodCheckExecutorOp_2", (String)CURR_APP, (Object[])new Object[]{pluginCheckItem.getPluginQualifiedName()}));
                throw new KDBizException(errCode, new Object[0]);
            }
            if (IClosePeriodCheckPlugin.class.isAssignableFrom(pluginClass)) {
                return this.executeCheckPlugin(context, pluginCheckItem, pluginClass);
            }
            return this.executeSDKCheckPlugin(context.toSpiContext(), pluginCheckItem, pluginClass);
        }
        catch (Throwable e) {
            LOG.error("execute plugin check item failed:" + e.getMessage(), e);
            throw new KDBizException(e.getMessage());
        }
    }

    private CheckExecutionResult.CheckResultWrapper executeSDKCheckPlugin(kd.sdk.fi.fcm.extpoint.checkitem.CheckContext context, CheckItemDetail pluginCheckItem, Class<?> pluginClass) throws Throwable {
        kd.sdk.fi.fcm.extpoint.checkitem.IClosePeriodCheckPlugin instance = (kd.sdk.fi.fcm.extpoint.checkitem.IClosePeriodCheckPlugin)TypesContainer.createInstance(pluginClass);
        kd.sdk.fi.fcm.extpoint.checkitem.CheckResult checkResult = instance.execute(context);
        if (Objects.isNull(checkResult)) {
            LOG.error(String.format("check item plugin return null, check item detail: %s, context: %s", pluginCheckItem.toString(), context.toString()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6-%1$s(%2$s) \u8fd4\u56de\u7a7a\u7ed3\u679c", (String)"ClosePeriodCheckExecutor_100", (String)"fi-bd-opplugin", (Object[])new Object[0]), pluginCheckItem.getPluginAlias(), pluginCheckItem.getPluginQualifiedName()));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)checkResult.getOnlineViewId())) {
            pluginCheckItem.setOnlineViewId(checkResult.getOnlineViewId());
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)checkResult.getOnlineQueryParams())) {
            pluginCheckItem.setCheckCondition(checkResult.getOnlineQueryParams());
        }
        CheckExecutionResult.CheckResultWrapper resultWrapper = new CheckExecutionResult.CheckResultWrapper(pluginCheckItem, checkResult.getIsSuccess() ? ExecuteStatus.PASS : ExecuteStatus.FAIL, CollectionUtils.isEmpty((Collection)checkResult.getMessages()) ? "" : StringUtils.join((Object[])checkResult.getMessages().toArray(), (String)"\n"));
        resultWrapper.setOnlineViewId(checkResult.getOnlineViewId());
        if (kd.bos.util.StringUtils.isNotEmpty((String)checkResult.getOnlineQueryParams())) {
            resultWrapper.setBillFilters(new QFilter[]{QFilter.fromSerializedString((String)checkResult.getOnlineQueryParams())});
        }
        LOG.info(String.format("execute_plugin_check_item done[%s], status: %s on org: %s, period: %s with params: %s", pluginCheckItem.getName(), resultWrapper.getExecuteStatus().name(), context.getOrgId(), context.getPeriodId(), context.getPluginDefineParams()));
        resultWrapper.setExecutionTraceId(RequestContext.get().getTraceId());
        return resultWrapper;
    }

    private CheckExecutionResult.CheckResultWrapper executeCheckPlugin(CheckContext context, CheckItemDetail pluginCheckItem, Class<?> pluginClass) throws Throwable {
        IClosePeriodCheckPlugin instance = (IClosePeriodCheckPlugin)TypesContainer.createInstance(pluginClass);
        CheckResult checkResult = instance.execute(context);
        if (Objects.isNull(checkResult)) {
            LOG.error(String.format("check item plugin return null, check item detail: %s, context: %s", pluginCheckItem.toString(), context.toString()));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u63d2\u4ef6-%1$s(%2$s) \u8fd4\u56de\u7a7a\u7ed3\u679c", (String)"ClosePeriodCheckExecutor_100", (String)"fi-bd-opplugin", (Object[])new Object[0]), pluginCheckItem.getPluginAlias(), pluginCheckItem.getPluginQualifiedName()));
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)checkResult.getOnlineViewId())) {
            pluginCheckItem.setOnlineViewId(checkResult.getOnlineViewId());
        }
        if (kd.bos.util.StringUtils.isNotEmpty((String)checkResult.getOnlineQueryParams())) {
            pluginCheckItem.setCheckCondition(checkResult.getOnlineQueryParams());
        }
        CheckExecutionResult.CheckResultWrapper resultWrapper = new CheckExecutionResult.CheckResultWrapper(pluginCheckItem, checkResult.getIsSuccess() ? ExecuteStatus.PASS : ExecuteStatus.FAIL, CollectionUtils.isEmpty(checkResult.getMessages()) ? "" : StringUtils.join((Object[])checkResult.getMessages().toArray(), (String)"\n"));
        resultWrapper.setOnlineViewId(checkResult.getOnlineViewId());
        if (kd.bos.util.StringUtils.isNotEmpty((String)checkResult.getOnlineQueryParams())) {
            resultWrapper.setBillFilters(new QFilter[]{QFilter.fromSerializedString((String)checkResult.getOnlineQueryParams())});
        }
        LOG.info(String.format("execute_plugin_check_item done[%s], status: %s on org: %s, period: %s with params: %s", pluginCheckItem.getName(), resultWrapper.getExecuteStatus().name(), context.getOrgId(), context.getPeriodId(), context.getPluginDefineParams()));
        resultWrapper.setExecutionTraceId(RequestContext.get().getTraceId());
        return resultWrapper;
    }

    public static List<CheckItemDetail> queryCheckItemList(String bizAppCode, String subBizAppCode, Long orgId, Boolean isEffective) {
        CheckItemQueryParam param = new CheckItemQueryParam();
        param.setBizAppId(bizAppCode);
        param.setEffective(isEffective);
        param.setOrgId(orgId);
        param.setSubbizAppCode(subBizAppCode);
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)CHECK_ITEM_PROVIDER_APP, (String)CHECK_ITEM_SERVICE_NAME, (String)"queryCheckItems", (Object[])new Object[]{param.toString()});
        return ClosePeriodCheckExecutor.parseCheckItemList(result);
    }

    private List<CheckItemDetail> queryCheckItemByIds(List<Long> ids) {
        String idsString;
        try {
            idsString = JSONUtils.toString(ids);
        }
        catch (IOException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            throw new KDException(BosErrorCode.systemError, new Object[]{e});
        }
        String result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)CHECK_ITEM_PROVIDER_APP, (String)CHECK_ITEM_SERVICE_NAME, (String)"listCheckItemsByIdList", (Object[])new Object[]{idsString});
        if (kd.bos.util.StringUtils.isEmpty((String)result)) {
            String errMsg = ResManager.loadKDString((String)"\u671f\u672b\u68c0\u67e5\u9879\u5217\u8868\u83b7\u53d6\u8fd4\u56de\u4e3a\u7a7a\uff1a", (String)"ClosePeriodService_3", (String)"fi-fcm-common", (Object[])new Object[0]);
            LOG.error(errMsg);
            throw new KDBizException(errMsg);
        }
        return ClosePeriodCheckExecutor.parseCheckItemList(result);
    }

    private static List<CheckItemDetail> parseCheckItemList(String queryResult) {
        if (kd.bos.util.StringUtils.isEmpty((String)queryResult)) {
            String errMsg = ResManager.loadKDString((String)"\u671f\u672b\u68c0\u67e5\u9879\u5217\u8868\u83b7\u53d6\u8fd4\u56de\u4e3a\u7a7a\uff1a", (String)"ClosePeriodService_3", (String)"fi-fcm-common", (Object[])new Object[0]);
            LOG.error(errMsg);
            throw new KDBizException(errMsg);
        }
        try {
            return (List)JSONUtils.cast((String)queryResult, List.class, (Class[])new Class[]{CheckItemDetail.class});
        }
        catch (IOException e) {
            String errMsg = ResManager.loadKDString((String)"\u671f\u672b\u68c0\u67e5\u9879\u5217\u8868\u83b7\u53d6\u5931\u8d25\u3002", (String)"ClosePeriodService_1", (String)"fi-fcm-common", (Object[])new Object[0]);
            LOG.error(errMsg);
            throw new KDBizException(errMsg);
        }
    }

    private void writeCheckLog(CheckItemExecutionParam executionParam, CheckExecutionResult executionResult) {
        Date now = new Date();
        String serialNum = String.format("CIE%s", DateUtils.formatString(now, "yyyyMMddHHmmssSSS"));
        if (Objects.nonNull(executionResult) && !CollectionUtils.isEmpty(executionResult.getItemCheckResultList())) {
            try {
                List<DynamicObject> checkLogDynamicObjs = executionResult.getItemCheckResultList().stream().map(x -> {
                    DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"fcm_checklog");
                    dynamicObject.set("billno", (Object)serialNum);
                    dynamicObject.set("checkitemid", (Object)x.getCheckItem().getId());
                    dynamicObject.set("checkitemcode", (Object)x.getCheckItem().getNumber());
                    dynamicObject.set("checkitemname", (Object)x.getCheckItem().getName());
                    dynamicObject.set("suggesttype", (Object)x.getCheckItem().getSuggestType());
                    dynamicObject.set("createtime", (Object)now);
                    dynamicObject.set("modifytime", (Object)now);
                    dynamicObject.set("executor", (Object)RequestContext.get().getUserId());
                    dynamicObject.set("org", (Object)executionParam.getOrgId());
                    dynamicObject.set("bizappid", (Object)executionParam.getBizAppId());
                    dynamicObject.set("executionperiod", (Object)executionParam.getPeriodId());
                    dynamicObject.set("subbiztypeid", (Object)executionParam.getSubBizAppCode());
                    dynamicObject.set("executiontraceid", (Object)String.format("%s|%s", RequestContext.get().getTraceId(), x.getExecutionTraceId()));
                    dynamicObject.set("operationid", (Object)executionParam.getOperationId());
                    if (Objects.nonNull((Object)x.getExecuteStatus())) {
                        dynamicObject.set("result", (Object)x.getExecuteStatus().getCode());
                        if (ExecuteStatus.PASS != x.getExecuteStatus() && kd.bos.util.StringUtils.isNotEmpty((String)x.getErrMsg())) {
                            dynamicObject.set("failcause", (Object)x.getErrMsg().substring(0, Math.min(50, x.getErrMsg().length())));
                        }
                    }
                    dynamicObject.set("billstatus", (Object)"A");
                    return dynamicObject;
                }).collect(Collectors.toList());
                BusinessDataWriter.save((IDataEntityType)EntityMetadataCache.getDataEntityType((String)"fcm_checklog"), (Object[])checkLogDynamicObjs.toArray(new DynamicObject[checkLogDynamicObjs.size()]));
            }
            catch (Exception e) {
                LOG.error("failed to log check item execution log:" + e.getMessage(), (Throwable)e);
            }
        }
    }

    private static List<Map<String, Object>> buildFilterColumns(MainEntityType entityType, String onlyHeadField) {
        boolean isOnlyMainEntityField = !kd.bos.util.StringUtils.isBlank((String)onlyHeadField) && Boolean.parseBoolean(onlyHeadField);
        EntityTypeUtil helper = new EntityTypeUtil();
        List filterFields = helper.getFilterFields(true, (IDataEntityType)entityType, isOnlyMainEntityField);
        ArrayList<Map<String, Object>> cols = new ArrayList<Map<String, Object>>(filterFields.size());
        for (FilterField filterField : filterFields) {
            Map filterColumn = filterField.createFilterColumn();
            cols.add(filterColumn);
        }
        return cols;
    }

    public static boolean isCheckItemEnable(String bizAppCode, String subBizAppCode, Long orgId, String checkItemNumber) {
        if (kd.bos.util.StringUtils.isEmpty((String)checkItemNumber)) {
            return false;
        }
        List<CheckItemDetail> checkItemDetails = ClosePeriodCheckExecutor.queryCheckItemList(BizAppServiceHelp.getAppIdByAppNumber((String)bizAppCode), subBizAppCode, orgId, null);
        return checkItemDetails.stream().anyMatch(x -> checkItemNumber.equals(x.getNumber()) && x.getIsEffective());
    }
}

