/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.fcm.plugins;

import com.google.common.collect.Table;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.AppMetadataCache;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fcm.CheckContext;
import kd.bos.ext.fi.fcm.CheckResult;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.fcm.IClosePeriodCheckPlugin;
import kd.bos.ext.fi.gl.closeperiod.RelatedBookQueryServiceHelper;
import kd.bos.ext.fi.gl.dao.BookDAOFactory;
import kd.bos.ext.fi.gl.service.GLAccountBookService;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class BillHadGenVoucherPlugin
implements IClosePeriodCheckPlugin {
    private static final int MAX_SIZE = 100000;

    @Override
    public CheckResult execute(CheckContext context) throws Throwable {
        Map<String, Object> pluginParams = context.getPluginDefineParams();
        Object bizObjectId = pluginParams.get("bizobj");
        if (Objects.isNull(bizObjectId)) {
            throw new KDBizException(BillHadGenVoucherPlugin.buildNoParamSettingMsg());
        }
        DynamicObject checkingBillObj = BusinessDataServiceHelper.loadSingle((Object)bizObjectId, (String)"fcm_checkingbill");
        String sourceBillEntityName = checkingBillObj.getString("checkingbill.number");
        String periodPropName = checkingBillObj.getString("periodpropvalue");
        String orgPropName = checkingBillObj.getString("orgpropvalue");
        ILocaleString billTypeName = checkingBillObj.getLocaleString("checkingbill.name");
        List<QFilter> billFilters = ClosePeriodCheckExecutor.buildFiltersForStandardCheckitem(context, sourceBillEntityName, periodPropName, orgPropName);
        billFilters.add(new QFilter("billstatus", ">=", (Object)"C"));
        try (DataSet billIdDs = QueryServiceHelper.queryDataSet((String)BillHadGenVoucherPlugin.class.getName(), (String)sourceBillEntityName, (String)"id", (QFilter[])billFilters.toArray(new QFilter[0]), null);){
            long minBillId;
            DataSet newBillIdDs = billIdDs.distinct().orderBy(new String[]{"id asc"});
            if (!newBillIdDs.hasNext()) {
                CheckResult sucResult = new CheckResult();
                sucResult.setMessages(Collections.singletonList(BillHadGenVoucherPlugin.buildNoBillMsg(billTypeName.getLocaleValue())));
                sucResult.setIsSuccess(true);
                CheckResult checkResult = sucResult;
                return checkResult;
            }
            DataSet ascDataSet = newBillIdDs.copy();
            long maxBillId = minBillId = ascDataSet.next().getLong("id").longValue();
            while (ascDataSet.hasNext()) {
                Row row = ascDataSet.next();
                if (ascDataSet.hasNext()) continue;
                maxBillId = row.getLong("id");
            }
            DataSet notNeedVchBillIds = this.getNotNeedVoucherBillIds(sourceBillEntityName, context.getOrgId(), minBillId, maxBillId);
            String appNumber = AppMetadataCache.getAppNumberById((String)context.getBizAppId());
            DataSet hadVchBillIds = this.getHadVoucherBillIds(sourceBillEntityName, appNumber, context.getOrgId(), context.getSubBizAppId(), minBillId, maxBillId);
            DataSet hadVchBillIdDs = notNeedVchBillIds.union(hadVchBillIds).distinct().orderBy(new String[]{"billid asc"});
            Set<Long> billIds = this.getNotCreateVchBillIds(newBillIdDs, hadVchBillIdDs);
            if (!billIds.isEmpty()) {
                CheckResult failResult = new CheckResult();
                failResult.setOnlineViewId(sourceBillEntityName);
                QFilter idFilter = new QFilter("id", "in", billIds);
                failResult.setOnlineQueryParams(idFilter.toSerializedString());
                failResult.setMessages(Collections.singletonList(BillHadGenVoucherPlugin.buildBillNotGenerateVoucherMsg(billIds.size())));
                failResult.setIsSuccess(false);
                CheckResult checkResult = failResult;
                return checkResult;
            }
            CheckResult sucResult = new CheckResult();
            sucResult.setMessages(Collections.singletonList(BillHadGenVoucherPlugin.buildBillHadGenerateVoucherMsg(billTypeName.getLocaleValue())));
            sucResult.setIsSuccess(true);
            CheckResult checkResult = sucResult;
            return checkResult;
        }
    }

    private static String buildBillHadGenerateVoucherMsg(String billType) {
        return ResManager.loadKDString((String)"\u6240\u6709%s\u5355\u636e\u5df2\u7ecf\u751f\u6210\u51ed\u8bc1\u3002", (String)"ClosePeriodCheckExecutorOp_16", (String)"bos-ext-fi", (Object[])new Object[]{billType});
    }

    private static String buildNoBillMsg(String billType) {
        return ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u3002", (String)"ClosePeriodCheckExecutorOp_19", (String)"bos-ext-fi", (Object[])new Object[]{billType});
    }

    private static String buildNoParamSettingMsg() {
        return ResManager.loadKDString((String)"\u6267\u884c\u5f02\u5e38\uff1a\u672a\u83b7\u53d6\u5230\u6307\u5b9a\u201c\u53c2\u6570\u201d\u3002", (String)"ClosePeriodCheckExecutorOp_18", (String)"bos-ext-fi", (Object[])new Object[0]);
    }

    private static String buildBillNotGenerateVoucherMsg(int count) {
        return ResManager.loadKDString((String)"\u5b58\u5728%s\u5f20\u672a\u751f\u6210\u51ed\u8bc1\u7684\u5355\u636e\u3002", (String)"ClosePeriodCheckExecutorOp_17", (String)"bos-ext-fi", (Object[])new Object[]{count});
    }

    private DataSet getHadVoucherBillIds(String billType, String appNumber, long orgId, String subBizAppId, long minBillId, long maxBillId) {
        long bookTypeId = StringUtils.isEmpty((String)subBizAppId) ? 0L : Long.parseLong(subBizAppId);
        Table<Long, Long, BookVO> bookVOTable = BookDAOFactory.getBookDAO(appNumber).query(appNumber, Collections.singletonList(orgId), bookTypeId);
        BookVO bookVO = (BookVO)bookVOTable.get((Object)orgId, (Object)bookTypeId);
        if (Objects.isNull(bookVO)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u672a\u67e5\u8be2\u5230\u201c\u4e1a\u52a1\u8d26\u7c3f\u201d\u5bf9\u5e94\u7684\u201c\u603b\u8d26\u8d26\u7c3f\u201d\u3002", (String)"BillHadGenVoucherPlugin_0", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        Set<Long> glAccountBookIdSet = RelatedBookQueryServiceHelper.getRelatedAccountBookIds(appNumber, bookVO);
        List<BookVO> glAccountBookList = GLAccountBookService.getAccountBooksByIds(glAccountBookIdSet);
        Set glOrgIdSet = glAccountBookList.stream().map(BookVO::getOrgId).collect(Collectors.toSet());
        SqlBuilder sql = new SqlBuilder();
        sql.append("select fsourcebillid billid from t_ai_daptracker where fbilltype = ?", new Object[]{billType});
        sql.append(" and fsourcebillid >= ?", new Object[]{minBillId});
        sql.append(" and fsourcebillid <= ?", new Object[]{maxBillId});
        sql.appendIn(" and forgid ", glOrgIdSet.toArray());
        sql.append(" union ", new Object[0]);
        sql.append("select t1.fsrc_billid billid from t_fah_evt_tracker t1 join t_fah_ae_headers t2 on t1.fxla_header_id = t2.fid", new Object[0]);
        sql.append(" where t1.fsrc_billtype = ? ", new Object[]{billType});
        sql.append(" and t1.fstatus = ?", new Object[]{"4"});
        sql.append(" and t1.fReverseFlag = ?", new Object[]{"0"});
        sql.append(" and t1.fsrc_billid >= ?", new Object[]{minBillId});
        sql.append(" and t1.fsrc_billid <= ?", new Object[]{maxBillId});
        sql.appendIn(" and t2.forgid ", glOrgIdSet.toArray());
        return DB.queryDataSet((String)"queryBillId_VchGenerated", (DBRoute)DBRoute.of((String)"ai"), (SqlBuilder)sql);
    }

    private DataSet getNotNeedVoucherBillIds(String sourceBillEntityName, long orgId, long minBillId, long maxBillId) {
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)sourceBillEntityName);
        String dbRouteKey = mainEntityType.getDBRouteKey();
        String tableName = mainEntityType.getAlias() + "_dapn";
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("select fsourcebillid billid from " + tableName + " where fsourcebillid >= ? and fsourcebillid <= ? and forgid = ?", new Object[]{minBillId, maxBillId, orgId});
        return DB.queryDataSet((String)this.getClass().getName(), (DBRoute)DBRoute.of((String)dbRouteKey), (SqlBuilder)sqlBuilder);
    }

    private Set<Long> getNotCreateVchBillIds(DataSet needCheckBillIdDs, DataSet hadVchBillIdDs) {
        HashSet<Long> notCreateVchBillIdSet = new HashSet<Long>(8);
        Row checkBillIdRow = needCheckBillIdDs.next();
        if (hadVchBillIdDs.hasNext()) {
            Row hadVchBillIdRow = hadVchBillIdDs.next();
            while (Objects.nonNull(checkBillIdRow) && Objects.nonNull(hadVchBillIdRow)) {
                long hadVchBillId;
                long checkBillId = checkBillIdRow.getLong("id");
                if (checkBillId > (hadVchBillId = hadVchBillIdRow.getLong("billid").longValue())) {
                    hadVchBillIdRow = hadVchBillIdDs.hasNext() ? hadVchBillIdDs.next() : null;
                    continue;
                }
                if (checkBillId == hadVchBillId) {
                    checkBillIdRow = needCheckBillIdDs.hasNext() ? needCheckBillIdDs.next() : null;
                    hadVchBillIdRow = hadVchBillIdDs.hasNext() ? hadVchBillIdDs.next() : null;
                    continue;
                }
                notCreateVchBillIdSet.add(checkBillId);
                Row row = checkBillIdRow = needCheckBillIdDs.hasNext() ? needCheckBillIdDs.next() : null;
                if (notCreateVchBillIdSet.size() < 100000) continue;
                return notCreateVchBillIdSet;
            }
            if (Objects.nonNull(checkBillIdRow)) {
                notCreateVchBillIdSet.add(checkBillIdRow.getLong("id"));
                while (needCheckBillIdDs.hasNext()) {
                    notCreateVchBillIdSet.add(needCheckBillIdDs.next().getLong("id"));
                    if (notCreateVchBillIdSet.size() < 100000) continue;
                    return notCreateVchBillIdSet;
                }
            }
            return notCreateVchBillIdSet;
        }
        notCreateVchBillIdSet.add(checkBillIdRow.getLong("id"));
        while (needCheckBillIdDs.hasNext()) {
            checkBillIdRow = needCheckBillIdDs.next();
            notCreateVchBillIdSet.add(checkBillIdRow.getLong("id"));
            if (notCreateVchBillIdSet.size() < 100000) continue;
            return notCreateVchBillIdSet;
        }
        return notCreateVchBillIdSet;
    }
}

