/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.func;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.CRExpressionContext;
import kd.bos.entity.formula.ExpressionContext;
import kd.bos.ext.fi.botp.helper.CasHelper;
import kd.bos.ext.fi.func.BaseDataBean;
import kd.bos.ext.fi.plugin.ArApConvert.util.EmptyUtils;
import kd.bos.ext.fi.util.MatchingHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;

public class BasedataMatcher {
    private static final Log LOGGER = LogFactory.getLog(BasedataMatcher.class);
    private static final String BASE_SELECTOR = "id";
    private static final String DETAIL_SELECTOR = "company.id,oppunit,oppbanknumber";
    private static final String BEI_TRANS_DETAIL_CAS = "bei_transdetail_cas";
    private static final String EMPTY_REGEX = "\\s+";
    private static final String SYMBOL_REGEX = "[^\\p{L}\\p{N}\\u4e00-\\u9fff]";

    public BaseDataBean matchByName(Long orgId, String matchingText, String entity, Object pk) {
        LOGGER.info("matchByName:orgId:{},matchingText:{},entity:{},pk:{}", new Object[]{orgId, matchingText, entity, pk});
        String[] oppTypeArry = new String[]{"bd_customer", "bd_supplier"};
        DynamicObject detail = null;
        if (BEI_TRANS_DETAIL_CAS.equals(entity) && pk != null) {
            QFilter detailFilter = new QFilter(BASE_SELECTOR, "=", pk);
            detail = QueryServiceHelper.queryOne((String)BEI_TRANS_DETAIL_CAS, (String)DETAIL_SELECTOR, (QFilter[])detailFilter.toArray());
        }
        String cacheKey = MatchingHelper.getMatchingRedisKey(detail, matchingText, entity, orgId);
        LOGGER.info("matchByName\uff1acacheKey\uff1a{}\uff0cmatchingText\uff1a{}", (Object)cacheKey, (Object)matchingText);
        BaseDataBean cacheBean = MatchingHelper.getMatchDataFromCache(cacheKey);
        if (cacheBean != null) {
            LOGGER.info("matchByName\uff1amatch cache return");
            return cacheBean;
        }
        for (String oppType : oppTypeArry) {
            BaseDataBean baseDataBean = this.dealCustomerOrSupplier(oppType, detail, matchingText, entity, orgId, false);
            if (baseDataBean == null) continue;
            MatchingHelper.putCache(cacheKey, baseDataBean);
            return baseDataBean;
        }
        BaseDataBean orgBean = this.dealBosOrg(oppTypeArry, detail, matchingText, entity, orgId);
        if (orgBean != null) {
            MatchingHelper.putCache(cacheKey, orgBean);
            return orgBean;
        }
        BaseDataBean userBean = this.dealBosUser(detail, matchingText, entity, orgId, false);
        if (userBean != null) {
            MatchingHelper.putCache(cacheKey, userBean);
            return userBean;
        }
        BaseDataBean result = new BaseDataBean();
        MatchingHelper.putCache(cacheKey, result);
        return result;
    }

    public BaseDataBean dealCustomerOrSupplier(String oppType, DynamicObject detail, String matchingText, String entity, Long orgId, boolean isFunc) {
        if (StringUtils.equals((CharSequence)entity, (CharSequence)BEI_TRANS_DETAIL_CAS) && CasHelper.isNotEmpty(detail)) {
            String oppBankNumber = detail.getString("oppbanknumber");
            long companyId = detail.getLong("company.id");
            return this.matchingByOppBankNumber(oppType, companyId, oppBankNumber, matchingText, orgId, isFunc);
        }
        return this.matchingNameIncludeClean(matchingText, oppType, orgId, isFunc);
    }

    public BaseDataBean dealBotpCustomerOrSupplier(String oppType, String oppBankNumber, String matchingText, Long companyId) {
        if (CasHelper.isNotEmpty(oppBankNumber)) {
            return this.matchingByOppBankNumber(oppType, companyId, oppBankNumber, matchingText, companyId, false);
        }
        return this.matchingNameIncludeClean(matchingText, oppType, companyId, false);
    }

    private BaseDataBean matchingByOppBankNumber(String oppType, long companyId, String oppBankNumber, String matchingText, Long orgId, boolean isFunc) {
        QFilter baseFilter = new QFilter("enable", "=", (Object)"1");
        baseFilter.and("status", "=", (Object)"C");
        if (CasHelper.isNotEmpty(oppBankNumber)) {
            DynamicObjectCollection customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType, (Long)companyId, (QFilter)new QFilter("entry_bank.bankaccount", "=", (Object)oppBankNumber).and(baseFilter), (String)"id,entry_bank.accountname");
            if (CasHelper.isNotEmpty(customerOrSupplier) && (customerOrSupplier.size() == 1 || customerOrSupplier.size() > 1 && isFunc)) {
                return new BaseDataBean(oppType, ((DynamicObject)customerOrSupplier.get(0)).get(BASE_SELECTOR));
            }
            if (CasHelper.isNotEmpty(customerOrSupplier) && customerOrSupplier.size() > 1) {
                if (CasHelper.isNotEmpty(matchingText)) {
                    List filterNameData = customerOrSupplier.stream().filter(s -> matchingText.equals(s.getString("entry_bank.accountname"))).collect(Collectors.toList());
                    if (CasHelper.isNotEmpty(filterNameData) && (filterNameData.size() == 1 || filterNameData.size() > 1 && isFunc)) {
                        return new BaseDataBean(oppType, ((DynamicObject)filterNameData.get(0)).get(BASE_SELECTOR));
                    }
                    String cleanedString = matchingText.replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, "");
                    LOGGER.info("kd.bos.ext.fi.func.BasedataMatcher#cleanedString:{}", (Object)cleanedString);
                    List nameMatchList = customerOrSupplier.stream().filter(s -> CasHelper.isNotEmpty(s.getString("entry_bank.accountname")) && cleanedString.equalsIgnoreCase(s.getString("entry_bank.accountname").replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, ""))).collect(Collectors.toList());
                    if (CasHelper.isNotEmpty(nameMatchList) && (nameMatchList.size() == 1 || nameMatchList.size() > 1 && isFunc)) {
                        return new BaseDataBean(oppType, ((DynamicObject)nameMatchList.get(0)).get(BASE_SELECTOR));
                    }
                    return null;
                }
                return null;
            }
        }
        return this.matchingNameIncludeClean(matchingText, oppType, orgId, isFunc);
    }

    private BaseDataBean matchingNameIncludeClean(String matchingText, String oppType, Long orgId, boolean isFunc) {
        QFilter baseFilter = new QFilter("enable", "=", (Object)"1");
        baseFilter.and("status", "=", (Object)"C");
        if (CasHelper.isNotEmpty(matchingText)) {
            DynamicObjectCollection customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType, (Long)orgId, (QFilter)new QFilter("name", "=", (Object)matchingText).and(baseFilter), (String)BASE_SELECTOR);
            if (customerOrSupplier != null && !customerOrSupplier.isEmpty() && (customerOrSupplier.size() == 1 || isFunc)) {
                return new BaseDataBean(oppType, ((DynamicObject)customerOrSupplier.get(0)).get(BASE_SELECTOR));
            }
            if (CasHelper.isEmpty((Collection)customerOrSupplier)) {
                QFilter qFilter = new QFilter("number", "=", (Object)"fi.cas.clean.name");
                qFilter.and("enable", "=", (Object)"1");
                qFilter.and("configvalue", "=", (Object)"true");
                DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"cas_extend_config", (String)BASE_SELECTOR, (QFilter[])qFilter.toArray());
                if (config != null) {
                    String cleanedString = matchingText.replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, "");
                    LOGGER.info("config#kd.bos.ext.fi.func.BasedataMatcher#cleanedString:{}", (Object)cleanedString);
                    Map oppTypeMap = BaseDataServiceHelper.queryBaseDataFromCache((String)oppType, (Long)orgId, (QFilter)baseFilter, (String)"id,name");
                    if (oppTypeMap != null && oppTypeMap.size() > 0) {
                        List nameMatchList = oppTypeMap.values().stream().filter(s -> CasHelper.isNotEmpty(s.getString("name")) && cleanedString.equalsIgnoreCase(s.getString("name").replaceAll(EMPTY_REGEX, "").replaceAll(SYMBOL_REGEX, ""))).collect(Collectors.toList());
                        if (CasHelper.isNotEmpty(nameMatchList) && (nameMatchList.size() == 1 || nameMatchList.size() > 1 && isFunc)) {
                            return new BaseDataBean(oppType, ((DynamicObject)nameMatchList.get(0)).get(BASE_SELECTOR));
                        }
                        return null;
                    }
                }
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BaseDataBean dealBosOrg(String[] oppTypeArry, DynamicObject detail, String matchingText, String entity, Long orgId) {
        DynamicObjectCollection orgInfo;
        String oppBankNumber;
        QFilter baseFilter = new QFilter("enable", "=", (Object)"1");
        if (StringUtils.equals((CharSequence)entity, (CharSequence)BEI_TRANS_DETAIL_CAS) && CasHelper.isNotEmpty(detail) && CasHelper.isNotEmpty(oppBankNumber = detail.getString("oppbanknumber"))) {
            QFilter accFilter = new QFilter("bankaccountnumber", "=", (Object)oppBankNumber);
            DynamicObjectCollection accountBanks = QueryServiceHelper.query((String)"bd_accountbanks", (String)"id,company.id", (QFilter[])accFilter.toArray());
            if (EmptyUtils.isNotEmpty(accountBanks) && accountBanks.size() == 1) {
                DynamicObject accountBank = (DynamicObject)accountBanks.get(0);
                Set<Long> orgIds = BasedataMatcher.getUserAuthorityOrgs(accountBank.getLong(BASE_SELECTOR));
                if (orgIds.size() != 1) return null;
                Long companyId = accountBank.getLong("company.id");
                QFilter orgFilter = new QFilter(BASE_SELECTOR, "=", (Object)companyId);
                orgFilter.and(baseFilter);
                DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_org", (String)BASE_SELECTOR, (QFilter[])orgFilter.toArray());
                if (EmptyUtils.isNotEmpty(org)) {
                    return new BaseDataBean("bos_org", companyId);
                }
            } else if (EmptyUtils.isNotEmpty(accountBanks) && accountBanks.size() > 1) {
                return null;
            }
        }
        if (!CasHelper.isNotEmpty(matchingText) || !CasHelper.isNotEmpty(orgInfo = BaseDataServiceHelper.queryBaseData((String)"bos_org", (Long)orgId, (QFilter)new QFilter("name", "=", (Object)matchingText).and(baseFilter), (String)BASE_SELECTOR)) || orgInfo.size() != 1) return null;
        if (oppTypeArry == null) return new BaseDataBean("bos_org", ((DynamicObject)orgInfo.get(0)).get(BASE_SELECTOR));
        for (String oppType : oppTypeArry) {
            QFilter qFilter = new QFilter("internal_company", "=", (Object)((DynamicObject)orgInfo.get(0)).getLong(BASE_SELECTOR));
            qFilter.and("status", "=", (Object)"C");
            DynamicObjectCollection customerOrSupplier = BaseDataServiceHelper.queryBaseData((String)oppType, (Long)orgId, (QFilter)qFilter.and(baseFilter), (String)BASE_SELECTOR);
            if (customerOrSupplier == null || customerOrSupplier.size() <= 0) continue;
            return new BaseDataBean(oppType, ((DynamicObject)customerOrSupplier.get(0)).get(BASE_SELECTOR));
        }
        return new BaseDataBean("bos_org", ((DynamicObject)orgInfo.get(0)).get(BASE_SELECTOR));
    }

    public BaseDataBean dealBosUser(DynamicObject detail, String matchingText, String entity, Long orgId, boolean isFunc) {
        QFilter baseFilter;
        DynamicObjectCollection user;
        String oppBankNumber;
        if (StringUtils.equals((CharSequence)entity, (CharSequence)BEI_TRANS_DETAIL_CAS) && CasHelper.isNotEmpty(detail) && CasHelper.isNotEmpty(oppBankNumber = detail.getString("oppbanknumber"))) {
            QFilter payeerFilter = new QFilter("isemployee", "=", (Object)"1");
            payeerFilter.and("enable", "=", (Object)"1");
            payeerFilter.and("payeraccount", "=", (Object)oppBankNumber);
            Map payeerMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payeraccountname", (QFilter[])payeerFilter.toArray());
            if (payeerMap != null && !payeerMap.isEmpty()) {
                if (payeerMap.size() == 1 || isFunc) {
                    DynamicObject payeer = (DynamicObject)payeerMap.values().iterator().next();
                    if (EmptyUtils.isNotEmpty(payeer)) {
                        return new BaseDataBean("bos_user", payeer.getDynamicObject("payer").get(BASE_SELECTOR));
                    }
                } else if (CasHelper.isNotEmpty(matchingText)) {
                    Set payeeIds = payeerMap.values().stream().filter(s -> matchingText.equals(s.getString("payeraccountname"))).map(s -> s.getDynamicObject("payer").getLong(BASE_SELECTOR)).collect(Collectors.toSet());
                    if (payeeIds.size() == 1) {
                        return new BaseDataBean("bos_user", payeeIds.iterator().next());
                    }
                } else {
                    return null;
                }
            }
        }
        if (CasHelper.isNotEmpty(matchingText) && CasHelper.isNotEmpty(user = BaseDataServiceHelper.queryBaseData((String)"bos_user", (Long)orgId, (QFilter)new QFilter("name", "=", (Object)matchingText).and(baseFilter = new QFilter("enable", "=", (Object)"1")), (String)BASE_SELECTOR)) && (user.size() == 1 || user.size() > 1 && isFunc)) {
            return new BaseDataBean("bos_user", ((DynamicObject)user.get(0)).get(BASE_SELECTOR));
        }
        return null;
    }

    private static Set<Long> getUserAuthorityOrgs(Long accountBankId) {
        String sql = "select fuseorgid from t_bd_accountbanks_u where fdataid= ?";
        BillEntityType dt = (BillEntityType)EntityMetadataCache.getDataEntityType((String)"bd_accountbanks");
        ResultSetHandler action = rs -> {
            HashSet<Long> list = new HashSet<Long>(10);
            while (rs.next()) {
                list.add(rs.getLong("fuseorgid"));
            }
            return list;
        };
        return (Set)DB.query((DBRoute)DBRoute.of((String)dt.getDBRouteKey()), (String)sql, (Object[])new Object[]{accountBankId}, (ResultSetHandler)action);
    }

    public boolean matchIsCustomerOrSupplier(ExpressionContext bosExpContext, String customerOrSupplier) {
        DynamicObject detail;
        String name;
        Object pkValue = ((CRExpressionContext)bosExpContext).getActiveRow().getPkValue();
        if (pkValue == null) {
            long id = ((CRExpressionContext)bosExpContext).getActiveRow().getLong(BASE_SELECTOR);
            if (id == 0L) {
                return false;
            }
            name = BEI_TRANS_DETAIL_CAS;
            String selectProperties = DETAIL_SELECTOR;
            QFilter idQfilter = new QFilter(BASE_SELECTOR, "=", (Object)id);
            detail = QueryServiceHelper.queryOne((String)name, (String)selectProperties, (QFilter[])new QFilter[]{idQfilter});
            if (CasHelper.isEmpty(detail)) {
                name = "cdm_receivablebill";
                selectProperties = "company.id,delivername";
                detail = QueryServiceHelper.queryOne((String)name, (String)selectProperties, (QFilter[])new QFilter[]{idQfilter});
            }
        } else {
            String selectProperties;
            name = ((CRExpressionContext)bosExpContext).getActiveRow().getDataEntityType().getName();
            if (StringUtils.equals((CharSequence)name, (CharSequence)BEI_TRANS_DETAIL_CAS)) {
                selectProperties = DETAIL_SELECTOR;
            } else if (StringUtils.equals((CharSequence)name, (CharSequence)"cdm_receivablebill")) {
                selectProperties = "company.id,delivername";
            } else {
                return false;
            }
            QFilter idQfilter = new QFilter(BASE_SELECTOR, "=", pkValue);
            detail = QueryServiceHelper.queryOne((String)name, (String)selectProperties, (QFilter[])new QFilter[]{idQfilter});
        }
        if (CasHelper.isEmpty(detail)) {
            return false;
        }
        Long companyId = detail.getLong("company.id");
        String oppunitName = StringUtils.equals((CharSequence)name, (CharSequence)BEI_TRANS_DETAIL_CAS) ? detail.getString("oppunit") : detail.getString("delivername");
        BaseDataBean baseDataBean = this.dealCustomerOrSupplier(customerOrSupplier, detail, oppunitName, name, companyId, true);
        return baseDataBean != null;
    }
}

