/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.gl.closeperiod;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.utils.OrmUtils;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.orm.datamanager.DataEntityCacheManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class BookRegisterService {
    private static final QFilter[] allF = QFilter.of((String)"1 = 1", (Object[])new Object[0]).toArray();

    public static BookRegisterInfo queryByBizApp(String bizApp) {
        return BookRegisterService.queryAll().stream().filter(register -> register.getBizApp().equals(bizApp)).findAny().orElse(null);
    }

    public static List<BookRegisterInfo> queryAllByCloudNum(String cloudNum) {
        return BookRegisterService.queryAll().stream().filter(register -> register.getCloud().equals(cloudNum)).collect(Collectors.toList());
    }

    public static boolean isBookOnOrg(String bizApp) {
        BookRegisterInfo bookRegisterInfo = BookRegisterService.queryByBizApp(bizApp);
        return bookRegisterInfo == null || bookRegisterInfo.getBookEntityId() == null;
    }

    public static List<String> queryAllCloudNum() {
        return BookRegisterService.queryAll().stream().map(BookRegisterInfo::getCloud).distinct().collect(Collectors.toList());
    }

    public static List<BookRegisterInfo> queryAll() {
        IDataEntityType entityType = OrmUtils.getDataEntityType(BookRegisterInfo.class);
        DataEntityCacheManager entityCache = new DataEntityCacheManager(entityType);
        Object[] cachePks = entityCache.getCachePks(allF);
        if (cachePks == null || cachePks.length == 0) {
            BookRegisterService.initAllCache();
        }
        return entityCache.get(entityCache.getCachePks(allF)).values().stream().map(BookRegisterInfo.class::cast).collect(Collectors.toList());
    }

    private static void initAllCache() {
        IDataEntityType entityType = OrmUtils.getDataEntityType(BookRegisterInfo.class);
        DataEntityCacheManager entityCache = new DataEntityCacheManager(entityType);
        Object[] allPks = QueryServiceHelper.queryPrimaryKeys((String)"AccountBookRegisterService#queryPrimaryKeys", (IDataEntityType)entityType, (QFilter[])allF, null, (int)-1).toArray();
        Object[] allEntity = BusinessDataServiceHelper.load((Object[])allPks, (IDataEntityType)entityCache.getDataEntityType());
        entityCache.putCachePks(allF, allPks);
        entityCache.put(allEntity);
    }
}

