/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.gl.service;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.ext.fi.bd.service.BDPeriodService;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.gl.closeperiod.RelatedBookQueryServiceHelper;
import kd.bos.ext.fi.gl.service.GLAccountBookService;
import kd.bos.ext.fi.gl.service.GLOpenedPeriodService;
import kd.bos.ext.fi.gl.vo.BookVO;
import kd.bos.util.CollectionUtils;

public class GLClosePeriodService {
    private static final String BizSystemCloseStatus = "BizSystemCloseStatus";
    private static final Set<String> CHECK_GL_CLOSED_APPS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"ap", "ar", "fa"}));

    public static boolean isRelatedAccountBookClosed(String bizAppNumber, BookVO bizBook, Long antiClosingPeriodId) {
        if (bizAppNumber == null || bizBook == null || antiClosingPeriodId == null) {
            throw new IllegalArgumentException("Param cannot be empty. ");
        }
        if (!CHECK_GL_CLOSED_APPS.contains(bizAppNumber.toLowerCase())) {
            return false;
        }
        Set<Long> relatedAccountBookIds = RelatedBookQueryServiceHelper.getRelatedAccountBookIds(bizAppNumber, bizBook);
        if (CollectionUtils.isEmpty(relatedAccountBookIds)) {
            return false;
        }
        List<BookVO> accountBooks = GLAccountBookService.getAccountBooksByIds(relatedAccountBookIds);
        List enabledAccountBooks = accountBooks.stream().filter(x -> ClosePeriodCheckExecutor.isCheckItemEnable("gl", String.valueOf(x.getBookTypeId()), x.getOrgId(), BizSystemCloseStatus)).collect(Collectors.toList());
        if (enabledAccountBooks.isEmpty()) {
            return false;
        }
        List<Long> periodIds = BDPeriodService.getPeriodIds(BDPeriodService.replacePeriodTypeId(antiClosingPeriodId, bizBook.getPeriodTypeId()), bizBook.getCurPeriodId(), bizBook.getPeriodTypeId());
        for (BookVO accountBook : enabledAccountBooks) {
            List<Long> openedPeriodIds = GLOpenedPeriodService.getOpenedPeriodIds(accountBook.getOrgId(), accountBook.getCurPeriodId());
            for (Long periodId : periodIds) {
                if (BDPeriodService.comparePeriod(accountBook.getCurPeriodId(), periodId) <= 0 || !openedPeriodIds.isEmpty() && !openedPeriodIds.stream().noneMatch(x -> BDPeriodService.comparePeriod(x, periodId) == 0)) continue;
                return true;
            }
        }
        return false;
    }
}

