/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.metadata.edit;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import kd.bos.dataentity.entity.DataEntityTypeAttribute;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.param.FuzzySearch;
import kd.bos.entity.param.ShowColumn;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.entity.property.AccountProp;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.sdk.annotation.SdkDeprecated;

@DataEntityTypeAttribute(name="kd.bos.ext.fi.metadata.edit.AccountEdit")
@SdkDeprecated
public class AccountEdit
extends BasedataEdit {
    private static final String END_DATE = "2999-12-31";

    public List<QFilter> getQFilters() {
        String periodField;
        DynamicObject acctT;
        ArrayList<QFilter> filters = super.getQFilters() == null ? new ArrayList(1) : super.getQFilters();
        AccountProp acProp = (AccountProp)this.getProperty();
        String accttable = acProp.getAcctTableField();
        if (accttable != null && (acctT = (DynamicObject)this.getModel().getValue(accttable)) != null) {
            filters.add(new QFilter("accounttable", "=", (Object)acctT.getLong("id")));
        }
        if ((periodField = acProp.getPeriodField()) != null) {
            DynamicObject period = (DynamicObject)this.getModel().getValue(periodField);
            if (period != null) {
                Date enddate = period.getDate("enddate");
                QFilter fsd = new QFilter("startdate", "<=", (Object)enddate);
                QFilter fed = new QFilter("enddate", ">=", (Object)enddate);
                filters.add(fsd);
                filters.add(fed);
            }
        } else if (!this.getView().getEntityId().equals("gl_initbalance")) {
            try {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                Date date = sdf.parse(END_DATE);
                QFilter filter = new QFilter("enddate", "=", (Object)date);
                filters.add(filter);
            }
            catch (ParseException e) {
                throw new KDBizException(e.getMessage());
            }
        }
        return filters;
    }

    protected ListShowParameter createAndSetListShowParameter(String sourceMethod) {
        ListShowParameter show = super.createAndSetListShowParameter(sourceMethod);
        if (Objects.nonNull(show)) {
            show.setCustomParam("acct_filter", (Object)"true");
        }
        return show;
    }

    protected FuzzySearch loadLookUpSetting(BasedataEntityType refBDType) {
        AccountProp acProp = (AccountProp)this.getProperty();
        FuzzySearch setting = super.loadLookUpSetting(refBDType);
        if (acProp.isDisplayFullname()) {
            boolean hasFullName = false;
            ShowColumn sColumn = null;
            for (ShowColumn sc : setting.getComboListFields()) {
                if (sc.getId().equals("name")) {
                    sColumn = sc;
                }
                if (!sc.getId().equals("fullname")) continue;
                hasFullName = true;
            }
            if (!hasFullName && sColumn != null) {
                sColumn.setId("fullname");
            }
        }
        return setting;
    }
}

