/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.ext.fi.ai.DapBuildVoucherCommonUtil;
import kd.bos.ext.fi.ai.DapVoucherUtil;
import kd.bos.ext.fi.validate.VoucherStateValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;

public class AutoProcessVoucherOpAction
extends AbstractOpBizRuleAction {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new VoucherStateValidator());
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] bills = e.getDataEntities();
        if (bills.length == 0) {
            return;
        }
        ArrayList<Long> billIds = new ArrayList<Long>(bills.length);
        for (DynamicObject bill : bills) {
            billIds.add(bill.getLong("id"));
        }
        HashSet<Long> vchIds = new HashSet<Long>(bills.length);
        ArrayList<QFilter> billTypeFilter = new ArrayList<QFilter>(2);
        DapVoucherUtil.addBillTypeFilter(bills[0].getDataEntityType().getName(), billTypeFilter);
        List splitBillIds = DapBuildVoucherCommonUtil.splitbatch(billIds, 1000);
        for (List list : splitBillIds) {
            QFilter[] qFilterArray;
            QFilter billIdFilter = new QFilter("sourcebillid", "in", (Object)list);
            if (billTypeFilter.isEmpty()) {
                qFilterArray = billIdFilter.toArray();
            } else {
                QFilter[] qFilterArray2 = new QFilter[2];
                qFilterArray2[0] = billIdFilter;
                qFilterArray = qFilterArray2;
                qFilterArray2[1] = (QFilter)billTypeFilter.get(0);
            }
            QFilter[] qFilters = qFilterArray;
            DataSet rows = QueryServiceHelper.queryDataSet((String)"kd.bos.ext.fi.operation.bizrule.AutoProcessVoucherOpAction.afterExecuteOperationTransaction", (String)"ai_daptracker", (String)"voucherid", (QFilter[])qFilters, null);
            Throwable throwable = null;
            try {
                for (Row row : rows) {
                    vchIds.add(row.getLong("voucherid"));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (rows == null) continue;
                if (throwable != null) {
                    try {
                        rows.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    continue;
                }
                rows.close();
            }
        }
        List splitVchIds = DapBuildVoucherCommonUtil.splitbatch(new ArrayList(vchIds), 100);
        for (List splitVchId : splitVchIds) {
            DeleteServiceHelper deleteService = new DeleteServiceHelper();
            deleteService.deleteOperate("gl_voucher", splitVchId.toArray(), OperateOption.create());
        }
    }
}

