/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.operate.bizrule.AbstractOpBizRuleAction;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.operation.bizrule.AutoSaveFormDataToDataMarketParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class AutoSaveFormDataToDataMarketOpAction
extends AbstractOpBizRuleAction {
    private static final Log logger = LogFactory.getLog(AutoSaveFormDataToDataMarketOpAction.class);
    public static final String JMS_Queue_PA_Region = "fi";
    public static final String JMS_Queue_PA_AUTOT_Job = "kd.fi.pa.appstart.auto_data_queue";
    public static final String CATEGORY_DATAMARKET = "DATAMARKET";

    protected boolean canSkipError() {
        AutoSaveFormDataToDataMarketParameter param = (AutoSaveFormDataToDataMarketParameter)((Object)SerializationUtils.fromJsonString((String)this.getBizRule().getParameter(), AutoSaveFormDataToDataMarketParameter.class));
        return "1".equals(param.getErrorHandleType());
    }

    protected DynamicObject getDataUnitId(String operationKey) {
        try {
            DynamicObject checkResult = BusinessDataServiceHelper.loadSingleFromCache((String)"ma_dataunit", (QFilter[])new QFilter("billtype", "=", (Object)this.billEntityType.getName()).and(new QFilter("genrecode", "=", (Object)"1")).and(new QFilter("oper", "like", (Object)(operationKey + ",%")).or("oper", "like", (Object)("%," + operationKey)).or("oper", "like", (Object)("%," + operationKey + ",%")).or("oper", "=", (Object)operationKey).or(new QFilter("reoper", "=", (Object)operationKey))).toArray());
            if (checkResult != null) {
                return checkResult;
            }
        }
        catch (Exception ex) {
            logger.error(ex.getMessage() + ": \u67e5\u8be2\u6570\u636e\u96c6\u5e02\u53d6\u6570\u914d\u7f6e\u7684\u9519\u8bef", (Throwable)ex);
        }
        return null;
    }

    public void endOperationTransaction(EndOperationTransactionArgs args) {
        block8: {
            DynamicObject dataUnit = this.getDataUnitId(args.getOperationKey());
            if (dataUnit == null) {
                return;
            }
            Long dataUnitId = dataUnit.getLong("id");
            if (dataUnit.get("datasource") == null) {
                return;
            }
            Long dataSourceId = ((DynamicObject)dataUnit.get("datasource")).getLong("id");
            String billnoKey = dataUnit.getString("srcbillno.fieldkey");
            String bizdateKey = dataUnit.getString("srcbizdate.fieldkey");
            String orgKey = dataUnit.getString("srcorg.fieldkey");
            Date recTime = new Date(System.currentTimeMillis());
            HashMap<String, Object> params = new HashMap<String, Object>();
            LinkedHashMap dataMap = new LinkedHashMap();
            params.put("dataTypeKey", this.billEntityType.getName());
            params.put("operationKey", args.getOperationKey());
            params.put("recTime", recTime);
            params.put("dataSourceType", CATEGORY_DATAMARKET);
            params.put("msgChannel", JMS_Queue_PA_AUTOT_Job);
            params.put("dataUnitId", dataUnitId);
            params.put("dataMap", dataMap);
            params.put("dataSourceId", dataSourceId);
            if (args.getDataEntities() != null) {
                Object org_id = null;
                Object bizdate = null;
                Object billno = null;
                for (DynamicObject obj : args.getDataEntities()) {
                    if (obj == null) continue;
                    HashMap<String, Object> rowDataMap = new HashMap<String, Object>();
                    try {
                        org_id = obj.get(orgKey);
                        bizdate = obj.get(bizdateKey);
                        billno = obj.get(billnoKey);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    dataMap.put(obj.get("id"), rowDataMap);
                    rowDataMap.put("org", org_id);
                    rowDataMap.put("bizdate", bizdate);
                    rowDataMap.put("billno", billno);
                }
                try {
                    this.sendJMSMessage(JMS_Queue_PA_Region, JMS_Queue_PA_AUTOT_Job, params);
                }
                catch (Exception ex) {
                    logger.error(String.format("Send DataMartket Msg Error:%s. dataMap=%s", ex.getMessage(), dataMap), (Throwable)ex);
                    if (this.canSkipError()) break block8;
                    throw ex;
                }
            }
        }
    }

    public void sendJMSMessage(String region, String queueName, Map<String, Object> params) throws KDBizException {
        MessagePublisher mp;
        if (region == null || queueName == null) {
            throw new KDBizException("JMS Region or Queue is null! Please Check BOS Configuration");
        }
        String errorMsg = String.format("Create JMS Message Publisher failed(region=%s, queueName=%s, params=%s)! Please Check BOS Configuration", region, queueName, params);
        try {
            mp = MQFactory.get().createSimplePublisher(region, queueName);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", errorMsg), new Object[0]);
        }
        if (mp == null) {
            throw new KDBizException(errorMsg);
        }
        errorMsg = String.format("Send Jms Message Failed(region=%s, queueName=%s, params=%s)! Please Check BOS Configuration", region, queueName, params);
        try {
            mp.publish(params);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException((Throwable)ex, new ErrorCode("", errorMsg), new Object[0]);
        }
        finally {
            mp.close();
        }
    }
}

