/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.bizrule;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DBServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;

public interface BgControlOpAction {
    public static final Log log = LogFactory.getLog(BgControlOpAction.class);

    default public void doAction(DynamicObject[] bills, String methodName, String operationKey) {
        String bizId;
        String entityNumber;
        if (bills == null || bills.length == 0 || methodName == null || operationKey == null) {
            return;
        }
        String billNumProp = null;
        DBRoute eb = DBRoute.of((String)"epm");
        Date date = new Date();
        String sql = "insert into t_eb_bgcontroloperlog (fid, fentitynumber, fbillid, fbillnumber, fcreatedate, foperation) values (?,?,?,?,?,?)";
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(bills.length);
        for (DynamicObject bill : bills) {
            entityNumber = bill.getDataEntityType().getName();
            bizId = bill.getString("id");
            if (billNumProp == null) {
                if (bill.getDataEntityType().getProperties().containsKey((Object)"billno")) {
                    billNumProp = "billno";
                } else if (bill.getDataEntityType().getProperties().containsKey((Object)"number")) {
                    billNumProp = "number";
                }
            }
            String billNumber = billNumProp != null ? bill.getString(billNumProp) : null;
            sqlParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, billNumber, date, operationKey});
        }
        try (TXHandle tx = TX.requiresNew((String)"eb/BgReturnBudgetOpAction/beginOperationTransaction");){
            try {
                DB.executeBatch((DBRoute)eb, (String)sql, sqlParams);
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
        HashMap<String, Set> fieldMap = new HashMap<String, Set>(10);
        Set fieldList = null;
        for (DynamicObject bill : bills) {
            entityNumber = bill.getDataEntityType().getName();
            bizId = bill.getString("id");
            DynamicObject requestBill = bill;
            if (this.useDynamicObject()) {
                if (fieldMap.containsKey(entityNumber)) {
                    fieldList = (Set)fieldMap.get(entityNumber);
                } else {
                    boolean isSimpleField = false;
                    fieldList = null;
                    try {
                        isSimpleField = (Boolean)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"isSimpleField", (Object[])new Object[]{entityNumber});
                        log.info("BgControlOpAction-isSimpleField=" + isSimpleField);
                        if (isSimpleField) {
                            fieldList = (Set)DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)"getQueryField", (Object[])new Object[]{entityNumber});
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    fieldMap.put(entityNumber, fieldList);
                }
                if (fieldList != null) {
                    try {
                        requestBill = this.clone(bill, fieldList, "");
                    }
                    catch (Throwable e) {
                        log.info("clone-error{}", (Object)e);
                    }
                }
            }
            try {
                Object result = this.invokeBizService(methodName, requestBill, entityNumber, bizId, operationKey);
                if (result == null) continue;
                this.setBillWarningFlag(result, bill);
            }
            catch (Throwable ex) {
                if (ex instanceof UndeclaredThrowableException) {
                    UndeclaredThrowableException utException = (UndeclaredThrowableException)ex;
                    if (utException.getUndeclaredThrowable() instanceof InvocationTargetException) {
                        InvocationTargetException _exception = (InvocationTargetException)utException.getUndeclaredThrowable();
                        throw new KDBizException(_exception.getTargetException().getMessage());
                    }
                    throw new KDBizException(utException.getUndeclaredThrowable().getMessage());
                }
                throw ex;
            }
        }
    }

    default public DynamicObject clone(DynamicObject bill, Set<String> fieldList, String priv) {
        if (bill == null || fieldList == null || fieldList.isEmpty()) {
            return bill;
        }
        IDataEntityType dt = bill.getDataEntityType();
        DynamicObject clone = (DynamicObject)dt.createInstance();
        clone.set(dt.getPrimaryKey().getName(), bill.getPkValue());
        String fullProp = null;
        String propname = null;
        Object value = null;
        for (IDataEntityProperty sp : dt.getProperties()) {
            propname = sp.getName();
            if (sp.getReadOnly()) continue;
            fullProp = propname;
            if (priv != null && priv.length() > 0) {
                fullProp = priv + "." + fullProp;
            }
            if (!"seq".equals(propname) && !fieldList.contains(fullProp)) continue;
            value = sp.getValue((Object)bill);
            if (value instanceof DynamicObject) {
                value = this.clone((DynamicObject)value, fieldList, fullProp);
                sp.setValue((Object)clone, value);
                continue;
            }
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection valueCol = (DynamicObjectCollection)value;
                DynamicObjectCollection cloneCol = clone.getDynamicObjectCollection(sp);
                for (DynamicObject entry : valueCol) {
                    cloneCol.add((Object)this.clone(entry, fieldList, fullProp));
                }
                continue;
            }
            if (value == null) continue;
            sp.setValue((Object)clone, value);
        }
        return clone;
    }

    default public void rollBack(DynamicObject[] bills, String methodName) {
        String entityNumber = null;
        String billNumProp = null;
        DBRoute eb = DBRoute.of((String)"epm");
        Date date = new Date();
        String sql = "insert into t_eb_bgcontroloperlog (fid, fentitynumber, fbillid, fbillnumber, fcreatedate, foperation) values (?,?,?,?,?,?)";
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>(bills.length);
        for (DynamicObject bill : bills) {
            entityNumber = bill.getDataEntityType().getName();
            String bizId = bill.getString("id");
            if (billNumProp == null) {
                if (bill.getDataEntityType().getProperties().containsKey((Object)"billno")) {
                    billNumProp = "billno";
                } else if (bill.getDataEntityType().getProperties().containsKey((Object)"number")) {
                    billNumProp = "number";
                }
            }
            String billNumber = billNumProp != null ? bill.getString(billNumProp) : null;
            sqlParams.add(new Object[]{DBServiceHelper.genGlobalLongId(), entityNumber, bizId, billNumber, date, methodName});
        }
        try (TXHandle tx = TX.requiresNew((String)"eb/BgReturnBudgetOpAction/beginOperationTransaction");){
            try {
                DB.executeBatch((DBRoute)eb, (String)sql, sqlParams);
            }
            catch (Exception ex) {
                tx.markRollback();
                throw ex;
            }
        }
        if (entityNumber == null) {
            return;
        }
        try {
            Set ids = Arrays.stream(bills).map(k -> k.getString("id")).collect(Collectors.toSet());
            DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)methodName, (Object[])new Object[]{entityNumber, ids});
        }
        catch (Exception e) {
            log.error("rollback-error,", (Throwable)e);
        }
    }

    default public Object invokeBizService(String methodName, DynamicObject bill, String entityNumber, String bizId, String operationKey) {
        if (this.useDynamicObject()) {
            return DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)methodName, (Object[])new Object[]{bill, operationKey});
        }
        return DispatchServiceHelper.invokeBizService((String)"epm", (String)"eb", (String)"BgControlService", (String)methodName, (Object[])new Object[]{entityNumber, bizId, operationKey});
    }

    default public String getRollBackMethod() {
        return null;
    }

    default public boolean useDynamicObject() {
        return true;
    }

    default public void setBillWarningFlag(Object result, DynamicObject bill) {
    }
}

