/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MainOrgProp;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.ext.fi.fa.business.util.FiBillParamUtil;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfo;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterInfoAccessor;
import kd.bos.ext.fi.gl.closeperiod.BookRegisterService;
import kd.bos.ext.fi.lock.ShareLockResult;
import kd.bos.ext.fi.operation.closeperiod.option.ClosePeriodOption;
import kd.bos.ext.fi.operation.closeperiod.validator.AntiClosePeriodValidator;
import kd.bos.log.api.AppLogInfo;
import kd.bos.log.api.ILogService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.service.operation.EntityOperateService;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.CollectionUtils;

public class AntiClosePeriodService
extends EntityOperateService {
    private static final Log LOG = LogFactory.getLog(AntiClosePeriodService.class);
    private BookRegisterInfo bookRegisterInfo;
    private BookRegisterInfoAccessor bookRegisterInfoAccessor;
    private List<ShareLockResult> shareLockResults;

    public void initialize(MainEntityType entityType, String operationKey, DynamicObject[] dataEntities) {
        super.initialize(entityType, operationKey, dataEntities);
        this.bookRegisterInfo = BookRegisterService.queryByBizApp(ClosePeriodOption.getBizAppNumber(this.getOption(), this.billEntityType.getBizAppNumber()));
        this.bookRegisterInfoAccessor = new BookRegisterInfoAccessor(this.bookRegisterInfo);
        this.shareLockResults = new ArrayList<ShareLockResult>(10);
    }

    protected void preparePropertys(List<String> fieldKeys) {
        super.preparePropertys(fieldKeys);
        fieldKeys.add(this.bookRegisterInfo.getOrgFieldOnCloseEntity());
        String bookTypeFieldOnBookMetaData = this.bookRegisterInfo.getBookTypeFieldOnCloseEntity();
        if (kd.bos.util.StringUtils.isNotEmpty((String)bookTypeFieldOnBookMetaData)) {
            fieldKeys.add(this.bookRegisterInfo.getBookTypeFieldOnCloseEntity());
        }
    }

    protected void addDefaultValidator(List<AbstractValidator> validators) {
        super.addDefaultValidator(validators);
        validators.add(new AntiClosePeriodValidator(this.bookRegisterInfo, this.shareLockResults));
    }

    protected void executeOperate(DynamicObject[] dataEntities) {
    }

    protected void callOperationTransaction(DynamicObject[] objs) throws Exception {
        try (TXHandle h = TX.required((String)(this.billEntityType.getName() + "." + this.operationKey));){
            try {
                super.callOperationTransaction(objs);
                this.invokeReconService(objs);
            }
            catch (Exception ex) {
                h.markRollback();
                throw ex;
            }
        }
    }

    protected void invokeReconService(DynamicObject[] objs) {
        if ("ar".equals(this.bookRegisterInfo.getBizApp()) || "ap".equals(this.bookRegisterInfo.getBizApp())) {
            boolean existsFrmSnapshot = FiBillParamUtil.existsParamType("1VUEMJU4W57X", "balance_from_snapshot");
            if (!existsFrmSnapshot) {
                return;
            }
            Set<Object> failedIds = this.getFailedIds();
            ArrayList<Long> orgList = new ArrayList<Long>(objs.length);
            ArrayList<Long> periodList = new ArrayList<Long>(objs.length);
            for (DynamicObject book : objs) {
                if (failedIds.contains(book.getPkValue())) continue;
                long orgId = this.bookRegisterInfoAccessor.getCloseOrgId(book);
                long curPeriodId = book.getLong("curperiod");
                orgList.add(orgId);
                periodList.add(curPeriodId);
            }
            HashMap<String, Object> paramMap = new HashMap<String, Object>(6);
            paramMap.put("appId", BizAppServiceHelp.getAppIdByAppNumber((String)this.bookRegisterInfo.getBizApp()));
            paramMap.put("bizOrgId", orgList);
            paramMap.put("periodId", periodList);
            Map resultMap = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"disableSnapShot", (Object[])new Object[]{paramMap});
            boolean success = true;
            String errorMsg = "";
            if (resultMap == null) {
                success = false;
                errorMsg = ResManager.loadKDString((String)"\u5bf9\u8d26\u5feb\u7167\u6570\u636e\u5931\u6548\u5931\u8d25", (String)"AntiClosePeriodService_1", (String)"bos-ext-fi", (Object[])new Object[0]);
            } else {
                success = Boolean.parseBoolean(resultMap.get("success").toString());
                if (!success) {
                    errorMsg = (String)resultMap.get("message");
                }
            }
            if (!success) {
                throw new KDBizException(errorMsg);
            }
        }
    }

    protected void release() {
        try {
            this.releaseShareLock();
        }
        finally {
            super.release();
        }
    }

    private Set<Object> getFailedIds() {
        return this.getOperationResult().getAllErrorOrValidateInfo().stream().map(IOperateInfo::getPkValue).collect(Collectors.toSet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseShareLock() {
        if (CollectionUtils.isEmpty(this.shareLockResults)) {
            return;
        }
        try {
            for (ShareLockResult shareLockResult : this.shareLockResults) {
                try {
                    shareLockResult.close();
                }
                catch (Exception e) {
                    LOG.error("AntiClosePeriod release share lock failed, key: " + shareLockResult.getKey(), (Throwable)e);
                }
            }
        }
        finally {
            this.shareLockResults.clear();
        }
    }

    protected void writeLog(OperationResult opResult) {
        if ("gl_autocloseperiod".equalsIgnoreCase(this.getBillEntityType().getName())) {
            return;
        }
        if (this.getExtendDataEntitySet().FindByEntityKey(this.subEntityType.getName()).length > 1) {
            super.writeLog(opResult);
        } else {
            this.writeOneLog(opResult);
        }
    }

    private void writeOneLog(OperationResult opResult) {
        if (opResult.isCancelWriteLog()) {
            this.getOperateLog().info("EntityOperateService.writeLog: isCancelWriteLog");
            return;
        }
        this.getOperateLog().info("EntityOperateService.writeLog: begin");
        ILogService logService = (ILogService)ServiceFactory.getService(ILogService.class);
        ArrayList<AppLogInfo> appLogInfoList = new ArrayList<AppLogInfo>(10);
        IDataEntityProperty billNoProp = null;
        MainOrgProp mainOrgProp = null;
        if (this.subEntityType instanceof BasedataEntityType) {
            BasedataEntityType bdType = (BasedataEntityType)this.subEntityType;
            if (StringUtils.isNotBlank((CharSequence)bdType.getNumberProperty())) {
                billNoProp = this.subEntityType.findProperty(bdType.getNumberProperty());
            }
            mainOrgProp = bdType.getMainOrgProperty();
        } else if (this.subEntityType instanceof BillEntityType) {
            billNoProp = this.subEntityType.findProperty(((BillEntityType)this.subEntityType).getBillNo());
            mainOrgProp = ((BillEntityType)this.subEntityType).getMainOrgProperty();
        }
        List errorInfos = opResult.getAllErrorOrValidateInfo();
        appLogInfoList = new ArrayList(10);
        HashSet<Long> errorIds = new HashSet<Long>();
        if (!errorInfos.isEmpty()) {
            ExtendedDataEntity[] billDataEntitys = this.getExtendDataEntitySet().FindByEntityKey(this.subEntityType.getName());
            HashMap<Object, DynamicObject> map = new HashMap<Object, DynamicObject>(billDataEntitys.length);
            for (ExtendedDataEntity dataEntity : billDataEntitys) {
                map.put(dataEntity.getDataEntity().get("id"), dataEntity.getDataEntity());
            }
            for (IOperateInfo errorInfo : errorInfos) {
                Long mainOrgId = 0L;
                DynamicObject billObj = (DynamicObject)map.get(errorInfo.getPkValue());
                if (mainOrgProp != null && billObj != null) {
                    Object value = mainOrgProp.getValue((Object)billObj);
                    if (value instanceof DynamicObject) {
                        DynamicObject mainOrg = (DynamicObject)value;
                        mainOrgId = (Long)mainOrg.getPkValue();
                    }
                    errorIds.add(billObj.getLong("id"));
                }
                String message = this.appendMessage(errorInfo.getMessage(), billObj);
                AppLogInfo logInfo = this.buildLogInfo(message, mainOrgId);
                appLogInfoList.add(logInfo);
            }
            if (!appLogInfoList.isEmpty()) {
                logService.addBatchLog(appLogInfoList);
            }
        }
        for (DynamicObject successObj : this.getSuccessDataEntities()) {
            Object value;
            if (errorIds.contains(successObj.get("id"))) {
                return;
            }
            String msg = "";
            String billNo = billNoProp == null ? "" : (String)billNoProp.getValue((Object)successObj);
            msg = StringUtils.isBlank((CharSequence)billNo) ? String.format(ResManager.loadKDString((String)"%s\u6210\u529f", (String)"EntityOperateService_16", (String)"bos-mservice-operation", (Object[])new Object[0]), this.getOpName()) : String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s\uff0c%2$s\u6210\u529f", (String)"EntityOperateService_17", (String)"bos-mservice-operation", (Object[])new Object[0]), billNo, this.getOpName());
            Long mainOrgId = 0L;
            if (mainOrgProp != null && (value = mainOrgProp.getValue((Object)successObj)) instanceof DynamicObject) {
                DynamicObject mainOrg = (DynamicObject)value;
                mainOrgId = (Long)mainOrg.getPkValue();
            }
            AppLogInfo logInfo = this.buildLogInfo(msg, mainOrgId);
            appLogInfoList.add(logInfo);
            if (appLogInfoList.isEmpty()) continue;
            logService.addBatchLog(appLogInfoList);
        }
        opResult.setCancelWriteLog(true);
        this.getOperateLog().info("EntityOperateService.writeLog: end");
    }

    private String appendMessage(String message, DynamicObject billObj) {
        try {
            DynamicObject typeField = QueryServiceHelper.queryOne((String)"bd_accountbookregister", (String)"booktypefieldid", (QFilter[])new QFilter("bizapp", "=", (Object)this.billEntityType.getAppId()).toArray());
            String field = typeField.getString("booktypefieldid");
            if (StringUtils.isNotBlank((CharSequence)field)) {
                BasedataProp prop = (BasedataProp)billObj.getDataEntityType().getProperties().get((Object)field);
                DynamicObject typeName = QueryServiceHelper.queryOne((String)prop.getBaseEntityId(), (String)"name", (QFilter[])new QFilter("id", "=", billObj.get(field)).toArray());
                return typeName == null ? message : typeName.get("name") + ": " + message;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return message;
    }
}

