/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.fcm.ExecuteStatus;
import kd.bos.ext.fi.fcm.mservice.CheckItemDetail;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;

public class ClosePeriodCheckService {
    private static final Log LOGGER = LogFactory.getLog(ClosePeriodCheckService.class);
    public static Map<String, String> APP_CONFIG = new HashMap<String, String>();
    private static IAppCache CACHE = AppCache.get((String)"gl");

    protected static void executeOperate(DynamicObject[] objs, OperateOption options, OperationResult operationResult) {
        String appNumber = options.getVariableValue("bizapp", "");
        String cacheKey = "periodClose_" + options.getVariableValue("closeCacheKey");
        LOGGER.info("close_check_appNumber:" + appNumber);
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && !"gl".equalsIgnoreCase(appNumber)) {
            LOGGER.info("close_check_begin");
            DynamicObject bizBook = objs[0];
            Long acctOrg = (Long)bizBook.getDynamicObject("org").getPkValue();
            String booktypeField = options.getVariableValue("booktype", "");
            Long currperiod = ClosePeriodCheckService.getPrePeriod(Long.parseLong(options.getVariableValue("reachperiod", "0")));
            if (currperiod.equals(0L)) {
                LOGGER.info("close_check_no_period");
                return;
            }
            String bookTypeId = null;
            if (StringUtils.isNotBlank((CharSequence)booktypeField)) {
                bookTypeId = String.valueOf(bizBook.getLong(booktypeField));
            }
            String operationId = options.getVariableValue("operationId", "");
            CheckItemExecutionParam executionParam = new CheckItemExecutionParam(BizAppServiceHelp.getAppIdByAppNumber((String)appNumber), bookTypeId, acctOrg, currperiod, null, operationId);
            CheckExecutionResult result = ClosePeriodCheckExecutor.instance.execute(executionParam);
            List<CheckExecutionResult.CheckResultWrapper> itemCheckResultList = result.getItemCheckResultList();
            String s = (String)CACHE.get(cacheKey, String.class);
            DynamicObject sd = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)s, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem"));
            DynamicObjectCollection entitys = sd.getDynamicObjectCollection("entryentity");
            for (CheckExecutionResult.CheckResultWrapper checkResultWrapper : itemCheckResultList) {
                ClosePeriodCheckService.setCheckInfo(entitys, checkResultWrapper);
            }
            if (!result.isFinalApproval()) {
                operationResult.setSuccess(false);
                OperateErrorInfo error = new OperateErrorInfo();
                error.setErrorLevel(ErrorLevel.Error.toString());
                StringBuilder sb = new StringBuilder();
                for (DynamicObject dyo : entitys) {
                    if (!"0".equals(dyo.getString("checkstate"))) continue;
                    sb.append(dyo.get("checkitem"));
                    sb.append("\t");
                }
                error.setMessage(sb.toString());
                if (StringUtils.isNotBlank((CharSequence)booktypeField)) {
                    error.setPkValue((Object)bizBook.getLong(booktypeField));
                }
                LOGGER.info("operationResult getAllErrorInfo:" + operationResult.getAllErrorInfo());
                operationResult.getAllErrorInfo().clear();
                operationResult.getAllErrorInfo().add(error);
            }
            CACHE.put(cacheKey, (Object)DataEntitySerializer.serializerToString((Object)sd));
        }
    }

    private static Long getPrePeriod(Long reachperiod) {
        if (reachperiod == null) {
            return 0L;
        }
        String entityName = "bd_period";
        String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)reachperiod, (String)entityName);
        Object periodtypeid = currPeriod.get("periodtype_id");
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(8);
        qFilters.add(new QFilter("id", "<", (Object)reachperiod));
        qFilters.add(new QFilter("periodtype", "=", periodtypeid));
        qFilters.add(new QFilter("isadjustperiod", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection perPeriods = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])qFilters.toArray(new QFilter[0]), (String)"id desc", (int)1);
        if (perPeriods == null || perPeriods.size() == 0) {
            return 0L;
        }
        return ((DynamicObject)perPeriods.get(0)).getLong("id");
    }

    private static void setCheckInfo(DynamicObjectCollection entitys, CheckExecutionResult.CheckResultWrapper checkResultWrapper) {
        CheckItemDetail checkItem = checkResultWrapper.getCheckItem();
        ExecuteStatus executeStatus = checkResultWrapper.getExecuteStatus();
        String errMsg = checkResultWrapper.getErrMsg();
        if (ExecuteStatus.PASS == executeStatus) {
            ClosePeriodCheckService.setSuccessInfo(entitys, checkItem.getName(), "1", checkItem.getCustomizeIcon());
        } else if (ExecuteStatus.FAIL == executeStatus) {
            String onlineViewId;
            if (StringUtils.isBlank((CharSequence)errMsg)) {
                errMsg = checkItem.getName();
            }
            if (StringUtils.isNotBlank((CharSequence)(onlineViewId = checkItem.getOnlineViewId()))) {
                errMsg = null;
            }
            String filterStr = "";
            QFilter[] billFilters = checkResultWrapper.getBillFilters();
            if (!Objects.isNull(billFilters) && billFilters.length > 0) {
                QFilter filter = null;
                for (QFilter qFilter : billFilters) {
                    filter = null == filter ? qFilter : filter.and(qFilter);
                }
                if (null != filter) {
                    filterStr = filter.toSerializedString();
                }
            }
            ClosePeriodCheckService.setCheckInfo(entitys, checkItem.getName(), "0", filterStr, onlineViewId, errMsg, checkItem.getCustomizeIcon());
        } else {
            ClosePeriodCheckService.setCheckInfo(entitys, checkItem.getName(), "0", null, null, errMsg, checkItem.getCustomizeIcon());
        }
    }

    private static DynamicObject setCheckInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String formquery, String formnumber, String message, String menuid) {
        DynamicObject entity = ClosePeriodCheckService.setSuccessInfo(entitys, checkitem, checkstate, menuid);
        entity.set("formquery", (Object)formquery);
        entity.set("formnumber", (Object)formnumber);
        entity.set("message", (Object)message);
        return entity;
    }

    private static DynamicObject setSuccessInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String menuid) {
        DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
        entity.set("checkitem", (Object)checkitem);
        entity.set("checkstate", (Object)checkstate);
        if (StringUtils.isBlank((CharSequence)menuid)) {
            menuid = "kingdee/fi/images/pc/icon/menu/7qmjz_48_48.png";
        }
        entity.set("menuid", (Object)menuid);
        entitys.add((Object)entity);
        return entity;
    }

    static {
        APP_CONFIG.put("fa", "assetbook");
        APP_CONFIG.put("cal", "costaccount");
        APP_CONFIG.put("ar", "policybook");
    }
}

