/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod;

import com.alibaba.fastjson.JSONObject;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.DataEntitySerializer;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.cache.AppCache;
import kd.bos.entity.cache.IAppCache;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class IntellCheckService {
    private static final Log logger = LogFactory.getLog(IntellCheckService.class);
    private static final String FAIL = "2";
    private static final String ERROR = "7";
    public static Map<String, String> appConfig = new HashMap<String, String>();
    private static IAppCache cache = AppCache.get((String)"gl");

    protected static void executeOperate(DynamicObject[] objs, OperateOption options, OperationResult operationResult) {
        String appNumber = options.getVariableValue("bizapp", "");
        String cacheKey = "periodClose_" + options.getVariableValue("closeCacheKey");
        logger.info("con_check_appNumber:" + appNumber);
        if (StringUtils.isNotEmpty((CharSequence)appNumber) && !"gl".equalsIgnoreCase(appNumber)) {
            Long bizBookId;
            logger.info("con_check_begin");
            DynamicObject bizBook = objs[0];
            Long acctOrg = (Long)bizBook.getDynamicObject("org").getPkValue();
            HashMap<String, Object> param = new HashMap<String, Object>(5);
            String booktypeField = options.getVariableValue("booktype", "");
            QFilter typeFilter = null;
            if (StringUtils.isNotEmpty((CharSequence)booktypeField)) {
                Long typeId = bizBook.getLong(booktypeField);
                typeFilter = new QFilter(booktypeField, "=", (Object)typeId);
            }
            QFilter orgFilter = new QFilter("org", "=", (Object)acctOrg);
            String bizBookEntity = bizBook.getDataEntityType().getName();
            if ("ar".equalsIgnoreCase(appNumber)) {
                bizBookEntity = "ar_policy";
            }
            Long l = bizBookId = (bizBook = QueryServiceHelper.queryOne((String)bizBookEntity, (String)"id", (QFilter[])new QFilter[]{typeFilter, orgFilter})) == null ? null : Long.valueOf(bizBook.getLong("id"));
            if ("ap".equalsIgnoreCase(appNumber) || "cas".equalsIgnoreCase(appNumber)) {
                bizBookId = 0L;
            }
            Long currperiod = IntellCheckService.getPrePeriod(Long.parseLong(options.getVariableValue("reachperiod", "0")));
            Long periodId = IntellCheckService.getPeriodId(appNumber, bizBookId, acctOrg);
            if (periodId.equals(0L) || currperiod.equals(0L)) {
                logger.info("con_check_no_period");
                return;
            }
            param.put("periodId", currperiod);
            param.put("appNumber", appNumber);
            param.put("bizBookId", bizBookId);
            param.put("orgId", acctOrg);
            param.put("init", false);
            String s = (String)cache.get(cacheKey, String.class);
            DynamicObject sd = (DynamicObject)DataEntitySerializer.deSerializerFromString((String)s, (IDataEntityType)EntityMetadataCache.getDataEntityType((String)"bd_closecheckitem"));
            sd.getDynamicObjectCollection("entryentity");
            IntellCheckService.check(operationResult, param, sd.getDynamicObjectCollection("entryentity"));
            cache.put(cacheKey, (Object)DataEntitySerializer.serializerToString((Object)sd));
        }
    }

    private static Long getPrePeriod(Long reachperiod) {
        QFilter isAdjust;
        if (reachperiod == null) {
            return 0L;
        }
        String entityName = "bd_period";
        String selector = "id,name,periodtype.id periodtype_id,periodyear,periodnumber,begindate,enddate";
        QFilter filterDate = new QFilter("id", "<", (Object)reachperiod);
        DynamicObject currPeriod = BusinessDataServiceHelper.loadSingle((Object)reachperiod, (String)entityName);
        Object periodtypeid = currPeriod.get("periodtype_id");
        QFilter filterType = new QFilter("periodtype.id", "=", periodtypeid);
        DynamicObjectCollection perPeriods = QueryServiceHelper.query((String)entityName, (String)selector, (QFilter[])new QFilter[]{filterDate, filterType, isAdjust = new QFilter("isadjustperiod", "=", (Object)false)}, (String)"id desc", (int)1);
        if (perPeriods == null || perPeriods.size() == 0) {
            return 0L;
        }
        return ((DynamicObject)perPeriods.get(0)).getLong("id");
    }

    private static Long getPeriodId(String appNumber, Long bizBookId, Long acctOrgId) {
        QFilter orgFilter = new QFilter("org", "=", (Object)acctOrgId);
        QFilter enableFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        DynamicObject[] acctBooks = null;
        if (appConfig.get(appNumber) != null) {
            String acctorgSelectFields = "org.id,curperiod.id," + appConfig.get(appNumber) + ".id";
            for (DynamicObject acctBook : acctBooks = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)acctorgSelectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter})) {
                DynamicObjectCollection bizBooks = (DynamicObjectCollection)acctBook.get(appConfig.get(appNumber));
                if (bizBooks == null || bizBooks.size() == 0) continue;
                for (DynamicObject eachBook : bizBooks) {
                    if (bizBookId.longValue() != eachBook.getLong("fbasedataid_id")) continue;
                    return acctBook.getLong("curperiod_id");
                }
            }
        } else {
            QFilter booksTypeFilter = null;
            if (bizBookId == null || bizBookId == 0L) {
                booksTypeFilter = new QFilter("bookstype.accounttype", "=", (Object)Character.valueOf('1'));
            }
            String acctorgSelectFields = "org.id,curperiod.id";
            acctBooks = BusinessDataServiceHelper.load((String)"gl_accountbook", (String)acctorgSelectFields, (QFilter[])new QFilter[]{orgFilter, enableFilter, booksTypeFilter});
            return acctBooks.length > 0 ? acctBooks[0].getLong("curperiod_id") : 0L;
        }
        return 0L;
    }

    private static void check(OperationResult operationResult, Map param, DynamicObjectCollection entitys) {
        String result;
        String errorCode;
        String errorMsg;
        String icon;
        block6: {
            icon = "/icons/pc/entrance/zz_pztx_48_48.png";
            errorMsg = null;
            errorCode = null;
            result = null;
            try {
                logger.info("con_check_mservice,param:" + JSONObject.toJSONString((Object)param));
                result = (String)DispatchServiceHelper.invokeBizService((String)"fi", (String)"frm", (String)"ReconciliationService", (String)"execute", (Object[])new Object[]{JSONObject.toJSONString((Object)param)});
            }
            catch (KDBizException e) {
                errorMsg = e.getMessage();
                errorCode = e.getErrorCode().getCode();
                if (e.getArgs().length <= 0) break block6;
                result = e.getArgs()[0].toString();
            }
        }
        logger.info("con_check_result:" + errorMsg);
        if (errorMsg != null) {
            logger.info("con_check_result:error");
            if (FAIL.equals(errorCode)) {
                IntellCheckService.setCheckInfo(entitys, ResManager.loadKDString((String)"\u672c\u671f\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\u3002", (String)"ClosePeriodOp_28", (String)"bos-ext-fi", (Object[])new Object[0]), "0", result, "frm_reconciliation_rst_fst", null, icon);
            } else if (ERROR.equals(errorCode)) {
                IntellCheckService.setCheckInfo(entitys, ResManager.loadKDString((String)"\u672c\u671f\u4e0e\u603b\u8d26\u5bf9\u8d26\u4e0d\u5e73\u3002", (String)"ClosePeriodOp_28", (String)"bos-ext-fi", (Object[])new Object[0]), "0", result, null, errorMsg, icon);
            }
            operationResult.setSuccess(false);
            return;
        }
        logger.info("con_check_result:success");
        IntellCheckService.setSuccessInfo(entitys, ResManager.loadKDString((String)"\u671f\u672b\u5bf9\u8d26\u68c0\u67e5", (String)"ClosePeriodOp_29", (String)"bos-ext-fi", (Object[])new Object[0]), "1", icon);
    }

    private static DynamicObject setCheckInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String formquery, String formnumber, String message, String menuid) {
        DynamicObject entity = IntellCheckService.setSuccessInfo(entitys, checkitem, checkstate, menuid);
        entity.set("formquery", (Object)formquery);
        entity.set("formnumber", (Object)formnumber);
        entity.set("message", (Object)message);
        return entity;
    }

    private static DynamicObject setSuccessInfo(DynamicObjectCollection entitys, String checkitem, String checkstate, String menuid) {
        DynamicObject entity = new DynamicObject(entitys.getDynamicObjectType());
        entity.set("checkitem", (Object)checkitem);
        entity.set("checkstate", (Object)checkstate);
        entity.set("menuid", (Object)menuid);
        entitys.add((Object)entity);
        return entity;
    }

    static {
        appConfig.put("fa", "assetbook");
        appConfig.put("cal", "costaccount");
        appConfig.put("ar", "policybook");
    }
}

