/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.result;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.result.ClosePeriodResultServiceHelper;
import kd.bos.util.StringUtils;

public class ClosePeriodResultCollector
implements AutoCloseable {
    private final Map<String, List<CloseCheckItemResult>> results;
    private final OperateOption operateOption;
    private final String closeEventId;

    public ClosePeriodResultCollector(OperateOption operateOption, String closeEventId) {
        this.operateOption = operateOption;
        this.closeEventId = closeEventId;
        this.results = new HashMap<String, List<CloseCheckItemResult>>();
    }

    public void collect(long orgId, long bookTypeId, CloseCheckItemResult result) {
        this.collect(bookTypeId > 0L ? orgId + "_" + bookTypeId : String.valueOf(orgId), result);
    }

    public void collect(String resultKey, CloseCheckItemResult result) {
        this.results.computeIfAbsent(resultKey, k -> new ArrayList(10)).add(result);
    }

    public void collect(String resultKey, Collection<CloseCheckItemResult> results) {
        this.results.computeIfAbsent(resultKey, k -> new ArrayList(10)).addAll(results);
    }

    @Override
    public void close() {
        String closeCacheKey = this.operateOption.getVariableValue("closeCacheKey", "");
        if (StringUtils.isNotEmpty((String)closeCacheKey)) {
            this.results.forEach((resultKey, resultList) -> ClosePeriodResultServiceHelper.recordItemResult(closeCacheKey, resultList));
        } else if (StringUtils.isNotEmpty((String)this.closeEventId)) {
            this.results.forEach((resultKey, resultList) -> ClosePeriodResultServiceHelper.recordItemResult(this.closeEventId + resultKey, resultList));
        }
    }
}

