/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import com.google.common.collect.Table;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.ext.fi.fcm.CheckExecutionResult;
import kd.bos.ext.fi.fcm.CheckItemExecutionParam;
import kd.bos.ext.fi.fcm.ClosePeriodCheckExecutor;
import kd.bos.ext.fi.operation.closeperiod.ClosePeriodService;
import kd.bos.ext.fi.operation.closeperiod.option.ClosePeriodOption;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.servicehelper.devportal.BizAppServiceHelp;
import kd.bos.util.StringUtils;

public class ClosePeriodCheckItemValidator
extends AbstractClosePeriodValidator {
    private final Table<Long, Long, ClosePeriodService.CloseData> closeDataTable;

    public ClosePeriodCheckItemValidator(Table<Long, Long, ClosePeriodService.CloseData> closeDataTable) {
        this.closeDataTable = closeDataTable;
    }

    @Override
    public void doValidate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String orgProp = this.getBookRegisterInfo().getOrgFieldOnCloseEntity();
        String bookTypeProp = this.getBookRegisterInfo().getBookTypeFieldOnCloseEntity();
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject data = dataEntity.getDataEntity();
            long orgId = data.getLong(orgProp + ".id");
            long bookTypeId = StringUtils.isNotEmpty((String)bookTypeProp) ? data.getLong(bookTypeProp + ".id") : 0L;
            ClosePeriodService.CloseData closeData = (ClosePeriodService.CloseData)this.closeDataTable.get((Object)orgId, (Object)bookTypeId);
            if (closeData == null) continue;
            CheckItemExecutionParam executionParam = new CheckItemExecutionParam(BizAppServiceHelp.getAppIdByAppNumber((String)this.getAppNumber()), StringUtils.isEmpty((String)bookTypeProp) ? "" : String.valueOf(bookTypeId), orgId, closeData.getClosePeriodId(), null, ClosePeriodOption.getOperationId(this.getOption()));
            CheckExecutionResult result = ClosePeriodCheckExecutor.instance.execute(executionParam);
            for (CheckExecutionResult.CheckResultWrapper checkResultWrapper : result.getItemCheckResultList()) {
                this.addCheckResultWrapper(dataEntity, orgId, bookTypeId, checkResultWrapper);
            }
        }
    }
}

