/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.closeperiod.validator;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.ext.fi.operation.closeperiod.result.CloseCheckItemResult;
import kd.bos.ext.fi.operation.closeperiod.validator.AbstractClosePeriodValidator;
import kd.bos.util.CollectionUtils;

public class DefaultValidatorResultCollector
extends AbstractClosePeriodValidator {
    @Override
    public void doValidate() {
        List validateResults = this.getValidateContext().getValidateResults().getValidateErrors();
        if (CollectionUtils.isNotEmpty((Collection)validateResults)) {
            Map<Object, ExtendedDataEntity> books = Arrays.stream(this.getDataEntities()).filter(x -> x.getBillPkId() != null).collect(Collectors.toMap(ExtendedDataEntity::getBillPkId, x -> x, (o, n) -> n));
            for (ValidateResult validateResult : validateResults) {
                List allErrorInfo = validateResult.getAllErrorInfo();
                if (!CollectionUtils.isNotEmpty((Collection)allErrorInfo)) continue;
                for (OperateErrorInfo operateErrorInfo : allErrorInfo) {
                    ExtendedDataEntity book = books.get(operateErrorInfo.getPkValue());
                    if (book == null) continue;
                    long orgId = this.getBookRegisterInfoAccessor().getCloseOrgId(book.getDataEntity());
                    long bookTypeId = this.getBookRegisterInfoAccessor().getCloseBookTypeId(book.getDataEntity());
                    this.recordItemResult(orgId, bookTypeId, CloseCheckItemResult.buildFailed(operateErrorInfo.getMessage(), operateErrorInfo.getMessage()));
                }
            }
        }
    }
}

