/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.operation.er;

import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportShowParameter;
import kd.bos.servicehelper.QueryServiceHelper;

public class ErViewLoanInfo
extends DefaultEntityOperate {
    public OperationResult invokeOperation() {
        OperationResult or = new OperationResult();
        IFormView view = this.getView();
        if (view instanceof BillView) {
            this.resolveBill();
        } else if (view instanceof ListView) {
            this.resolveList();
        }
        return or;
    }

    protected boolean isShowMessage(OperationResult operationResult) {
        return false;
    }

    private void resolveList() {
        BillList billList = (BillList)this.getView().getControl("billlistap");
        ListSelectedRowCollection selectedRows = billList.getSelectedRows();
        if (this.isMultiSelect(selectedRows)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u5355\u6761\u6570\u636e\u3002", (String)"BtnSettingPluginForBillList_5", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        String appId = this.getView().getFormShowParameter().getAppId();
        if (appId.equals("kdem") || appId.equals("10MYBGBYHXDU") || appId.equals("/J5TH+OKHVUA") || appId.equals("em")) {
            this.showFiList(selectedRows);
        } else {
            this.showErList(selectedRows);
        }
    }

    private boolean isMultiSelect(ListSelectedRowCollection rows) {
        if (rows.size() > 1) {
            for (int i = 0; i < rows.size() - 1; ++i) {
                ListSelectedRow curr = rows.get(i);
                ListSelectedRow next = rows.get(i + 1);
                if (curr.getPrimaryKeyValue().equals(next.getPrimaryKeyValue())) continue;
                return true;
            }
        }
        return false;
    }

    private void showErList(ListSelectedRowCollection selectedRows) {
        long userId;
        String formId = "er_employee_loan_repay";
        if (selectedRows.isEmpty()) {
            userId = RequestContext.get().getCurrUserId();
        } else {
            String entityId = ((ListView)this.getView()).getListModel().getEntityId();
            Object primaryKey = selectedRows.get(0).getPrimaryKeyValue();
            DynamicObject row = QueryServiceHelper.queryOne((String)entityId, (String)"id,applier.id,company.id", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKey)});
            userId = row.getLong("applier.id");
        }
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().clear();
        filterInfo.addFilterItem("applier", (Object)userId);
        this.showReportList(formId, filterInfo);
    }

    private void showFiList(ListSelectedRowCollection selectedRows) {
        long userId;
        FilterInfo filterInfo = new FilterInfo();
        if (selectedRows.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8981\u6267\u884c\u7684\u6570\u636e\u3002", (String)"BtnSettingPluginForBillList_4", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        long orgId = 0L;
        String formId = ((ListView)this.getView()).getListModel().getEntityId();
        Object primaryKey = selectedRows.get(0).getPrimaryKeyValue();
        try {
            DynamicObject row = QueryServiceHelper.queryOne((String)formId, (String)"id,applier.id,company.id", (QFilter[])new QFilter[]{new QFilter("id", "=", primaryKey)});
            orgId = row.getLong("company.id");
            userId = row.getLong("applier.id");
        }
        catch (Exception e) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u770b\u501f\u8fd8\u6b3e\u5931\u8d25\u3002", (String)"BtnSettingPluginForBillList_6", (String)"fi-er-formplugin", (Object[])new Object[0]));
            throw e;
        }
        filterInfo.getFilterItems().clear();
        filterInfo.addFilterItem("loanpayer", (Object)userId);
        filterInfo.addFilterItem("paramcompany", (Object)orgId);
        this.showReportList("er_employee_loan_repay_fi", filterInfo);
    }

    private void resolveBill() {
        String formId;
        String appid = this.getView().getFormShowParameter().getAppId();
        DynamicObject userinfo = (DynamicObject)this.getView().getModel().getValue("applier");
        if (userinfo == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7533\u8bf7\u4eba\u4fe1\u606f\u83b7\u53d6\u5931\u8d25\u3002", (String)"BtnSettingPlugin_1", (String)"fi-er-formplugin", (Object[])new Object[0]));
            return;
        }
        Long userid = userinfo.getLong("id");
        FilterInfo filterInfo = new FilterInfo();
        switch (appid) {
            case "10MYBGBYHXDU": 
            case "em": 
            case "/J5TH+OKHVUA": 
            case "kdem": {
                formId = "er_employee_loan_repay_fi";
                filterInfo.getFilterItems().clear();
                filterInfo.addFilterItem("loanpayer", (Object)new Long[]{userid}, "IN");
                break;
            }
            default: {
                formId = "er_employee_loan_repay";
                filterInfo.addFilterItem("applier", (Object)userid, "=");
            }
        }
        this.showReportList(formId, filterInfo);
    }

    private void showReportList(String formId, FilterInfo filterInfo) {
        ReportShowParameter showForm = new ReportShowParameter();
        if (filterInfo != null) {
            filterInfo.addFilterItem("paramstatus", (Object)0, "=");
            ReportQueryParam queryParam = new ReportQueryParam();
            queryParam.setFilter(filterInfo);
            showForm.setQueryParam(queryParam);
        }
        showForm.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showForm.setFormId(formId);
        showForm.setHasRight(true);
        this.getView().showForm((FormShowParameter)showForm);
    }

    public boolean needSelectData() {
        return false;
    }
}

