/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.ext.fi.util.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ArApConvertHelper {
    public static final String ExRate_CONVERT_MODE_DIRECT = "0";
    public static final String ExRate_CONVERT_MODE_INDIRECT = "1";
    private QueryUtil queryUtil;

    public void setBillInfoByInit(DynamicObject targetBill, DynamicObject init) {
        if (ObjectUtils.isEmpty((Object)ArApConvertHelper.getStartDate(init))) {
            DynamicObject org = targetBill.getDynamicObject("org");
            ErrorCode ARAPORGNAME_NOT_SET = null;
            ARAPORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_SET_1", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u4ed8\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u4ed8\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_1", (String)"bos-ext-fi", (Object[])new Object[0]));
            throw new KDBizException(ARAPORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        Date currentdate = init.getDate("currentdate");
        Date bizdate = targetBill.getDate("bizdate");
        if (currentdate != null && bizdate != null && currentdate.compareTo(bizdate) > 0) {
            targetBill.set("bizdate", (Object)currentdate);
        }
        DynamicObject bascurrency = ArApConvertHelper.getStandardCurrency(init);
        targetBill.set("basecurrency", (Object)bascurrency);
        if (ObjectUtils.isEmpty((Object)targetBill.get("exratetable"))) {
            targetBill.set("exratetable", (Object)ArApConvertHelper.getExrateTable(init));
        }
        DynamicObject exeatetable = targetBill.getDynamicObject("exratetable");
        if (ObjectUtils.isEmpty((Object)targetBill.get("exratedate"))) {
            targetBill.set("exratedate", (Object)new Date());
        }
        BigDecimal exchangerate = targetBill.getBigDecimal("exchangerate");
        DynamicObject currency = targetBill.getDynamicObject("currency");
        String quotation = targetBill.getString("quotation");
        if (StringUtils.isEmpty(quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
            boolean isIndirect = this.getQueryUtil().getRateConversionConfig(currency.getLong("id"), bascurrency.getLong("id"), targetBill.getDate("exratedate"));
            quotation = isIndirect ? ExRate_CONVERT_MODE_INDIRECT : ExRate_CONVERT_MODE_DIRECT;
            targetBill.set("quotation", (Object)quotation);
        }
        if (ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0 || BigDecimal.ONE.compareTo(exchangerate) == 0) {
            if (bascurrency.getPkValue().equals(currency.getPkValue())) {
                targetBill.set("exchangerate", (Object)BigDecimal.ONE);
            } else if (exeatetable != null) {
                BigDecimal exchangeRate = this.getQueryUtil().getExchangeRate(exeatetable.getLong("id"), currency.getLong("id"), bascurrency.getLong("id"), quotation, targetBill.getDate("exratedate"));
                targetBill.set("exchangerate", (Object)exchangeRate);
            }
        }
    }

    public Map<Long, BigDecimal> getBatchFarmMaterial(ExtendedDataEntity[] entities) {
        return this.getBatchFarmMaterial(entities, "entry", "e_material.id");
    }

    public Map<Long, BigDecimal> getBatchFarmMaterial(ExtendedDataEntity[] entities, String entryKey, String materialIdKey) {
        HashMap<Long, BigDecimal> farmRate = new HashMap<Long, BigDecimal>(2);
        HashSet<Long> materialIds = new HashSet<Long>(2);
        for (ExtendedDataEntity entity : entities) {
            DynamicObjectCollection entry = entity.getDataEntity().getDynamicObjectCollection(entryKey);
            for (DynamicObject row : entry) {
                Long materialId = row.getLong(materialIdKey);
                if (materialId == null || materialId == 0L) continue;
                materialIds.add(materialId);
            }
        }
        if (materialIds.size() > 0) {
            Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,farmproducts,deductiblerate", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
            for (Map.Entry entrySet : materialMap.entrySet()) {
                DynamicObject material = (DynamicObject)entrySet.getValue();
                boolean isFarmproducts = material.getBoolean("farmproducts");
                if (!isFarmproducts) continue;
                farmRate.put(material.getLong("id"), material.getBigDecimal("deductiblerate"));
            }
        }
        return farmRate;
    }

    public static Date getStartDate(DynamicObject init) {
        if (init == null) {
            return null;
        }
        Date startDate = init.getDate("startdate");
        return startDate == null ? null : ArApConvertHelper.getDataFormat(startDate, true);
    }

    public static DynamicObject getStandardCurrency(DynamicObject init) {
        if (init == null) {
            return null;
        }
        return init.getDynamicObject("standardcurrency");
    }

    public static DynamicObject getExrateTable(DynamicObject init) {
        if (init == null) {
            return null;
        }
        return init.getDynamicObject("exratetable");
    }

    public static boolean isFinishInit(DynamicObject init) {
        if (init == null) {
            return false;
        }
        return init.getBoolean("isfinishinit");
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        return InitConvertHelper.getUnitRateConv(materialId, srcUnitId, desUnitId);
    }

    public static BigDecimal getBaseunitqty(BigDecimal quantity, BigDecimal covertRate, DynamicObject baseUnit) {
        BigDecimal baseunitqty = BigDecimal.ZERO;
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        int precisionaccount = 4;
        int precision = 10;
        if (baseUnit == null) {
            baseunitqty = quantity.multiply(covertRate).setScale(precision, precisionaccount);
            return baseunitqty;
        }
        precisionaccount = baseUnit.getInt("precisionaccount");
        precision = baseUnit.getInt("precision");
        baseunitqty = precisionaccount == 2 ? quantity.multiply(covertRate).setScale(precision, 1) : (precisionaccount == 3 ? quantity.multiply(covertRate).setScale(precision, 0) : quantity.multiply(covertRate).setScale(precision, 4));
        return baseunitqty;
    }

    private QueryUtil getQueryUtil() {
        if (this.queryUtil == null) {
            this.queryUtil = new QueryUtil();
        }
        return this.queryUtil;
    }

    public static boolean isBizPartner(DynamicObject custsupper) {
        DynamicObject asstact;
        DynamicObject intercompany;
        boolean isBizPartner = false;
        if (custsupper != null && (custsupper.getDataEntityType().getName().equals("bd_supplier") || custsupper.getDataEntityType().getName().equals("bd_customer")) && (intercompany = (asstact = BusinessDataServiceHelper.loadSingle((Object)((Long)custsupper.getPkValue()), (String)custsupper.getDynamicObjectType().getName(), (String)"internal_company")).getDynamicObject("internal_company")) != null) {
            isBizPartner = true;
        }
        return isBizPartner;
    }

    public static List<Object> getBizPartnerIds(String asstactType, List<Object> asstactIds) {
        List<Object> bizPartnerIds = new ArrayList<Object>(2);
        if (!asstactIds.isEmpty() && ("bd_customer".equals(asstactType) || "bd_supplier".equals(asstactType))) {
            bizPartnerIds = QueryServiceHelper.queryPrimaryKeys((String)asstactType, (QFilter[])new QFilter[]{new QFilter("id", "in", asstactIds), new QFilter("internal_company", "!=", (Object)0L)}, (String)"", (int)-1);
        }
        return bizPartnerIds;
    }
}

