/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterBuildQueryParemeterEventArgs;
import kd.bos.entity.botp.plugin.args.AfterFieldMappingEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;

public class BillNoRecalculateConvertPlugin
extends AbstractConvertPlugIn {
    private String targetEntityNumber;
    private String srcEntityNumber;

    public void initVariable(InitVariableEventArgs e) {
        this.targetEntityNumber = this.getTgtMainType().getName();
        this.srcEntityNumber = this.getSrcMainType().getName();
    }

    public void afterBuildQueryParemeter(AfterBuildQueryParemeterEventArgs e) {
        List<String> selectorSrcField = this.getSelector();
        for (String srcField : selectorSrcField) {
            e.addSrcField(srcField);
        }
    }

    public void afterFieldMapping(AfterFieldMappingEventArgs e) {
        BigDecimal qty;
        BigDecimal returnqty;
        BigDecimal remainjoinpriceqty;
        BigDecimal arjoinqty;
        BigDecimal e_invoicednotaxamt;
        BigDecimal e_invoicedqty;
        BigDecimal joinpayablepriceqty;
        BigDecimal verifyqty;
        Long entryId;
        ExtendedDataEntity[] billDataEntitys = e.getTargetExtDataEntitySet().FindByEntityKey(this.targetEntityNumber);
        ArrayList srcRows = new ArrayList(billDataEntitys.length);
        for (ExtendedDataEntity billDataEntity : billDataEntitys) {
            List rows = (List)billDataEntity.getValue("ConvertSource");
            srcRows.addAll(rows);
        }
        if (ObjectUtils.isEmpty(srcRows)) {
            return;
        }
        HashSet<Long> noRecalculateSrcEntryIds = new HashSet<Long>(billDataEntitys.length);
        if ("ap_finapbill".equals(this.targetEntityNumber)) {
            if ("im_purinbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    verifyqty = (BigDecimal)this.getValue(e, srcRow, "billentry.verifyqty");
                    if (verifyqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("conm_purcontract".equals(this.srcEntityNumber) || "pm_purorderbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    joinpayablepriceqty = (BigDecimal)this.getValue(e, srcRow, "billentry.joinpayablepriceqty");
                    if (joinpayablepriceqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("ap_busbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "entry.id");
                    e_invoicedqty = (BigDecimal)this.getValue(e, srcRow, "entry.e_invoicedqty");
                    e_invoicednotaxamt = (BigDecimal)this.getValue(e, srcRow, "entry.e_invoicednotaxamt");
                    BigDecimal e_unwoffqty = (BigDecimal)this.getValue(e, srcRow, "entry.e_unwoffqty");
                    BigDecimal e_quantity = (BigDecimal)this.getValue(e, srcRow, "entry.e_quantity");
                    BigDecimal e_unwoffnotaxamt = (BigDecimal)this.getValue(e, srcRow, "entry.e_unwoffnotaxamt");
                    BigDecimal e_amount = (BigDecimal)this.getValue(e, srcRow, "entry.e_amount");
                    if (e_invoicedqty.compareTo(BigDecimal.ZERO) != 0 || e_invoicednotaxamt.compareTo(BigDecimal.ZERO) != 0 || e_unwoffqty.compareTo(e_quantity) != 0 || e_unwoffnotaxamt.compareTo(e_amount) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("er_publicreimbursebill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "expenseentryentity.id");
                    Integer iscreateappaycount = (Integer)this.getValue(e, srcRow, "expenseentryentity.iscreateappaycount");
                    if (0 != iscreateappaycount) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if ("ap_busbill".equals(this.targetEntityNumber)) {
            if ("conm_purcontract".equals(this.srcEntityNumber) || "pm_purorderbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    joinpayablepriceqty = (BigDecimal)this.getValue(e, srcRow, "billentry.joinpayablepriceqty");
                    if (joinpayablepriceqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("im_purinbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    verifyqty = (BigDecimal)this.getValue(e, srcRow, "billentry.verifyqty");
                    if (verifyqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if ("ar_finarbill".equals(this.targetEntityNumber)) {
            if ("conm_salcontract".equals(this.srcEntityNumber) || "sm_salorder".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    arjoinqty = (BigDecimal)this.getValue(e, srcRow, "billentry.arjoinqty");
                    if (arjoinqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("im_saloutbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    remainjoinpriceqty = (BigDecimal)this.getValue(e, srcRow, "billentry.remainjoinpriceqty");
                    returnqty = (BigDecimal)this.getValue(e, srcRow, "billentry.returnqty");
                    qty = (BigDecimal)this.getValue(e, srcRow, "billentry.qty");
                    if (remainjoinpriceqty.subtract(returnqty).compareTo(qty) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("ar_busbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "entry.id");
                    e_invoicedqty = (BigDecimal)this.getValue(e, srcRow, "entry.e_invoicedqty");
                    e_invoicednotaxamt = (BigDecimal)this.getValue(e, srcRow, "entry.e_invoicednotaxamt");
                    BigDecimal e_relateinvqty = (BigDecimal)this.getValue(e, srcRow, "entry.e_relateinvqty");
                    BigDecimal relateinvamt = (BigDecimal)this.getValue(e, srcRow, "entry.e_relateinvamt");
                    BigDecimal e_unwoffqty = (BigDecimal)this.getValue(e, srcRow, "entry.e_unwoffqty");
                    BigDecimal e_quantity = (BigDecimal)this.getValue(e, srcRow, "entry.e_quantity");
                    BigDecimal e_unwoffnotaxamt = (BigDecimal)this.getValue(e, srcRow, "entry.e_unwoffnotaxamt");
                    BigDecimal e_amount = (BigDecimal)this.getValue(e, srcRow, "entry.e_amount");
                    if (e_invoicedqty.compareTo(BigDecimal.ZERO) != 0 || e_invoicednotaxamt.compareTo(BigDecimal.ZERO) != 0 || e_relateinvqty.compareTo(BigDecimal.ZERO) != 0 || relateinvamt.compareTo(BigDecimal.ZERO) != 0 || e_unwoffqty.compareTo(e_quantity) != 0 || e_unwoffnotaxamt.compareTo(e_amount) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if ("ar_busbill".equals(this.targetEntityNumber)) {
            if ("conm_salcontract".equals(this.srcEntityNumber) || "sm_salorder".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    arjoinqty = (BigDecimal)this.getValue(e, srcRow, "billentry.arjoinqty");
                    if (arjoinqty.compareTo(BigDecimal.ZERO) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
            if ("im_saloutbill".equals(this.srcEntityNumber)) {
                for (DynamicObject srcRow : srcRows) {
                    entryId = (Long)this.getValue(e, srcRow, "billentry.id");
                    remainjoinpriceqty = (BigDecimal)this.getValue(e, srcRow, "billentry.remainjoinpriceqty");
                    returnqty = (BigDecimal)this.getValue(e, srcRow, "billentry.returnqty");
                    qty = (BigDecimal)this.getValue(e, srcRow, "billentry.qty");
                    if (remainjoinpriceqty.subtract(returnqty).compareTo(qty) != 0) continue;
                    noRecalculateSrcEntryIds.add(entryId);
                }
            }
        }
        if (noRecalculateSrcEntryIds.size() > 0) {
            this.getOption().setVariableValue("noRecalculateSrcEntryIds", SerializationUtils.toJsonString(noRecalculateSrcEntryIds));
        }
    }

    private Object getValue(AfterFieldMappingEventArgs e, DynamicObject srcRow, String field) {
        return ((DynamicProperty)e.getFldProperties().get(field)).getValue((Object)srcRow);
    }

    private List<String> getSelector() {
        ArrayList<String> selector = new ArrayList<String>(8);
        if ("im_purinbill".equals(this.srcEntityNumber)) {
            selector.add("billentry.verifyqty");
        }
        if ("conm_purcontract".equals(this.srcEntityNumber) || "pm_purorderbill".equals(this.srcEntityNumber)) {
            selector.add("billentry.joinpayablepriceqty");
        }
        if ("conm_salcontract".equals(this.srcEntityNumber) || "sm_salorder".equals(this.srcEntityNumber)) {
            selector.add("billentry.arjoinqty");
        }
        if ("im_saloutbill".equals(this.srcEntityNumber)) {
            selector.add("billentry.remainjoinpriceqty");
            selector.add("billentry.returnqty");
            selector.add("billentry.qty");
        }
        if ("ap_busbill".equals(this.srcEntityNumber)) {
            selector.add("entry.e_invoicedqty");
            selector.add("entry.e_invoicednotaxamt");
            selector.add("entry.e_unwoffqty");
            selector.add("entry.e_quantity");
            selector.add("entry.e_unwoffnotaxamt");
            selector.add("entry.e_amount");
        }
        if ("ar_busbill".equals(this.srcEntityNumber)) {
            selector.add("entry.e_invoicedqty");
            selector.add("entry.e_invoicednotaxamt");
            selector.add("entry.e_relateinvqty");
            selector.add("entry.e_relateinvamt");
            selector.add("entry.e_unwoffqty");
            selector.add("entry.e_quantity");
            selector.add("entry.e_unwoffnotaxamt");
            selector.add("entry.e_amount");
        }
        if ("er_publicreimbursebill".equals(this.srcEntityNumber)) {
            selector.add("expenseentryentity.iscreateappaycount");
        }
        return selector;
    }
}

