/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.AsstactConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.BookDateHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.PriceTaxTotalCalculator;
import kd.bos.ext.fi.util.price.PriceTotalCalculator;
import kd.bos.ext.fi.util.price.TaxUnitPriceCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;

public class BillToBusArConvertPlugin
extends AbstractConvertPlugIn {
    private final Set<String> noRecalculateFieldKeys = Stream.of("e_unitprice", "e_taxunitprice", "e_actunitprice", "e_acttaxunitprice", "e_amount", "e_localamt", "e_tax", "e_taxlocalamt", "e_recamount", "e_reclocalamt", "e_discountamount", "e_discountlocalamt").collect(Collectors.toSet());
    private Map<String, Boolean> ruleIsSettingMap = new HashMap<String, Boolean>(8);
    private final Map<Long, String> noRecalculateSrcEntryIdMap = new HashMap<Long, String>(8);

    public void afterConvert(AfterConvertEventArgs e) {
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] entities = entitySet.FindByEntityKey("ar_busbill");
        HashSet<DynamicObject> arBusBills = new HashSet<DynamicObject>(entities.length);
        List<DynamicObject> busArBills = Stream.of(entities).map(ExtendedDataEntity::getDataEntity).collect(Collectors.toList());
        this.buildNoRecalculateInfo();
        HashMap<Long, List<DynamicObject>> billByOrgId = new HashMap<Long, List<DynamicObject>>(4);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            Long orgId = bill.getLong("org.id");
            if (ObjectUtils.isEmpty((Object)orgId)) {
                return;
            }
            List bills = billByOrgId.computeIfAbsent(orgId, a -> new ArrayList(64));
            bills.add(bill);
        }
        new InitConvertHelper("ar_init", this.getRule(), billByOrgId);
        AsstactConvertHelper.checkAsstactType(busArBills);
        QueryUtil queryUtil = new QueryUtil();
        for (ExtendedDataEntity entity : entities) {
            DynamicObject apBusBill = entity.getDataEntity();
            arBusBills.add(apBusBill);
            DynamicObject org = apBusBill.getDynamicObject("org");
            DynamicObject recorg = apBusBill.getDynamicObject("recorg");
            if (ObjectUtils.isEmpty((Object)recorg) || !recorg.getBoolean("fisbankroll")) {
                apBusBill.set("recorg", (Object)org);
                recorg = org;
            }
            if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
                apBusBill.set("recorg", null);
            }
            if (ObjectUtils.isEmpty((Object)org)) continue;
            DynamicObject bascur = apBusBill.getDynamicObject("basecurrency");
            int baseprecision = bascur.getInt("amtprecision");
            int precision = apBusBill.getInt("currency.amtprecision");
            if (apBusBill.get("duedate") == null) {
                apBusBill.set("duedate", (Object)new Date());
            }
            apBusBill.set("srcfinbillid", (Object)0L);
            DynamicObjectCollection entries = apBusBill.getDynamicObjectCollection("entry");
            boolean includeTax = apBusBill.getBoolean("isincludetax");
            boolean ispricetotal = apBusBill.getBoolean("ispricetotal");
            BigDecimal exchangeRate = apBusBill.getBigDecimal("exchangerate");
            String quotation = apBusBill.getString("quotation");
            if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
                quotation = "0";
            }
            BigDecimal amount = BigDecimal.ZERO;
            BigDecimal localamt = BigDecimal.ZERO;
            BigDecimal tax = BigDecimal.ZERO;
            BigDecimal taxlocamt = BigDecimal.ZERO;
            BigDecimal pricetaxtotal = BigDecimal.ZERO;
            BigDecimal pricetaxtotallocal = BigDecimal.ZERO;
            for (DynamicObject entry : entries) {
                BigDecimal e_baseunitqty;
                BigDecimal covertRate;
                boolean isPresent = entry.getBoolean("e_ispresent");
                BigDecimal price = entry.getBigDecimal("e_unitprice");
                BigDecimal priceTax = entry.getBigDecimal("e_taxunitprice");
                if (ispricetotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                    BigDecimal e_baseunitqty2;
                    BigDecimal covertRate2;
                    BigDecimal quantity = entry.getBigDecimal("e_quantity");
                    if (quantity == null) {
                        quantity = BigDecimal.ZERO;
                    }
                    boolean covertRateIsEmpty = (covertRate2 = entry.getBigDecimal("e_unitcoefficient")) == null || covertRate2.compareTo(BigDecimal.ZERO) == 0;
                    DynamicObject material = entry.getDynamicObject("e_material");
                    DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                    DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
                    if (!ObjectUtils.isEmpty((Object)material)) {
                        if (ObjectUtils.isEmpty((Object)baseUnit)) {
                            baseUnit = material.getDynamicObject("baseunit");
                            entry.set("e_baseunit", (Object)baseUnit);
                        }
                        if (measureUnit == null) {
                            measureUnit = baseUnit;
                        }
                        if (covertRateIsEmpty) {
                            covertRate2 = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                        }
                    } else if (covertRateIsEmpty) {
                        covertRate2 = BigDecimal.ONE;
                    }
                    if (covertRateIsEmpty) {
                        entry.set("e_unitcoefficient", (Object)covertRate2);
                    }
                    if ((e_baseunitqty2 = entry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                        entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate2, baseUnit));
                    }
                    entry.set("e_uninvoicedqty", (Object)quantity);
                    entry.set("e_unwoffqty", (Object)quantity);
                    entry.set("e_unconfirmqty", (Object)quantity);
                    entry.set("e_unrelateinvqty", (Object)quantity);
                    this.reSetPresentAmountField(entry, isPresent);
                    continue;
                }
                Long e_sourcebillentryid = entry.getLong("e_srcentryid");
                String noRecalculate = this.noRecalculateSrcEntryIdMap.getOrDefault(e_sourcebillentryid, "false");
                PriceLocalCalculator localCalculator = null;
                AbstractPriceCalculator calculator = null;
                BigDecimal qty = entry.getBigDecimal("e_quantity");
                BigDecimal taxRate = entry.getBigDecimal("e_taxrate");
                String discountMode = entry.getString("e_discountmode");
                BigDecimal discountRate = entry.getBigDecimal("e_discountrate");
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    if (includeTax) {
                        if ("true".equals(noRecalculate)) {
                            if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                                entry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                            }
                        } else {
                            entry.set("e_discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else if ("true".equals(noRecalculate)) {
                        if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                            entry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else {
                        entry.set("e_discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                BigDecimal discountAmt = entry.getBigDecimal("e_discountamount");
                if (includeTax && !ispricetotal) {
                    BigDecimal taxUnitPrice = entry.getBigDecimal("e_taxunitprice");
                    calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else if (!includeTax && !ispricetotal) {
                    BigDecimal unitPrice = entry.getBigDecimal("e_unitprice");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else if (!includeTax && ispricetotal) {
                    BigDecimal entryAmount = entry.getBigDecimal("e_amount");
                    calculator = new PriceTotalCalculator(qty, entryAmount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                } else if (includeTax && ispricetotal) {
                    BigDecimal entryRecamount = entry.getBigDecimal("e_recamount");
                    calculator = new PriceTaxTotalCalculator(qty, entryRecamount, taxRate, discountMode, discountRate, precision, BigDecimal.ZERO, discountAmt);
                }
                localCalculator = new PriceLocalCalculator(calculator, exchangeRate, baseprecision, quotation);
                localCalculator.calculate();
                if ("true".equals(noRecalculate)) {
                    if (!this.ruleIsSettingMap.getOrDefault("e_unitprice", false).booleanValue()) {
                        entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_taxunitprice", false).booleanValue()) {
                        entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_actunitprice", false).booleanValue()) {
                        entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_acttaxunitprice", false).booleanValue()) {
                        entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_amount", false).booleanValue()) {
                        entry.set("e_amount", (Object)localCalculator.getAmount());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_localamt", false).booleanValue()) {
                        entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_tax", false).booleanValue()) {
                        entry.set("e_tax", (Object)localCalculator.getTax());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_taxlocalamt", false).booleanValue()) {
                        entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_recamount", false).booleanValue()) {
                        entry.set("e_recamount", (Object)localCalculator.getPricetaxtotal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_reclocalamt", false).booleanValue()) {
                        entry.set("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_discountamount", false).booleanValue()) {
                        entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                    }
                    if (!this.ruleIsSettingMap.getOrDefault("e_discountlocalamt", false).booleanValue()) {
                        entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                    }
                } else {
                    entry.set("e_unitprice", (Object)localCalculator.getUnitprice());
                    entry.set("e_taxunitprice", (Object)localCalculator.getTaxunitprice());
                    entry.set("e_actunitprice", (Object)localCalculator.getActunitprice());
                    entry.set("e_acttaxunitprice", (Object)localCalculator.getActtaxunitprice());
                    entry.set("e_amount", (Object)localCalculator.getAmount());
                    entry.set("e_localamt", (Object)localCalculator.getAmountlocal());
                    entry.set("e_tax", (Object)localCalculator.getTax());
                    entry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                    entry.set("e_recamount", (Object)localCalculator.getPricetaxtotal());
                    entry.set("e_reclocalamt", (Object)localCalculator.getPricetaxtotallocal());
                    entry.set("e_discountamount", (Object)localCalculator.getDiscountamount());
                    entry.set("e_discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                }
                this.reSetPresentAmountField(entry, isPresent);
                BigDecimal e_recamount = entry.getBigDecimal("e_recamount");
                BigDecimal e_amountbase = entry.getBigDecimal("e_localamt");
                BigDecimal e_reclocalamt = entry.getBigDecimal("e_reclocalamt");
                BigDecimal e_amount = entry.getBigDecimal("e_amount");
                BigDecimal e_tax = entry.getBigDecimal("e_tax");
                BigDecimal e_taxlocalamt = entry.getBigDecimal("e_taxlocalamt");
                entry.set("e_unconfirmamt", (Object)e_amount);
                entry.set("e_unconfirmqty", (Object)qty);
                entry.set("e_uninvoicedamt", (Object)e_recamount);
                entry.set("e_uninvoicedlocamt", (Object)e_reclocalamt);
                entry.set("e_unwoffamt", (Object)e_recamount);
                entry.set("e_unwofflocamt", (Object)e_reclocalamt);
                entry.set("e_unwoffnotaxamt", (Object)e_amount);
                entry.set("e_unwoffnotaxlocamt", (Object)e_amountbase);
                entry.set("e_unwofftax", (Object)e_tax);
                entry.set("e_unwofftaxlocal", (Object)e_taxlocalamt);
                entry.set("e_uninvnotaxamt", (Object)e_amount);
                entry.set("e_uninvnotaxlocalamt", (Object)e_amountbase);
                entry.set("e_unrelateinvqty", (Object)qty);
                entry.set("e_unrelateinvamt", (Object)e_recamount);
                entry.set("e_unrelateinvlocamt", (Object)e_reclocalamt);
                entry.set("e_uninvoicedqty", (Object)qty);
                entry.set("e_unwoffqty", (Object)qty);
                amount = amount.add(e_amount);
                localamt = localamt.add(e_amountbase);
                tax = tax.add(e_tax);
                taxlocamt = taxlocamt.add(e_taxlocalamt);
                pricetaxtotal = pricetaxtotal.add(e_recamount);
                pricetaxtotallocal = pricetaxtotallocal.add(e_reclocalamt);
                BigDecimal e_quantity = entry.getBigDecimal("e_quantity");
                if (e_quantity == null) {
                    e_quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate = entry.getBigDecimal("e_unitcoefficient")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = entry.getDynamicObject("e_material");
                DynamicObject measureUnit = entry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = entry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        entry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate = queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    entry.set("e_unitcoefficient", (Object)covertRate);
                }
                if ((e_baseunitqty = entry.getBigDecimal("e_baseunitqty")) != null && e_baseunitqty.compareTo(BigDecimal.ZERO) != 0) continue;
                entry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(e_quantity, covertRate, baseUnit));
            }
            apBusBill.set("amount", (Object)amount);
            apBusBill.set("localamt", (Object)localamt);
            apBusBill.set("tax", (Object)tax);
            apBusBill.set("taxlocamt", (Object)taxlocamt);
            apBusBill.set("recamount", (Object)pricetaxtotal);
            apBusBill.set("reclocalamt", (Object)pricetaxtotallocal);
            apBusBill.set("uninvoicedamt", (Object)pricetaxtotal);
            apBusBill.set("uninvoicedlocamt", (Object)pricetaxtotallocal);
            apBusBill.set("unwoffamt", (Object)pricetaxtotal);
            apBusBill.set("unwofflocamt", (Object)pricetaxtotallocal);
            apBusBill.set("unwoffnotaxamt", (Object)amount);
            apBusBill.set("unwoffnotaxlocamt", (Object)localamt);
            apBusBill.set("unwofftax", (Object)tax);
            apBusBill.set("unwofftaxlocal", (Object)taxlocamt);
            apBusBill.set("unrelateinvamt", (Object)pricetaxtotal);
            apBusBill.set("unrelateinvlocamt", (Object)pricetaxtotallocal);
        }
        BookDateHelper.setBookDate(arBusBills.toArray(new DynamicObject[0]), true);
    }

    private void reSetPresentAmountField(DynamicObject entry, boolean isPresent) {
        if (isPresent) {
            entry.set("e_actunitprice", (Object)BigDecimal.ZERO);
            entry.set("e_acttaxunitprice", (Object)BigDecimal.ZERO);
            entry.set("e_amount", (Object)BigDecimal.ZERO);
            entry.set("e_localamt", (Object)BigDecimal.ZERO);
            entry.set("e_tax", (Object)BigDecimal.ZERO);
            entry.set("e_taxlocalamt", (Object)BigDecimal.ZERO);
            entry.set("e_recamount", (Object)BigDecimal.ZERO);
            entry.set("e_reclocalamt", (Object)BigDecimal.ZERO);
            entry.set("e_unconfirmamt", (Object)BigDecimal.ZERO);
            entry.set("e_uninvoicedamt", (Object)BigDecimal.ZERO);
            entry.set("e_uninvoicedlocamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwoffamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwofflocamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwoffnotaxamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwoffnotaxlocamt", (Object)BigDecimal.ZERO);
            entry.set("e_unwofftax", (Object)BigDecimal.ZERO);
            entry.set("e_unwofftaxlocal", (Object)BigDecimal.ZERO);
            entry.set("e_uninvnotaxamt", (Object)BigDecimal.ZERO);
            entry.set("e_uninvnotaxlocalamt", (Object)BigDecimal.ZERO);
            entry.set("e_unrelateinvamt", (Object)BigDecimal.ZERO);
            entry.set("e_unrelateinvlocamt", (Object)BigDecimal.ZERO);
        }
    }

    private void buildNoRecalculateInfo() {
        Map variables = this.getOption().getVariables();
        String noRecalculateSrcEntryIds = (String)variables.get("noRecalculateSrcEntryIds");
        if (!ObjectUtils.isEmpty((Object)noRecalculateSrcEntryIds)) {
            List noRecalculateSrcEntryIdList = (List)SerializationUtils.fromJsonString((String)noRecalculateSrcEntryIds, List.class);
            for (Long entryId : noRecalculateSrcEntryIdList) {
                this.noRecalculateSrcEntryIdMap.put(entryId, "true");
            }
            this.ruleIsSettingMap = BOTPHelper.ruleIsSetting(this.getRule(), false, this.noRecalculateFieldKeys);
        }
    }
}

