/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.AsstactConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.BookDateHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ApPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ConditionServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.TaxCodeConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.enums.InvoiceBizTypeEnum;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.ext.fi.util.price.AbstractPriceCalculator;
import kd.bos.ext.fi.util.price.PriceLocalCalculator;
import kd.bos.ext.fi.util.price.PriceTaxTotalCalculator;
import kd.bos.ext.fi.util.price.PriceTotalCalculator;
import kd.bos.ext.fi.util.price.TaxUnitPriceCalculator;
import kd.bos.ext.fi.util.price.UnitPriceCalculator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class BillToFinApConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(BillToFinApConvertPlugin.class);
    private static final String FI_BIZ_ID = "83bfebc8000002ac";
    private Map<Long, DynamicObject> orgInitMap;
    private DynamicObject[] needMatchSplitSchemes;
    private Map<Object, DynamicObject> supplierMap = new HashMap<Object, DynamicObject>(8);
    private Map<Object, DynamicObject> customerMap = new HashMap<Object, DynamicObject>(8);
    private Map<Object, DynamicObject> userMap = new HashMap<Object, DynamicObject>(8);
    private Map<Object, DynamicObject> specInvoiceTypeMap = new HashMap<Object, DynamicObject>(2);
    private final Map<Object, DynamicObject> supplierIdToInvoiceTypeMap = new HashMap<Object, DynamicObject>(8);
    private final List<Object> bizPartnerIds = new ArrayList<Object>(8);
    private final Map<Long, BigDecimal> farmRateMap = new HashMap<Long, BigDecimal>(8);
    private final Map<Long, Boolean> orgIsTaxMap = new HashMap<Long, Boolean>(1);
    private final QueryUtil queryUtil = new QueryUtil();
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);
    private final Set<String> noRecalculateFieldKeys = Stream.of("price", "pricetax", "actprice", "actpricetax", "discountamount", "discountlocalamt", "e_amount", "e_amountbase", "e_tax", "e_taxlocalamt", "e_pricetaxtotal", "e_pricetaxtotalbase", "e_adjustamount", "e_adjustlocalamt").collect(Collectors.toSet());
    private Map<String, Boolean> ruleIsSettingMap = new HashMap<String, Boolean>(8);
    private final Map<Long, String> noRecalculateSrcEntryIdMap = new HashMap<Long, String>(8);

    public void initVariable(InitVariableEventArgs e) {
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("BillToFinApConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        AsstactConvertHelper.setAccountBankField(extendEntites, "", "asstacttype", "asstact", "payeebanknum", "bebank");
        for (DynamicObject finApBill : entities) {
            DynamicObject org = finApBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit(org, this.orgInitMap, false);
            this.setHeadValue(finApBill);
            this.setDetailEntryValue(finApBill);
        }
        for (DynamicObject finApBill : entities) {
            this.setHeadAmtValue(finApBill);
            this.setPlanEntryValue(finApBill);
        }
        BookDateHelper.setBookDate(entities.toArray(new DynamicObject[0]), false);
        logger.info("BillToFinApConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        List userPks;
        List customerPks;
        logger.info("BillToFinApConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashSet<Long> materialIds = new HashSet<Long>(8);
        HashMap<String, List> asstactTypeToAsstactIdMap = new HashMap<String, List>(8);
        AsstactConvertHelper.checkAsstactType(entities);
        for (DynamicObject entity : entities) {
            long orgId;
            List asstactIds = asstactTypeToAsstactIdMap.computeIfAbsent(entity.getString("asstacttype"), c -> new ArrayList(8));
            asstactIds.add(entity.getLong("asstact.id"));
            if ("bd_supplier".equals(entity.getString("asstacttype")) && !ObjectUtils.isEmpty((Object)entity.getDynamicObject("receivingsupplierid"))) {
                asstactIds.add(entity.getLong("receivingsupplierid.id"));
            }
            if ((orgId = entity.getLong("org.id")) != 0L) {
                orgIds.add(orgId);
            }
            DynamicObjectCollection detailEntries = entity.getDynamicObjectCollection("detailentry");
            for (DynamicObject detailEntry : detailEntries) {
                long materialId = detailEntry.getLong("material.id");
                if (materialId == 0L) continue;
                materialIds.add(materialId);
            }
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, false);
        for (Long orgId : orgIds) {
            this.orgIsTaxMap.put(orgId, TaxCodeConvertHelper.isNeedTax(orgId, false));
        }
        List supplierIds = (List)asstactTypeToAsstactIdMap.get("bd_supplier");
        if (supplierIds != null && supplierIds.size() > 0) {
            this.supplierMap = BusinessDataServiceHelper.loadFromCache((String)"bd_supplier", (String)"internal_company, paymentcurrency, entry_bank.bankaccount, entry_bank.bank, entry_bank.isdefault_bank,invoicecategory", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)supplierIds)});
            Set invoiceCategoryIdSet = this.supplierMap.values().stream().map(t -> t.getLong("invoicecategory.id")).collect(Collectors.toSet());
            Map invoiceBizTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("mulinvoicetype.fbasedataid", "in", invoiceCategoryIdSet).and("mulbiz.fbasedataid", "=", (Object)FI_BIZ_ID)});
            for (Map.Entry<Object, DynamicObject> supplierEntrySet : this.supplierMap.entrySet()) {
                Long invoiceTypeId;
                DynamicObject supplier = supplierEntrySet.getValue();
                DynamicObject intercompany = supplier.getDynamicObject("internal_company");
                if (intercompany != null) {
                    this.bizPartnerIds.add(supplier.getPkValue());
                }
                if ((invoiceTypeId = Long.valueOf(supplier.getLong("invoicecategory.id"))) == 0L) continue;
                for (Map.Entry bizTypeIdEntry : invoiceBizTypeMap.entrySet()) {
                    DynamicObject invoiceBizType = (DynamicObject)bizTypeIdEntry.getValue();
                    DynamicObjectCollection mulInvoiceTypes = invoiceBizType.getDynamicObjectCollection("mulinvoicetype");
                    Set invoiceTypeIds = mulInvoiceTypes.stream().map(t -> t.getLong("FBasedataId.id")).collect(Collectors.toSet());
                    if (!invoiceTypeIds.contains(invoiceTypeId)) continue;
                    this.supplierIdToInvoiceTypeMap.put(supplier.getLong("id"), invoiceBizType);
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object)(customerPks = (List)asstactTypeToAsstactIdMap.get("bd_customer")))) {
            this.customerMap = BusinessDataServiceHelper.loadFromCache((String)"bd_customer", (String)"internal_company,entry_bank.bankaccount,entry_bank.bank,entry_bank.isdefault_bank", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)customerPks)});
            for (Map.Entry<Object, DynamicObject> customerEntrySet : this.customerMap.entrySet()) {
                DynamicObject customer = customerEntrySet.getValue();
                DynamicObject intercompany = customer.getDynamicObject("internal_company");
                if (intercompany == null) continue;
                this.bizPartnerIds.add(customer.getPkValue());
            }
        }
        if (!ObjectUtils.isEmpty((Object)(userPks = (List)asstactTypeToAsstactIdMap.get("bos_user")))) {
            Map payeerMap = BusinessDataServiceHelper.loadFromCache((String)"er_payeer", (String)"id,payer,payerbank,payeraccount", (QFilter[])new QFilter[]{new QFilter("payer", "in", (Object)userPks), new QFilter("status", "=", (Object)Character.valueOf('C')), new QFilter("enable", "=", (Object)Boolean.TRUE)}, (String)"isdefault desc");
            for (Map.Entry map : payeerMap.entrySet()) {
                DynamicObject payeer = (DynamicObject)map.getValue();
                DynamicObject payer = payeer.getDynamicObject("payer");
                if (this.userMap.containsKey(payer.getPkValue())) continue;
                this.userMap.put(payer.getPkValue(), payeer);
            }
        }
        if (materialIds.size() > 0) {
            Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,farmproducts,deductiblerate", (QFilter[])new QFilter[]{new QFilter("id", "in", materialIds)});
            for (Map.Entry entrySet : materialMap.entrySet()) {
                DynamicObject material = (DynamicObject)entrySet.getValue();
                boolean isFarmProducts = material.getBoolean("farmproducts");
                if (!isFarmProducts) continue;
                this.farmRateMap.put(material.getLong("id"), material.getBigDecimal("deductiblerate"));
            }
        }
        this.specInvoiceTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bd_invoicebiztype", (String)"number,id,mulinvoicetype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)InvoiceBizTypeEnum.SP00002_S.getValue()).and("mulbiz.fbasedataid", "=", (Object)FI_BIZ_ID)});
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes("ap_finapbill");
        this.buildNoRecalculateInfo();
        logger.info("BillToFinApConvertPlugin.prepareData end");
    }

    private void buildNoRecalculateInfo() {
        Map variables = this.getOption().getVariables();
        String noRecalculateSrcEntryIds = (String)variables.get("noRecalculateSrcEntryIds");
        if (!ObjectUtils.isEmpty((Object)noRecalculateSrcEntryIds)) {
            List noRecalculateSrcEntryIdList = (List)SerializationUtils.fromJsonString((String)noRecalculateSrcEntryIds, List.class);
            for (Long entryId : noRecalculateSrcEntryIdList) {
                this.noRecalculateSrcEntryIdMap.put(entryId, "true");
            }
            this.ruleIsSettingMap = BOTPHelper.ruleIsSetting(this.getRule(), false, this.noRecalculateFieldKeys);
            logger.info("ruleIsSettingMap\uff1a" + this.ruleIsSettingMap.toString());
        }
    }

    private void setHeadValue(DynamicObject finApBill) {
        DynamicObject invoiceBizType;
        DynamicObject paymentCurrency;
        DynamicObject asstact;
        logger.info("BillToFinApConvertPlugin.setHeadValue start");
        DynamicObject org = finApBill.getDynamicObject("org");
        InitServiceHelper.setBizDate(finApBill, this.orgInitMap.get(org.getLong("id")), this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), false, "exchangerate");
        InitServiceHelper.setInitValue(finApBill, this.orgInitMap.get(org.getLong("id")), isSettingForExchange);
        DynamicObject payorg = finApBill.getDynamicObject("payorg");
        if (ObjectUtils.isEmpty((Object)payorg) || !payorg.getBoolean("fisbankroll")) {
            finApBill.set("payorg", (Object)org);
            payorg = org;
        }
        if (!ObjectUtils.isEmpty((Object)payorg) && !payorg.getBoolean("fisbankroll")) {
            finApBill.set("payorg", null);
        }
        finApBill.set("relationpay", (Object)this.bizPartnerIds.contains(finApBill.getLong("asstact.id")));
        Date termsDate = finApBill.getDate("termsdate");
        if (termsDate == null) {
            Date basicDate = ConditionServiceHelper.getBasicDate(finApBill);
            finApBill.set("termsdate", (Object)basicDate);
        }
        if ((asstact = finApBill.getDynamicObject("asstact")) == null) {
            return;
        }
        String asstactType = asstact.getDataEntityType().getName();
        Object asstactPk = asstact.getPkValue();
        DynamicObject asstactValue = null;
        if ("bd_supplier".equals(asstactType)) {
            asstactValue = this.supplierMap.get(asstactPk);
        } else if ("bd_customer".equals(asstactType)) {
            asstactValue = this.customerMap.get(asstactPk);
        } else if ("bos_user".equals(asstactType)) {
            asstactValue = this.userMap.get(asstactPk);
        }
        if (!"bd_supplier".equals(asstactType)) {
            finApBill.set("paymentcurrency", (Object)finApBill.getDynamicObject("currency"));
        }
        if (asstactValue != null && ObjectUtils.isEmpty((Object)finApBill.get("paymentcurrency")) && !ObjectUtils.isEmpty((Object)(paymentCurrency = asstactValue.getDynamicObject("paymentcurrency")))) {
            finApBill.set("paymentcurrency", (Object)paymentCurrency);
        }
        if ("bd_supplier".equals(asstactType) && (invoiceBizType = finApBill.getDynamicObject("invoicebiztype")) == null) {
            DynamicObject invoiceBizTypeId = this.supplierIdToInvoiceTypeMap.get(asstactPk);
            if (invoiceBizTypeId == null) {
                finApBill.set("invoicebiztype", (Object)this.specInvoiceTypeMap.get(InvoiceBizTypeEnum.SP00002_S.getValue()));
            } else {
                finApBill.set("invoicebiztype", (Object)invoiceBizTypeId);
            }
        }
        String taxPayerType = finApBill.getString("org.taxpayertype");
        long invoiceBizType2 = finApBill.getLong("invoicebiztype.id");
        if (StringUtils.isNotEmpty((CharSequence)taxPayerType)) {
            if (invoiceBizType2 != 0L) {
                if ("1".equals(taxPayerType) && (InvoiceBizTypeEnum.SP00004_S.getValue() == invoiceBizType2 || InvoiceBizTypeEnum.SP00002_S.getValue() == invoiceBizType2)) {
                    finApBill.set("istaxdeduction", (Object)true);
                } else {
                    finApBill.set("istaxdeduction", (Object)false);
                }
            }
        } else if (invoiceBizType2 != 0L && InvoiceBizTypeEnum.SP00002_S.getValue() != invoiceBizType2) {
            finApBill.set("istaxdeduction", (Object)false);
        }
        logger.info("BillToFinApConvertPlugin.setHeadValue end");
    }

    private void setDetailEntryValue(DynamicObject finApBill) {
        logger.info("BillToFinApConvertPlugin.setDetailEntryValue start");
        long orgId = finApBill.getLong("org.id");
        boolean needTax = this.orgIsTaxMap.get(orgId);
        this.calculateDetailEntry(finApBill);
        if (needTax) {
            logger.info("BillToFinApConvertPlugin.setDetailEntryValue needTax");
            TaxCodeConvertHelper.setDetailEntryTax(finApBill);
            this.calculateDetailEntry(finApBill);
        }
        this.farmDeductibleRate(finApBill);
        if (this.isPushAndSave(finApBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finApBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finApDetailEntries = new ArrayList(8);
                finApDetailEntries.addAll(finApBill.getDynamicObjectCollection("detailentry"));
                this.detailEntriesCache.put(finApBill.getLong("id"), finApDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finApBill.getDynamicObjectCollection("detailentry"));
            }
        }
        logger.info("BillToFinApConvertPlugin.setDetailEntryValue end");
    }

    private void setHeadAmtValue(DynamicObject finApBill) {
        logger.info("BillToFinApConvertPlugin.setHeadAmtValue start");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finApBill) ? this.detailEntriesCache.get(finApBill.getLong("id")) : finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_pricetaxtotal"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_pricetaxtotalbase"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_amountbase"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finApBill.set("pricetaxtotal", (Object)priceTaxTotal);
        finApBill.set("pricetaxtotalbase", (Object)priceTaxTotalBase);
        finApBill.set("amount", (Object)amount);
        finApBill.set("amountbase", (Object)amountBase);
        finApBill.set("tax", (Object)tax);
        finApBill.set("taxlocamt", (Object)taxLocAmt);
        finApBill.set("uninvoicedamt", (Object)priceTaxTotal);
        finApBill.set("unverifyamount", (Object)amount);
        finApBill.set("unsettleamount", (Object)priceTaxTotal);
        finApBill.set("unsettleamountbase", (Object)priceTaxTotalBase);
        finApBill.set("adjustamount", (Object)adjustamt);
        finApBill.set("adjustlocalamt", (Object)adjustamtlocal);
        logger.info("BillToFinApConvertPlugin.setHeadAmtValue end");
    }

    private void setPlanEntryValue(DynamicObject finApBill) {
        logger.info("BillToFinApConvertPlugin.setPlanEntryValue start");
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finApBill, this.needMatchSplitSchemes);
        finApBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finApBill)) {
            this.calculatePlanEntryByPushAndSave(finApBill, matchSplitScheme);
        } else {
            ApPlanSplitAndBuilder.splitAndBuild(finApBill, matchSplitScheme);
        }
        this.setHeadDueDate(finApBill);
        logger.info("BillToFinApConvertPlugin.setPlanEntryValue end");
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finApBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinApBills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finApBill.getLong("id"))});
        if (dbFinApBills == null || dbFinApBills.length == 0) {
            ApPlanSplitAndBuilder.splitAndBuild(finApBill, matchSplitScheme);
        } else {
            DynamicObject dbFinApBill = dbFinApBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finApBill.getLong("id"));
            Map<Integer, Integer> detailEntryIndexToSplitDimensionId = ApPlanSplitAndBuilder.splitAndBuildByPushAndSave(finApBill, detailEntries, matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinApBill.getDynamicObjectCollection("detailentry");
            DynamicObjectCollection curDetailEntries = finApBill.getDynamicObjectCollection("detailentry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", (Object)detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", (Object)detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinApBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinApBill});
        }
    }

    private void setHeadDueDate(DynamicObject finApBill) {
        Date planMaxDuedate = finApBill.getDate("duedate");
        DynamicObjectCollection planEntries = finApBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finApBill.set("duedate", (Object)planMaxDuedate);
    }

    private void calculateDetailEntry(DynamicObject finApBill) {
        boolean isbasedonamt = finApBill.getBoolean("payproperty.isbasedonamt");
        DynamicObject baseCurreny = finApBill.getDynamicObject("basecurrency");
        int basePrecision = baseCurreny.getInt("amtprecision");
        int precision = finApBill.getInt("currency.amtprecision");
        boolean includeTax = finApBill.getBoolean("isincludetax");
        boolean isPriceTotal = finApBill.getBoolean("ispricetotal");
        BigDecimal exchangeRate = finApBill.getBigDecimal("exchangerate");
        String quotation = finApBill.getString("quotation");
        if (exchangeRate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        String srcMainTypeName = this.getSrcMainType().getExtendName();
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_baseunitqty;
            BigDecimal covertRate;
            AbstractPriceCalculator calculator;
            BigDecimal discountAmt;
            boolean isPresent = detailEntry.getBoolean("ispresent");
            BigDecimal price = detailEntry.getBigDecimal("price");
            BigDecimal priceTax = detailEntry.getBigDecimal("pricetax");
            if (isbasedonamt && isPresent || isPriceTotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                BigDecimal e_baseunitqty2;
                BigDecimal covertRate2;
                BigDecimal quantity = detailEntry.getBigDecimal("quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate2 = detailEntry.getBigDecimal("e_unitconvertrate")) == null || covertRate2.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = detailEntry.getDynamicObject("material");
                DynamicObject measureUnit = detailEntry.getDynamicObject("measureunit");
                DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        detailEntry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate2 = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate2 = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    detailEntry.set("e_unitconvertrate", (Object)covertRate2);
                }
                if ((e_baseunitqty2 = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                    detailEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate2, baseUnit));
                }
                detailEntry.set("unverifyquantity", (Object)quantity);
                BigDecimal e_unverifybaseqty = detailEntry.getBigDecimal("e_unverifybaseqty");
                if (e_unverifybaseqty == null || e_unverifybaseqty.compareTo(BigDecimal.ZERO) == 0) {
                    detailEntry.set("e_unverifybaseqty", (Object)InitConvertHelper.getBaseunitqty(detailEntry.getBigDecimal("unverifyquantity"), covertRate2, baseUnit));
                }
                BigDecimal e_discountamount = detailEntry.getBigDecimal("discountamount");
                BigDecimal e_discountlocalamt = this.getLocalAmt(e_discountamount, quotation, exchangeRate, basePrecision);
                detailEntry.set("discountlocalamt", (Object)e_discountlocalamt);
                this.reSetPresentAmountField(detailEntry, isPresent);
                continue;
            }
            Long e_sourcebillentryid = detailEntry.getLong("e_sourcebillentryid");
            String noRecalculate = this.noRecalculateSrcEntryIdMap.getOrDefault(e_sourcebillentryid, "false");
            BigDecimal qty = detailEntry.getBigDecimal("quantity");
            BigDecimal taxRate = detailEntry.getBigDecimal("taxrate");
            String discountMode = detailEntry.getString("discountmode");
            BigDecimal discountRate = detailEntry.getBigDecimal("discountrate");
            BigDecimal eAdjustamount = detailEntry.getBigDecimal("e_adjustamount");
            if (isbasedonamt && "ap_busbill".equals(srcMainTypeName)) {
                if ("PERUNIT".equals(discountMode) && BigDecimal.ZERO.compareTo(detailEntry.getBigDecimal("pricetax")) != 0) {
                    discountMode = "PERCENT";
                    detailEntry.set("discountmode", (Object)discountMode);
                    discountRate = includeTax ? discountRate.multiply(new BigDecimal(100)).divide(detailEntry.getBigDecimal("pricetax"), 4, RoundingMode.HALF_UP) : detailEntry.getBigDecimal("discountamount").multiply(new BigDecimal(100)).divide(detailEntry.getBigDecimal("pricetax"), 4, RoundingMode.HALF_UP);
                    if (BigDecimal.ZERO.compareTo(discountRate) > 0) {
                        discountRate = discountRate.negate();
                    }
                    detailEntry.set("discountrate", (Object)discountRate);
                }
                if (includeTax) {
                    if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                        if ("true".equals(noRecalculate)) {
                            if (!this.ruleIsSettingMap.getOrDefault("discountamount", false).booleanValue()) {
                                detailEntry.set("discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                            }
                        } else {
                            detailEntry.set("discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                        }
                    }
                    discountAmt = detailEntry.getBigDecimal("discountamount");
                    BigDecimal e_pricetaxtotal = detailEntry.getBigDecimal("e_pricetaxtotal");
                    calculator = new PriceTaxTotalCalculator(qty, e_pricetaxtotal, taxRate, discountMode, discountRate, precision, eAdjustamount, includeTax, discountAmt);
                } else {
                    if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                        if ("true".equals(noRecalculate)) {
                            if (!this.ruleIsSettingMap.getOrDefault("discountamount", false).booleanValue()) {
                                detailEntry.set("discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                            }
                        } else {
                            detailEntry.set("discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                        }
                    }
                    discountAmt = detailEntry.getBigDecimal("discountamount");
                    BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
                    calculator = new PriceTotalCalculator(qty, e_amount, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                }
            } else if (includeTax) {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    if ("true".equals(noRecalculate)) {
                        if (!this.ruleIsSettingMap.getOrDefault("discountamount", false).booleanValue()) {
                            detailEntry.set("discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else {
                        detailEntry.set("discountamount", (Object)discountRate.multiply(qty).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                discountAmt = detailEntry.getBigDecimal("discountamount");
                if (isPriceTotal) {
                    BigDecimal entryPriceTaxTotal = detailEntry.getBigDecimal("e_pricetaxtotal");
                    calculator = new PriceTaxTotalCalculator(qty, entryPriceTaxTotal, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                } else {
                    BigDecimal taxUnitPrice = detailEntry.getBigDecimal("pricetax");
                    calculator = new TaxUnitPriceCalculator(qty, taxUnitPrice, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                }
            } else {
                if ("TOTAL".equals(discountMode) && discountRate.compareTo(BigDecimal.ZERO) != 0) {
                    if ("true".equals(noRecalculate)) {
                        if (!this.ruleIsSettingMap.getOrDefault("discountamount", false).booleanValue()) {
                            detailEntry.set("discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                        }
                    } else {
                        detailEntry.set("discountamount", (Object)discountRate.multiply(qty).multiply(BigDecimal.ONE.add(taxRate.divide(BigDecimal.valueOf(100L)))).setScale(precision, RoundingMode.HALF_UP));
                    }
                }
                discountAmt = detailEntry.getBigDecimal("discountamount");
                if (isPriceTotal) {
                    BigDecimal entryAmount = detailEntry.getBigDecimal("e_amount");
                    calculator = new PriceTotalCalculator(qty, entryAmount, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                } else {
                    BigDecimal unitPrice = detailEntry.getBigDecimal("price");
                    calculator = new UnitPriceCalculator(qty, unitPrice, taxRate, discountMode, discountRate, precision, eAdjustamount, discountAmt);
                }
            }
            PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, exchangeRate, basePrecision, quotation);
            localCalculator.calculate();
            if ("true".equals(noRecalculate)) {
                if (!this.ruleIsSettingMap.getOrDefault("price", false).booleanValue()) {
                    detailEntry.set("price", (Object)localCalculator.getUnitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("pricetax", false).booleanValue()) {
                    detailEntry.set("pricetax", (Object)localCalculator.getTaxunitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("actprice", false).booleanValue()) {
                    detailEntry.set("actprice", (Object)localCalculator.getActunitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("actpricetax", false).booleanValue()) {
                    detailEntry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
                }
                if (!this.ruleIsSettingMap.getOrDefault("discountamount", false).booleanValue()) {
                    detailEntry.set("discountamount", (Object)localCalculator.getDiscountamount());
                }
                if (!this.ruleIsSettingMap.getOrDefault("discountlocalamt", false).booleanValue()) {
                    detailEntry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_amount", false).booleanValue()) {
                    detailEntry.set("e_amount", (Object)localCalculator.getAmount());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_amountbase", false).booleanValue()) {
                    detailEntry.set("e_amountbase", (Object)localCalculator.getAmountlocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_tax", false).booleanValue()) {
                    detailEntry.set("e_tax", (Object)localCalculator.getTax());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_taxlocalamt", false).booleanValue()) {
                    detailEntry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_pricetaxtotal", false).booleanValue()) {
                    detailEntry.set("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_pricetaxtotalbase", false).booleanValue()) {
                    detailEntry.set("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_adjustamount", false).booleanValue()) {
                    detailEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
                }
                if (!this.ruleIsSettingMap.getOrDefault("e_adjustlocalamt", false).booleanValue()) {
                    detailEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamtlocal());
                }
            } else {
                detailEntry.set("price", (Object)localCalculator.getUnitprice());
                detailEntry.set("pricetax", (Object)localCalculator.getTaxunitprice());
                detailEntry.set("actprice", (Object)localCalculator.getActunitprice());
                detailEntry.set("actpricetax", (Object)localCalculator.getActtaxunitprice());
                detailEntry.set("discountamount", (Object)localCalculator.getDiscountamount());
                detailEntry.set("discountlocalamt", (Object)localCalculator.getDiscountamountlocal());
                detailEntry.set("e_amount", (Object)localCalculator.getAmount());
                detailEntry.set("e_amountbase", (Object)localCalculator.getAmountlocal());
                detailEntry.set("e_tax", (Object)localCalculator.getTax());
                detailEntry.set("e_taxlocalamt", (Object)localCalculator.getTaxlocal());
                detailEntry.set("e_pricetaxtotal", (Object)localCalculator.getPricetaxtotal());
                detailEntry.set("e_pricetaxtotalbase", (Object)localCalculator.getPricetaxtotallocal());
                detailEntry.set("e_adjustamount", (Object)localCalculator.getAdjustamt());
                detailEntry.set("e_adjustlocalamt", (Object)localCalculator.getAdjustamtlocal());
            }
            this.reSetPresentAmountField(detailEntry, isPresent);
            BigDecimal e_pricetaxtotal = detailEntry.getBigDecimal("e_pricetaxtotal");
            BigDecimal e_pricetaxtotalbase = detailEntry.getBigDecimal("e_pricetaxtotalbase");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            detailEntry.set("unlockamt", (Object)e_pricetaxtotal);
            detailEntry.set("unsettleamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_uninvoicedamt", (Object)e_pricetaxtotal);
            detailEntry.set("e_unverifyamount", (Object)e_amount);
            detailEntry.set("unsettleamtbase", (Object)e_pricetaxtotalbase);
            BigDecimal quantity = detailEntry.getBigDecimal("quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            boolean covertRateIsEmpty = (covertRate = detailEntry.getBigDecimal("e_unitconvertrate")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
            DynamicObject material = detailEntry.getDynamicObject("material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRateIsEmpty) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRateIsEmpty) {
                covertRate = BigDecimal.ONE;
            }
            if (covertRateIsEmpty) {
                detailEntry.set("e_unitconvertrate", (Object)covertRate);
            }
            if ((e_baseunitqty = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            detailEntry.set("unverifyquantity", (Object)quantity);
            BigDecimal e_unverifybaseqty = detailEntry.getBigDecimal("e_unverifybaseqty");
            if (e_unverifybaseqty != null && e_unverifybaseqty.compareTo(BigDecimal.ZERO) != 0) continue;
            detailEntry.set("e_unverifybaseqty", (Object)InitConvertHelper.getBaseunitqty(detailEntry.getBigDecimal("unverifyquantity"), covertRate, baseUnit));
        }
    }

    private void reSetPresentAmountField(DynamicObject detailEntry, boolean isPresent) {
        if (isPresent) {
            detailEntry.set("actprice", (Object)BigDecimal.ZERO);
            detailEntry.set("actpricetax", (Object)BigDecimal.ZERO);
            detailEntry.set("e_amount", (Object)BigDecimal.ZERO);
            detailEntry.set("e_amountbase", (Object)BigDecimal.ZERO);
            detailEntry.set("e_tax", (Object)BigDecimal.ZERO);
            detailEntry.set("e_taxlocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_pricetaxtotal", (Object)BigDecimal.ZERO);
            detailEntry.set("e_pricetaxtotalbase", (Object)BigDecimal.ZERO);
            detailEntry.set("e_adjustamount", (Object)BigDecimal.ZERO);
            detailEntry.set("e_adjustlocalamt", (Object)BigDecimal.ZERO);
            detailEntry.set("unlockamt", (Object)BigDecimal.ZERO);
            detailEntry.set("unsettleamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_uninvoicedamt", (Object)BigDecimal.ZERO);
            detailEntry.set("e_unverifyamount", (Object)BigDecimal.ZERO);
            detailEntry.set("unsettleamtbase", (Object)BigDecimal.ZERO);
        }
    }

    private void farmDeductibleRate(DynamicObject finApBill) {
        DynamicObjectCollection detailEntries = finApBill.getDynamicObjectCollection("detailentry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal deductibleRate = detailEntry.getBigDecimal("deductiblerate");
            if (deductibleRate != null && deductibleRate.compareTo(BigDecimal.ZERO) != 0) continue;
            long materialId = detailEntry.getLong("material.id");
            if (materialId != 0L) {
                deductibleRate = this.farmRateMap.get(materialId);
            }
            if (deductibleRate != null) {
                detailEntry.set("deductiblerate", (Object)deductibleRate);
                continue;
            }
            detailEntry.set("deductiblerate", (Object)detailEntry.getBigDecimal("taxrate"));
        }
    }

    private boolean isPushAndSave(DynamicObject finApBill) {
        return BOTPHelper.isPushAndSave(this.getRule(), finApBill);
    }

    private BigDecimal getLocalAmt(BigDecimal amount, String quotation, BigDecimal exchange, int precision) {
        if ("1".equals(quotation)) {
            return amount.divide(exchange, precision, RoundingMode.HALF_UP);
        }
        return amount.multiply(exchange).setScale(precision, RoundingMode.HALF_UP);
    }
}

