/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.ConvertRuleElement;
import kd.bos.entity.botp.FieldMapItem;
import kd.bos.entity.botp.FieldMapPolicy;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.ext.fi.botp.helper.QuotationHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

public class InitConvertHelper {
    public DynamicObject init = null;
    private final QuotationHelper quotationHelper = new QuotationHelper();
    public static final String ExRate_CONVERT_MODE_DIRECT = "0";
    public static final String ExRate_CONVERT_MODE_INDIRECT = "1";

    @SdkDeprecated
    public InitConvertHelper(DynamicObject org, String entity) {
        this.init = this.getInit(org.getLong("id"), entity);
    }

    @SdkDeprecated
    public InitConvertHelper(DynamicObject org, String entity, DynamicObject tarabebtObject, String srcMainTypeName) {
        this.init = this.getInit(org.getLong("id"), entity);
        this.setInitValue(org, tarabebtObject);
    }

    public final DynamicObject getInit(long orgPk, String entity) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        if ("ar_init".equals(entity)) {
            Object[] inits = BusinessDataServiceHelper.load((String)entity, (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
            if (!ObjectUtils.isEmpty((Object[])inits)) {
                if (inits.length == 1) {
                    this.init = inits[0];
                } else {
                    for (Object obj : inits) {
                        DynamicObject policytype = obj.getDynamicObject("policytype");
                        if (policytype == null || !"master".equals(policytype.getString("type"))) continue;
                        this.init = obj;
                    }
                    if (this.init == null) {
                        this.init = inits[0];
                    }
                }
            }
        } else {
            this.init = BusinessDataServiceHelper.loadSingle((String)entity, (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter});
        }
        return this.init;
    }

    public InitConvertHelper(String initEntity, ConvertRuleElement rule, Map<Long, List<DynamicObject>> targetBillByOrgId) {
        ErrorCode ARAPORGNAME_NOT_SET;
        DynamicObject[] inits;
        if (targetBillByOrgId.isEmpty()) {
            return;
        }
        HashMap<Long, DynamicObject> initmap = new HashMap<Long, DynamicObject>(2);
        QFilter qFilter = new QFilter("org", "in", targetBillByOrgId.keySet());
        if ("ar_init".equals(initEntity)) {
            inits = BusinessDataServiceHelper.load((String)initEntity, (String)(this.getSelectors() + ", policytype.type"), (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject initInfo : inits) {
                Long orgId = initInfo.getLong("org.id");
                String policytype = initInfo.getString("policytype.type");
                if ("master".equals(policytype)) {
                    initmap.put(orgId, initInfo);
                    continue;
                }
                initmap.putIfAbsent(orgId, initInfo);
            }
            ARAPORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_SET_2", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u6536\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u6536\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        } else {
            inits = BusinessDataServiceHelper.load((String)initEntity, (String)this.getSelectors(), (QFilter[])new QFilter[]{qFilter});
            for (DynamicObject initInfo : inits) {
                initmap.put(initInfo.getLong("org.id"), initInfo);
            }
            ARAPORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_SET_1", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u4ed8\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u4ed8\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        boolean ruleIsSettingRate = BOTPHelper.ruleIsSetting(rule, false, "exchangerate");
        for (Map.Entry entry : targetBillByOrgId.entrySet()) {
            Long orgId = (Long)entry.getKey();
            this.init = (DynamicObject)initmap.get(orgId);
            if (ObjectUtils.isEmpty((Object)this.getStartDate())) {
                String orgName = "";
                List targetBillList = (List)entry.getValue();
                if (!ObjectUtils.isEmpty((Object)targetBillList)) {
                    DynamicObject org = ((DynamicObject)targetBillList.get(0)).getDynamicObject("org");
                    orgName = org.getLocaleString("name").getLocaleValue();
                }
                throw new KDBizException(ARAPORGNAME_NOT_SET, new Object[]{orgName});
            }
            this.checkOrgInitValue(initEntity);
            for (DynamicObject tarabebtObject : (List)entry.getValue()) {
                this.setExchangeRateInfo(tarabebtObject, ruleIsSettingRate);
            }
        }
    }

    private void setExchangeRateInfo(DynamicObject tarabebtObject, boolean botpSetRate) {
        String entityName = tarabebtObject.getDataEntityType().getName();
        if (!"ap_liquidation".equals(entityName) && !"ar_liquidation".equals(entityName)) {
            Date currentdate = this.init.getDate("currentdate");
            Date bizdate = tarabebtObject.getDate("bizdate");
            if (currentdate != null && bizdate != null && currentdate.compareTo(bizdate) > 0) {
                tarabebtObject.set("bizdate", (Object)currentdate);
            }
        }
        DynamicObject basecurrency = this.getStandardCurrency();
        tarabebtObject.set("basecurrency", (Object)basecurrency);
        if (ObjectUtils.isEmpty((Object)tarabebtObject.get("exratetable"))) {
            tarabebtObject.set("exratetable", (Object)this.getExrateTable());
        }
        if (ObjectUtils.isEmpty((Object)tarabebtObject.get("exratedate"))) {
            tarabebtObject.set("exratedate", (Object)new Date());
        }
        long srcCurrencyId = tarabebtObject.getLong("currency.id");
        String quotation = tarabebtObject.getString("quotation");
        BigDecimal exchangerate = tarabebtObject.getBigDecimal("exchangerate");
        if (!botpSetRate || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0 || ObjectUtils.isEmpty((Object)quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
            long destCurrencyId = basecurrency.getLong("id");
            if (srcCurrencyId == destCurrencyId) {
                tarabebtObject.set("quotation", (Object)ExRate_CONVERT_MODE_DIRECT);
                tarabebtObject.set("exchangerate", (Object)BigDecimal.valueOf(1L));
            } else {
                Tuple<String, BigDecimal> tuple = this.quotationHelper.getExchangeRateMap(tarabebtObject.getLong("exratetable.id"), srcCurrencyId, destCurrencyId, tarabebtObject.getDate("exratedate"));
                if (ObjectUtils.isEmpty((Object)quotation) || quotation.equals(ExRate_CONVERT_MODE_DIRECT)) {
                    tarabebtObject.set("quotation", tuple.item1);
                }
                if (!botpSetRate || ObjectUtils.isEmpty((Object)exchangerate) || BigDecimal.ZERO.compareTo(exchangerate) == 0) {
                    tarabebtObject.set("exchangerate", tuple.item2);
                }
            }
        }
    }

    @SdkDeprecated
    public void setInitValue(DynamicObject org, DynamicObject tarabebtObject) {
        if (ObjectUtils.isEmpty((Object)this.getStartDate())) {
            if ("ap_finapbill".equals(tarabebtObject.getDataEntityType().getName())) {
                ErrorCode ARAPORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_SET_1", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u4ed8\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u4ed8\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_1", (String)"bos-ext-fi", (Object[])new Object[0]));
                throw new KDBizException(ARAPORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
            }
            ErrorCode ARAPORGNAME_NOT_SET = new ErrorCode("ARAPORGNAME_NOT_SET_2", ResManager.loadKDString((String)"\u7ec4\u7ec7:%1$s\u6ca1\u6709\u8fdb\u884c\u5e94\u6536\u521d\u59cb\u5316\u8bbe\u7f6e\uff0c\u8bf7\u5230\u5e94\u6536\u5e94\u7528\u4e0b\u5148\u8fdb\u884c\u7ed3\u675f\u521d\u59cb\u5316\u540e\u518d\u8bd5\u3002", (String)"ARAPORGNAME_NOT_SET_2", (String)"bos-ext-fi", (Object[])new Object[0]));
            throw new KDBizException(ARAPORGNAME_NOT_SET, new Object[]{org.getLocaleString("name").getLocaleValue()});
        }
        this.checkOrgInitValue();
        this.setExchangeRateInfo(tarabebtObject, true);
    }

    @Deprecated
    public static BigDecimal getExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        return InitConvertHelper.getConvertExchangeRate(exratetableId, srcCurrencyId, destCurrencyId, exrateDate);
    }

    public static BigDecimal getConvertExchangeRate(Long exratetableId, Long srcCurrencyId, Long destCurrencyId, Date exrateDate) {
        BigDecimal rate;
        BigDecimal exchangeRate = BigDecimal.ZERO;
        if (exrateDate == null) {
            exrateDate = new Date();
        }
        if (srcCurrencyId == null || srcCurrencyId == 0L || destCurrencyId == null || destCurrencyId == 0L || srcCurrencyId.compareTo(destCurrencyId) == 0) {
            return exchangeRate;
        }
        Map exrateMap = BaseDataServiceHelper.getExchangeRateMap((Long)srcCurrencyId, (Long)destCurrencyId, (Long)exratetableId, (Date)exrateDate);
        if (exrateMap != null && (rate = exrateMap.getOrDefault("exchangeRate", BigDecimal.ZERO)) != null) {
            exchangeRate = rate;
        }
        return exchangeRate;
    }

    @SdkDeprecated
    public static BigDecimal getUnitRateConv(Long materialId, Long srcUnitId, Long desUnitId) {
        BigDecimal unitRate = BigDecimal.ONE;
        if (srcUnitId.equals(desUnitId)) {
            return unitRate;
        }
        DynamicObject muConv1 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)srcUnitId, (Long)desUnitId);
        if (!ObjectUtils.isEmpty((Object)muConv1) && muConv1.getInt("numerator") != 0) {
            unitRate = muConv1.getBigDecimal("numerator").divide(muConv1.getBigDecimal("denominator"), 10, RoundingMode.HALF_UP);
        } else {
            DynamicObject muConv2 = BaseDataServiceHelper.getMUConv((Long)materialId, (Long)desUnitId, (Long)srcUnitId);
            if (!ObjectUtils.isEmpty((Object)muConv2) && muConv2.getInt("numerator") != 0) {
                unitRate = muConv2.getBigDecimal("denominator").divide(muConv2.getBigDecimal("numerator"), 10, RoundingMode.HALF_UP);
            }
        }
        if (unitRate == null) {
            unitRate = BigDecimal.ONE;
        }
        return unitRate;
    }

    @SdkDeprecated
    public static BigDecimal getBaseunitqty(BigDecimal quantity, BigDecimal covertRate, DynamicObject baseUnit) {
        BigDecimal baseunitqty = BigDecimal.ZERO;
        if (covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0) {
            covertRate = BigDecimal.ONE;
        }
        int precisionaccount = 4;
        int precision = 10;
        if (baseUnit == null) {
            baseunitqty = quantity.multiply(covertRate).setScale(precision, precisionaccount);
            return baseunitqty;
        }
        precisionaccount = baseUnit.getInt("precisionaccount");
        precision = baseUnit.getInt("precision");
        baseunitqty = precisionaccount == 2 ? quantity.multiply(covertRate).setScale(precision, 1) : (precisionaccount == 3 ? quantity.multiply(covertRate).setScale(precision, 0) : quantity.multiply(covertRate).setScale(precision, 4));
        return baseunitqty;
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("org");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startdate");
        selectors.add("currentdate");
        selectors.add("periodtype");
        return String.join((CharSequence)",", selectors);
    }

    public final Date getStartDate() {
        if (this.init == null) {
            return null;
        }
        Date startDate = this.init.getDate("startdate");
        return startDate == null ? null : InitConvertHelper.getDataFormat(startDate, true);
    }

    public static Date getDataFormat(Date date, boolean isStart) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
        String suffix = " 00:00:00";
        if (!isStart) {
            suffix = " 23:59:59";
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(dateStr + suffix);
        }
        catch (ParseException e) {
            throw new KDException((Throwable)e, BosErrorCode.systemError, new Object[0]);
        }
    }

    public DynamicObject getStandardCurrency() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("standardcurrency");
    }

    public DynamicObject getExrateTable() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDynamicObject("exratetable");
    }

    public boolean isFinishInit() {
        if (this.init == null) {
            return false;
        }
        return this.init.getBoolean("isfinishinit");
    }

    public boolean isFinishSetting() {
        return this.init.getDate("startdate") != null;
    }

    public String getEntityName() {
        if (this.init == null) {
            return null;
        }
        return this.init.getDataEntityType().getName();
    }

    @SdkDeprecated
    public static void checkExRate(ConvertRuleElement cre, DynamicObject targetObj) {
        BigDecimal targetExRate = (BigDecimal)targetObj.get("exchangerate");
        if (!ObjectUtils.isEmpty((Object)targetExRate) && BigDecimal.ONE.compareTo(targetExRate) == 0) {
            FieldMapPolicy fmp = cre.getFieldMapPolicy();
            List fmis = fmp.getFieldMaps();
            boolean exchangerateExist = false;
            for (FieldMapItem fmi : fmis) {
                if (!"exchangerate".equals(fmi.getTargetFieldKey())) continue;
                exchangerateExist = true;
                break;
            }
            if (!exchangerateExist) {
                targetObj.set("exchangerate", (Object)BigDecimal.ZERO);
            }
        }
    }

    public final void checkOrgInitValue() {
        StringBuilder errMsg = new StringBuilder();
        if (ObjectUtils.isEmpty((Object)this.init.getDynamicObject("standardcurrency"))) {
            errMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e3b\u5e01\u79cd", (String)"InitConvertHelper_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)this.init.getDynamicObject("exratetable"))) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"InitConvertHelper_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)this.init.getDynamicObject("periodtype"))) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"InitConvertHelper_3", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (errMsg.length() > 0) {
            String initEntity = this.init.getDataEntityType().getName();
            String appName = "ar_init".equals(initEntity) ? ResManager.loadKDString((String)"\u5e94\u6536", (String)"InitConvertHelper_4", (String)"bos-ext-fi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8", (String)"InitConvertHelper_5", (String)"bos-ext-fi", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u521d\u59cb\u5316\u8bbe\u7f6e\u5b57\u6bb5\u201c%2$s\u201d\u9519\u8bef\uff0c\u8bf7\u5230\u201c%3$s\u201d\u5e94\u7528\u4e0b\u68c0\u67e5\u201c\u521d\u59cb\u5316\u8bbe\u7f6e\u201d\u3002", (String)"InitConvertHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]), this.init.getString("org.name"), errMsg.toString(), appName));
        }
    }

    public void checkOrgInitValue(String initEntity) {
        StringBuilder errMsg = new StringBuilder();
        if (ObjectUtils.isEmpty((Object)this.init.getDynamicObject("standardcurrency"))) {
            errMsg.append(ResManager.loadKDString((String)"\u4e1a\u52a1\u4e3b\u5e01\u79cd", (String)"InitConvertHelper_1", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)this.init.getDynamicObject("exratetable"))) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u6c47\u7387\u8868", (String)"InitConvertHelper_2", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)this.init.getDynamicObject("periodtype"))) {
            if (errMsg.length() > 0) {
                errMsg.append("\u3001");
            }
            errMsg.append(ResManager.loadKDString((String)"\u671f\u95f4\u7c7b\u578b", (String)"InitConvertHelper_3", (String)"bos-ext-fi", (Object[])new Object[0]));
        }
        if (errMsg.length() > 0) {
            String appName = "ar_init".equals(initEntity) ? ResManager.loadKDString((String)"\u5e94\u6536", (String)"InitConvertHelper_4", (String)"bos-ext-fi", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5e94\u4ed8", (String)"InitConvertHelper_5", (String)"bos-ext-fi", (Object[])new Object[0]);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%1$s\u201d\u521d\u59cb\u5316\u8bbe\u7f6e\u5b57\u6bb5\u201c%2$s\u201d\u9519\u8bef\uff0c\u8bf7\u5230\u201c%3$s\u201d\u5e94\u7528\u4e0b\u68c0\u67e5\u201c\u521d\u59cb\u5316\u8bbe\u7f6e\u201d\u3002", (String)"InitConvertHelper_0", (String)"bos-ext-fi", (Object[])new Object[0]), this.init.getString("org.name"), errMsg.toString(), appName));
        }
    }
}

