/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.ExtendedDataEntitySet;
import kd.bos.entity.botp.plugin.AbstractConvertPlugIn;
import kd.bos.entity.botp.plugin.args.AfterConvertEventArgs;
import kd.bos.entity.botp.plugin.args.InitVariableEventArgs;
import kd.bos.ext.fi.plugin.ArApConvert.ArApConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitConvertHelper;
import kd.bos.ext.fi.plugin.ArApConvert.InitServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.ArPlanSplitAndBuilder;
import kd.bos.ext.fi.plugin.ArApConvert.Plan.PlanSplitSchemeServiceHelper;
import kd.bos.ext.fi.plugin.ArApConvert.helper.BOTPHelper;
import kd.bos.ext.fi.util.QueryUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class InvoiceToFinArConvertPlugin
extends AbstractConvertPlugIn {
    private static final Log logger = LogFactory.getLog(InvoiceToFinArConvertPlugin.class);
    private Map<Long, DynamicObject> orgInitMap;
    private DynamicObject[] needMatchSplitSchemes;
    private final QueryUtil queryUtil = new QueryUtil();
    private final List<Object> bizPartnerIds = new ArrayList<Object>(8);
    private final Map<Long, List<DynamicObject>> detailEntriesCache = new HashMap<Long, List<DynamicObject>>(1);

    public void initVariable(InitVariableEventArgs e) {
    }

    public void afterConvert(AfterConvertEventArgs e) {
        logger.info("InvoiceToFinArConvertPlugin.afterConvert start");
        ExtendedDataEntitySet entitySet = e.getTargetExtDataEntitySet();
        ExtendedDataEntity[] extendEntites = entitySet.FindByEntityKey(this.getTgtMainType().getExtendName());
        ArrayList<DynamicObject> entities = new ArrayList<DynamicObject>(extendEntites.length);
        for (ExtendedDataEntity extendEntity : extendEntites) {
            entities.add(extendEntity.getDataEntity());
        }
        this.prepareData(entities);
        for (DynamicObject finArBill : entities) {
            DynamicObject org = finArBill.getDynamicObject("org");
            if (ObjectUtils.isEmpty((Object)org)) {
                return;
            }
            InitServiceHelper.checkOrgInit(org, this.orgInitMap, true);
            this.setHeadValue(finArBill);
            this.setDetailEntryValue(finArBill);
        }
        for (DynamicObject finArBill : entities) {
            this.setHeadAmtValue(finArBill);
            this.setPlanEntryValue(finArBill);
        }
        logger.info("InvoiceToFinArConvertPlugin.afterConvert end");
    }

    private void prepareData(List<DynamicObject> entities) {
        logger.info("InvoiceToFinArConvertPlugin.prepareData start");
        HashSet<Long> orgIds = new HashSet<Long>(1);
        HashMap<String, List> asstactTypeToAsstactIdMap = new HashMap<String, List>(8);
        for (DynamicObject dynamicObject : entities) {
            List asstactIds = asstactTypeToAsstactIdMap.computeIfAbsent(dynamicObject.getString("asstacttype"), c -> new ArrayList(8));
            asstactIds.add(dynamicObject.getLong("asstact.id"));
            long orgId = dynamicObject.getLong("org.id");
            if (orgId == 0L) continue;
            orgIds.add(orgId);
        }
        this.orgInitMap = InitServiceHelper.loadInitInfos(orgIds, true);
        for (Map.Entry entry : asstactTypeToAsstactIdMap.entrySet()) {
            this.bizPartnerIds.addAll(ArApConvertHelper.getBizPartnerIds((String)entry.getKey(), (List)entry.getValue()));
        }
        this.needMatchSplitSchemes = PlanSplitSchemeServiceHelper.getMatchSchemes("ar_finarbill");
        logger.info("InvoiceToFinArConvertPlugin.prepareData end");
    }

    private void setHeadValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setHeadValue start");
        DynamicObject org = finArBill.getDynamicObject("org");
        InitServiceHelper.setBizDate(finArBill, this.orgInitMap.get(org.getLong("id")), this.getRule());
        boolean isSettingForExchange = BOTPHelper.ruleIsSetting(this.getRule(), false, "exchangerate");
        InitServiceHelper.setInitValue(finArBill, this.orgInitMap.get(org.getLong("id")), isSettingForExchange);
        DynamicObject recorg = finArBill.getDynamicObject("recorg");
        if (ObjectUtils.isEmpty((Object)recorg) || !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", (Object)org);
            recorg = org;
        }
        if (!ObjectUtils.isEmpty((Object)recorg) && !recorg.getBoolean("fisbankroll")) {
            finArBill.set("recorg", null);
        }
        finArBill.set("relationpay", (Object)this.bizPartnerIds.contains(finArBill.getLong("asstact.id")));
        logger.info("InvoiceToFinArConvertPlugin.setHeadValue end");
    }

    private void setDetailEntryValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setDetailEntryValue start");
        this.calculateDetailEntry(finArBill);
        if (this.isPushAndSave(finArBill)) {
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            if (detailEntries == null) {
                ArrayList finArDetailEntries = new ArrayList(8);
                finArDetailEntries.addAll(finArBill.getDynamicObjectCollection("entry"));
                this.detailEntriesCache.put(finArBill.getLong("id"), finArDetailEntries);
            } else {
                detailEntries.addAll((Collection<DynamicObject>)finArBill.getDynamicObjectCollection("entry"));
            }
        }
        logger.info("InvoiceToFinArConvertPlugin.setDetailEntryValue end");
    }

    private void setHeadAmtValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setHeadAmtValue start");
        BigDecimal priceTaxTotal = BigDecimal.ZERO;
        BigDecimal priceTaxTotalBase = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal amountBase = BigDecimal.ZERO;
        BigDecimal tax = BigDecimal.ZERO;
        BigDecimal taxLocAmt = BigDecimal.ZERO;
        BigDecimal adjustamt = BigDecimal.ZERO;
        BigDecimal adjustamtlocal = BigDecimal.ZERO;
        Object detailEntries = this.isPushAndSave(finArBill) ? this.detailEntriesCache.get(finArBill.getLong("id")) : finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            priceTaxTotal = priceTaxTotal.add(detailEntry.getBigDecimal("e_recamount"));
            priceTaxTotalBase = priceTaxTotalBase.add(detailEntry.getBigDecimal("e_reclocalamt"));
            amount = amount.add(detailEntry.getBigDecimal("e_amount"));
            amountBase = amountBase.add(detailEntry.getBigDecimal("e_localamt"));
            tax = tax.add(detailEntry.getBigDecimal("e_tax"));
            taxLocAmt = taxLocAmt.add(detailEntry.getBigDecimal("e_taxlocalamt"));
            adjustamt = adjustamt.add(detailEntry.getBigDecimal("e_adjustamount"));
            adjustamtlocal = adjustamtlocal.add(detailEntry.getBigDecimal("e_adjustlocalamt"));
        }
        finArBill.set("recamount", (Object)priceTaxTotal);
        finArBill.set("reclocalamt", (Object)priceTaxTotalBase);
        finArBill.set("amount", (Object)amount);
        finArBill.set("localamt", (Object)amountBase);
        finArBill.set("tax", (Object)tax);
        finArBill.set("taxlocamt", (Object)taxLocAmt);
        finArBill.set("unverifyamount", (Object)amount);
        finArBill.set("unsettleamount", (Object)priceTaxTotal);
        finArBill.set("unsettlelocalamt", (Object)priceTaxTotalBase);
        finArBill.set("adjustamount", (Object)adjustamt);
        finArBill.set("adjustlocalamt", (Object)adjustamtlocal);
        finArBill.set("invoicedamt", (Object)priceTaxTotal);
        finArBill.set("invoicedlocalamt", (Object)priceTaxTotalBase);
        logger.info("InvoiceToFinArConvertPlugin.setHeadAmtValue end");
    }

    private void setPlanEntryValue(DynamicObject finArBill) {
        logger.info("InvoiceToFinArConvertPlugin.setPlanEntryValue start");
        DynamicObject matchSplitScheme = PlanSplitSchemeServiceHelper.matchSingleScheme(finArBill, this.needMatchSplitSchemes);
        finArBill.set("splitscheme", (Object)matchSplitScheme);
        if (this.isPushAndSave(finArBill)) {
            this.calculatePlanEntryByPushAndSave(finArBill, matchSplitScheme);
        } else {
            ArPlanSplitAndBuilder.splitAndBuild(finArBill, matchSplitScheme);
        }
        this.setHeadDueDate(finArBill);
        logger.info("InvoiceToFinArConvertPlugin.setPlanEntryValue end");
    }

    private void calculatePlanEntryByPushAndSave(DynamicObject finArBill, DynamicObject matchSplitScheme) {
        DynamicObject[] dbFinArBills = BusinessDataServiceHelper.load((String)"ar_finarbill", (String)"e_splitdimensionid,planentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finArBill.getLong("id"))});
        if (dbFinArBills == null || dbFinArBills.length == 0) {
            ArPlanSplitAndBuilder.splitAndBuild(finArBill, matchSplitScheme);
        } else {
            DynamicObject dbFinArBill = dbFinArBills[0];
            List<DynamicObject> detailEntries = this.detailEntriesCache.get(finArBill.getLong("id"));
            Map<Integer, Integer> detailEntryIndexToSplitDimensionId = ArPlanSplitAndBuilder.splitAndBuildByPushAndSave(finArBill, detailEntries, matchSplitScheme);
            DynamicObjectCollection dbDetailEntries = dbFinArBill.getDynamicObjectCollection("entry");
            DynamicObjectCollection curDetailEntries = finArBill.getDynamicObjectCollection("entry");
            int dbDetailEntrySize = dbDetailEntries.size();
            for (int i = 0; i < dbDetailEntrySize; ++i) {
                DynamicObject dbDetailEntry = (DynamicObject)dbDetailEntries.get(i);
                dbDetailEntry.set("e_splitdimensionid", (Object)detailEntryIndexToSplitDimensionId.get(i));
            }
            int curDetailEntrySize = curDetailEntries.size();
            for (int i = 0; i < curDetailEntrySize; ++i) {
                DynamicObject curDetailEntry = (DynamicObject)curDetailEntries.get(i);
                curDetailEntry.set("e_splitdimensionid", (Object)detailEntryIndexToSplitDimensionId.get(i + dbDetailEntrySize));
            }
            DynamicObjectCollection dbPlanEntries = dbFinArBill.getDynamicObjectCollection("planentity");
            dbPlanEntries.clear();
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dbFinArBill});
        }
    }

    private void setHeadDueDate(DynamicObject finArBill) {
        Date planMaxDuedate = finArBill.getDate("duedate");
        DynamicObjectCollection planEntries = finArBill.getDynamicObjectCollection("planentity");
        for (DynamicObject planEntry : planEntries) {
            Date planEntryDueDate = planEntry.getDate("planduedate");
            if (planMaxDuedate == null) {
                planMaxDuedate = planEntryDueDate;
                continue;
            }
            if (planEntryDueDate == null) continue;
            planMaxDuedate = planEntryDueDate.after(planMaxDuedate) ? planEntryDueDate : planMaxDuedate;
        }
        finArBill.set("duedate", (Object)planMaxDuedate);
    }

    private void calculateDetailEntry(DynamicObject finArBill) {
        String quotation = finArBill.getString("quotation");
        BigDecimal exchangerate = finArBill.getBigDecimal("exchangerate");
        if (exchangerate.compareTo(BigDecimal.ZERO) == 0) {
            quotation = "0";
        }
        int baseprecision = finArBill.getInt("basecurrency.amtprecision");
        DynamicObjectCollection detailEntries = finArBill.getDynamicObjectCollection("entry");
        for (DynamicObject detailEntry : detailEntries) {
            BigDecimal e_baseunitqty;
            BigDecimal price = detailEntry.getBigDecimal("e_unitprice");
            boolean isPresent = detailEntry.getBoolean("e_ispresent");
            boolean ispricetotal = finArBill.getBoolean("ispricetotal");
            BigDecimal priceTax = detailEntry.getBigDecimal("e_taxunitprice");
            if (ispricetotal && isPresent && (BigDecimal.ZERO.compareTo(price) != 0 || BigDecimal.ZERO.compareTo(priceTax) != 0)) {
                BigDecimal e_baseunitqty2;
                BigDecimal covertRate;
                BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
                if (quantity == null) {
                    quantity = BigDecimal.ZERO;
                }
                boolean covertRateIsEmpty = (covertRate = detailEntry.getBigDecimal("e_unitcoefficient")) == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
                DynamicObject material = detailEntry.getDynamicObject("e_material");
                DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
                DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
                if (!ObjectUtils.isEmpty((Object)material)) {
                    if (ObjectUtils.isEmpty((Object)baseUnit)) {
                        baseUnit = material.getDynamicObject("baseunit");
                        detailEntry.set("e_baseunit", (Object)baseUnit);
                    }
                    if (measureUnit == null) {
                        measureUnit = baseUnit;
                    }
                    if (covertRateIsEmpty) {
                        covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                    }
                } else if (covertRateIsEmpty) {
                    covertRate = BigDecimal.ONE;
                }
                if (covertRateIsEmpty) {
                    detailEntry.set("e_unitcoefficient", (Object)covertRate);
                }
                if ((e_baseunitqty2 = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty2.compareTo(BigDecimal.ZERO) == 0) {
                    detailEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
                }
                detailEntry.set("e_unverifyqty", (Object)quantity);
                detailEntry.set("e_unconfirmqty", (Object)quantity);
                detailEntry.set("e_invoicedqty", (Object)quantity);
                detailEntry.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
                continue;
            }
            BigDecimal e_recAmount = detailEntry.getBigDecimal("e_recamount");
            BigDecimal e_reclocalamt = detailEntry.getBigDecimal("e_reclocalamt");
            BigDecimal e_amount = detailEntry.getBigDecimal("e_amount");
            BigDecimal e_tax = detailEntry.getBigDecimal("e_tax");
            BigDecimal e_adjustamount = detailEntry.getBigDecimal("e_adjustamount");
            BigDecimal e_adjustlocalamt = detailEntry.getBigDecimal("e_adjustlocalamt");
            if (detailEntry.getBigDecimal("e_unitprice").compareTo(BigDecimal.ZERO) == 0 || detailEntry.getBigDecimal("e_taxunitprice").compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_ispresent", (Object)Boolean.TRUE);
            }
            detailEntry.set("e_reclocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_unverifyamt", (Object)e_amount);
            detailEntry.set("e_unlockamt", (Object)e_recAmount);
            detailEntry.set("e_unsettleamt", (Object)e_recAmount);
            detailEntry.set("e_unsettlelocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_unconfirmamt", (Object)e_amount);
            detailEntry.set("e_invoicedamt", (Object)e_recAmount);
            detailEntry.set("e_invoicedlocalamt", (Object)e_reclocalamt);
            detailEntry.set("e_adjustamount", (Object)e_adjustamount);
            detailEntry.set("e_adjustlocalamt", (Object)e_adjustlocalamt);
            BigDecimal quantity = detailEntry.getBigDecimal("e_quantity");
            if (quantity == null) {
                quantity = BigDecimal.ZERO;
            }
            BigDecimal e_taxlocal = "1".equals(quotation) ? e_tax.divide(exchangerate, baseprecision, RoundingMode.HALF_UP) : e_tax.multiply(exchangerate).setScale(baseprecision, RoundingMode.HALF_UP);
            detailEntry.set("e_taxlocalamt", (Object)e_taxlocal);
            detailEntry.set("e_invoicedqty", (Object)quantity);
            detailEntry.set("e_uninvoicedqty", (Object)BigDecimal.ZERO);
            BigDecimal covertRate = detailEntry.getBigDecimal("e_unitcoefficient");
            boolean covertRateIsEmpty = covertRate == null || covertRate.compareTo(BigDecimal.ZERO) == 0;
            DynamicObject material = detailEntry.getDynamicObject("e_material");
            DynamicObject measureUnit = detailEntry.getDynamicObject("e_measureunit");
            DynamicObject baseUnit = detailEntry.getDynamicObject("e_baseunit");
            if (!ObjectUtils.isEmpty((Object)material)) {
                if (ObjectUtils.isEmpty((Object)baseUnit)) {
                    baseUnit = material.getDynamicObject("baseunit");
                    detailEntry.set("e_baseunit", (Object)baseUnit);
                }
                if (measureUnit == null) {
                    measureUnit = baseUnit;
                }
                if (covertRateIsEmpty) {
                    covertRate = this.queryUtil.getConvertRate(material.getLong("id"), measureUnit.getLong("id"), baseUnit.getLong("id"));
                }
            } else if (covertRateIsEmpty) {
                covertRate = BigDecimal.ONE;
            }
            if (covertRateIsEmpty) {
                detailEntry.set("e_unitcoefficient", (Object)covertRate);
            }
            if ((e_baseunitqty = detailEntry.getBigDecimal("e_baseunitqty")) == null || e_baseunitqty.compareTo(BigDecimal.ZERO) == 0) {
                detailEntry.set("e_baseunitqty", (Object)InitConvertHelper.getBaseunitqty(quantity, covertRate, baseUnit));
            }
            detailEntry.set("e_unverifyqty", (Object)quantity);
            detailEntry.set("e_unconfirmqty", (Object)quantity);
        }
    }

    private boolean isPushAndSave(DynamicObject finArBill) {
        return BOTPHelper.isPushAndSave(this.getRule(), finArBill);
    }
}

