/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin.ArApConvert.Plan;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sdk.annotation.SdkDeprecated;

public class PlanSplitSchemeServiceHelper {
    private static final Log logger = LogFactory.getLog(PlanSplitSchemeServiceHelper.class);

    public static List<String> getDimensionsBySchemeId(long schemeId, DynamicObjectType type) {
        ArrayList<String> dimensionKeys = new ArrayList<String>(8);
        String entityName = type.getName();
        DynamicObject splitScheme = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"detailkey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        DynamicObjectCollection dimensionEntries = splitScheme.getDynamicObjectCollection("d_entry");
        for (DynamicObject dimensionEntry : dimensionEntries) {
            dimensionKeys.add(dimensionEntry.getString("detailkey"));
        }
        return dimensionKeys;
    }

    public static Map<String, String> getDimensionMapBySchemeId(long schemeId, DynamicObjectType type) {
        HashMap<String, String> result = new HashMap<String, String>();
        String entityName = type.getName();
        DynamicObject splitScheme = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"detailkey,plankey", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)schemeId)});
        DynamicObjectCollection dimensionEntries = splitScheme.getDynamicObjectCollection("d_entry");
        for (DynamicObject dimensionEntry : dimensionEntries) {
            result.put(dimensionEntry.getString("detailkey"), dimensionEntry.getString("plankey"));
        }
        return result;
    }

    public static Map<String, String> getDimensionMapByScheme(DynamicObject splitScheme) {
        HashMap<String, String> result = new HashMap<String, String>();
        DynamicObjectCollection dimensionEntries = splitScheme.getDynamicObjectCollection("d_entry");
        for (DynamicObject dimensionEntry : dimensionEntries) {
            result.put(dimensionEntry.getString("detailkey"), dimensionEntry.getString("plankey"));
        }
        return result;
    }

    public static List<String> getDimensionsByScheme(DynamicObject splitScheme) {
        ArrayList<String> dimensionKeys = new ArrayList<String>(8);
        DynamicObjectCollection dimensionEntries = splitScheme.getDynamicObjectCollection("d_entry");
        for (DynamicObject dimensionEntry : dimensionEntries) {
            dimensionKeys.add(dimensionEntry.getString("detailkey"));
        }
        return dimensionKeys;
    }

    public static DynamicObject[] getAllSchemes(boolean isAr) {
        String entityName = isAr ? "ar_plansplit_scheme" : "ap_plansplit_scheme";
        List ids = QueryServiceHelper.queryPrimaryKeys((String)entityName, null, (String)"", (int)10000);
        return BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityName));
    }

    @SdkDeprecated
    public static DynamicObject[] getMatchSchemes(DynamicObject finBill) {
        String finName = finBill.getDynamicObjectType().getName();
        String schemeName = "ar_finarbill".equals(finName) ? "ar_plansplit_scheme" : "ap_plansplit_scheme";
        List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)schemeName, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)10000);
        return BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)schemeName));
    }

    @SdkDeprecated
    public static DynamicObject[] getMatchSchemes(String finBillName, long orgId) {
        String schemeName = "ar_finarbill".equals(finBillName) ? "ar_plansplit_scheme" : "ap_plansplit_scheme";
        List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)schemeName, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)10000);
        return BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)schemeName));
    }

    @SdkDeprecated
    public static DynamicObject[] getMatchSchemes(String finBillName) {
        String schemeName = "ar_finarbill".equals(finBillName) ? "ar_plansplit_scheme" : "ap_plansplit_scheme";
        List schemeIds = QueryServiceHelper.queryPrimaryKeys((String)schemeName, (QFilter[])new QFilter[]{new QFilter("enable", "=", (Object)"1")}, (String)"createtime", (int)10000);
        return BusinessDataServiceHelper.load((Object[])schemeIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)schemeName));
    }

    @SdkDeprecated
    public static DynamicObject matchSingleScheme(DynamicObject finBill, DynamicObject[] schemes) {
        DynamicObject result = null;
        for (DynamicObject scheme : schemes) {
            boolean match = true;
            DynamicObjectCollection conditionEntries = scheme.getDynamicObjectCollection("c_entry");
            for (DynamicObject conditionEntry : conditionEntries) {
                String field = conditionEntry.getString("field");
                String condition = conditionEntry.getString("condition");
                String conditionValue = conditionEntry.getString("clargevalue_tag");
                Object finBillValue = finBill.get(field);
                if (finBillValue != null) {
                    String fieldValueId = finBillValue instanceof DynamicObject ? String.valueOf(((DynamicObject)finBillValue).getLong("id")) : finBillValue.toString();
                    if ("in".equals(condition) && !conditionValue.contains(fieldValueId)) {
                        match = false;
                        break;
                    }
                    if ("notin".equals(condition) && conditionValue.contains(fieldValueId)) {
                        match = false;
                        break;
                    }
                    if ("=".equals(condition) && !fieldValueId.equals(conditionValue)) {
                        match = false;
                        break;
                    }
                    if (!"!=".equals(condition) || !fieldValueId.equals(conditionValue)) continue;
                    match = false;
                    break;
                }
                match = false;
                break;
            }
            if (!match) continue;
            logger.info("match a splitscheme:" + scheme.getString("name"));
            result = scheme;
            break;
        }
        return result;
    }

    public static DynamicObject matchSingleScheme(DynamicObject finBill) {
        DynamicObject[] schemes = PlanSplitSchemeServiceHelper.getMatchSchemes(finBill);
        return PlanSplitSchemeServiceHelper.matchSingleScheme(finBill, schemes);
    }
}

