/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin;

import java.util.EventObject;
import java.util.Objects;
import java.util.Optional;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.util.StringUtils;

public class DataMapperMatchPluginIn
extends AbstractFuncParamPlugIn {
    private static final String SIGN_SOURCEPROP = "source_prop";
    private static final String SIGN_MAPPERTABLE = "mapper_table";
    private static final String FROM_SELECTFIELD = "botp_selectfield";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{SIGN_SOURCEPROP, SIGN_MAPPERTABLE});
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String sourceProp = (String)this.getModel().getValue(SIGN_SOURCEPROP);
        String mapperTable = (String)this.getModel().getValue(SIGN_MAPPERTABLE);
        if (StringUtils.isBlank((String)sourceProp) || StringUtils.isBlank((String)mapperTable)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u5b57\u6bb5\u9879\u201d\u3002", (String)"DataMapperMatchPluginIn_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (SIGN_SOURCEPROP.equalsIgnoreCase(source.getKey())) {
            this.showSelectFieldForm(SIGN_SOURCEPROP);
        } else if (SIGN_MAPPERTABLE.equalsIgnoreCase(source.getKey())) {
            ListShowParameter listShowParameter = ShowFormHelper.createShowListForm((String)"fbd_data_mapper", (boolean)false);
            listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, SIGN_MAPPERTABLE));
            listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            this.getView().showForm((FormShowParameter)listShowParameter);
        }
    }

    private void showSelectFieldForm(String actionId) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId(FROM_SELECTFIELD);
        TreeNode fieldNodes = this.getVarNodes();
        String nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        form.getCustomParams().put("treenodes", nodesJson);
        form.setCloseCallBack(new CloseCallBack((IFormPlugin)this, actionId));
        form.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(form);
    }

    public void closedCallBack(ClosedCallBackEvent ccbe) {
        super.closedCallBack(ccbe);
        if (SIGN_SOURCEPROP.equalsIgnoreCase(ccbe.getActionId())) {
            String prop = Optional.ofNullable(ccbe.getReturnData()).map(Objects::toString).orElseGet(() -> null);
            Optional.ofNullable(prop).ifPresent(o -> this.getModel().setValue(SIGN_SOURCEPROP, o));
        } else if (SIGN_MAPPERTABLE.equalsIgnoreCase(ccbe.getActionId())) {
            ListSelectedRowCollection lsrc = (ListSelectedRowCollection)ccbe.getReturnData();
            Optional.ofNullable(lsrc).ifPresent(o -> {
                ListSelectedRow lsr = lsrc.get(0);
                this.getModel().setValue(SIGN_MAPPERTABLE, (Object)lsr.getNumber());
            });
        }
    }

    public String getSetting() {
        String mapperTable;
        String sourceProp = (String)this.getModel().getValue(SIGN_SOURCEPROP);
        if (StringUtils.isBlank((String)sourceProp)) {
            sourceProp = "0";
        }
        if (StringUtils.isBlank((String)(mapperTable = (String)this.getModel().getValue(SIGN_MAPPERTABLE)))) {
            mapperTable = "0";
        }
        String setting = String.format("%s('%s', '%s')", this.getFuncId(), sourceProp, mapperTable);
        return setting;
    }
}

