/*
 * Decompiled with CFR 0.152.
 */
package kd.bos.ext.fi.plugin;

import java.util.EventObject;
import java.util.List;
import java.util.ListIterator;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.LinkEntryProp;
import kd.bos.entity.property.OrgProp;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.func.AbstractFuncParamPlugIn;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class GetAccountParamPlugIn
extends AbstractFuncParamPlugIn {
    private static final String Key_OrgId = "orgid";
    private static final String Key_AccountType = "accounttype";

    public void initialize() {
        super.initialize();
        this.addClickListeners(new String[]{Key_OrgId});
    }

    public Boolean checkSetting(StringBuilder msgBuilder) {
        String paramKey = (String)this.getModel().getValue(Key_OrgId);
        if (StringUtils.isBlank((CharSequence)paramKey)) {
            msgBuilder.append(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u7ec4\u7ec7\u201d\u9879\u3002", (String)"GetAccountParamPlugIn_0", (String)"bos-ext-fi", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control source = (Control)evt.getSource();
        if (StringUtils.equalsIgnoreCase((CharSequence)source.getKey(), (CharSequence)Key_OrgId)) {
            this.showSelectFieldForm(Key_OrgId, true);
        }
    }

    private void showSelectFieldForm(String sourceCtrlKey, boolean onlyShowOrg) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("botp_selectfield");
        TreeNode fieldNodes = this.getVarNodes();
        MainEntityType dataEntityType = null;
        if (onlyShowOrg) {
            String formId = fieldNodes.getId();
            try {
                dataEntityType = MetadataServiceHelper.getDataEntityType((String)formId);
            }
            catch (Exception e) {
                String fid = QueryServiceHelper.queryOne((String)"bos_formmeta", (String)"masterid", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)formId)}).get("masterid").toString();
                String sourceId = MetadataDao.getNumberById((String)fid);
                dataEntityType = MetadataServiceHelper.getDataEntityType((String)sourceId);
            }
            this.removeNotOrgNode(fieldNodes, dataEntityType);
        }
        String nodesJson = SerializationUtils.toJsonString((Object)fieldNodes);
        showParameter.getCustomParams().put("treenodes", nodesJson);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, sourceCtrlKey));
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        this.getView().showForm(showParameter);
    }

    private void removeNotOrgNode(TreeNode treeNode, MainEntityType dataEntityType) {
        List children = treeNode.getChildren();
        String nodeId = treeNode.getId();
        if (children != null && !children.isEmpty()) {
            DynamicProperty property = this.getProperty(nodeId, dataEntityType);
            if (property instanceof OrgProp) {
                treeNode.setChildren(null);
            } else {
                for (TreeNode child : children) {
                    this.removeNotOrgNode(child, dataEntityType);
                }
                ListIterator listIterator = children.listIterator();
                while (listIterator.hasNext()) {
                    Object data = ((TreeNode)listIterator.next()).getData();
                    if (!"toremove".equals(data)) continue;
                    listIterator.remove();
                }
                if (children.isEmpty()) {
                    this.removeNotOrgNode(treeNode, dataEntityType);
                }
            }
        } else {
            String[] split = nodeId.split("[.]");
            DynamicProperty property = this.getProperty(split[0], dataEntityType);
            if (!(property instanceof OrgProp)) {
                treeNode.setData((Object)"toremove");
            }
        }
    }

    private DynamicProperty getProperty(String propName, MainEntityType dt) {
        DynamicProperty property = dt.getProperty(propName);
        if (property == null) {
            DataEntityPropertyCollection properties = dt.getProperties();
            for (IDataEntityProperty pro : properties) {
                if (!(pro instanceof EntryProp) || pro instanceof LinkEntryProp) continue;
                EntryProp entryProp = (EntryProp)pro;
                property = entryProp._collectionItemPropertyType.getProperty(propName);
                if (property == null) continue;
                return property;
            }
        }
        return property;
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        if (closedCallBackEvent.getReturnData() == null) {
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)closedCallBackEvent.getActionId(), (CharSequence)Key_OrgId)) {
            this.getModel().setValue(Key_OrgId, closedCallBackEvent.getReturnData());
        }
    }

    public String getSetting() {
        String orgId = (String)this.getModel().getValue(Key_OrgId);
        if (StringUtils.isBlank((CharSequence)orgId)) {
            orgId = "0";
        }
        String accounttype = (String)this.getModel().getValue(Key_AccountType);
        String setting = String.format("%s(%s, '%s')", this.getFuncId(), orgId, accounttype);
        return setting;
    }
}

